/**************************************************************************
 *
 * SOURCE FILE NAME = TOULOADM.H
 *
 * DESCRIPTIVE NAME = Include file for touch sub system
 *
 * Copyright : COPYRIGHT IBM CORPORATION, 1991, 1992
 *             LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
 *             REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
 *             RESTRICTED MATERIALS OF IBM
 *             IBM CONFIDENTIAL
 *
 * VERSION = V2.0
 *
 * DATE        07/12/91
 *
 * DESCRIPTION
 *             Using run time loading
 *
 * FUNCTIONS   LoadTouchModule.
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
 * CHANGE ACTIVITY =
 *  DATE      FLAG        APAR   CHANGE DESCRIPTION
 *  --------  ----------  -----  --------------------------------------
 *  mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
 ****************************************************************************/

#define  TOU_MODULE_NAME         "TOUCALLS"

/*
** declare pointers to touch functions
*/
typedef USHORT(APIENTRY *pTouOpen)(PHTOU);
typedef USHORT(APIENTRY *pTouClose)(HTOU);
typedef USHORT(APIENTRY *pTouSetEventMask)(PUSHORT,HTOU);
typedef USHORT(APIENTRY *pTouGetEventMask)(PUSHORT,HTOU);
typedef USHORT(APIENTRY *pTouSetDevStatus)(PUSHORT,HTOU);
typedef USHORT(APIENTRY *pTouGetDevStatus)(PUSHORT,HTOU);
typedef USHORT(APIENTRY *pTouSetCoordSys)(PTOUCSYS,HTOU);
typedef USHORT(APIENTRY *pTouGetCoordSys)(PTOUCSYS,HTOU);
typedef USHORT(APIENTRY *pTouSetCoordOrg)(PUSHORT,HTOU);
typedef USHORT(APIENTRY *pTouGetCoordOrg)(PUSHORT,HTOU);
typedef USHORT(APIENTRY *pTouSetSelMech)(PTOUSELMECH,HTOU);
typedef USHORT(APIENTRY *pTouGetSelMech)(PTOUSELMECH,HTOU);
typedef USHORT(APIENTRY *pTouSetRepRate)(PUSHORT,HTOU);
typedef USHORT(APIENTRY *pTouGetRepRate)(PUSHORT,HTOU);
typedef USHORT(APIENTRY *pTouSetThresh)(PTOUTHRESHOLDS,HTOU);
typedef USHORT(APIENTRY *pTouGetThresh)(PTOUTHRESHOLDS,HTOU);
typedef USHORT(APIENTRY *pTouReadEventQue)(PTOUEVENTINFO,PUSHORT,HTOU);
typedef USHORT(APIENTRY *pTouSetNumQueEl)(PUSHORT,HTOU);
typedef USHORT(APIENTRY *pTouGetNumQueEl)(PTOUQUEINFO,HTOU);
typedef USHORT(APIENTRY *pTouFlushQue)(HTOU);
typedef USHORT(APIENTRY *pTouSetFilter)(PTOUFILTPARMS,HTOU);
typedef USHORT(APIENTRY *pTouGetFilter)(PTOUFILTPARMS,HTOU);
typedef USHORT(APIENTRY *pTouResetEmulState)(HTOU);
typedef USHORT(APIENTRY *pTouSetEmulOnOff)(PUSHORT,HTOU);
typedef USHORT(APIENTRY *pTouGetEmulOnOff)(PUSHORT,HTOU);
typedef USHORT(APIENTRY *pTouSelectParms)(PUSHORT,HTOU);
typedef USHORT(APIENTRY *pTouQueryParms)(PUSHORT,HTOU);
typedef USHORT(APIENTRY *pTouSetXYOffset)(PTOUXYOFFSET,HTOU);
typedef USHORT(APIENTRY *pTouGetXYOffset)(PTOUXYOFFSET,HTOU);
typedef USHORT(APIENTRY *pTouSetClickLockData)(PTOUCLICKLOCK,HTOU);
typedef USHORT(APIENTRY *pTouGetClickLockData)(PTOUCLICKLOCK,HTOU);

/*
** define touch procedures structure
*/
struct _TOUPROC
{
  char *name;
  PFN addr;
} _TouProc[] =
{
  "TOUOPEN", 0,                        /* 0                                  */
  "TOUCLOSE", 0,                       /* 1                                  */
  "TOUSETEVENTMASK", 0,                /* 2                                  */
  "TOUGETEVENTMASK", 0,                /* 3                                  */
  "TOUSETDEVSTATUS", 0,                /* 4                                  */
  "TOUGETDEVSTATUS", 0,                /* 5                                  */
  "TOUSETCOORDSYS", 0,                 /* 6                                  */
  "TOUGETCOORDSYS", 0,                 /* 7                                  */
  "TOUSETCOORDORG", 0,                 /* 8                                  */
  "TOUGETCOORDORG", 0,                 /* 9                                  */
  "TOUSETSELMECH", 0,                  /* 10                                 */
  "TOUGETSELMECH", 0,                  /* 11                                 */
  "TOUSETREPRATE", 0,                  /* 12                                 */
  "TOUGETREPRATE", 0,                  /* 13                                 */
  "TOUSETTHRESH", 0,                   /* 14                                 */
  "TOUGETTHRESH", 0,                   /* 15                                 */
  "TOUREADEVENTQUE", 0,                /* 16                                 */
  "TOUSETNUMQUEEL", 0,                 /* 17                                 */
  "TOUGETNUMQUEEL", 0,                 /* 18                                 */
  "TOUFLUSHQUE", 0,                    /* 19                                 */
  "TOUSETFILTER", 0,                   /* 20                                 */
  "TOUGETFILTER", 0,                   /* 21                                 */
  "TOURESETEMULSTATE", 0,              /* 22                                 */
  "TOUSETEMULONOFF", 0,                /* 23                                 */
  "TOUGETEMULONOFF", 0,                /* 24                                 */
  "TOUSELECTPARMS", 0,                 /* 25                                 */
  "TOUQUERYPARMS", 0,                  /* 26                                 */
  "TOUSETXYOFFSET", 0,                 /* 27                                 */
  "TOUGETXYOFFSET", 0,                 /* 28                                 */
  "TOUSETCLICKLOCKDATA", 0,            /* 29                                 */
  "TOUGETCLICKLOCKDATA", 0,            /* 30                                 */
  NULL, 0                              /* terminator                         */
} ;

/*
** defines to map TouXxx calls to function pointers
*/
#define TouOpen(a)               (*(pTouOpen)_TouProc[0].addr)(a)
#define TouClose(a)              (*(pTouClose)_TouProc[1].addr)(a)
#define TouSetEventMask(a,b)     (*(pTouSetEventMask)_TouProc[2].addr)(a,b)
#define TouGetEventMask(a,b)     (*(pTouGetEventMask)_TouProc[3].addr)(a,b)
#define TouSetDevStatus(a,b)     (*(pTouSetDevStatus)_TouProc[4].addr)(a,b)
#define TouGetDevStatus(a,b)     (*(pTouGetDevStatus)_TouProc[5].addr)(a,b)
#define TouSetCoordSys(a,b)      (*(pTouSetCoordSys)_TouProc[6].addr)(a,b)
#define TouGetCoordSys(a,b)      (*(pTouGetCoordSys)_TouProc[7].addr)(a,b)
#define TouSetCoordOrg(a,b)      (*(pTouSetCoordOrg)_TouProc[8].addr)(a,b)
#define TouGetCoordOrg(a,b)      (*(pTouGetCoordOrg)_TouProc[9].addr)(a,b)
#define TouSetSelMech(a,b)       (*(pTouSetSelMech)_TouProc[10].addr)(a,b)
#define TouGetSelMech(a,b)       (*(pTouGetSelMech)_TouProc[11].addr)(a,b)
#define TouSetRepRate(a,b)       (*(pTouSetRepRate)_TouProc[12].addr)(a,b)
#define TouGetRepRate(a,b)       (*(pTouGetRepRate)_TouProc[13].addr)(a,b)
#define TouSetThresh(a,b)        (*(pTouSetThresh)_TouProc[14].addr)(a,b)
#define TouGetThresh(a,b)        (*(pTouGetThresh)_TouProc[15].addr)(a,b)
#define TouReadEventQue(a,b,c)   (*(pTouReadEventQue)_TouProc[16].addr)(a,b,c)
#define TouSetNumQueEl(a,b)      (*(pTouSetNumQueEl)_TouProc[17].addr)(a,b)
#define TouGetNumQueEl(a,b)      (*(pTouGetNumQueEl)_TouProc[18].addr)(a,b)
#define TouFlushQue(a)           (*(pTouFlushQue)_TouProc[19].addr)(a)
#define TouSetFilter(a,b)        (*(pTouSetFilter)_TouProc[20].addr)(a,b)
#define TouGetFilter(a,b)        (*(pTouGetFilter)_TouProc[21].addr)(a,b)
#define TouResetEmulState(a)     (*(pTouResetEmulState)_TouProc[22].addr)(a)
#define TouSetEmulOnOff(a,b)     (*(pTouSetEmulOnOff)_TouProc[23].addr)(a,b)
#define TouGetEmulOnOff(a,b)     (*(pTouGetEmulOnOff)_TouProc[24].addr)(a,b)
#define TouSelectParms(a,b)      (*(pTouSelectParms)_TouProc[25].addr)(a,b)
#define TouQueryParms(a,b)       (*(pTouQueryParms)_TouProc[26].addr)(a,b)
#define TouSetXYOffset(a,b)      (*(pTouSetXYOffset)_TouProc[27].addr)(a,b)
#define TouGetXYOffset(a,b)      (*(pTouGetXYOffset)_TouProc[28].addr)(a,b)
#define TouSetClickLockData(a,b) (*(pTouSetClickLockData)_TouProc[29].addr)(a,b)
#define TouGetClickLockData(a,b) (*(pTouGetClickLockData)_TouProc[30].addr)(a,b)

/****************************************************************************
 *
 * FUNCTION NAME = LoadTouchModule
 *
 * DESCRIPTION   = Code to load touch dll module
 *
 *
 * INPUT         = (void)
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = 0
 *
 * RETURN-ERROR  = Return code
 *
 ****************************************************************************/

USHORT LoadTouchModule(void)
{
  char obj_buf;
  HMODULE hmod;
  USHORT ret;
  int i;
  ret = DosLoadModule(&obj_buf, 1, TOU_MODULE_NAME, &hmod);
  if (ret)
    return (ret);
  for (i = 0; _TouProc[i].name; ++i)
  {
    ret = DosGetProcAddr(hmod, _TouProc[i].name, &_TouProc[i].addr);
    if (ret)
      return (ret);
  }
  /* ??? could include TouOpen here ???                                      */
  return (0);                          /* ok                                 */
}                                      /* LoadTouchModule                    */

/*
** end
*/
