/**************************************************************************
 *
 * SOURCE FILE NAME = TOUCALLS.H
 *
 * DESCRIPTIVE NAME = Include file for touch sub system (TouXxx)
 *
 * Copyright : COPYRIGHT IBM CORPORATION, 1991, 1992
 *             LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
 *             REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
 *             RESTRICTED MATERIALS OF IBM
 *             IBM CONFIDENTIAL
 *
 * VERSION = V2.0
 *
 * DATE        07/12/91
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
 * CHANGE ACTIVITY =
 *  DATE      FLAG        APAR   CHANGE DESCRIPTION
 *  --------  ----------  -----  --------------------------------------
 *  mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
 ****************************************************************************/

#ifndef  TOU_INCLUDED                  /* stop multiple inclusion            */
#define  TOU_INCLUDED                  /* included                           */

/*
** OS2 typedefs if not using 'OS2.H'
*/
#ifndef  OS2_INCLUDED
#define  APIENTRY             pascal far
typedef  unsigned short SHANDLE,USHORT,far *PUSHORT;
typedef  short SHORT;
typedef  unsigned long ULONG;
typedef  unsigned char UCHAR;
/* typedef VOID far *    PVOID */
#endif

/*
** file handle for touch device
*/
typedef SHANDLE HTOU, far *PHTOU;

/*
** open touch device
** (emulation is turned off & data is directed to the event queue)
*/
USHORT APIENTRY TouOpen(PHTOU);

/*
** define for TouClose(), internal handle (no effect in DLL)
*/
#define  TOU_CLOSE_ALL           -1    /* RESERVED                           */

/*
** close touch device
** (emulation is turned back on if it was enabled for this screen group)
** (raw mode is reset for this screen group)
*/
USHORT APIENTRY TouClose(HTOU);

/*
** set/get device status
*/
USHORT APIENTRY TouSetDevStatus(PUSHORT,HTOU);
USHORT APIENTRY TouGetDevStatus(PUSHORT,HTOU);

/*
** structure for TouSet/GetCoordSys()
*/
typedef struct _TOUCSYS
{
  USHORT xMin;
  USHORT xMax;
  USHORT yMin;
  USHORT yMax;
  USHORT zMin;
  USHORT zMax;
  USHORT xHys;
  USHORT yHys;
} TOUCSYS, far *PTOUCSYS;

/*
** set/get coordinate system
*/
USHORT APIENTRY TouSetCoordSys(PTOUCSYS,HTOU);
USHORT APIENTRY TouGetCoordSys(PTOUCSYS,HTOU);

/*
** defines for TouSet/GetCoordOrg()
*/
#define  TOU_CO_UPPERLEFT        0     /* default at power up                */
#define  TOU_CO_LOWERLEFT        1

/*
** set/get coordinate origin
*/
USHORT APIENTRY TouSetCoordOrg(PUSHORT,HTOU);
USHORT APIENTRY TouGetCoordOrg(PUSHORT,HTOU);

/*
** structure for TouSet/GetSelMech()
*/
typedef struct _TOUSELM
{
  USHORT Method;
  USHORT NumPoints;                    /* only valid for method > 1          */
  USHORT Tolerance;                    /* only valid for method > 1          */
  USHORT SearchLim;                    /* only valid for method > 1          */
} TOUSELMECH, far *PTOUSELMECH;

/*
** defines for TouSet/GetSelMech() method
*/
#define  TOU_SM_PUSH             0     /* default at power up                */
#define  TOU_SM_LIFTOFF          1
#define  TOU_SM_SINGLE_TOUCH     2
#define  TOU_SM_STABLE_POINT     4

/*
** set/get selection mechanism
** (parms pointer to void for downwards compatibility)
*/
USHORT APIENTRY TouSetSelMech(PTOUSELMECH,HTOU);
USHORT APIENTRY TouGetSelMech(PTOUSELMECH,HTOU);

/*
** set/get data report rate
*/
USHORT APIENTRY TouSetRepRate(PUSHORT,HTOU);
USHORT APIENTRY TouGetRepRate(PUSHORT,HTOU);

/*
** structure for TouSet/GetThresh()
*/
typedef struct _TOUTHRESHOLDS
{
  USHORT OnScThr;
  USHORT PushThr;
  USHORT PushHys;
} TOUTHRESHOLDS, far *PTOUTHRESHOLDS;

/*
** set/get screen & selection thresholds
*/
USHORT APIENTRY TouSetThresh(PTOUTHRESHOLDS,HTOU);
USHORT APIENTRY TouGetThresh(PTOUTHRESHOLDS,HTOU);

/*
** defines for TouReadEventQue() status & TouSet/GetEventMask()
** The status bits are only vaild in certain combinations:
**      (x?) - xyz mode
**      (r?) - raw mode
**      (b?) - both modes
**      (?n) - normal data
**      (?e) - error data
** When raw mode is selected all events are reported,
** irrespective of the event mask and the event status flags
*/
#define  TOU_EI_XY_CHANGED             0x0001  /* (xn) X or Y changed        */
#define  TOU_EI_Z_CHANGED              0x0002  /* (xn) Z changed             */
#define  TOU_EI_TOUCH_DOWN             0x0004  /* (xn) on-screen OFF to ON   */
#define  TOU_EI_LIFT_OFF               0x0100  /* (xn) on-screen ON to OFF   */
#define  TOU_EI_SELECT_TURNED_ON       0x0008  /* (xn) selection OFF to ON   */
#define  TOU_EI_SELECT_TURNED_OFF      0x0200  /* (xn) selection ON to OFF   */
#define  TOU_EI_ON_SCREEN              0x0010  /* (xn) on-screen active      */
#define  TOU_EI_SELECT_ON              0x0020  /* (xn) selection active      */
#define  TOU_EI_CHANNEL_PEGGED         0x0800  /* (be) too much pressure     */
#define  TOU_EI_HW_ERROR               0x0080  /* (be) GE, FP or OE error    */
/* not used                            0x0040     not used                   */
/* not used                            0x0400     not used                   */
#define  TOU_EI_OE_ERROR               0x1000  /* (re) offset error          */
#define  TOU_EI_FP_ERROR               0x2000  /* (re) float error           */
#define  TOU_EI_ADJUST_OCCURRED        0x4000  /* (rn) adjust occurred       */
#define  TOU_EI_RAW_DATA               0x8000  /* (rn) enable raw data       */
#define  TOU_EI_ALL_XYZ_DATA           0x033F  /* (xn) xyz data, no errors   */
#define  TOU_EI_ALL_XYZ_ERROR          0x0880  /* (xe) xyz error data only   */
#define  TOU_EI_ALL_XYZ_DATA_ERROR     0x0BBF  /* (xe) xyz data incl errors  */
#define  TOU_EI_ALL_RAW_DATA           0x8000  /* (re) raw data incl errors  */

/*
** defines for TouReadEventQue() wait flag
*/
#define  TOU_EI_NOWAIT           0     /* return zero packet if no data
                                          available                          */
#define  TOU_EI_WAIT             1     /* wait till data available           */

/*
** structure for TouReadEventQue()
*/
typedef struct _TOUEVENTINFO
{
  USHORT status;
  ULONG time;
  USHORT x;                            /* (raw mode transducer 1)            */
  USHORT y;                            /* (raw mode transducer 2)            */
  USHORT z;                            /* (raw mode transducer 3)            */
  USHORT r;                            /* (raw mode transducer 4)            */
} TOUEVENTINFO, far *PTOUEVENTINFO;

/*
** read event queue data
*/
USHORT APIENTRY TouReadEventQue(PTOUEVENTINFO,PUSHORT,HTOU);

/*
** set/get event mask (see TOU_EI_ for defines)
*/
USHORT APIENTRY TouSetEventMask(PUSHORT,HTOU);
USHORT APIENTRY TouGetEventMask(PUSHORT,HTOU);

/*
** structure for TouGetNumQueEl()
*/
typedef struct _TOUQUEINFO
{
  USHORT cEvents;
  USHORT cMaxEvents;
} TOUQUEINFO, far *PTOUQUEINFO;

/*
** get information on queue state to structure
*/
USHORT APIENTRY TouGetNumQueEl(PTOUQUEINFO,HTOU);

/*
** set current max number of elements in queue ( <= .cMaxEvents, above)
**      zero sets config line default
*/
USHORT APIENTRY TouSetNumQueEl(PUSHORT,HTOU);

/*
** flush event queue
*/
USHORT APIENTRY TouFlushQue(HTOU);

/*
** defines for TouGet/SetFilter()
*/
#define  TOU_FP_TYPE_DEFAULT     0
#define  TOU_FP_TYPE_ALTERNATE   1
#define  TOU_FP_FREQ_DEFAULT     0
#define  TOU_FP_FREQ_SLOW        1
#define  TOU_FP_FREQ_MEDIUM      2
#define  TOU_FP_FREQ_FAST        3
#define  TOU_FP_FREQ_RAPID       4

/*
** structure for TouGet/SetFilter()
*/
typedef struct _TOUFILTPARMS
{
  USHORT type;
  USHORT freq;
} TOUFILTPARMS, far *PTOUFILTPARMS;

/*
** set/get filter constants
*/
USHORT APIENTRY TouGetFilter(PTOUFILTPARMS,HTOU);
USHORT APIENTRY TouSetFilter(PTOUFILTPARMS,HTOU);

/*
** reset emulation parameters back to defaults
*/
USHORT APIENTRY TouResetEmulState(HTOU);

/*
** defines for TouSet/GetEmulOnOff()
*/
#define  TOU_EO_OFF              0
#define  TOU_EO_ON               1

/*
** set/get emulation state for this screen group
*/
USHORT APIENTRY TouSetEmulOnOff(PUSHORT,HTOU);
USHORT APIENTRY TouGetEmulOnOff(PUSHORT,HTOU);

/*
** defines for TouSelect/QueryParms
*/
#define  TOU_PI_TOUCH            0
#define  TOU_PI_EMULATION        1

/*
** select/query touch parameters for Set/Get calls
*/
USHORT APIENTRY TouSelectParms(PUSHORT,HTOU);
USHORT APIENTRY TouQueryParms(PUSHORT,HTOU);

/*
** structure for TouSet/GetXYOffset()
*/
typedef struct _TOUXYOFFSET
{
  SHORT xOffset;                       /* x offset additive                  */
  SHORT yOffset;                       /* y offset additive                  */
} TOUXYOFFSET, far *PTOUXYOFFSET;

/*
** get/set pointer offset
*/
USHORT APIENTRY TouSetXYOffset(PTOUXYOFFSET,HTOU);
USHORT APIENTRY TouGetXYOffset(PTOUXYOFFSET,HTOU);

/*
** structure for TouSet/GetClickLockData()
*/
typedef struct _TOUCLICKLOCK
{
  USHORT size;                         /* clk active area                    */
  USHORT time;                         /* clk timeout period (msecs)         */
  UCHAR type;                          /* clk count, max                     */
} TOUCLICKLOCK, far *PTOUCLICKLOCK;

/*
** get/set click coordinate locking data
*/
USHORT APIENTRY TouSetClickLockData(PTOUCLICKLOCK,HTOU);
USHORT APIENTRY TouGetClickLockData(PTOUCLICKLOCK,HTOU);

/*
** defines for TouXxx returns
*/
#define  NO_ERROR                         0
#define  NO_ERROR_TOUCH_NO_DATA           9001
#define  ERROR_TOUCH_NO_DEVICE            9002
#define  ERROR_TOU_DETACHED               9003
#define  ERROR_TOUCH_INV_PARMS            9004
#define  ERROR_TOUCH_NOT_CALIBRATED       9005
#define  ERROR_TOUCH_EMUL_NOT_AVAILABLE   9006
#define  ERROR_TOUCH_GENERAL_FAILURE      9007
#define  ERROR_TOUCH_RESERVED1            9008
#endif                                 /* TOU_INCLUDED                       */

/*
** end
*/
