/**************************************************************************
 *
 * SOURCE FILE NAME = TOUCALIB.H
 *
 * DESCRIPTIVE NAME = Touch sub system (TouXxx)
 *
 * Copyright : COPYRIGHT IBM CORPORATION, 1991, 1992
 *             LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
 *             REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
 *             RESTRICTED MATERIALS OF IBM
 *             IBM CONFIDENTIAL
 *
 * VERSION = V2.0
 *
 * DATE        07/12/91
 *
 * DESCRIPTION
 *             Include file for touch sub system (TouXxx)
 *             ** CALIBRATION ONLY **
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
 * CHANGE ACTIVITY =
 *  DATE      FLAG        APAR   CHANGE DESCRIPTION
 *  --------  ----------  -----  --------------------------------------
 *  mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
 ****************************************************************************/

/*
** data type for TouDldCalibConst()
*/

#define  TOU_CALIB_SIZ   4             /* size of each entry (prescott float)*/
#define  TOU_CALIB_LEN   10            /* number of entries                  */

typedef struct _TOUDCC
{
  unsigned char con[TOU_CALIB_LEN][TOU_CALIB_SIZ];
} TOUDCC, far *PTOUDCC;

/*
** download calibration constants from structure to prescott
*/
USHORT APIENTRY TouDldCalibConst(PTOUDCC,HTOU);

/*
** get calibration constants from prescott to structure
*/
USHORT APIENTRY TouGetCalibConst(PTOUDCC,HTOU);

#if 0

/*
** download default calibration constants
**
** USHORT APIENTRY TouDefaultCalibConst( HTOU );
*/

/*
** defines for TouReadRaw() status
*/
#define  TOU_RAW_R3        0x0004      /* reserved                           */
#define  TOU_RAW_TI        0x0040      /* tilt unlocked                      */
#define  TOU_RAW_R1        0x0400      /* reserved                           */
#define  TOU_RAW_R2        0x4000      /* reserved                           */

/*
** structure for TouReadRaw()
*/
typedef struct _TOURRAW
{
  USHORT stat;                /* (msb) 1,R2,0,0,0,R1,0,0 0,TI,0,0,0,R3,0,0   */
  USHORT t1;                           /* transducer 1                       */
  USHORT t2;                           /* transducer 2                       */
  USHORT t3;                           /* transducer 3                       */
  USHORT t4;                           /* transducer 4                       */
} TOURRAW, far *PTOURRAW;

/*
** read raw transducer data into structure
*/
USHORT APIENTRY TouReadRaw(PTOURRAW,HTOU);

/*
** defines for TouReadXYZ() status
*/
#define  TOU_XYZ_HE        0x0001      /* hadrware offset adjust error       */
#define  TOU_XYZ_OE        0x0002      /* offset adjust error                */
#define  TOU_XYZ_FE        0x0004      /* floating point error               */
#define  TOU_XYZ_CP        0x0010      /* channnel pegged                    */
#define  TOU_XYZ_R4        0x0020      /* reserved                           */
#define  TOU_XYZ_TI        0x0040      /* tilt unlocked                      */
#define  TOU_XYZ_R1        0x0100      /* reserved                           */
#define  TOU_XYZ_R2        0x0200      /* reserved                           */
#define  TOU_XYZ_R3        0x0400      /* reserved                           */
#define  TOU_XYZ_TS2       0x1000      /* touch screen status 2              */
#define  TOU_XYZ_TS1       0x2000      /* touch screen status 1              */
#define  TOU_XYZ_SD        0x4000      /* selection detection                */

/*
** structure for TouReadXYZ()
*/
typedef struct _TOURXYZ
{
  USHORT stat;      /* (msb) 1,SD,TS1,TS2,0,R3,R2,R1 0,TI,R4,CP,0,FE,OE,HE   */
  USHORT x;                            /* x coordinate                       */
  USHORT y;                            /* y coordinate                       */
  USHORT z;                            /* z coordinate                       */
} TOURXYZ, far *PTOURXYZ;

/*
** read XYZ data into structure
*/
USHORT APIENTRY TouReadXYZ(PTOURXYZ,HTOU);

#endif

/*
** structure for TouRead/WriteMem()
*/
typedef struct _TOUMEM
{
  UCHAR data;                          /* memory data                        */
  USHORT addr;                         /* memory address                     */
} TOUMEM, far *PTOUMEM;

/*
** read/write to memory
*/
USHORT APIENTRY TouReadMem(PTOUMEM,HTOU);
USHORT APIENTRY TouWriteMem(PTOUMEM,HTOU);

/*
** calibration specific error codes
*/
#define  ERROR_TOUCH_NOT_IN_FOREGROUND    ERROR_TOUCH_RESERVED1

/*
** end
*/
