/**************************************************************************
 *
 * SOURCE FILE NAME = TDDCALLS.H
 *
 * DESCRIPTIVE NAME = Touch device dependant sub system (TddXxx)
 *
 * Copyright : COPYRIGHT IBM CORPORATION, 1991, 1992
 *             LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
 *             REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
 *             RESTRICTED MATERIALS OF IBM
 *             IBM CONFIDENTIAL
 *
 * VERSION = V2.0
 *
 * DATE        07/31/91
 *
 * DESCRIPTION
 *             Include file for touch device dependant sub system (TddXxx),
 *             only 16:16 interface supported.
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
 * CHANGE ACTIVITY =
 *  DATE      FLAG        APAR   CHANGE DESCRIPTION
 *  --------  ----------  -----  --------------------------------------
 *  mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
 ****************************************************************************/

/*
** stop multiple inclusion
*/

#ifndef  TDD_INCLUDED                     /* test if included                */
#define  TDD_INCLUDED                     /* now included                    */

/*
** sort out default interface defines for 32 & 16 calling
*/

#ifdef   INCL_32
#define  _FAR           _far16   /* force thunk from 32 bit apps to tddcalls */
#else
#define  _FAR           FAR               /* conventional 16:16 interface    */
#endif

#define  TDDENTRY       _export _pascal _FAR

/*
** file handle for touch device
*/
typedef USHORT HTDD,_FAR *PHTDD;


#pragma  pack(1)                          /* set structure packing size of 1 */

/*
** open touch device
** (emulation is turned off & data is directed to the event queue)
*/
USHORT TDDENTRY TddOpen(PHTDD);

/*
** close touch device
** (emulation is turned back on if it was enabled for this screen group)
*/
USHORT TDDENTRY TddClose(HTDD);

/*
** used by set thresholds, set report rate, set click lock, set xy offset
*/
#define  TDD_SET_DEFAULTS  -32768       /* use this to set power-on defaults */

#ifdef   TDD_SEM

/*
** get & release system semaphore for beep on selection detect/
*/
extern USHORT TDDENTRY TddGetBeepSem(HSYSSEM,HTDD);
extern USHORT TDDENTRY TddRelBeepSem(HTDD);

#endif                                    /* TDD_SEM                         */

/*
** default report rate
** #define TDD_DEF_RATE    3
*/

/*
** set/get data report rate
*/
USHORT TDDENTRY TddSetReportRate(USHORT,HTDD);
USHORT TDDENTRY TddGetReportRate(USHORT _FAR *,HTDD);

/*
** structure for TddSet/GetThresholds()
*/
typedef struct _TDDTHRESHOLDS
{
  USHORT OnScThr;
  USHORT PushHys;
  USHORT PushThr;
} TDDTHRESHOLDS, _FAR *PTDDTHRESHOLDS;

/*
** default thresholds
*/
/* #define TDD_DEF_ONS     46       */    /* on-screen threshold (ito Z)     */
/* #define TDD_DEF_PTH     96       */    /* push threshold (ito Z)          */
/* #define TDD_DEF_PHY     80       */    /* push hysteresis (ito Z)         */

/*
** set/get screen & selection thresholds
*/
USHORT TDDENTRY TddSetThresholds(const PTDDTHRESHOLDS,HTDD);
USHORT TDDENTRY TddGetThresholds(PTDDTHRESHOLDS,HTDD);

/*
** defines for TddReadData() status, xyz mode
*/
#define  TDD_XYZ_HE        0x0001         /* hadrware offset adjust error    */
#define  TDD_XYZ_OE        0x0002         /* offset adjust error             */
#define  TDD_XYZ_FE        0x0004         /* floating point error            */
/* b3    0                 0x0008   */
#define  TDD_XYZ_CP        0x0010         /* channel pegged                  */
#define  TDD_XYZ_ADJ       0x0020         /* adjusted                        */
/* b6    ?                 0x0040   */    /* (was tilt)                      */
/* b7    0                 0x0080   */
/* b8    ?                 0x0100   */    /* reserved                        */
/* b9    ?                 0x0200   */    /* reserved                        */
/* b10   ?                 0x0400   */    /* reserved                        */
/* b11   0                 0x0800   */
#define  TDD_XYZ_TS2       0x1000         /* touch screen status 2           */
#define  TDD_XYZ_TS1       0x2000         /* touch screen status 1           */
#define  TDD_XYZ_SD        0x4000         /* selection detection             */
/* b15   0                 0x8000   */    /* reset to indicate an xyz packet */

/*
** defines for TddReadData() status, raw mode
*/
/* b0    0                 0x0001   */
/* b1    0                 0x0002   */
/* b2    ?                 0x0004   */    /* reserved                        */
/* b3    0                 0x0008   */
/* b4    0                 0x0010   */
/* b5    0                 0x0020   */
#define  TDD_RAW_CP        0x0040         /* channel pegged                  */
/* b7    0                 0x0080   */
/* b8    0                 0x0100   */
/* b9    0                 0x0200   */
#define  TDD_RAW_ADJ       0x0400         /* adjusted                        */
/* b11   0                 0x0800   */
/* b12   0                 0x1000   */
/* b13   0                 0x2000   */
#define  TDD_RAW_OE        0x4000         /* offset error                    */
#define  TDD_RAW_DATA      0x8000         /* raw data indicator              */

/*
** range of data from TddReadData
*/
#define  TDD_X_MIN         0
#define  TDD_X_MAX         4095
#define  TDD_Y_MIN         0
#define  TDD_Y_MAX         4095
#define  TDD_Z_MIN         0
#define  TDD_Z_MAX         255

/*
** typedef for TddReadData()
*/
typedef struct _TDDRXYZ
{
  USHORT count;                           /* count of items in queue, BEFORE
                                             read                            */
  USHORT status;                          /* data status                     */
  union
  {
    struct
    {                                     /* xyz data                        */
      USHORT x;                           /* x coordinate                    */
      USHORT y;                           /* y coordinate                    */
      USHORT z;                           /* z coordinate                    */
      USHORT r;                           /* reserved                        */
    } ;

    struct
    {                                     /* raw data                        */
      USHORT t1;                          /* transducer 1                    */
      USHORT t2;                          /* transducer 2                    */
      USHORT t3;                          /* transducer 3                    */
      USHORT t4;                          /* transducer 4                    */
    } ;

  } ;

} TDDDATA,_FAR *PTDDDATA;

/*
** Read event queue data
*/
USHORT TDDENTRY TddReadData(PTDDDATA,HTDD);

/*
** defines for set/get mode
*/
#define  TDD_MODE_XYZ      0
#define  TDD_MODE_RAW      1

/*
** Set/Get Mode
*/
USHORT TDDENTRY TddSetMode(USHORT,HTDD);
USHORT TDDENTRY TddGetMode(USHORT _FAR *,HTDD);

/*
** Flush Event Queue
*/
USHORT TDDENTRY TddFlushQueue(HTDD);

/*
** defines for TddGet/SetFilter()
*/
#define  TDD_FP_TYPE_DEFAULT     0
#define  TDD_FP_TYPE_ALTERNATE   1
#define  TDD_FP_FREQ_DEFAULT     0
#define  TDD_FP_FREQ_SLOW        1
#define  TDD_FP_FREQ_MEDIUM      2
#define  TDD_FP_FREQ_FAST        3
#define  TDD_FP_FREQ_RAPID       4

/*
** structure for TddGet/SetFilters()
*/
typedef struct _TDDFILTCONST
{
  USHORT type;
  USHORT freq;
} TDDFILTCONST, _FAR *PTDDFILTCONST;

/*
** set/get filter constants
*/
USHORT TDDENTRY TddSetFilterConst(const PTDDFILTCONST,HTDD);
USHORT TDDENTRY TddGetFilterConst(PTDDFILTCONST,HTDD);

/*
** structure for TddSet/GetXYOffset()
*/
typedef struct _TDDXYOFFSET
{
  SHORT xOffset;                          /* x offset additive               */
  SHORT yOffset;                          /* y offset additive               */
} TDDXYOFFSET, _FAR *PTDDXYOFFSET;

/*
** get/set pointer offset
*/
USHORT TDDENTRY TddSetXYOffset(const PTDDXYOFFSET,HTDD);
USHORT TDDENTRY TddGetXYOffset(PTDDXYOFFSET,HTDD);

/*
** structure for TddSet/GetClickLockData()
*/
typedef struct _TDDCLICKLOCK
{
  USHORT size;                            /* clk active area                 */
  USHORT time;                            /* clk timeout period (msecs)      */
  USHORT type;                            /* clk count, max                  */
} TDDCLICKLOCK, _FAR *PTDDCLICKLOCK;

/*
** defaults for click locking
*/
/* #define TDD_DEF_SIZE    20       */    /* click lock size, square         */
/* #define TDD_DEF_TIME    500      */    /* timeout in milliseconds         */
/* #define TDD_DEF_TYPE    2        */    /* lock type                       */

/*
** get/set click coordinate locking data
*/
USHORT TDDENTRY TddSetClickLockData(const PTDDCLICKLOCK,HTDD);
USHORT TDDENTRY TddGetClickLockData(PTDDCLICKLOCK,HTDD);

/*
** data type for TddSetCalibConst()
*/
#define  TDD_CALIB_SIZ     4        /* size of each entry (prescott float)   */
#define  TDD_CALIB_LEN     10       /* number of entries                     */

#ifdef   _TDD_OLD

typedef struct _TDDCALCONST
{
  BYTE con[TDD_CALIB_LEN][TDD_CALIB_SIZ];
} TDDCALCONST, _FAR *PTDDCALCONST;

#else
typedef struct _TDDPFLOAT
{
  BYTE Pfloat[TDD_CALIB_SIZ];
} TDDPFLOAT, _FAR *PTDDPFLOAT;

typedef struct _TDDCALCONST
{
  TDDPFLOAT CalConst[TDD_CALIB_LEN];
} TDDCALCONST, _FAR *PTDDCALCONST;

#endif                                    /* _TDD_OLD                        */

/*
** Set/Get Calibration Constants from structure to Prescott
*/
USHORT TDDENTRY TddSetCalibConst(const PTDDCALCONST,HTDD);
USHORT TDDENTRY TddGetCalibConst(PTDDCALCONST,HTDD);

/*
** structure for TddRead/WriteMem()
*/
typedef struct _TDDMEM
{
  UCHAR data;                             /* memory data read/write          */
  USHORT addr;                            /* memory address                  */
} TDDMEM,_FAR *PTDDMEM;

/*
** read/write to memory
*/
USHORT TDDENTRY TddWriteMem(const PTDDMEM,HTDD);
USHORT TDDENTRY TddReadMem(PTDDMEM,HTDD);

/*
** get/set emulation selection detection beeper state
*/
extern USHORT TDDENTRY TddSetBeep(USHORT,HTDD);
extern USHORT TDDENTRY TddGetBeep(USHORT _FAR *,HTDD);

#define  TDD_BEEP_OFF      0              /* turn emulation beeper off       */
#define  TDD_BEEP_ON       1              /* turn emulation beeper on        */

/*
** get/set emulation state
*/
extern USHORT TDDENTRY TddSetEmul(USHORT,HTDD);
extern USHORT TDDENTRY TddGetEmul(USHORT _FAR *,HTDD);

#define  TDD_EMUL_OFF      0              /* turn emulation state off        */
#define  TDD_EMUL_ON       1              /* turn emulation state on         */
#pragma  pack()                           /* set pack to default             */

#endif                                    /* TDD_INCLUDED                    */

/*
** end
*/
