/**************************************************************************
 *
 * SOURCE FILE NAME = TOUASM.C
 *
 * DESCRIPTIVE NAME = Touch assembler support
 *
 * Copyright : COPYRIGHT IBM CORPORATION, 1991, 1992
 *             LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
 *             REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
 *             RESTRICTED MATERIALS OF IBM
 *             IBM CONFIDENTIAL
 *
 * VERSION = V2.0
 *
 * DATE        07/12/91
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS      PddEntry,      TouVddCall,    clc,        stc,
 *                cli,           sti,           GetCS.
 *
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
 * CHANGE ACTIVITY =
 *  DATE      FLAG        APAR   CHANGE DESCRIPTION
 *  --------  ----------  -----  --------------------------------------
 *  mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
 ****************************************************************************/

#include <os2.h>
#include "toudefs.h"
#include "toutypes.h"
#include "touasm.h"

extern USHORT FAR LOADDS SAVEREGS NewPddEntry(ULONG,PUSHORT,PUSHORT);
extern FWORD NEAR TouVddEntry;


/****************************************************************************
 *
 * FUNCTION NAME = PddEntry
 *
 * DESCRIPTION   =
 *     The VDD calls this routine as FWORD. This is a 16:32 entry point.
 *     The call is actually made as 32:32 due to dword stack alignment.
 *     As 'C' only knows about 16:16 (far), a dummy variable is inserted
 *     in the parameter list to adjust BP for the extra high words of the
 *     selector & the offset which have been pushed on the stack.
 *     The return is achived with an assembler bodge to get a RETFD back
 *     to the VDD. The retfd cleans up 12 bytes of parameters, this is the
 *     actual number pushed by the VDD.  The dummy parameter should not be
 *     included as it is not actually on the stack.  The routine is not
 *     really VOID, but 'C' can't see the return value.  As the proc was
 *     called _far16 only AX is checked on return to the VDD.
 *   Called from : VDD via 16:32 IDC
 *
 *
 * INPUT         = (ULONG Func,PUSHORT pIBuff,PUSHORT pOBuff,ULONG dummy)
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

extern VOID FAR PASCAL PddEntry(ULONG Func, PUSHORT pIBuff, PUSHORT pOBuff,
                  ULONG dummy  /* Padding to get round 16:32 return address  */
                )
{
  USHORT ret_val;

  /*
  ** called from Vdd, name exported with DHRegisterPDD()
  ** call local proc to do work
  */
  ret_val = NewPddEntry(Func, pIBuff, pOBuff);

  /* leave this way as we were called 16:32 */
  RETFD(12, ret_val);
}                                     /* PddEntry                            */


/****************************************************************************
 *
 * FUNCTION NAME = TouVddCall
 *
 * DESCRIPTION   =
 *   Called from : ReportVdmEvent (seg?)
 *                 InitVdmCb (seg?)
 *
 *
 * INPUT         = (ULONG func,VOID FAR *parm1,VOID FAR *parm2)
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

USHORT FAR PASCAL TouVddCall(ULONG func, VOID FAR *parm1, VOID FAR *parm2)
{
  USHORT ret_val;

  /* called here to do an fword call to Vdd*/
  _asm
  {
        push word ptr   func+2
        push word ptr   func
        push word ptr   parm1+2
        push word ptr   parm1
        push word ptr   parm2+2
        push word ptr   parm2

        _emit   0x66                  /* call fword ptr ...                  */
        call    dword ptr TouVddEntry /* call Vdd                            */
        mov     ret_val, ax
  }                                   /* _asm                                */

  return (ret_val);
}                                     /* TouVddCall                          */


/****************************************************************************
 *
 * FUNCTION NAME = clc
 *
 * DESCRIPTION   =
 *
 *
 * INPUT         = (VOID)
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

VOID clc(VOID)
{
  _asm    { clc }
}                                     /* clc                                 */


/****************************************************************************
 *
 * FUNCTION NAME = stc
 *
 * DESCRIPTION   =
 *
 *
 * INPUT         = (VOID)
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

VOID stc(VOID)
{
  _asm    { stc }
}                                     /* stc                                 */


/****************************************************************************
 *
 * FUNCTION NAME = cli
 *
 * DESCRIPTION   =
 *
 *
 * INPUT         = (VOID)
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

VOID cli(VOID)
{
  _asm    { cli }
}                                     /* cli                                 */


/****************************************************************************
 *
 * FUNCTION NAME = sti
 *
 * DESCRIPTION   =
 *
 *
 * INPUT         = (VOID)
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

VOID sti(VOID)
{
  _asm    { sti }
}                                     /* sti                                 */


/****************************************************************************
 *
 * FUNCTION NAME = GetCS
 *
 * DESCRIPTION   = Get code segment of caller.
 *     This procedure must be declared FAR & SAVEREGS for these bp offset:
 *                 bp+22   ret-seg
 *                 bp+20   ret-off
 *                 bp+18   ax
 *                 bp+16   cx
 *                 bp+14   dx
 *                 bp+12   bx
 *                 bp+10   sp
 *                 bp+8    bp
 *                 bp+6    si
 *                 bp+4    di
 *                 bp+2    ds
 *                 bp+0    es
 *
 *
 * INPUT         = (VOID)
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

USHORT FAR PASCAL SAVEREGS GetCS(VOID)
{
  USHORT ret_val;

  _asm
  {
        mov     ax, [bp+22]           ; return address segment
        mov     ret_val, ax

  }                                   /* _asm                                */

  return (ret_val);
}                                     /* GetCS                               */

/*
** end
*/
