;/*****************************************************************************
;*
;* SOURCE FILE NAME = SEGDEF.ASM
;*
;* DESCRIPTIVE NAME = Define segments, groups & their order
;*
;* COPYRIGHT    COPYRIGHT IBM CORPORATION, 1991, 1992
;*              LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
;*              REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
;*              RESTRICTED MATERIALS OF IBM
;*              IBM CONFIDENTIAL
;*
;* VERSION      V2.0
;*
;* DATE         09/23/91
;*
;* DESCRIPTION
;*
;* FUNCTIONS
;*
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*****************************************************************************/

        .286p

        .seq                            ; define segments in the order they
                                        ;   are required


        public  _last_data
        public  _last_code

;*
;* ***EP Segment & Group Definitions
;*
;* The order the segments are defined here determines the order the segments
;* appear in the executable.
;*
;* These segment definitions must be matched by a corresponding entry in the
;* linker definition file. They must also match the 'C' compilers segments.
;*

;*
;* Main data segments.
;* These logical segments are grouped together to form a physical segment.
;* They must be first segment in device driver
;*


;*
;* Initialised global data.
;*
_DATA           SEGMENT         WORD PUBLIC 'DATA'
_DATA           ENDS

;*
;* ?
;*
CONST           SEGMENT         WORD PUBLIC 'CONST'
CONST           ENDS

;*
;* Un-initialised global data. The linker moves this to c_common or far_bss
;*
_BSS            SEGMENT         WORD PUBLIC 'BSS'
_BSS            ENDS

;*
;* Un-initialised near global data.
;*
c_common        SEGMENT         WORD PUBLIC 'BSS'
c_common        ENDS

;*
;* Only get far_bss if use far un-initialised global data or
;* the linker decides(?) to put near un-init global data there.
;*
FAR_BSS         SEGMENT         WORD PUBLIC 'FAR_BSS'
FAR_BSS         ENDS

;*
;* dummy segment to mark end of first data segment, used in req_init
;*
LAST_DATA       SEGMENT         WORD PUBLIC 'LAST_DATA'
_last_data      equ     $               ; mark end of data segment
LAST_DATA       ENDS


;*
;* main code segments
;*
;* Default code segments
;*
_TEXT           SEGMENT         WORD PUBLIC 'CODE'
_TEXT           ENDS

;*
;* named code segment for fixed code
;*
FIXED_TEXT      SEGMENT         WORD PUBLIC 'CODE'
FIXED_TEXT      ENDS

;*
;* device helper routines
;* DEVHLP_TEXT    SEGMENT       WORD PUBLIC 'CODE'
;* DEVHLP_TEXT    ENDS


;*
;* dummy segment to mark end of first code segment, used in req_init
;*
LAST_CODE       SEGMENT         WORD PUBLIC 'CODE'
_last_code      equ     $               ; mark end of code segment
LAST_CODE       ENDS


;*
;* moveable code segments
;*
;* named code segment for moveable code
;*
MOVE1_TEXT      SEGMENT         WORD PUBLIC 'CODE'
MOVE1_TEXT      ENDS


;*
;* define segment groupings
;*
DGROUP          GROUP   _DATA, CONST, _BSS, c_common, FAR_BSS, LAST_DATA
CGROUP          GROUP   _TEXT, FIXED_TEXT, LAST_CODE
M1GROUP         GROUP   MOVE1_TEXT


if 0

_TEXT   SEGMENT
        ASSUME  cs:_TEXT

;*
;* This is a replacement for the 'C' compiler's stack checking routines.
;* It allocates space for local variables without generating any errors.
;* It is here to resolve __a?chkstk in library routines which may have
;* explicitly enabled stack checking & prevents the 'C' runtime being included.
;*
;* Entry:        AX - size of local stack frame required
;* Exit:         SP - new stack frame
;* Uses:         BX, CX, DX
;*


public          __aNchkstk
public          __aFchkstk

__aNchkstk      proc      near

        pop     cx                      ; get return address

        mov     bx, sp                  ; create local frame
        sub     bx, ax
        mov     sp, bx

        jmp     cx                      ; near ret to cx

__aNchkstk      endp



__aFchkstk      proc      far

        pop     cx                      ; get return address
        pop     dx

        mov     bx, sp                  ; create local frame
        sub     bx, ax
        mov     sp, bx

        push    dx                      ; far ret to dx:cx
        push    cx
        ret

__aFchkstk      endp


        public  __astart

__astart                proc    far
        int     3
__astart                endp

        public  _main

_main           proc    far
        int     3
_main           endp

_TEXT           ENDS

endif

        end

;*
;* end
;*
