;/*****************************************************************************
;*
;* SOURCE FILE NAME = TOUABIOS.ASM
;*
;* DESCRIPTIVE NAME =
;*
;* COPYRIGHT    COPYRIGHT IBM CORPORATION, 1991, 1992
;*              LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
;*              REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
;*              RESTRICTED MATERIALS OF IBM
;*              IBM CONFIDENTIAL
;*
;* VERSION      V2.0
;*
;* DATE         02/18/92
;*
;* DESCRIPTION
;*
;* FUNCTIONS    prescott_io,    abios_tsbs,     abios_cmd,
;*              del1,           del106,         prescott_hw_init,
;*              prescott_hw_deinit,             mou_stream_dis,
;*              mou_stream_en,  int_service,    process_data,
;*              build_pkt.
;*
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   xx/xx/xx  @V2.0xxx01  DCR1555  Micronyx Security Hook
;*
;*****************************************************************************/

;*
;* DEBUG        equ     0       ; on if defined
;*
CALLAB          equ     0       ; 0 - use devhlp,  1 - use CALLABIOS

.286p

.seq
DSEG    segment para public 'DATA'
DSEG    ends
CSEG    segment para public 'CODE'
CSEG    ends


include struc.inc
include proc.inc

include toudderr.inc
include touequ.inc
include toustruc.inc
include toumacro.inc
include devhlpP.inc            ; 76711

;*
;* ABIOS equates
;*

ABIOS_RETRY_CNT         equ     0fffh   ; abios cmd DIU retry count
ABIOS_RESEND_RESP       equ     0feh    ; abios resend response
ABIOS_RESEND_RETRY      equ     500     ; abios tsbs resend count
ABIOS_SOI_RETRY1        equ     3       ;**0.21g abios cmd SOI outer loop
ABIOS_SOI_RETRY2        equ     47241   ;**0.21g abios cmd SOI inner loop
;* 0.21g retry1*retry2*106uS -> 15s

;*
;* retry counter for mouse commands
;* used in stream_en & stream_dis
;*
MOUSE_CMD_RETRY         equ     200
TOUCH_CMD_RETRY         equ     10


        public  prescott_io
        public  prescott_hw_init
        public  prescott_hw_deinit
        public  prescott_failed
        public  read_rqb, cmd_rqb
;*      public  prescott_io_resp
        public  abios_cmd               ; used by TOUMOUA.ASM during mouse init
        public  int_pkt
        public  mou_stream_en, mou_stream_dis
        public  del1_count


        extrn   devhlp:dword
        extrn   essi2dsdi:near
        extrn   dev_status:word
        extrn   idc_disable_dev:near
        extrn   idc_enable_dev:near
        extrn   dddd_idc:byte
        extrn   bmove:near
;*      extrn   emul_current:byte
        extrn   int_pkt_off:word

        extrn   process_data:near

;*      extrn   mou_int_pkt_off:word
;*      extrn   mou_dddd_idc:byte
;*      extrn   mou_dev_status:word

;*      extrn   current_row_siz:word
;*      extrn   current_col_siz:word
;*      extrn   current_col_min:word
;*      extrn   current_col_max:word
;*      extrn   current_row_min:word
;*      extrn   current_row_max:word
;*      extrn   y_offset:word
;*      extrn   x_offset:word

        extrn   prescott_io_resp:byte
        extrn   prescott_io_dat:byte
        extrn   pio_cmd_lens:byte
        extrn   pio_add_lens:byte

        extrn   conf_data:byte
        extrn   raw_mode:byte

        extrn   mconf_irqnum:byte


DSEG    segment

if CALLAB
abios_parms     ABPB    <>
endif

int_pkt         db      3 dup (0)       ; holding buffer for int packet

prescott_failed dw      0               ; permanent failure flag

prescott_lid    dw      ?               ; logical ID of prescott

del1_count      dw      0               ; 1 uS delay cont

                                        ; DCR 1555                    @V2.0xxx01
DD 09CBE9F9Eh                           ; 1st half of DD start signature
DD 0AFAB8BABh                           ; 2nd half of DD start signature
DD Security_Hook1               ; Label name/offset to security hook area start
DD Security_End1                ; Label name/offset to security hook area end
DD 0A19CBEAEh                           ; 1st half of end signature
DD 09E9FAB8Bh                           ; 2nd half of end signature


read_rqb        ABRQB   <>      ; read request block (continuous read only)
cmd_rqb         ABRQB   <>      ; command request block (all other cmds)

public          cmd_status
cmd_status      db      1               ; ?


if 0
;*
;* the following data area must be >= to the largest data item
;* which is download_mc, at the moment!
;*
prescott_io_dat db      255+5+1 dup (0) ; abios tsbs data area

prescott_io_resp db     6 dup (0)       ; (see below for max)

PIO_FIRST_CMD   equ     0b0h
PIO_LAST_CMD    equ     0cfh

;*
;* table of command lengths starting at cmd=0B0h
;* where: 0 is illegal cmd and -1 is 6+n for download micro code
;*

;* Write memory                 B0h
;* Read memory                  B1h
;* STAT REQ                     B2h
;* RES WRAP                     B3h
;* Read code level byte         B4h
;* SET WRAP                     B5h
;* RAM EXE                      B6h
;* Read post status             B7h
;* READ TYPE                    B8h
;* Acquire offsets              B9h >= 130, removed
;* Resend                       BAh
;* Reset                        BBh
;* (not used)                   BCh
;* Set coordinate system        BDh
;* Read processed data          BEh >= 190, read processed data 1 + 12
;* Feed forward data            BFh >= 190, feed forward 33 + 0
;* Load thresholds              C0h >= 130, one word less
;* Set stream mode              C1h
;* Read data                    C2h
;* SET REMOTE                   C3h
;* SET SAMPLE                   C4h
;* Enable stream mode           C5h
;* Disable stream mode          C6h
;* SET DEF                      C7h
;* SET MISC                     C8h
;* Enable raw mode              C9h
;* Enable XYZ mode              CAh
;* (not used)                   CBh
;* Download micro code          CCh
;* SET ENV                      CDh >= 130, removed
;* Set calibration constants    CEh
;* Set filter constants         CFh >= 130, one byte extra (tau)

IF MC_LEVEL ge 190
;*                       0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
;*                       ----------------------------------------------
pio_cmd_lens    db       4, 3, 1, 1, 1, 1, 3, 1, 1, 0, 1, 1, 0,13, 1,33 ; 0B?h
                db       9, 1, 1, 1, 2, 1, 1, 1, 6, 1, 1, 0,-1, 0,41,30 ; 0C?h
ELSE
IF MC_LEVEL ge 130
;*                       0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
;*                       ----------------------------------------------
pio_cmd_lens    db       4, 3, 1, 1, 1, 1, 3, 1, 1, 0, 1, 1, 0,13, 0, 0 ; 0B?h
                db       9, 1, 1, 1, 2, 1, 1, 1, 6, 1, 1, 0,-1, 0,41,30 ; 0C?h
ELSE    ; <130
;*                       0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
;*                       ----------------------------------------------
pio_cmd_lens    db       4, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 0,13, 0, 0 ; 0B?h
                db      11, 1, 1, 1, 2, 1, 1, 1, 6, 1, 1, 0,-1,16,41,29 ; 0C?h
ENDIF   ; >=130
ENDIF   ; >=190

;*
;* table of length of additional responses starting at cmd=0B0h
;* (see prescott work book)
;*
IF MC_LEVEL ge 190
;*                       0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
;*                       ----------------------------------------------
pio_add_lens    db       0, 1, 6, 0, 1, 0, 0, 2, 1, 0, 0, 2, 0, 0,12, 0 ; 0B?h
                db       0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ; 0C?h
ELSE
;*                       0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
;*                       ----------------------------------------------
pio_add_lens    db       0, 1, 6, 0, 1, 0, 0, 2, 1, 1, 0, 2, 0, 0, 0, 0 ; 0B?h
                db       0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ; 0C?h
ENDIF
endif

DSEG    ends


CSEG    segment
        assume  cs:CSEG, ds:DSEG


;/***************************************************************************
;*
;* FUNCTION NAME = prescott_io
;*
;* DESCRIPTION   =
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

PROCEDURE       prescott_io     near

PARAMETER       data_ptr        dword   ; far ptr to data if total length > 1
PARAMETER       cmd             word    ; prescott command

VARIABLE        ax_ret_val      word    ; ax return value

        BEGINPROC

        push    es
        pusha

        ;*
        ;* get cmd length
        ;*
        mov     bx, cmd
        .if     <bx b PIO_FIRST_CMD> or
        .if     <bx a PIO_LAST_CMD>
                ;*
                ;* unsupported cmd
                ;*
pio_err_uns_cmd:
;*      DH_INTERR       f3, f3l
;* int 3
        int_err DSEG,"IBMTOU: prescott_io: illegal cmd"
        .endif

        sub     bx, PIO_FIRST_CMD
        mov     cl, pio_cmd_lens[bx]
        xor     ch, ch                  ; ucbw

        .if     <zero cx>
                ;*
                ;* unsupported cmd
                ;*
                jmp     pio_err_uns_cmd
        .endif

        ;*
        ;* get data for cmd (if any)
        ;*
        .if     <cx a 1>
                ;*
                ;* some data to xfer (ie. not just a single byte cmd)
                ;*
                les     si, data_ptr                    ; source
                mov     di, offset prescott_io_dat+1    ; destination

                .if     <cx eq 255>
                        ;*
                        ;* special case for DMC (variable data count = 6+n)
                        ;*
                        mov     cl, es:[si]     ; get data count from header
                        xor     ch, ch          ; ucbw
                        add     cx, 6           ; + cmd + header + crc
                .endif

                dec     cx              ; not xfering cmd
                call    essi2dsdi
                inc     cx              ; restore true size
                dec     di              ; move to begining of data

        .endif                          ; data xfer size test

        mov     ax, cmd                 ; get command parameter
        call    abios_tsbs              ; do cmd (CY if error)
        mov     ax_ret_val, ax          ; save return value

        popa
        pop     es

        ;*
        ;* check for errors
        ;*
        .if     <c>
                ;*
                ;* an error occurred
                ;* force ax value to be returned, not preserved
                ;*
                mov     ax, ax_ret_val
        .endif


FREEVAR         ax_ret_val

ENDPROC         prescott_io


;/***************************************************************************
;*
;* FUNCTION NAME = abios_tsbs
;*
;* DESCRIPTION   =
;*
;*
;* INPUT         = cl - DAT count (including cmd)
;*                 al - prescott cmd
;*                 ds:di - DAT off (cl != 1)
;*
;* OUTPUT        = ch - additional respose count
;*                 dseg:di - if(ch != 0) di -> additional resp buffer
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

abios_tsbs      proc    near

        push    dx

        mov     si, offset cmd_rqb

        .if     <cl eq 1>

                ;*
                ;* set data buffer addr
                ;*
                mov     [si].abrqb_ssp.tsbsi_DatPtr.xoff,offset prescott_io_dat

                mov     prescott_io_dat.0, al   ; set cmd
;*              mov     prescott_io_dat.1, dl   ; set data byte (cl==2)

        .else

                mov     [di], al                ; save cmd

                ;*
                ;* set data buffer addr
                ;*
                mov     [si].abrqb_ssp.tsbsi_DatPtr.xoff, di

        .endif


        mov     [si].abrqb_ssp.tsbsi_DatPtr.xseg, ds    ; data must be in dseg

        mov     [si].abrqb_ssp.tsbsi_DatCnt, cl         ; save DAT count

        ;*
        ;* get additional length for this cmd
        ;*

        push    bx                      ; save
        mov     bl, al                  ; cmd
        xor     bh, bh                  ; ucbw
        sub     bx, pio_first_cmd       ; first cmd available
        mov     al, pio_add_lens[bx]    ; get additional respose count
        pop     bx                      ; restore

        mov     [si].abrqb_ssp.tsbsi_AddCnt, al

        ;*
        ;* set up buffer for additional resposes
        ;*
        mov     [si].abrqb_ssp.tsbsi_AddPtr.xoff, offset prescott_io_resp
        mov     [si].abrqb_ssp.tsbsi_AddPtr.xseg, ds

        ;*
        ;* set up ACK option
        ;*
        mov     byte ptr [si].abrqb_ssp.tsbsi_AckOpt.1, 0cah    ; ack byte
        mov     byte ptr [si].abrqb_ssp.tsbsi_AckOpt.0, 1       ; ack count


        mov     cx, ABIOS_RESEND_RETRY

abios_tsbs_resend:

        ;*
        ;* ax = func
        ;* si = rqb
        ;* ret = ax
        ;*
        mov     ax, ABIOS_SBS
        call    abios_cmd
        .if     <c>
                ;*
                ;* errors occurred
                ;* test for resend
                ;*
                .if     <ax eq ABIOS_NAK> and
                .if     <[si].abrqb_ssp.tsbso_nonACK eq ABIOS_RESEND_RESP>
                        ;*
                        ;* non-ack respose
                        ;* && response == resend
                        ;*
                        .if     <<byte ptr prescott_io_dat.0> eq PIO_RESET>
                                ;*
                                ;* cmd == reset so do not retry
                                ;*
                                mov     ax, ABIOS_NAK_RESEND
                                jmp     short abios_tsbs_error

                        .endif          ; reset cmd test

                        ;*
                        ;* get num good bytes sent so far
                        ;*
                        mov     al, [si].abrqb_ssp.tsbso_AckCnt
                        xor     ah, ah  ; ucbw


                        .if     <nonzero al>
                                ;*
                                ;* still progressing up RQB
                                ;* so let it continue resending
                                ;* reset retry counters as not retrying
                                ;*
                                mov     cx, ABIOS_RESEND_RETRY

                                ;*
                                ;* calc num of outstanding bytes left
                                ;*
                                sub     [si].abrqb_ssp.tsbsi_DatCnt, al

                                ;*
                                ;* calc start of outstanding bytes left
                                ;* (no check for segment wrap, would be fatal!)
                                ;*
                                add     [si].abrqb_ssp.tsbsi_DatPtr.xoff, ax

                                ;*
                                ;* re-submit command with outstanding data
                                ;*
                                jmp     abios_tsbs_resend

                        .else   ;* retrying @ same point
                                ;* so start timeing out

                                ;*
                                ;* jif retry still running
                                ;*
                                loop    abios_tsbs_resend

                                ;*
                                ;* loop timed out
                                ;* fall thru with timeout error
                                ;*
                                mov     ax, ABIOS_NAK_RESEND

                                ;*
                                ;* set permanent abios failure
                                ;*
                                mov     prescott_failed, ax

                        .endif          ; num bytes to be re-sent, test

                .endif                  ; resend test

                ;*
                ;* here if CY && !(NAK && resend) || retry timeout
                ;*
                jmp     short abios_tsbs_error

        .endif                          ; CY test


        ;*
        ;* get num additional resposes rxed
        ;*
        mov     ch, [si].abrqb_ssp.tsbso_AddCnt

        ;*
        ;* setup additional data ptr if any addit. resposes
        ;*
        .if     <nonzero ch>
                mov     di, [si].abrqb_ssp.tsbsi_AddPtr.xoff
        .endif

        clc                             ; no erorrs

        jmp     short abios_tsbs_exit

abios_tsbs_error:
        stc

public abios_tsbs_exit
abios_tsbs_exit:

        pop     dx

        ret

abios_tsbs      endp


;/***************************************************************************
;*
;* FUNCTION NAME = abios_cmd
;*
;* DESCRIPTION   =
;*
;*
;*
;*
;* INPUT         = ax - func
;*                 ds:si - request block
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = ax - abios ret
;*
;* RETURN-ERROR  = CY set if DH or ABIOS error
;*
;**************************************************************************/

PROCEDURE       abios_cmd       near    ; 0.21g

VARIABLE        soi_to1         word    ; 0.21g stage-on-int time-out
VARIABLE        soi_to2         word    ; 0.21g stage-on-int time-out

        BEGINPROC                       ; 0.21g

        push    cx
        push    dx

        .if     <prescott_failed ne 0>
                mov     ax, prescott_failed
                jmp     short abios_cmd_error
        .endif

        mov     dh, ABIOS_START         ; start entry point

        mov     cx, ABIOS_RETRY_CNT     ; set busy retry count

        mov     soi_to1, ABIOS_SOI_RETRY1 ; 0.21g set soi retry counter 1
        mov     soi_to2, ABIOS_SOI_RETRY2 ; 0.21g set soi retry counter 2

        mov     [si].abrqb_func, ax     ; save RQ function

        mov     dl, 36h                 ; set func for devhlp


abios_cmd_retry:

        mov     ax, prescott_lid        ; get LID for devhlp

        .if     <zero dh>
                ;*
                ;* init return code if start entry
                ;*
                mov     [si].abrqb_ret, -1
        .endif

        sti

        ;*
        ;* call ABIOS
        ;*
        call    devhlp
        jc      abios_cmd_error         ; jif devhlp failed


abios_cmd_wait:

        mov     ax, [si].abrqb_ret      ; get response

        .if     <ax eq ABIOS_DIU>
                ;*
                ;* wait for device to be available
                ;*

                loop    abios_cmd_retry

                ;*
                ;* device not available, timeout
                ;*
                jmp     short abios_cmd_error

        .endif                          ; diu test



        .if     <bit ax and ABIOS_ERR>
                ;*
                ;* jif error & not DIU (this includes retry)
                ;*
                jmp     short abios_cmd_error
        .endif                          ; abios error test



        .if     <ax eq ABIOS_SOT>
                ;*
                ;* (stops KB hits causing error during microcode download)
                ;*

                ;*
                ;* get uSec delay period
                ;*
                mov     ax, word ptr [si].abrqb_ssp.8

                ;*
                ;* delay for ax micro-seconds
                ;*
@@:             call    del1
                dec     ax
                jnz     @B

                mov     dh, ABIOS_INT   ; entry now stage-on-int
                jmp     abios_cmd_retry
        .endif


        ;*
        ;* Wait for cmd to complete in int service routine
        ;*   if cmd is not, set-continuous-read
        ;*

        .if     <[si].abrqb_func ne ABIOS_CONTREAD>


                .if     <ax eq ABIOS_SOI>
                        ;*
                        ;* jif cmd still in progress or
                        ;* if not my interrupt
                        ;*

                        ;*
                        ;* delay here to reduce effect of different
                        ;*  model speeds
                        ;*
                        call    del106          ; 0.21g delay 106uS

                        dec     soi_to2
                        jnz     abios_cmd_wait  ; 0.21g jif not timed out

                        ;*
                        ;* reset soi-to2 ready for next try
                        ;*
                        mov     soi_to2, ABIOS_SOI_RETRY2 ;**0.21g

                        dec     soi_to1         ; 0.21g
                        jnz     abios_cmd_wait  ; 0.21g jif not timed out

                        ;*
                        ;* timed out waiting for cmd to complete
                        ;*
                        jmp     short abios_cmd_error
                .endif

                ;*
                ;* not SOI but has cmd finished ok?
                ;*
                .if     <ax ne ABIOS_OK>
                        ;*
                        ;* jif not soi but not complete
                        ;*
                        jmp     short abios_cmd_error
                .endif

        ;*
        ;* ELSE if not cont read, leave
        ;*
        .endif                          ; cont-read test

        clc
        jmp     short abios_cmd_exit


abios_cmd_error:
        stc


abios_cmd_exit:

        pop     dx
        pop     cx

;*
;* 0.21g        ret
;* 0.21g abios_cmd      endp
;*


FREEVAR         soi_to                  ; 0.21g
FREEVAR         soi_to1                 ; 0.21g

ENDPROC         abios_cmd               ; 0.21g


;/***************************************************************************
;*
;* FUNCTION NAME = del1
;*
;* DESCRIPTION   = Delay 1 microsecond
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

del1    proc    near

        push    cx

        mov     cx, del1_count

        .if     <zero cx>
                ;*
                ;* not yet done
                ;*
                push    ax

                pushf
                cli

                ;*
                ;* get refresh hi cycle time
                ;*
@@:             in      al, 61h
                and     al, 10h
                jz      @B              ; jif while lo

                ;*
                ;* refresh now hi
                ;*
@@:             in      al, 61h
                inc     cx              ; bump count
                and     al, 10h
                jnz     @B              ; jif while hi

                POPFF                   ; retore int flag

                ;*
                ;* derive delay count for 1 uS loop
                ;* (eqn empirically determined)
                ;* count = (1.5*CX + 7)/8
                ;*

                imul    ax, cx, 3       ; ax = cx*3
                add     ax, 14          ; ax += 14
                shr     ax, 4           ; ax /= 16
                inc     ax              ; round up!
                mov     del1_count, ax  ; save count

                pop     ax

                ;*
                ;* over a uS wasted above, so just exit
                ;*

        .else                           ; delay counter already setup

                ;*
                ;* wait ...
                ;*
                loop    $               ; (8 clocks per loop)

        .endif

        pop     cx

        ret

del1    endp


;/***************************************************************************
;*
;* FUNCTION NAME = del106
;*
;* DESCRIPTION   = Delay 106 micro seconds
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

del106  proc    near

        push    ax
        push    cx

        mov     cx, 7+1                 ; 7 * 15.12 -> 106uS
        ;*
        ;* +1 because al probably != ah first time in
        ;*

        ;*
        ;* wait for refresh bit to flip
        ;*
@@:     in      al, 61h                 ; pio port B
        and     al, 10h                 ; refresh bit
        cmp     al, ah                  ; bit flipped?
        je      @B                      ; jif same

        ;*
        ;* bit has flipped
        ;*
        mov     ah, al                  ; save for next compare

        loop    @B                      ; do it again

        pop     cx
        pop     ax

        ret

del106  endp


;/***************************************************************************
;*
;* FUNCTION NAME = prescott_hw_init
;*
;* DESCRIPTION   =
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

PROCEDURE       prescott_hw_init        near

VARIABLE        returncode      word

        BEGINPROC


        mov     returncode, 0


        DH_GETLID       PD_DEVID, 1, 0  ; id, relative lid#, shared
        .if     <c>
                mov     returncode, ERR_DD_LID
                jmp     hw_init_fail2
        .endif

        ;*
        ;* save LID in working RQBs
        ;*

        mov     prescott_lid, ax
        mov     read_rqb.abrqb_lid, ax
        mov     cmd_rqb.abrqb_lid, ax


if CALLAB
;*
;* ??? undocumented call so better to remove & use devhelp calling convention
;*
        ;*
        ;* get ABIOS parms for O/S direct calling with CALLABIOS macro
        ;*

        DH_ABIOSGPARMS  prescott_lid, abios_parms
        .if     <c>
                mov     returncode, ERR_DD_GPARM
                jmp     short hw_init_fail1
        .endif
endif

        ;*
        ;* get lid parms for RQB len
        ;*

        mov     ax, ABIOS_GETLIDP
        mov     si, offset cmd_rqb
        call    abios_cmd
        .if     <c>
;*              error   [si].abrqb_ret
                mov     returncode, ERR_DD_INIGLP
                jmp     short hw_init_fail1
        .endif

        ;*
        ;* save returned RQB length in working RQBs
        ;*

        mov     ax, word ptr cmd_rqb.abrqb_ssp.8
        .if     <ax a <size ABRQB>>
                ;*
                ;* rqb too small!
                ;*
                int_err DSEG,"IBMTOU: abios rqb too small"
        .endif

        mov     cmd_rqb.abrqb_len, ax
        mov     read_rqb.abrqb_len, ax

        mov     al, byte ptr cmd_rqb.abrqb_ssp.0        ; hw int level
        ;*
        ;* save irq number
        ;*
        mov     mconf_irqnum, al                        ; for mouse
        mov     conf_data.conf_irq_num, al              ; for touch


;*
;* ??? build int mask ??
;*

        ;*
        ;* hook AUX int; shared between mouse & touch display
        ;*
        DH_SETIRQ       int_service, MOU_INT_NUM, 0
        .if     <c>
                mov     returncode, ERR_DD_SIRQ
                jmp     short hw_init_fail1
        .endif

        ;*
        ;* enable interrupts
        ;*
        call    idc_enable_dev

        ;*
        ;* abios is callable
        ;*
        or      dev_status, DEVS_ABIOS

        ;*
        ;* set continuous read (enables 8042 ints)
        ;*
        mov     ax, ABIOS_CONTREAD
        mov     si, offset read_rqb
        mov     byte ptr [si].abrqb_ssp.0, 3            ; mouse read packet size
        call    abios_cmd
        .if     <c>
;*              error   [si].abrqb_ret
                mov     returncode, ERR_DD_INICNTR
                jmp     short hw_init_fail
        .endif

        clc
        jmp     short hw_init_exit


hw_init_fail:
hw_init_fail1a:

        DH_UNSETIRQ     MOU_INT_NUM

hw_init_fail1:
hw_init_fail2a:
hw_init_fail2:

        DH_FREELID      prescott_lid

        mov     ax, returncode

        stc

hw_init_exit:


FREEVAR         returncode

ENDPROC         prescott_hw_init


;/***************************************************************************
;*
;* FUNCTION NAME = prescott_hw_deinit
;*
;* DESCRIPTION   =
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

PROCEDURE       prescott_hw_deinit      near

        BEGINPROC

        DH_UNSETIRQ     MOU_INT_NUM
        DH_FREELID      prescott_lid

ENDPROC         prescott_hw_deinit


;/***************************************************************************
;*
;* FUNCTION NAME = mou_stream_dis
;*
;* DESCRIPTION   =
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

mou_stream_dis  proc    near

                mov     cx, MOUSE_CMD_RETRY

stream_dis_mou_retry:

                mov     ax, ABIOS_DISABLE
                mov     si, offset cmd_rqb
                call    abios_cmd
                .if     <c>
                        .if     <ax eq ABIOS_RESEND>
                                loop    stream_dis_mou_retry
fatal1:

;*
;* DH_INTERR    fm1, fm1l
;* int 3;TEMP for testing retry
;*
                                stc
                        .endif
                .endif

        ret

mou_stream_dis  endp


;/***************************************************************************
;*
;* FUNCTION NAME = mou_stream_en
;*
;* DESCRIPTION   =
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

mou_stream_en   proc    near

                mov     cx, MOUSE_CMD_RETRY

stream_en_mou_retry:

                mov     ax, ABIOS_ENABLE
                mov     si, offset cmd_rqb
                call    abios_cmd
                .if     <c>
                        .if     <ax eq ABIOS_RESEND>
                                loop    stream_en_mou_retry
;*
;* jmp    fatal1
;* int 3
;*
                                stc
                        .endif
                .endif

        ret

mou_stream_en   endp


;/***************************************************************************
;*
;* FUNCTION NAME = int_service
;*
;* DESCRIPTION   =
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

pubdeb          int_service
PROCEDURE       int_service     far

VARIABLE        int_status      word

        BEGINPROC


;*
;* values for int status local variable
;*

ISTAT_INIT      equ     0               ; initialize
ISTAT_OURS      equ     1               ; our interrupt
ISTAT_EOI       equ     2               ; EOI needed

        mov     int_status, ISTAT_INIT

        sti
        Security_Hook1 LABEL near       ; DCR 1555 Micronyx           @V2.0xxx01
        nop                             ;   Security Hook             @V2.0xxx01
        nop                             ; Do not Remove               @V2.0xxx01
        nop                             ;                             @V2.0xxx01
        nop                             ;                             @V2.0xxx01
        nop                             ;                             @V2.0xxx01
        nop                             ;                             @V2.0xxx01
        nop                             ;                             @V2.0xxx01
        nop                             ;                             @V2.0xxx01
        Security_End1 LABEL near        ; DCR 1555                    @V2.0xxx01

ife CALLAB

if1
%out *** ABIOS call by DevHlp
endif
        mov     si, offset read_rqb
        mov     ax, [si].abrqb_lid
        mov     dx, 0136h
        call    devhlp
else
if1
%out *** ABIOS call by CALLABIOS macro
endif
        CALLABIOS       read_rqb, ABIOS_INT, abios_parms
endif

        .if     <[si].abrqb_ret ne ABIOS_SOI_NMI>
                ;*
                ;* our int
                ;*

                or      int_status, ISTAT_OURS

;*  1           cli
;*  1           DH_EOI  mconf_irqnum
or      int_status, ISTAT_EOI           ; eoi needed

                .if     <[si].abrqb_ret eq ABIOS_SOI_ATTN>
                        ;*
                        ;* packet now completly assembled
                        ;*

                        ;*
                        ;* move to holding buffer for processing
                        ;*
                        mov     al, byte ptr [si].abrqb_ssp.12
                        mov     byte ptr int_pkt.0, al
                        mov     al, byte ptr [si].abrqb_ssp.13
                        mov     byte ptr int_pkt.1, al
                        mov     al, byte ptr [si].abrqb_ssp.14
                        mov     byte ptr int_pkt.2, al

                        call    process_data

                .endif                  ; packet complete test


;*      .elseif <bit cmd_status and 1>
        .else
                ;*
                ;* not read rqb int
                ;* must be a cmd in progress or a spurious int
                ;*

ife CALLAB
                mov     si, offset cmd_rqb
                mov     ax, [si].abrqb_lid
                mov     dx, 0136h

                ;*
                ;* if( func == touch-send-byte-string )
                ;*      save DS to pointers, for bimodality
                ;*

                .if     <[si].abrqb_func eq ABIOS_SBS>
                        mov     [si].abrqb_ssp.tsbsi_DatPtr.xseg, ds
                        mov     [si].abrqb_ssp.tsbsi_AddPtr.xseg, ds
                .endif

                call    devhlp
else
                CALLABIOS       cmd_rqb, ABIOS_INT, abios_parms
endif

                .if     <[si].abrqb_ret ne ABIOS_SOI_NMI>

                        or      int_status, (ISTAT_OURS or ISTAT_EOI)

                        .if     <[si].abrqb_ret ne ABIOS_SOI_ATTN>

;*
;* Used if block rather than spin in wait for int complete
;* Would also need a cmd exclusion semephore, maybe
;*                              and     cmd_status, not 1       ; cmd complete
;*
;*                               .if     <bit cmd_status and 2>
;*                                       DH_RUN  EventId
;*                               .endif
;*
                        .endif
                .endif

        .endif                          ; read rqb our int test

        ;*
        ;* clean up at end of int
        ;*

        .if     <bit int_status and ISTAT_OURS>

                .if     <bit int_status and ISTAT_EOI>

                        cli
                        ;* DH_EOI  mconf_irqnum See Toumacro.inc Removed 76711
                        DevEOI    <mconf_irqnum>,DevHlp ;        Add     76711
                .endif

                clc                     ; our int, EOI done

        .else
                stc                     ; not our int, EOI needed
        .endif


FREEVAR         int_status

ENDPROC         int_service


;/***************************************************************************
;*
;* FUNCTION NAME = process_data
;*
;* DESCRIPTION   = Process data for int service rtn
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/
if 0

pubdeb  process_data
process_data    proc    near

        ;*
        ;* move to internal data pkt
        ;*
        .if     <bit <byte ptr [si].abrqb_ssp.12> and 8>
                ;*
                ;* current packet is for mouse
                ;* reset data count
                ;*
                mov     data_count, 0

        .else   ; touch packet

                .if     <bit <byte ptr [si].abrqb_ssp.12> and 80h>
                        ;*
                        ;* 2nd packet rxed
                        ;*

                        .if     <data_count eq 0>
                                ;*
                                ;* 2nd follwed by 2nd, expecting 1st pkt
                                ;* discard current pkt, wait for new 1st
                                ;*

                                jmp     proc_data_exit
                        .endif

                .else                   ; 1st packet rxed

                        .if     <data_count eq 3>
                                ;*
                                ;* 1st followed by 1st, expecting 2nd pkt
                                ;* discard last pkt, keep current 1st
                                ;*

                                mov     data_count, 0
                        .endif

                .endif                  ; 1st/2nd pkt test

        .endif                          ; mouse/touch pkt test

        mov     di, data_count

        mov     al, byte ptr [si].abrqb_ssp.12
        mov     byte ptr data_pkt[di].0, al
        mov     al, byte ptr [si].abrqb_ssp.13
        mov     byte ptr data_pkt[di].1, al
        mov     al, byte ptr [si].abrqb_ssp.14
        mov     byte ptr data_pkt[di].2, al

;*
;* probably not needed with above .if statements
;*
        add     word ptr data_count, 3

        ;*
        ;*   might be better to use [si].......
        ;*
        .if     <bit <byte ptr data_pkt.0> and 8> near
                ;*
                ;* current packet is for mouse
                ;*

                ;*
                ;* one pkt for mouse
                ;*
                mov     data_count, 0

                .if     <bit mou_dev_status and DEVS_READ_EN>
                        ;*
                        ;* mou DIDD ready for data
                        ;*

                        xor     cx, cx
                        mov     ah, byte ptr data_pkt.0

                        shr     ah, 1
                        .if     <c>
                                or      cx, 2
                        .endif

                        shr     ah, 1
                        .if     <c>
                                or      cx, 8
                        .endif

                        mov     bh, byte ptr data_pkt.1
                        mov     bl, byte ptr data_pkt.2
                        neg     bl

                        .if     <bx eq 0>
                                shl     cx, 1
                        .else
                                .if     <cx eq 0>
                                        inc     cx
                                .endif
                        .endif

                        push    ds      ; save
                        push    es      ; save
                        push    ds      ; ds ->
                        mov     si, mou_int_pkt_off
                        push    ax
                        GET_MODE        ; carry set if prot
                        pop     ax

                        .if     <c>
                                ;*
                                ;* set prot mode DS
                                ;*
                                mov     ds, mou_dddd_idc.idc_p_ds
                        .else
                                ;*
                                ;* set real mode DS
                                ;*
                                mov     ds, mou_dddd_idc.idc_r_ds
                        .endif

                        mov     [si], cx
                        mov     al, bh
                        cbw
                        mov     [si].2, ax
                        mov     al, bl
                        cbw
                        mov     [si].4, ax

                        pop     es      ; -> es

                        ;*
                        ;* call mou DIDD
                        ;*
                        XIDC_PROCPKT    mou_dddd_idc

                        pop     es      ; restore
                        pop     ds      ; restore

                .endif                  ; mou DIDD ready test

        .else near                      ; touch packet processing


            .if <data_count eq 6> near
                ;*
                ;* received 2nd pkt
                ;*

                mov     data_count, 0

                ;*
                ;* reformat interrupt packet
                ;*
                mov     di, offset data_pkt
                mov     si, offset curr_pkt
                call    build_pkt

                .if     <bit dev_status and DEVS_READ_EN> near

                    .if <emul_current eq 1> near
                        ;*
                        ;* absolute mouse emulation
                        ;*

;*
;* ?? if emulation on only return one button for mou Qconfig
;*

                        .if     <bit mou_dev_status and DEVS_READ_EN> near
                                ;*
                                ;* mou DIDD ready for emulated data
                                ;*

                                xor     cx, cx          ; no buttons yet

                                ;*
                                ;* get button emulation
                                ;*
                                .if     <bit curr_pkt.tpkt_stat and IOC_REQS_SD>
                                        or      cx, 4   ; button1, no motion
                                .endif


labdeb  add_off_e
                                ;*
                                ;* get x (col) -> bx
                                ;* get y (row) -> ax
                                ;* add in offsets
                                ;*

                                mov     bx, curr_pkt.tpkt_x     ; col
                                mov     ax, curr_pkt.tpkt_y     ; row

                                ;*
                                ;* add x (col) offset
                                ;*
                                add     bx, x_offset

                                ;*
                                ;* check x bounds
                                ;*
                                .if     <bx gt current_col_max>
                                        mov     bx, current_col_max
                                .endif

                                .if     <bx lt current_col_min>
                                        mov     bx, current_col_min
                                .endif

                                ;*
                                ;* add y (row) offset
                                ;*
                                add     ax, y_offset

                                ;*
                                ;* check y bounds
                                ;*
                                .if     <ax gt current_row_max>
                                        mov     ax, current_row_max
                                .endif

                                .if     <ax lt current_row_min>
                                        mov     ax, current_row_min
                                .endif

                                push    ds      ; save
                                push    es      ; save
                                push    ds      ; ds -> (es later)
                                mov     si, mou_int_pkt_off
                                push    ax
                                GET_MODE        ; carry set if prot
                                pop     ax
                                .if     <c>

                                        ;*
                                        ;* set prot mode DS
                                        ;*
                                        mov     ds, mou_dddd_idc.idc_p_ds

                                .else

                                        ;* set real mode DS
                                        mov     ds, mou_dddd_idc.idc_r_ds

                                .endif

                                pop     es      ; (DDDD ds) -> es

                                ;*
                                ;* ds:si -> mou int packet (in mou DIDD)
                                ;* es:   -> DDDD dseg
                                ;*

                                mov     [si].abse_stat, cx

                                mov     [si].abse_row_pos, ax   ; y
                                mov     [si].abse_col_pos, bx   ; x

                                mov     ax, es:current_row_siz
                                mov     [si].abse_row_siz, ax
                                mov     ax, es:current_col_siz
                                mov     [si].abse_col_siz, ax

                                        ; call mou DIDD
                                XIDC_ABSPROCPKT mou_dddd_idc

                                pop     es                      ; restore
                                pop     ds                      ; restore

                        .endif          ; mou DIDD ready for emul data, test


                    .elseif     <emul_current eq 2> near
                        ;*
                        ;* glass mouse emulation
                        ;*

                        .if     <bit curr_pkt.tpkt_stat and IOC_REQS_OS> near
                                ;*
                                ;* onscreen
                                ;*

                            .if <bit curr_pkt.tpkt_stat and IOC_REQS_DOS1>
                                ;*
                                ;* touch down
                                ;*

                                push    offset curr_pkt
                                push    offset ds:td_pkt
                                push    size TPKT
                                call    bmove

                            .else       ; not touch down

                                .if     <bit mou_dev_status and DEVS_READ_EN>
                                        ;*
                                        ;* mou DIDD ready for data
                                        ;*

                                        ;*
                                        ;* set x value
                                        ;*
                                        mov     bx, curr_pkt.tpkt_x
                                        sub     bx, last_pkt.tpkt_x

;*
;* ??? \/ these need to be changed to parameters
;*
sar bx, 1
                                        ;*
                                        ;* set y value
                                        ;*
                                        mov     ax, curr_pkt.tpkt_y
                                        sub     ax, last_pkt.tpkt_y

sar ax, 2
                                        mov     cx, ax
                                        or      cx, bx
                                        .if     <nonzero cx>
                                                ;*
                                                ;* movement
                                                ;* & no button yet
                                                ;*
                                                mov     cx, 1

                                        .else   ;*
                                                ;* no movement
                                                ;* & no button yet
                                                ;*
                                                mov     cx, 2

                                        .endif

                                        ;*
                                        ;* get button emulation
                                        ;*
                                        .if     <bit curr_pkt.tpkt_stat and IOC_REQS_SD>
                                                shl     cx, 1   ; button1 down
                                        .endif

                                        push    ds      ; save
                                        push    es      ; save
                                        push    ds      ; ds ->
                                        mov     si, mou_int_pkt_off
                                        push    ax
                                        GET_MODE                ; carry set if prot
                                        pop     ax

                                        .if     <c>
                                                ;*
                                                ;* set prot mode DS
                                                ;*
                                                mov     ds, mou_dddd_idc.idc_p_ds

                                        .else
                                                ;*
                                                ;* set real mode DS
                                                ;*
                                                mov     ds, mou_dddd_idc.idc_r_ds

                                        .endif

                                        mov     [si].0, cx
                                        mov     [si].2, bx
                                        mov     [si].4, ax
                                        pop     es      ; -> es

                                        ;*
                                        ;* call mou DIDD
                                        ;*
                                        XIDC_PROCPKT    mou_dddd_idc

                                        pop     es      ; restore
                                        pop     ds      ; restore

                                .endif                  ; mou DIDD ready test

                            .endif                      ; touch down test

                        .endif                          ; on screen test

                    .else       near                    ; not emulating

                        ;*
                        ;* touch mode
                        ;*

                        ;*
                        ;* DIDD ready for data
                        ;*
                        push    ds      ; save
                        push    es      ; save

                        ;* mov  es, ds
                        push    ds      ; ds ->
                        pop     es      ; -> es

                        GET_MODE        ; carry set if prot
                        .if     <c>
                                ;*
                                ;* set prot mode data seg
                                ;*
                                mov     ds, dddd_idc.idc_p_ds

                        .else
                                ;*
                                ;* set real mode data seg
                                ;*
                                mov     ds, dddd_idc.idc_r_ds

                        .endif

                        mov     di, offset DSEG:data_pkt
                        mov     si, es:int_pkt_off

                        ;*
                        ;* es:di -> dddd data pkt (source)
                        ;* ds:si -> didd data pkt (dest)
                        ;*
                        ;* build data pkt from int buff
                        ;*

                        ;*
                        ;* XYZ mode
                        ;*
                        mov     di, offset es:curr_pkt

                        mov     [si].evnt_r, 0          ; clr reserved

                        ;*
                        ;* set z value
                        ;*
                        mov     ax, es:[di].tpkt_z
                        mov     [si].evnt_z, ax

labdeb  add_off_t
                        ;*
                        ;* es -> dddd dseg
                        ;* ds -> didd dseg
                        ;*
                        ;* get x (col) value
                        ;* add offsets
                        ;*
                        mov     ax, es:[di].tpkt_x

                        ;*
                        ;* add x (col) offset
                        ;*
                        add     ax, es:x_offset

                        ;*
                        ;* check x bounds
                        ;*
                        .if     <ax gt es:current_col_max>
                                mov     ax, es:current_col_max
                        .endif

                        .if     <ax lt es:current_col_min>
                                mov     ax, es:current_col_min
                        .endif

                        mov     [si].evnt_x, ax         ; into didd

                        ;*
                        ;* get y (row) value
                        ;* add offsets
                        ;*

                        mov     ax, es:[di].tpkt_y

                        ;*
                        ;* add y (row) offset
                        ;*
                        add     ax, es:y_offset

                        ;*
                        ;* check y bounds
                        ;*
                        .if     <ax gt es:current_row_max>
                                mov     ax, es:current_row_max
                        .endif

                        .if     <ax lt es:current_row_min>
                                mov     ax, es:current_row_min
                        .endif

                        mov     [si].evnt_y, ax ; into didd

                        ;*
                        ;* set status
                        ;*
                        mov     ax, es:[di].tpkt_stat
                        mov     [si].evnt_stat, ax

                        ;*
                        ;* call tou DIDD
                        ;*
                        XIDC_PROCPKT    dddd_idc

                        pop     es      ; restore
                        pop     ds      ; restore

                    .endif              ; emulation test

                .endif                  ; tou DIDD ready test

                ;*
                ;* save current data packet
                ;*

                push    offset curr_pkt
                push    offset ds:last_pkt
                push    size TPKT
                call    bmove

            .endif                      ; tou double pkt rcvd test

        .endif                          ; mou/tou packet test

proc_data_exit:
        ret

process_data    endp


;/***************************************************************************
;*
;* FUNCTION NAME = build_pkt
;*
;* DESCRIPTION   = Reformat int buffer into holding buffer
;*                 ds:di -> interrupt buffer (XYZ)
;*                 ds:si -> formated holding buffer (TPKT)
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

build_pkt       proc    near

        pushf
        cli

        xor     cx, cx                  ; clear status

        ;*
        ;* set z value
        ;*
        mov     al, [di].xyz_z
        xor     ah, ah                  ; ucbw
        mov     [si].tpkt_z, ax

        .if     <ax ne old_z>
                or      cx, IOC_REQS_DZ ; z changed
                mov     old_z, ax       ; update
        .endif

        ;*
        ;* set x value
        ;*
        mov     al, [di].xyz_xl
        mov     ah, [di].xyz_yxh
        and     ah, 0fh                 ; get lo nib
        mov     [si].tpkt_x, ax

        .if     <ax ne old_x>
                or      cx, IOC_REQS_DXY; x changed
                mov     old_x, ax       ; update
        .endif

        ;*
        ;* set y value
        ;*
        mov     al, [di].xyz_yl
        mov     ah, [di].xyz_yxh
        shr     ah, 4                   ; get hi nib
        mov     [si].tpkt_y, ax

        .if     <ax ne old_y>
                or      cx, IOC_REQS_DXY; y changed
                mov     old_y, ax       ; update
        .endif

        ;*
        ;* set other statuses
        ;*
        mov     al, [di].xyz_s1         ; get prescott status 1

        .if     <bit al and <PRES_S1_HE or PRES_S1_OE or PRES_S1_FE>>
                ;*
                ;* hard err || offs adj || float point
                ;*
                or      cx, IOC_REQS_HW_ERR     ; hardware error
        .endif


        .if     <bit al and PRES_S1_CP>
                or      cx, IOC_REQS_CP ; pegged
        .endif


        .if     <bit al and PRES_S1_TI>
                or      cx, IOC_REQS_UL ; unlocked
        .endif


        ;*
        ;* do not use prescott ts2
        ;* fake up ts2 from ts1 & old_s2
        ;*

        mov     al, [di].xyz_s2         ; get current s2
        mov     ah, old_s2              ; get old s2

        .if     <bit al and PRES_S2_TS1>
                ;*
                ;* currently on-screen
                ;*
                or      cx, IOC_REQS_OS ; on screen

                .if     <bit ah nand PRES_S2_TS1>
                        ;*
                        ;* new=1 old=0 (off to on screen)
                        ;* was off-screen
                        ;*
                        or      cx, IOC_REQS_DOS1
                .endif

        .else                           ; currently off-screen

                .if     <bit ah  and PRES_S2_TS1>
                        ;*
                        ;* new=0 old=1 (on to off screen)
                        ;* was on-screen
                        ;*
                        or      cx, IOC_REQS_DOS0
                .endif

        .endif                          ; ts1 test


        .if     <bit al and PRES_S2_SD>
                ;*
                ;* currently selected
                ;*
                or      cx, IOC_REQS_SD ; select detected

                .if     <bit ah nand PRES_S2_SD>
                        ;*
                        ;* new=1 old=0 (un-selected to selected)
                        ;* was un-selected
                        ;*
                        or      cx, IOC_REQS_DSD1
                .endif

        .else                           ; currently un-selected

                .if     <bit ah  and PRES_S2_SD>
                        ;*
                        ;* new=0 old=1 (selected to un-selected)
                        ;* was selected
                        ;*
                        or      cx, IOC_REQS_DSD0
                .endif

        .endif                          ; sd test


        mov     old_s2, al              ; update old status
        mov     [si].tpkt_stat, cx      ; save completed status

        POPFF

        ret

build_pkt       endp

endif

CSEG    ends

        end
;*
;* end of file
;*
