;******************************************************************************
;*
;*                              File SSOS2.INC
;*
;*                          OS2 related definitions
;*
;*            Copyright (c) Award Software International Inc., 1994
;*
;*
;******************************************************************************

ifndef   __SSOS2_INC_
__SSOS2_INC_            equ     1

MAX_MSG                 equ     4192        ; Size of message buffer
                        include utilmd17.inc ; User defined messages

;---------------------- OS/2 Init Command Request Packet ----------------------

InitPacket              struc
Pkt_Len                 db      ?           ; length in bytes of packet
Pkt_Unit                db      ?           ; subunit number of block device
Pkt_Cmd                 db      ?           ; command code
Pkt_Status              dw      ?           ; status word
Pkt_Flag                db      ?           ; disk driver internal flags
                        db      3 dup(?)    ; reserved
Pkt_DevLink             dd      ?           ; device multiple-request link

PktInitcUnit            db      ?           ; number of units returned
PktInitpEnd             dd      ?           ; On Exit:  pointer to free mem
                                            ; after dev
                                            ; On Entry: address of Device
                                            ; Helper router
PktInitParms            dd      ?           ; pointer parameters
InitPacket              ends

;----------------------------- Attach DD structure ----------------------------

AttachDD_Data           struc
ADDD_Reserved1          dw      ?
ADDD_Reserved2          dw      ?
ADDD_Reserved3          dw      ?
ADDD_IDCOff             dw      ?           ; IDC Entry point offset
ADDD_IDCSeg             dw      ?           ; IDC Entry point segment
ADDD_IDCDS              dw      ?           ; Protected mode DS of IDC Driver
AttachDD_Data           ends

AddSS_Data              struc               ; Add Socket Services argument
wAttr                   dw      ?
if PCMCIA_LEVEL GT 210h
pData_Off               dw      ?           ; Socket Services data area offset
endif
pData_Seg               dw      ?           ; Socket Services data area segment
AddSS_Data              ends

AddSS                   equ     032h        ; Add Socket Services function

;--------------------------- OS/2 Device attributes ---------------------------

DEV_IDC         equ     0100000000000000b   ; Support inter-driver communications

DATTR_SS        equ     DEV_CHAR_DEV OR DEV_IDC
                                            ; Character device, supporting
                                            ; inter-driver communications

DATTR_CAPS      equ     DEV_INITCOMPLETE    ; Supports INIT_COMPLETE message

;---------------------- Device commands and return codes ----------------------

UNKNOWN_CMD             equ     3
osGENERAL_FAILURE       equ     0Ch

;-------------------------------- OS2 functions -------------------------------

stdOut                  equ     1           ; Standart Output device
EXTERNDEF               GetSegmPars:near    ; Forward reference
EXTERNDEF               osAddSS:far         ; Forward reference

;------------------------------- OS2 Driver Name ------------------------------

OS2DRVNAME              equ     'SSPCIC$$'

endif                                       ; __SSOS2_INC_
