;******************************************************************************
;*
;*                              File SSMAC.INC
;*
;*                                 Macro's
;*
;*           Copyright (c) Award Software International Inc., 1994
;*
;*
;******************************************************************************

ifndef   __SSMAC_INC_
__SSMAC_INC_    equ     1
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                  PUSHX/POPX
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

pushx   macro   regs                        ;; Push group
        irp     r,<regs>
        push    r
        ENDM
        ENDM

popx    macro   regs                        ;; Pop group
        irp     r,<regs>
        pop     r
        ENDM
        ENDM
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                  Register access during initialisation
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

_DELAY_         MACRO
                jmp     $+2
                ENDM

ADDRESS_REG_AL  MACRO                       ;; Address PCIC register from al
                out     dx, al
                _DELAY_
                inc     dx
                ENDM

ADDRESS_REG     MACRO   reg                 ;; Address PCIC register 'reg'
                mov     al, reg             ;; During setup time: ah - socket
                add     al, ah              ;; index
                ADDRESS_REG_AL
                ENDM

PUT_AL_REG      MACRO
                out     dx, al
                _DELAY_
                dec     dx
                ENDM

SET_PCIC_REG    MACRO   reg, value          ;; Set PCIC register 'reg' to value
                                            ;; 'value'
                ADDRESS_REG reg

                mov     al, value

                PUT_AL_REG
                ENDM

GET_PCIC_REG    MACRO   reg                 ;; Return PCIC register 'reg' value

                ADDRESS_REG reg

                in      al, dx
                _DELAY_
                dec     dx
                ENDM

PUT_PCIC_REG    MACRO   reg                 ;; Write al to PCIC register 'reg'
                push    ax
                ADDRESS_REG reg
                pop     ax
                PUT_AL_REG
                ENDM

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                  staticFP
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
ifndef staticFP
staticFP        MACRO   Name
Name            label   DWORD
Off_&Name       dw      ?
Seg_&Name       dw      ?
                endm
endif                                       ; ifndef staticFP

endif                                       ; ifndef   __SSMAC_INC_
