/**************************************************************************
 *
 * SOURCE FILE NAME = CLIENT.H
 *
 * DESCRIPTIVE NAME = PCMCIA Client Services sample code header file
 *
 *
 *
 * COPYRIGHT    Copyright (C) 1992 IBM Corporation
 *
 * The following IBM OS/2 2.1 source code is provided to you solely for
 * the purpose of assisting you in your development of OS/2 2.x device
 * drivers. You may use this code in accordance with the IBM License
 * Agreement provided in the IBM Device Driver Source Kit for OS/2. This
 * Copyright statement may not be removed.
 *
 *
 *
 * VERSION =
 *
 * DATE        06/22/93
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
 * CHANGE ACTIVITY =
 *
 *   DATE      FLAG        APAR   CHANGE DESCRIPTION
 *   --------  ----------  -----  --------------------------------------
 *   07/10/95  @128895            Structure REQ_IRQ

 ***************************************************************************/



/**************************************************************************
 * Function Definition
 **************************************************************************/

#define ADD_SOCKET_SERVICES      0x32
#define ADJUST_RESOURCE_INFO     0x35
#define CHECK_ERASE_QUEUE        0x26
#define CLOSE_MEMORY             0x00
#define COPY_MEMORY              0x01
#define DEREGISTER_CLIENT        0x02
#define DEREGISTER_ERASE_QUEUE   0x25
#define GET_CARDSERVICES_INFO    0x0B
#define GET_CLIENT_INFO          0x03
#define GET_CONFIGURATIONINFO    0x04
#define GET_EVENT_MASK           0x2E
#define GET_FIRST_CLIENT         0x0E
#define GET_FIRST_PARTITION      0x05
#define GET_FIRST_REGION         0x06
#define GET_FIRST_TUPLE          0x07
#define GET_NEXT_CLIENT          0x2A
#define GET_NEXT_PARTITION       0x08
#define GET_NEXT_REGION          0x09
#define GET_NEXT_TUPLE           0x0A
#define GET_STATUS               0x0C
#define GET_TUPLE_DATA           0x0D
#define MAP_LOG_SOCKET           0x12
#define MAP_LOG_WINDOW           0x13
#define MAP_MEM_PAGE             0x14
#define MAP_PHY_SOCKET           0x15
#define MAP_PHY_WINDOW           0x16
#define MODIFY_CONFIGURATION     0x27
#define MODIFY_WINDOW            0x17
#define OPEN_MEMORY              0x18
#define REGISTER_CLIENT          0x10
#define READ_MEMORY              0x19
#define REGISTER_ERASE_QUEUE     0x0F
#define REGISTER_MTD             0x1A
#define REGISTER_TIMER           0x28
#define RELEASE_CONFIGURATION    0x1E
#define RELEASE_EXCLUSIVE        0x2D
#define RELEASE_IO               0x1B
#define RELEASE_IRQ              0x1C
#define RELEASE_SOCKET_MASK      0x2F
#define RELEASE_WINDOW           0x1D
#define REPLACE_SOCKET_SERVICES  0x33
#define REQUEST_CONFIGURATION    0x30
#define REQUEST_EXCLUSIVE        0x2C
#define REQUEST_IO               0x1F
#define REQUEST_IRQ              0x20
#define REQUEST_SOCKET_MASK      0x22
#define REQUEST_WINDOW           0x21
#define RESET_CARD               0x11
#define RETURN_SS_ENTRY          0x23
#define SET_EVENT_MASK           0x31
#define SET_REGION               0x29
#define VALIDATE_CIS             0x2B
#define VENDOR_SPECIFIC          0x34
#define WRITE_MEMORY             0x24

/*
** AddSocketServices (0x32)
*/
typedef struct ADD_SS {
   USHORT  usAttributes;                /* information about SS entry point  */
   USHORT  usDDData;                    /* pointer to SS data are            */
} ADD_SS, FAR *PADD_SS, NEAR *NPADD_SS;


/*
** AdjustResourceInfo (0x35)
*/

typedef struct ADJ_RESINFO {
   UCHAR   ucAction;                    /* add/remove resource               */
   UCHAR   ucResource;                  /* resource type to adjust           */
} ADJ_RESINFO, FAR *PADJ_RESINFO, NEAR *NPADJ_RESINFO;

   /*
   ** ucAction field definition
   */
#define ARIA_REMOVE              0x00   /* remove                            */
#define ARIA_ADD                 0x01   /* add                               */

   /*
   ** ucResource field definition
   */
#define ARIR_MEMORY_RANGE        0x00   /* system mappable memory range      */
#define ARIR_IO_RANGE            0x01   /* system mappable IO range          */
#define ARIR_STEERABLE_IRQ       0x02   /* system steerable IRQ              */

   /*
   ** System Mappable Memory Range resource adjustment
   */
typedef struct ADJ_RESINFO_M {
   ADJ_RESINFO  adjResInfo;
   USHORT       usAttributes;           /* attributes of the memory range    */
   ULONG        ulBase;                 /* system base address               */
   ULONG        ulSize;                 /* memory window size                */
} ADJ_RESINFO_M, FAR *PADJ_RESINFO_M, NEAR *NPADJ_RESINFO_M;

      /*
      ** usAttributes field definition
      */
#define ARIM_SHARED              0x20   /* shared                            */

   /*
   ** System Mappable IO Range resource adjustment
   */
typedef struct ADJ_RESINFO_I {
   ADJ_RESINFO  adjResInfo;
   USHORT       usBasePort;             /* base port address for range       */
   UCHAR        ucNumPort;              /* number of contiguous ports        */
   UCHAR        ucAttributes;           /* ( defined below )                 */
   UCHAR        ucIOAddrLines;          /* num of IO address lines decoded   */
} ADJ_RESINFO_I, FAR *PADJ_RESINFO_I, NEAR *NPADJ_RESINFO_I;

      /*
      ** ucAttributes field definition
      */
#define ARII_SHARED              0x01   /* shared                            */

   /*
   ** System Steerable IRQ resource adjustment
   */
typedef struct ADJ_RESINFO_Q {
   ADJ_RESINFO  adjResInfo;
   UCHAR        ucAttributes;           /* ( defined below )                 */
   UCHAR        ucIRQ;                  /* IRQ being adjusted                */
} ADJ_RESINFO_Q, FAR *PADJ_RESINFO_Q, NEAR *NPADJ_RESINFO_Q;

      /*
      ** ucAttributes field definition
      */
#define ARIQ_EXCLUSIVE           0x00   /* IRQ type - exclusive              */
#define ARIQ_TIME_MULT_SHARED    0x01   /* IRQ type - time multiplexed shared*/
#define ARIQ_DYNAMIC_SHARED      0x02   /* IRQ type - dynamic shared         */


/*
** CopyMemory (0x01)
*/

typedef struct CPY_MEMORY {
   ULONG   ulSourceOff;                 /* card services address             */
   ULONG   ulDestOff;                   /* card destination address          */
   ULONG   ulCount;                     /* number of bytes to transfer       */
   USHORT  usAttributes;                /* ( defined below )                 */
} CPY_MEMORY, FAR *PCPY_MEMORY, NEAR *NPCPY_MEMORY;

   /*
   ** usAttributes field definition
   */
#define CMA_DISABLE_ERASE         0x0004
#define CMA_VERIFY                0x0008


/*
** GetCardServicesInfo (0x0B)
*/

typedef struct GET_CSINFO {
   USHORT   usInfoLen;                  /* length of data returned by CS     */
   USHORT   usSignature;                /* ASCII "CS" returned if installed  */
   USHORT   usCount;                    /* number of sockets                 */
   USHORT   usRevision;                 /* BCD value of vendor's CS revision */
   USHORT   usCSLevel;                  /* BCD value of CS release           */
   USHORT   usVStrOff;                  /* offset to vendor string in arg pkt*/
   USHORT   usVStrLen;                  /* vendor string length              */
   UCHAR    VendorString[1];            /* ASCII vendor string buffer area   */
} GET_CSINFO, FAR *PGET_CSINFO, NEAR *NPGET_CSINFO;


/*
** GetClientInfo (0x03)
*/

typedef struct GET_CLINFO {
   USHORT   usMaxLen;                   /* length of this packet             */
   USHORT   usInfoLen;                  /* length of info required by client */
   USHORT   usAttributes;               /* (defined in RegisterClient)       */
   UCHAR    clientinfo[1];              /* client information                */
} GET_CLINFO, FAR *PGET_CLINFO, NEAR *NPGET_CLINFO;

   /*
   ** clientinfo field definition
   */
typedef struct CLIENTINFO {
   USHORT  usRevision;                  /* BCD value of vendor client revision*/
   USHORT  usCSLevel;                   /* BCD value of CS release           */
   USHORT  usRevDate;                   /* revision date                     */
   USHORT  usNameOff;                   /* offset to clientname string       */
   USHORT  usNameLen;                   /* length of client name string      */
   USHORT  usVStringOff;                /* offset in pkt to vendor string    */
   USHORT  usVStringLen;                /* length of vendor string           */
   UCHAR   stringArea[1];               /* client name and vendor name       */
} CLIENTINFO, FAR *PCLIENTINFO, NEAR *NPCLIENTINFO;


/*
** GetConfigurationInfo (0x04)
*/

typedef struct GET_CONFGINFO {
   USHORT  usSocket;                    /* Logical socket                    */
   USHORT  usAttributes;                /* (defined  below)                  */
   UCHAR   ucVcc;                       /* Vcc setting                       */
   UCHAR   ucVpp1;                      /* Vpp1 setting                      */
   UCHAR   ucVpp2;                      /* Vpp2 setting                      */
   UCHAR   ucIntType;                   /* memory or memory+I/O interface    */
   ULONG   ucConfigBase;                /* card base addr of config registers*/
   UCHAR   ucStatus;                    /* card status register setting      */
   UCHAR   ucPin;                       /* card pin register setting         */
   UCHAR   ucCopy;                      /* card/scket copy register setting  */
   UCHAR   ucOption;                    /* card option register setting      */
   UCHAR   ucPresent;                   /* card cinfig registers present     */
   UCHAR   ucFirstDevType;              /* from device ID tuple              */
   UCHAR   ucFuncCode;                  /* from function ID tuple            */
   UCHAR   ucSysInitMask;               /* from finction ID tuple            */
   USHORT  usManufCode;                 /* from manufacture ID tuple         */
   USHORT  usManuInfo;                  /* from manufacture ID tuple         */
   UCHAR   ucCardValues;                /* valid card register values        */
   UCHAR   ucAssignedIRQ;               /* IRQ assigned to PC card           */
   USHORT  usIRQAttributes;             /* attributes fir assigned IRQ       */
   USHORT  usBasePort1;                 /* base port address for range       */
   UCHAR   ucNumPort1;                  /* number of contiguous ports        */
   UCHAR   ucAttributes1;               /*                                   */
   USHORT  usBasePort2;                 /* base port address for range       */
   UCHAR   ucNumPort2;                  /* number of contiguous ports        */
   UCHAR   ucAttributes2;               /*                                   */
   UCHAR   ucIOAddrLines;               /* number of IO addr lines decoded   */
} GET_CONFGINFO, FAR *PGET_CONFGINFO, NEAR *NPGET_CONFGINFO;

   /*
   ** usAttributes field definition
   */
#define GCA_EXCLUSIVE         0x0001    /* exclusively used ( set = true     */

   /*
   ** ucCardValues field definition
   */
#define GCCV_OPTION_VALID       0x01    /* option value valid in card config */
#define GCCV_STATUS_VALID       0x02    /* status value valid in card config */
#define GCCV_PIN_VALID          0x04    /* pin value valid in card config    */
#define GCCV_COPY_VALID         0x08    /* copy value valid in card config   */


/*
** GetEventMask (0x2E)
*/

typedef struct GET_EVEMASK {
   USHORT usAttributes;                 /* (defined below.)                  */
   USHORT usEventMask;                  /* (defined below.)                  */
   USHORT usSocket;                     /* logical socket                    */
} GET_EVEMASK, FAR *PGET_EVEMASK, NEAR *NPGET_EVEMASK;

   /*
   ** usAttributes field definition
   */
#define EMA_THIS_COCKET_ONLY    0x0001  /* event mask of this socket only    */

   /*
   ** usEventMask field definition
   */
#define EM_SS_UPDATED           0x0400  /* SS update                         */
#define EM_RESET                0x0200  /* reset events                      */
#define EM_PM_CHANGE            0x0100  /* PM change                         */
#define EM_CARD_DETECT_CHANGE   0x0080  /* card detect change                */
#define EM_READY_CHANGE         0x0040  /* ready change                      */
#define EM_BATTERY_LOW          0x0020  /* battery low                       */
#define EM_BATTERY_DEAD         0x0010  /* battery dead                      */
#define EM_INSERTION_REQUEST    0x0008  /* insertion request                 */
#define EM_EJECTION_REQUEST     0x0004  /* ejection request                  */
#define EM_CARD_LOCK_CHANGE     0x0002  /* card lock change                  */
#define EM_WP_CHANGE            0x0001  /* write protect                     */

#define EM_ALL_EVENTS           0xFFFF


/*
** GetFirstClient (0x0E) / GetNextClient (0x2A)
*/

typedef struct GET_CLIENT {
   USHORT usSocket;                     /* logical socket                    */
   USHORT usAttributes;                 /* (define below)                    */
} GET_CLIENT, FAR *PGET_CLIENT, NEAR *NPGET_CLIENT;

   /*
   ** usAttributes field definition
   */
#define GFCA_THIS_COCKET_ONLY   0x0001  /* client for this socket only       */


/*
** GetFirstPartition (0x05) / GetNextPartition (0x08)
*/

typedef struct GET_PARTITION {
   USHORT usSocket;                     /* logical socket                    */
   USHORT usAttributes;                 /* (defined below)                   */
   UCHAR  ucTupleMask;                  /* (defined below)                   */
   UCHAR  ucAccessSpeed;                /* window speed field                */
   USHORT usFlag;                       /* CS partition flags data           */
   ULONG  ulLinkOff;                    /* CS partition link data            */
   ULONG  ulCISOff;                     /* CS partition CIS data             */
   ULONG  ulCardOff;                    /* card memory region offset         */
   ULONG  ulPartSize;                   /* partition size                    */
   ULONG  ulEffBlockSize;               /* erase block size                  */
   USHORT usPartMultiple;               /* partition multiple                */
   USHORT usJEDECID;                    /* partition JEDEC memory ID code    */
   USHORT usPartType;                   /* partition type field              */
} GET_PARTITION, FAR *PGET_PARTITION, NEAR *NPGET_PARTITION;

   /*
   ** usAttributes field definition
   */
#define PA_MEMORY_TYPE        0x0001    /* memory type (1=attributes,0=common*/
#define PA_VIRTUAL_PARTITION  0x0100    /* virtual partition                 */
#define PA_WRITE_WO_ERASE     0x0000    /* write without erase               */
#define PA_WRITE_W_ERASE      0x0200    /* write with erase                  */
#define PA_WRITE_W_DERASE     0x0600    /* write with disableable erase      */
#define FA_WRITE_W_VERIFY     0x0800    /* write with verify                 */
#define FA_ERASE_SUPPORTED    0x1000    /* erase requests supported          */

   /*
   ** ucTupleMask field definition
   */
#define TM_ACCESS_SPEED         0x01    /* access speed from tuples          */
#define TM_CARD_OFFSET          0x02    /* card offset from tuples           */
#define TM_PART_SIZE            0x04    /* part size from tuples             */
#define TM_EFFBLOCKSIZE         0x08    /* effblocksize from tuples          */
#define TM_PART_MULTIPLE        0x10    /* part multiple from tuples         */
#define TM_JEDEC_ID             0x20    /* JEDEC ID from tuples              */
#define TM_PART_TYPE            0x40    /* part type from tuples             */

   /*
   ** ucAceesSpeed field definition
   */
#define AS_250NSEC              0x02    /* 250 nsec                          */
#define AS_200NSEC              0x04    /* 200 nsec                          */
#define AS_150NSEC              0x08    /* 150 nsec                          */
#define AS_100NSEC              0x10    /* 100 nsec                          */

   /*
   ** ucPartType field definition
   */
#define PT_NO_PARTITION       0x0000    /* no partition information tuple    */
#define PT_DOS_BPB_FAT        0x0001    /* DOS BPB/FAT partition             */
#define PT_FFS_1              0x0002    /* FFS 1 partition                   */
#define PT_FFS_2              0x0003    /* FFS 2 partition                   */
#define PT_XIP                0x0004    /* XIP partition                     */
#define PT_UNKNOWN            0x7FFF    /* unknown partition                 */


/*
** GetFirstRegion (0x06) / GetNextRegion (0x09)
*/

typedef struct GET_REGION {
   USHORT usSocket;                     /* logical socket                    */
   USHORT usAttributes;                 /* (defined in GetFirstPartition)    */
   UCHAR  ucTupleMask;                  /* (defined in GetFirstPartition)    */
   UCHAR  ucAccessSpeed;                /* window speed field                */
   USHORT usFlag;                       /* CS partition flags data           */
   ULONG  ulLinkOff;                    /* CS partition link data            */
   ULONG  ulCISOff;                     /* CS partition CIS data             */
   ULONG  ulCardOff;                    /* card memory region offset         */
   ULONG  ulRegionSize;                 /* region size                       */
   ULONG  ulEffBlockSize;               /* erase block size                  */
   USHORT usPartMultiple;               /* partition multiple                */
   USHORT usJEDECID;                    /* region JEDEC memory ID code       */
} GET_REGION, FAR *PGET_REGION, NEAR *NPGET_REGION;


/*
** GetFirstTuple (0x07) / GetNextTuple (0x0A)
*/

typedef struct GET_TUPLE {
   USHORT usSocket;                     /* logical socket                    */
   USHORT usAttributes;                 /* (defined below)                   */
   UCHAR  usDesiredTuple;               /* desired tuple code value          */
   UCHAR  usReserved;                   /* reserved (reset to zero)          */
   USHORT usFlags;                      /* CS tuple flag data                */
   ULONG  ulLinkOff;                    /* CS link state information         */
   ULONG  ulCISOff;                     /* CS CIS state information          */
   UCHAR  ucTupleCode;                  /* tuple found                       */
   UCHAR  ucTupleLink;                  /* link value for tuple found        */
} GET_TUPLE, FAR *PGET_TUPLE, NEAR *NPGET_TUPLE;

   /*
   ** usAttributes field definition
   */
#define GFTA_RETURN_LINK_TUPLE  0x0001  /* return link tuple                 */


/*
** GetStatus (0x0C)
*/

typedef struct GETSTATUS {
   USHORT usSocket;                     /* logical socket                    */
   USHORT usCardState;                  /* card state output data            */
   USHORT usSocketState;                /* socket state output data          */
} GETSTATUS, FAR *PGETSTATUS, NEAR *NPGETSTATUS;

   /*
   ** usCardState field definition
   */
#define GSC_WRITE_PROTECT       0x0001  /* write proteced                    */
#define GSC_CARD_LOCKED         0x0002  /* card locked                       */
#define GSC_EJECTION_REQUEST    0x0004  /* ejection request                  */
#define GSC_INSERTION_REQUEST   0x0008  /* insertion request                 */
#define GSC_BVD1                0x0010  /* battery voltage detect 1 (1=dead) */
#define GSC_BVD2                0x0020  /* bvd2 (1=warning)                  */
#define GSC_READY               0x0040  /* ready/busy (1=ready)              */
#define GSC_CARD_DETECTED       0x0080  /* card detected                     */

   /*
   ** usSocketState field definition
   */
#define GSS_WRITE_PROTECT       0x0001  /* write protect change              */
#define GSS_CARD_LOCK           0x0002  /* card lock change                  */
#define GSS_EJECTION_PENDING    0x0004  /* ejection request pending          */
#define GSS_INSERTION_PENDING   0x0008  /* insertion request pending         */
#define GSS_BATTERY_DEAD        0x0010  /* battery dead change               */
#define GSS_BATTERY_WARNING     0x0020  /* battery warning change            */
#define GSS_READY               0x0040  /* ready change                      */
#define GSS_CARD_DETECT         0x0080  /* card detect change                */


/*
** GetTupleData (0x0D)
*/

typedef struct GET_TUPLEDATA {
   USHORT usSocket;                     /* logical socket                    */
   USHORT usAttributes;                 /* (defined in GetFirstTuple)        */
   UCHAR  ucDesiredTuple;               /* desired tuple code value          */
   UCHAR  ucTupleOff;                   /* offset into tuple from link byte  */
   USHORT usFlags;                      /* CS tuple flags data               */
   ULONG  ulLinkOff;                    /* CS linke state information        */
   ULONG  ulCISOff;                     /* CS CIS state information          */
   USHORT usTupleDataMax;               /* maximum size of tuple data area   */
   USHORT usTupleDataLen;               /* number of bytes in tuple body     */
   UCHAR  TupleData[1];                 /* tuple data                        */
} GET_TUPLEDATA, FAR *PGET_TUPLEDATA, NEAR *NPGET_TUPLEDATA;


/*
** MapLogSocket (0x12)
*/

typedef struct MAP_LOGSOCKET {
   USHORT usLogSocket;                  /* logical socket                    */
   UCHAR  ucPhyAddr;                    /* physical adapter number           */
   UCHAR  ucPhySocket;                  /* physical socket number            */
} MAP_LOGSOCKET, FAR *PMAP_LOGSOCKET, NEAR *NPMAP_LOGSOCKET;


/*
** MapLogWindow (0x13)
*/

typedef struct MAP_LOGWINDOW {
   UCHAR ucPhyAddr;                     /* physical adapter number           */
   UCHAR ucPhyWindow;                   /* physical window number            */
} MAP_LOGWINDOW, FAR *PMAP_LOGWINDOW, NEAR *NPMAP_LOGWINDOW;


/*
** MapMemPage (0x14)
*/

typedef struct MAP_MEMPAGE {
   ULONG ulCardOff;                     /* card offset address               */
   UCHAR ucPage;                        /* page number                       */
} MAP_MEMPAGE, FAR *PMAP_MEMPAGE, NEAR *NPMAP_MEMPAGE;


/*
** MapPhySocket (0x15)
*/

typedef struct MAP_PHYSOCKET {
   USHORT usLogSocket;                  /* logical socket                    */
   UCHAR  ucPhyAdapter;                 /* physical adapter number           */
   UCHAR  ucPhySocket;                  /* physical socket number            */
} MAP_PHYSOCKET, FAR *PMAP_PHYSOCKET, NEAR *NPMAP_PHYSOCKET;


/*
** MapPhyWindow (0x16)
*/

typedef struct MAP_PHYWINDOW {
   UCHAR ucPhyAdapter;                  /* physical adapter number           */
   UCHAR ucPhyWindow;                   /* physical socket number            */
} MAP_PHYWINDOW, FAR *PMAP_PHYWINDOW, NEAR *NPMAP_PHYWINDOW;


/*
** ModifyConfiguration (0x27)
*/

typedef struct MODIFY_CONFIG {
   USHORT usSocket;                     /* logical socket                    */
   USHORT usAttributes;                 /* ( defined below )                 */
   UCHAR  ucVcc;                        /* Vcc setting                       */
   UCHAR  ucVpp1;                       /* Vpp1 setting                      */
   UCHAR  ucVpp2;                       /* Vpp2 setting                      */
} MODIFY_CONFIG, FAR *PMODIFY_CONFIG, NEAR *NPMODIFY_CONFIG;

   /*
   ** usAttributes field definition
   */
#define MCA_ENABLE_IRQ_STEERING 0x0002  /* enable IRQ steering               */
#define MCA_IRQ_CHANGE_VALID    0x0004  /* IRQ change valid                  */
#define MCA_VCC_CHANGE_VALID    0x0008  /* Vcc change valid                  */
#define MCA_VPP1_CHANGE_VALID   0x0010  /* Vpp1 change valid                 */
#define MCA_VPP2_CHANGE_VALID   0x0020  /* Vpp2 change valid                 */


/*
** ModifyWindow (0x17)
*/

typedef struct MODIFY_WIN {
   USHORT usAttributes;                 /* window attributes field           */
   UCHAR  ucAccessSpeed;                /* window speed                      */
} MODIFY_WIN, FAR *PMODIFY_WIN, NEAR *NPMODIFY_WIN;

   /*
   ** usAttributes field definition
   */
#define MWA_MEMORY              0x0002  /* memory type ( 1=attributes )      */
#define MWA_ENABLE              0x0004  /* enable                            */
#define MWA_ACCESS_SPEED        0x0008  /* access speed valid                */


/*
** OpenMemory (0x18)
*/

typedef struct OPN_MEMORY {
   USHORT  usSocket;                    /* logical socket                    */
   USHORT  usAttributes;                /* attributes of mem are to be access*/
   ULONG   ulOffset;                    /* card offset for are to open       */
} OPN_MEMORY, FAR *POPN_MEMORY, NEAR *NPOPN_MEMORY;

   /*
   ** usAttributes field definition
   */
#define OMA_ATTRIBUTE_MEMORY    0x0001  /* memory type (1=attributes)        */
#define OMA_EXCLUSIVE           0x0002  /* exclusive                         */


/*
** RegisterClient (0x10)
*/

typedef struct REG_CLIENT {
   USHORT  usAttributes;                /* (defined below )                  */
   USHORT  usEventMask;                 /* events to notify client           */
   USHORT  usClientData[4];             /* data for client (binding specific)*/
   USHORT  usVersion;                   /* card services version             */
} REG_CLIENT, FAR *PREG_CLIENT, NEAR *NPREG_CLIENT;

   /*
   ** usAttributes field definition
   */
#define RCA_MEMORY_CDD          0x0001  /* memory client device driver       */
#define RCA_MTD                 0x0002  /* memory technology driver          */
#define RCA_IO_CDD              0x0004  /* IO client device driver           */
#define RCA_CI_SHARABLE         0x0008  /* CARD_INSERTION fot sharable PC card*/
#define RCA_CI_EXCLUSIVE        0x0010  /* CARD_INSERTION for exclusively used*/


/*
** ReadMemory (0x19)
*/

typedef struct READ_MEM {
   ULONG   ulCardOff;                   /* card source offset                */
   ULONG   ulCount;                     /* number of bytes to transfer       */
} READ_MEM, FAR *PREAD_MEM, NEAR *NPREAD_MEM;


/*
** RegisterEraseQueue (0x0F)
*/

   /*
   ** QueueEntry field definition
   */
typedef struct QUEUE_ENTRY {
   USHORT  usHandle;                    /* memory handle                     */
   UCHAR   ucEntryState;                /* state of this erase queue entry   */
   UCHAR   ucSize;                      /* size of area to be erased         */
   ULONG   ulOffset;                    /* offset of area to be erased       */
   UCHAR   ucOptional[1];               /* additional bytes for client use   */
} QUEUE_ENTRY, FAR *PQUEUE_ENTRY, NEAR *NPQUEUE_ENTRY;


typedef struct REG_ERASEQUEUE {
   USHORT      usEntryLen;              /* number of bytes to transfer       */
   USHORT      usNumEntry;              /* number of bytes to transfer       */
   QUEUE_ENTRY QueueEntry[1];           /* number of bytes to transfer       */
} REG_ERASEQUEUE, FAR *PREG_ERASEQUEUE, NEAR *NPREG_ERASEQUEUE;

      /*
      ** ucEntryState field definition
      */
#define EQES_IDLE                 0xFF
#define EQES_QUEUE_FOR_ERASE      0x00
#define EQES_ERASE_IN_PROG01      0x01
#define EQES_ERASE_PASSED         0xE0
#define EQES_ERASE_FAILED         0xE1
#define EQES_MEDIA_WP             0x84
#define EQES_MEDIA_NOT_ERASABLE   0x86
#define EQES_MEDIA_MISSING        0x80
#define EQES_MEDIA_NOT_WRITABLE   0x87
#define EQES_BAD_SOCKET           0xC3
#define EQES_BAD_TECHNOLOGY       0xC2
#define EQES_BAD_OFFSET           0xC1
#define EQES_BAD_VCC              0xC4
#define EQES_BAD_VPP              0xC5
#define EQES_BAD_SIZE             0xC6


/*
** RegisterMTD (0x1A)
*/

typedef struct REG_MTD {
   USHORT usSocket;                     /* logical socket                    */
   USHORT usAttributes;                 /* (defined in GetFirstPartition)    */
   ULONG  ulOffset;                     /* card offset for region MTD support*/
   USHORT usMTDMediaID;                 /* token for MTD use to identify media*/
} REG_MTD, FAR *PREG_MTD, NEAR *NPREG_MTD;


/*
** RegisterTimer (0x28)
*/

typedef struct REG_TIMER {
   USHORT usWait;                       /* number of ticks to wait           */
} REG_TIMER, FAR *PREG_TIMER, NEAR *NPREG_TIMER;


/*
** ReleaseConfiguration (0x1E)
*/

typedef struct REL_CONFG {
   USHORT usSocket;                     /* logical socket                    */
} REL_CONFG, FAR *PREL_CONFG, NEAR *NPREL_CONFG;


/*
** ReleaseExclusive (0x2D) / RequestExclusive (0x2C)
*/

typedef struct REQ_EXCLUSIVE {
   USHORT  usSocket;                    /* logical socket                    */
   USHORT  usAttributes;                /* all reserved                      */
} REQ_EXCLUSIVE, FAR *PREQ_EXCLUSIVE, NEAR *NPREQ_EXCLUSIVE;


/*
** ReleaseIO (0x1B) / RequestIO (0x1F)
*/

typedef struct REQ_IO {
   USHORT usSocket;                     /* logical socket                    */
   USHORT usBasePort1;                  /* base port address for range 1     */
   UCHAR  ucNumPorts1;                  /* number of contiguous ports        */
   UCHAR  ucAttributes1;                /* (defined below in RequestIO)      */
   USHORT usBasePort2;                  /* base port address for range 2     */
   UCHAR  ucNumPorts2;                  /* number of contiguous ports        */
   UCHAR  ucAttributes2;                /* (defined below in RequestIO)      */
   UCHAR  ucIOAddrLines;                /* number of IO address lined decoded*/
} REQ_IO, FAR *PREQ_IO, NEAR *NPREQ_IO;

   /*
   ** ucAttrobute1/2 field definition
   */
#define RIOA_SHARED               0x01  /* shared                            */
#define RIOA_FIRST_SHARED         0x02  /* first shared                      */
#define RIOA_FORCE_ALIAS_ACCESS   0x04  /* force alias accessibility         */
#define RIOA_DATA_PATH_WIDTH      0x08  /* data path width for I/O range     */


/*
** ReleaseIRQ (0x1C)
*/

typedef struct REL_IRQ {
   USHORT usSocket;                     /* logical socket                    */
   USHORT usAttributes;                 /* (defined in RequestIRQ)           */
   UCHAR  ucAssignedIRQ;                /* IRQ number assigned by CS         */
} REL_IRQ, FAR *PREL_IRQ, NEAR *NPREL_IRQ;


/*
** ReleaseSocketMask (0x2F)
*/

typedef struct REL_SOCKETMASK {
   USHORT usSocket;                     /* logical socket                    */
} REL_SOCKETMASK, FAR *PREL_SOCKETMASK, NEAR *NPSOCKETMASK;


/*
** ReleaseWindow (0x1D) / RequestWindow (0x21)
*/

typedef struct REQ_WINDOW {
   USHORT usSocket;                     /* logical socket                    */
   USHORT usAttributes;                 /* memory window attribute field     */
   ULONG  ulBase;                       /* system base address               */
   ULONG  ulSize;                       /* memory window size                */
   UCHAR  ucAccessSpeed;                /* window speed field                */
} REQ_WINDOW, FAR *PREQ_WINDOW, NEAR *NPREQ_WINDOW;

   /*
   ** usAttributes field definition
   */
#define RWA_MEMORY_TYPE         0x0002  /* memory type 1=attribute           */
#define RWA_ENABLED             0x0004  /* enabled                           */
#define RWA_DATA_PATH_WIDTH     0x0008  /* data path width (0=8bit/1=16but)  */
#define RWA_PAGED               0x0010  /* paged                             */
#define RWA_SHARED              0x0020  /* shared                            */
#define RWA_FIRST_SHARED        0x0040  /* first shared                      */
#define RWA_OFFSET_WINDOW_SIZE  0x0100  /* card offset are window sized      */


/*
** ReplaceSocketServices (0x33)
*/

typedef struct REPLACE_SS {
   USHORT usSocket;                     /* logical socket                    */
   USHORT usNumSockets;                 /* number of sockets to replace      */
   USHORT usAttributes;                 /* information about SS entry point  */
   USHORT usDataPtr;                    /* pointer for SS data area          */
} REPLACE_SS, FAR *PREPLACE_SS, NEAR *NPREPLACE_SS;


/*
** RequestConfiguration (0x30)
*/

typedef struct REQ_CONFG {
   USHORT usSocket;                     /* logical socket                    */
   USHORT usAttributes;                 /* (defined below)                   */
   UCHAR  ucVcc;                        /* Vcc setting                       */
   UCHAR  ucVpp1;                       /* Vpp1 setting                      */
   UCHAR  ucVpp2;                       /* Vpp2 setting                      */
   UCHAR  ucIntType;                    /* memory or memory+I/O interface    */
   ULONG  ulConfigBase;                 /* card base addr. of config registers*/
   UCHAR  ucStatus;                     /* card state register setting       */
   UCHAR  ucPin;                        /* card pin register setting         */
   UCHAR  ucCopy;                       /* card socket/copy register setting */
   UCHAR  ucConfiIndex;                 /* card option register setting      */
   UCHAR  ucPresent;                    /* card configuration register present*/
} REQ_CONFG, FAR *PREQ_CONFG, NEAR *NPREQ_CONFG;

   /*
   ** usAttributes field definition
   */
#define RCA_ENABLE_IRQ          0x0002  /* enable IRQ setting                */

   /*
   ** ucPresent field definition
   */
#define RCP_OPTION                0x01  /* option                            */
#define RCP_STATUS                0x02  /* status                            */
#define RCP_PIN_REPLACEMENT       0x04  /* pin replacement                   */
#define RCP_COPY                  0x08  /* copy                              */

   /*
   ** ucIntType field definition
   */
#define RCT_MEMORY                0x01  /* memory                            */
#define RCT_MEMORY_IO             0x02  /* memory and I/O                    */


/*
** RequestIRQ (0x20)
*/

typedef struct REQ_IRQ {
   USHORT usSocket;                     /* logical socket                    */
   USHORT usAttributes;                 /* (defined below)                   */
   UCHAR  ucAssignedIRQ;                /* IRQ number assigned by CS         */
   UCHAR  ucIRQInfo1;                   /* first PCMCIA IRQ byte             */
   USHORT usIRQInfo2;                   /* @ 128895 optional PCMCIA IRQ bytes*/
} REQ_IRQ, FAR *PREQ_IRQ, NEAR *NPREQ_IRQ;

   /*
   ** usAttributes field definition
   */
#define RIA_TYPE_EXCLUSIVE      0x0000  /* IRQtype - exclusive               */
#define RIA_TYPE_TIME_SHARE     0x0001  /* IRQtype - time multiplexed share  */
#define RIA_TYPE_DYNAMIC_SHARE  0x0002  /* IRQtype - dynamic sharing         */

#define RIA_FORCE_PULSE         0x0004  /* forse pulse                       */
#define RIA_FIRST_SHARED        0x0008  /* first shared                      */
#define RIA_PULSE_IRQ_ALLOCATED 0x0100  /* pulse IRQ allocated               */

   /*
   ** ucIRQInfo1 field definition
   */
#define RII1_NMI                0x01    /* NMI                               */
#define RII1_LOCK               0x02    /* LOCK                              */
#define RII1_BERR               0x04    /* BERR                              */
#define RII1_VEND               0x08    /* VEND                              */
#define RII1_INFO2_VALID        0x10    /* 1=>IRQInfo2 is valid              */
#define RII1_LEVEL              0x20    /* level                             */
#define RII1_PULSE              0x40    /* pulse                             */
#define RII1_SHARE              0x80    /* share                             */

   /*
   ** usIRQInfo2 field definition
   */
#define RII2_IRQ0               0x0001  /* IOQ0                              */
#define RII2_IRQ1               0x0002  /* IOQ1                              */
#define RII2_IRQ2               0x0004  /* IOQ2                              */
#define RII2_IRQ3               0x0008  /* IOQ3                              */
#define RII2_IRQ4               0x0010  /* IOQ4                              */
#define RII2_IRQ5               0x0020  /* IOQ5                              */
#define RII2_IRQ6               0x0040  /* IOQ6                              */
#define RII2_IRQ7               0x0080  /* IOQ7                              */
#define RII2_IRA8               0x0100  /* IOQ8                              */
#define RII2_IRA9               0x0200  /* IOQ9                              */
#define RII2_IRA10              0x0400  /* IOQ10                             */
#define RII2_IRA11              0x0800  /* IOQ11                             */
#define RII2_IRA12              0x1000  /* IOQ12                             */
#define RII2_IRA13              0x2000  /* IOQ13                             */
#define RII2_IRA14              0x4000  /* IOQ14                             */
#define RII2_IRA15              0x8000  /* IOQ15                             */


/*
** RequestSocketMask (0x22)
*/

typedef struct REQ_SOCKETMASK {
   USHORT usSocket;                     /* logical socket                    */
   USHORT usEventMask;                  /* (defined in GetEventMask)         */
} REQ_SOCKETMASK, FAR *PREQ_SOCKETMASK, NEAR *NPREQ_SOCKETMASK;


/*
** ResetCard (0x11)
*/

typedef struct RESETCARD {
   USHORT usSocket;                     /* logical socket                    */
   USHORT usAttributes;                 /* all reserved                      */
} RESETCARD, FAR *PRESETCARD, NEAR *NPRESETCARD;


/*
** ReturnSSEntry (0x23)
*/

typedef struct RETURN_SSENTRY {
   USHORT usAttributes;                 /* information about SS entry point  */
} RETURN_SSENTRY, FAR *PRETURN_SSENTRY, NEAR *NPSSENTRY;


/*
** SetEventMask (0x31)
*/

typedef struct SET_EVENTMASK {
   USHORT usAttributes;                 /* defined in GetEventMask           */
   USHORT usEventMask;                  /* defined in GetEventMask           */
   USHORT usSocket;                     /* logical socket                    */
} SET_EVENTMASK, FAR *PSET_EVENTMASK, NEAR *NPSET_EVENTMASK;


/*
** SetRegion (0x29)
*/

typedef struct SETREGION {
   USHORT usSocket;                     /* logical socket                    */
   USHORT usAttributes;                 /* defined below                     */
   ULONG  ulCardOffset;                 /* card memory region offset         */
   ULONG  ulRegionSize;                 /* region size                       */
   ULONG  ulEffBlockSize;               /* erase block size                  */
   USHORT usPartMultiple;               /* partition multiple                */
   USHORT usJEDECID;                    /* partition JEDEC memory ID code    */
   ULONG  ulBiasOffset;                 /* address bias for MTD              */
   UCHAR  ucAccessSpeed;                /* window speed field                */
} SETREGION, FAR *PSETREGION, NEAR *NPSETREGION;

   /*
   ** usAttributes field definition
   */
#define SRA_MEMORY_TYPE         0x0001  /* memory type                       */
#define SRA_DELETE_REGION       0x0002  /* delete region                     */
#define SRA_VIRTUAL_REGION      0x0100  /* virtual region                    */


/*
** ValidateCIS (0x2B)
*/

typedef struct VALIDATECIS {
   USHORT usSocket;                     /* logical socket                    */
   USHORT usChains;                     /* number of chains validated        */
} VALIDATECIS, FAR *PVALIDATECIS, NEAR *NPVALIDATECIS;


/*
** VendorSpecific (0x34)
*/

typedef struct VENDOR_SPEC {
   USHORT usInfoLen;                    /* length of returned info packet    */
   UCHAR  VendorData[1];                /* vendor specific data              */
} VENDOR_SPEC, FAR *PVENDOR_SPEC, NEAR *NPVENDOR_SPEC;


/*
** WriteMemory (0x24)
*/

typedef struct WRITE_MEM {
   ULONG  ulCardOffset;                 /* card destination address          */
   ULONG  ulCount;                      /* number of butes to trnasfer       */
   USHORT usAttributes;                 /* defined below                     */
} WRITE_MEM, FAR *PWRITE_MEM, NEAR *NPWRITE_MEM;

   /*
   ** usAttributes field definition
   */
#define WMA_DISABLE_ERASE       0x0004  /* disable erase                     */
#define WMA_VERIFY              0x0008  /* verify                            */



/**************************************************************************
 * Events Definition
 **************************************************************************/

#define BATTERY_DEAD            0x01
#define BATEERY_LOW             0x02
#define CARD_INSERTION          0x40
#define CARD_READY              0x04
#define CARD_REMOVAL            0x05
#define CARD_RESET              0x11
#define CARD_LOCK               0x03
#define CARD_UNLOCK             0x06
#define CLIENT_INFO             0x14
#define EJECTION_REQUEST        0x08
#define EJECTION_COMPLETE       0x07
#define ERASE_COMPLETE          0x81
#define EXCLUSIVE_REQUEST       0x0E
#define EXCLUSIVE_COMPLETE      0x0D
#define INSERTION_REQUEST       0x0A
#define INSERTION_COMPLETE      0x09
#define MTD_REQUEST             0x12
#define PM_RESUME               0x0B
#define PM_SUSPEND              0x0C
#define REGISTRATION_COMPLETE   0x82
#define RESET_COMPLETE          0x80
#define RESET_PHYSICAL          0x0F
#define RESET_REQUEST           0x10
#define SS_UPDATED              0x16
#define TIMER_EXPIRED           0x15

/*
** MTD request packet
*/

typedef struct MTD_REQPKT {
   USHORT  lnMTDreqpkt;                 /* length of this packet             */
   USHORT  usSocket;                    /* socket containing PC card to access*/
   ULONG   ulSrcCardOff;                /* source card offset for request    */
   ULONG   ulDestCardOff;               /* dest. card offset for request     */
   ULONG   ulTransferLen;               /* length of request                 */
   UCHAR   ucFunction;                  /* MTD request function              */
   UCHAR   ucAccessSpeed;               /* access speed for region           */
   USHORT  usMTDID;                     /* MTD's token from registerMTD      */
   USHORT  usMTDStatus;                 /* MTD returned status               */
   USHORT  usTimeout;                   /* timer count for timer delayed req.*/
   UCHAR   MediaAccessTbl[1];           /* media access table                */
} MTD_REQPKT, FAR *PMTD_REQPKT, NEAR *NPMTD_REQPKT;

   /*
   ** MTD request function
   */
#define MTD_ERASE               0x00    /* command Erase                     */
#define MTD_READ                0x01    /* command Read                      */
#define MTD_WRITE               0x02    /* command Write                     */
#define MTD_COPY                0x03    /* command Copy                      */
#define MTD_DISABPLE_ERASE      0x04    /* DisableEraseBeforeWrite           */
#define MTD_VERIFY_AFTER_WRITE  0x08    /* VerifyAfterWrite                  */
#define MTD_READY_CONTINUED     0x10    /* Ready Continued                   */
#define MTD_TIMEOUT_CONTINUED   0x20    /* Timeout Continued                 */
#define MTD_LAST_IN_SEQUENCE    0x40    /* Last in Sequesnce                 */
#define MTD_FIRST_IN_SEQUESNCE  0x80    /* First Sequence                    */

   /*
   ** MTD status
   */
#define MTD_WAITREQ             0x0000  /* not currently able to service req.*/
#define MTD_WAITTIMER           0x0001  /* waiting for specified period      */
#define MTD_WAITRDY             0x0002  /* waiting for RDY                   */
#define MTD_WAITPOWER           0x0003  /* not able to service               */


/**************************************************************************
 * Return Code Definition
 **************************************************************************/

#define SUCCESS                 0x0000  /* the request succeeded              */
#define BAD_ADAPTER             0x0001  /* specified adapter is invalid       */
#define BAD_ATTRIBUTE           0x0002  /* value specified for attr is invalid*/
#define BAD_BASE                0x0003  /* base system memory addr. is invalid*/
#define BAD_EDC                 0x0004  /* EDC generator is invalid           */
#define BAD_IRQ                 0x0006  /* IRQ level is invalid               */
#define BAD_OFFSET              0x0007  /* PC card memory array off is invalid*/
#define BAD_PAGE                0x0008  /* page is invalid                    */
#define READ_FAILURE            0x0009  /* unable to complete read request    */
#define BAD_SIZE                0x000A  /* size is invalid                    */
#define BAD_SOCKET              0x000B  /* socket is invalid (logical or phys)*/
#define BAD_TYPE                0x000D  /* window or interface type is invalid*/
#define BAD_VCC                 0x000E  /* Vcc power level index is invalid   */
#define BAD_VPP                 0x000F  /* Vpp1 or Vpp2 power level invalid   */
#define BAD_WINDOW              0x0011  /* window is invalid                  */
#define WRITE_FAILURE           0x0012  /* unable to complete write request   */
#define NO_CARD                 0x0014  /* no PC card in socket               */
#define UNSUPPORTED_FUNCTION    0x0015  /* does not support function          */
#define UNSUPPORTED_MODE        0x0016  /* processor mode is not supported    */
#define BAD_SPEED               0x0017  /* speed is unavailable               */
#define BUSY                    0x0018  /* unable to process request - retry  */
#define GENERAL_FAILURE         0x0019  /* undefined error has occurred       */
#define WRITE_PROTECTED         0x001A  /* media is write-protected           */
#define BAD_ARG_LENGTH          0x001B  /* ArgLength argument is invalid      */
#define BAD_ARGS                0x001C  /* values in Argument pkt are invalid */
#define CONFIGURATION_LOCKED    0x001D  /* configuration has locked           */
#define IN_USE                  0x001E  /* resource is being used by a client */
#define NO_MORE_ITEMS           0x001F  /* there are no more the req. item    */
#define OUT_OF_RESOURCE         0x0020  /* CS has exhausted resource          */
#define BAD_HANDLE              0x0021  /* client handle is invliad           */


/**************************************************************************
 * COM Inter Device Driver Client Interface Definition
 **************************************************************************/

/*
** COM IDC parameter packet
*/

typedef struct COM_PARMPKT {
   USHORT  usFunction;                  /* function code                     */
   USHORT  usPortNumber;                /* COM port number                   */
   USHORT  usPortAddr;                  /* COM port address                  */
   USHORT  usPortIRQ;                   /* COM port IRQ                      */
   USHORT  usReturnCode;                /* return code                       */
} COM_PARMPKT, FAR *PCOM_PARMPKT, NEAR *NPCOM_PARMPKT;

   /*
   ** COM IDC function definition
   */
#define COM_DEINSTALL           0x0000  /* deinstall COM port drive          */
#define COM_INSTALL             0x0001  /* install COM port drive            */

   /*
   ** COM IDC Port Number definition
   */
#define COM1_PORT               0x0001  /* COM1 port selection               */
#define COM2_PORT               0x0002  /* COM2 port selection               */
#define COM3_PORT               0x0003  /* COM3 port selection               */
#define COM4_PORT               0x0004  /* COM4 port selection               */

   /*
   ** COM IDC return codes are defined in DDK\H\BSEERR.H
   */


