;*****************************************************************************/
;
; COPYRIGHT    Copyright (C) 1992 IBM Corporation
;
;    The following IBM OS/2 2.1 source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 2.x device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = COM_IDC.ASM
;*
;* DESCRIPTIVE NAME =
;*
;*
;* VERSION
;*
;* DATE
;*
;* DESCRIPTION
;*
;* FUNCTIONS
;*
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   03/13/95              113751 DS Set before calling IDC Entry Point in COM
;*****************************************************************************/

.286
.287

;*
;* constant definitions
;*
ATTACHDD equ 42


_DATA   SEGMENT WORD PUBLIC 'DATA'
_DATA   ENDS

_BSS    SEGMENT WORD PUBLIC 'BSS'
_BSS    ENDS

CONST   SEGMENT WORD PUBLIC 'CONST'
CONST   ENDS

_TEXT   SEGMENT WORD PUBLIC 'CODE'
_TEXT   ENDS

DGROUP  GROUP   _DATA, CONST, _BSS
CGRP    GROUP   _TEXT


_DATA   SEGMENT
Driver_name       DB 'COM1    ',  00H
Driver_handle     DW 6 DUP (0)
Driver_entry_func DW 2 DUP (0)
Driver_DS         DW        0     ; @113751
Idc_pack          DW 5 DUP (0)

EXTRN Device_help:NEAR
_DATA   ENDS


_TEXT   SEGMENT WORD PUBLIC 'CODE'
        ASSUME cs:CGRP, ds:DGROUP, es:NOTHING, ss:NOTHING

PUBLIC _com_idc_init
_com_idc_init PROC NEAR

            push bx                    ; attach to com driver
            push di
            push dx

            mov  bx,OFFSET DGROUP:Driver_name
            mov  di,OFFSET DGROUP:Driver_handle
            mov  dl,ATTACHDD
            call DWORD PTR Device_help
            jc   error1

                                       ; if successful store entry point
                                       ;               com driver
next:       mov  ax,WORD PTR Driver_handle + 6       ; offset
            mov  dx,WORD PTR Driver_handle + 8       ; segment
            mov  bx,WORD PTR Driver_handle + 0ah     ; @113751 - DS of IDC DD
            mov  WORD PTR Driver_entry_func,ax
            mov  WORD PTR Driver_entry_func+2,dx
            mov  WORD PTR Driver_DS,bx               ; @113751
            mov  ax,0
            jmp  done1

error1:     mov  ax,-1

done1:      pop  dx
            pop  di
            pop  bx
            ret

_com_idc_init ENDP


;/***************************************************************************
;*
;* FUNCTION NAME = _set_com_port
;*
;* DESCRIPTION   = USHORT set_com_port(USHORT command, USHORT com_port
;*                                     USHORT io_address, USHORT irq_num)
;*
;* INPUT         =
;*
;* OUTPUT        =
;*
;* RETURN-NORMAL =
;*
;* RETURN-ERROR  =
;*
;**************************************************************************/

PUBLIC _set_com_port
_set_com_port PROC NEAR

        push bp                        ; save registers
        mov  bp,sp                     ;    - set up parameter pointer
        push bx
        push es
        push ds                        ;@113751
                                       ; packP = -2
                                       ; irq_num = 10
                                       ; io_address = 8
                                       ; com_port = 6
                                       ; command = 4

                                       ; idc_pack.command = command
        mov  ax,WORD PTR [bp+4]                      ;command
        mov  WORD PTR Idc_pack,ax
                                       ; idc_pack.com_port = com_port
        mov  ax,WORD PTR [bp+6]                      ;com_port
        mov  WORD PTR Idc_pack+2,ax
                                       ; idc_pack.io_address = io_address
        mov  ax,WORD PTR [bp+8]                      ;io_address
        mov  WORD PTR Idc_pack+4,ax
                                       ; idc_pack.irq_num = irq_num
        mov  ax,WORD PTR [bp+10]                     ;irq_num
        mov  WORD PTR Idc_pack+6,ax
                                       ; set up idc packet
        mov  ax,DGROUP
        mov  es,ax
        mov  bx,OFFSET DGROUP:Idc_pack
        mov  ds,Driver_DS              ; @113751

        call DWORD PTR Driver_entry_func ; make idc call
                                       ; set up return code
        mov  ax,WORD PTR Idc_pack+8
                                       ; restore registers and return
        pop  ds                        ; @113751
        pop  es
        pop  bx
        pop  bp
        ret

_set_com_port ENDP

_TEXT ENDS

END
