/* SCCSID = "%W% %E%" */
/****************************************************************************/
/*                                                                          */
/*                           IBM Confidential                               */
/*                                                                          */
/*                 Copyright (c) IBM Corporation 1996                       */
/*                           All Rights Reserved                            */
/*                                                                          */
/****************************************************************************/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  PARTYPE.H                                             */
/*                                                                            */
/*   DESCRIPTIVE NAME:  PARALLEL port snooper TYPEDEF include file.           */
/*                                                                            */
/*   FUNCTION: This module is the PARALLEL port device driver                 */
/*             TYPEDEF include file.                                          */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          96/03/01  Frank Schroeder                                         */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/
typedef struct _BIOSDATAAREA  /* BIOS Data Area */
{
  USHORT  parBaseAddr[4];     /* parallel port base address */

} BIOSDATAAREA, *NPBIOSDATAAREA, FAR *FPBIOSDATAAREA;

/*----------------------------------------------*/
/* PORTCB used when requesting resources from   */
/* resource manager                             */
/*----------------------------------------------*/
typedef struct _PORTCB
{
   HADAPTER  hAdapter;        /* handle to parallel port adapter */
   HDEVICE   hDevice;         /* handle to parallel port attached device */
   USHORT    PortAddr;        /* available parallel port base address */
   HRESOURCE hPortRes;        /* handle to parallel port base addr */
   USHORT    ECPPortAddr;     /* available ECP parallel port base address */
   HRESOURCE hECPPortRes;     /* handle to ECP parallel port base addr */
   USHORT    IrqLevel;        /* dynamically determined irq */
   HRESOURCE hIrqRes;         /* handle to parallel port irq level */

} PORTCB, *NPPORTCB, FAR * FPPORTCB;

/*----------------------------------------------*/
/* IRQCB used when requesting resources from    */
/* resource manager                             */
/*----------------------------------------------*/
typedef struct _IRQCB
{
   USHORT    IrqLevel;        /* available parallel port irq level */
   HRESOURCE hIrqRes;         /* handle to parallel port irq level */
   BOOL      fIrqNeeded;      /* flag this irq as needed */

} IRQCB, *NPIRQCB, FAR * FPIRQCB;

/*----------------------------------------------*/
/* DETECTCB used when dynamically detecting IRQ */
/*----------------------------------------------*/
typedef struct _DETECTCB
{
   USHORT    PortAddr;        /* parallel port base address being detected */
   USHORT    DetectIRQ;       /* IRQ level being detected */
   BOOL      WaitForIRQ;      /* wait flag for hardware interrupt to occur */

} DETECTCB, *NPDETECTCB, FAR * FPDETECTCB;

/*----------------------------------------------*/
/* IOCTLCOMB used to validate IOCtl requests    */
/*----------------------------------------------*/
typedef struct _IOCTLCOMB
{
   UCHAR     CatCode;         /* category code */
   UCHAR     FuncCode;        /* function code */

} IOCTLCOMB, *NPIOCTLCOMB, FAR * FPIOCTLCOMB;

/*----------------------------------------------*/
/* timerElement_t used to manage internal timers*/
/*----------------------------------------------*/
typedef struct _timer_element_t
{
  USHORT                TimerCount;
  void                  (*TimeoutRtn)( void *pInst );

} timerElement_t;

#define TIMERS_PER_INSTANCE     3

typedef struct _LASTREAD_t
{
  USHORT                usCharCount;
  UCHAR                 ucCharBuffer[MAX_FIFO_DEPTH];
} LastRead_t;


typedef USHORT pio_info_t;

/*----------------------------------------------*/
/* parInstance_t defines per adapter information*/
/*----------------------------------------------*/
typedef struct _parInstance_t
{
  /*----------------------------------*/
  /* Pointer to next active instance  */
  /*----------------------------------*/
  ULONG                         cSignature;     /* identifier like LPT1 */
  struct _parInstance_t         *pNextInst;

  /*-------------------*/
  /* ADD Work Queue    */
  /*-------------------*/
  RPH                           FAR *pRP;
  RPH                           FAR *pRPHead;
  RPH                           FAR *pRPFoot;

  /*-------------------------*/
  /* Pointer active Flush RP */
  /*-------------------------*/
  RPH                           FAR *pFlushRP;

  /*--------------------------------------*/
  /* Instance Flags field (see F_* below) */
  /*--------------------------------------*/
  ULONG                         Flags;

  /*-------------------------------*/
  /* Inner state machine variables */
  /*-------------------------------*/
  USHORT                        UseCount;
  USHORT                        State;

  USHORT                        DataCount;
  USHORT                        ReqDataCount;
  UCHAR                         FAR *pDataBuf;
  SEL                           GDTSel;
  ULONG                         LockHandle;

  USHORT                        RLEState;
  USHORT                        RLECount;
  UCHAR                         RLEData;
  UCHAR                         IRQINFOIndex;

  /*-------------------------------*/
  /* Outer state machine variables */
  /*-------------------------------*/
  USHORT                        ReqUseCount;
  USHORT                        ReqState;
  void                          (*DoneRtn)( struct _parInstance_t *pInst );

  USHORT                        ProcUseCount;

  void                          (*IRQRtn)( struct _parInstance_t *pInst );

  pio_info_t                    pIO[3];
  USHORT                        BlockedWaitCount;
  USHORT                        ExclusiveID;

  /*------------------*/
  /* FIFO Information */
  /*------------------*/
  USHORT                        FIFODepth;
  USHORT                        FIFOWriteThresh;
  USHORT                        FIFOReadThresh;

  /*-------------------------*/
  /* Instance timer elements */
  /*-------------------------*/
  timerElement_t                Timers[TIMERS_PER_INSTANCE];

  USHORT                        RIdleTimeoutMS;
  USHORT                        RTimeoutMS;

  USHORT                        WIdleTimeoutMS;
  USHORT                        WTimeoutMS;

  USHORT                        ReturnCode;

  /*--------------------------*/
  /* Chipset register images  */
  /*--------------------------*/
  UCHAR                         ControlReg;
  UCHAR                         StatusReg;
  UCHAR                         ExtControlReg;

  /*-----------------------*/
  /* CommMode Information  */
  /*-----------------------*/
  UCHAR                         ExtReqByte;
  UCHAR                         ReqCommMode;
  UCHAR                         CurCommMode;

  /*----------------------------*/
  /* Frame Control Information  */
  /*----------------------------*/
  UCHAR                          CharsPerLine;
  UCHAR                          LinesPerInch;

  /*----------------------------*/
  /* Last Read Buffer           */
  /*----------------------------*/
  LastRead_t                     *pLastRead;

  /*----------------------------*/
  /* Statistics                 */
  /*----------------------------*/
  USHORT                        nWrites;
  USHORT                        nErrorWrites;
  USHORT                        nReads;
  USHORT                        nErrorReads;
  USHORT                        nZeroReads;

} parInstance_t;

/*----------------------------------------------*/
/* parInstance_t->Flags                         */
/*----------------------------------------------*/
#define F_WAIT_STATE            0x80000000
#define F_INTERRUPT_EXPECTED    0x40000000
#define F_NO_INTERRUPT          0x20000000
#define F_TIMEOUT               0x10000000
#define F_ADDRESS_CYCLE         0x08000000
#define F_WRITE_REQ             0x04000000
#define F_RQ_ACTIVE             0x02000000
#define F_FIFO_SUPPORT          0x01000000
#define F_EPP_SUPPORT           0x00800000
#define F_CANCELLED             0x00400000
#define F_DIRECT_MODE           0x00200000
#define F_SHARE_MODE            0x00100000
#define F_DENIED_ACCESS         0x00080000
#define F_INFINITE_RETRY        0x00040000

#define F_ALLOCATED             0x00000020
#define F_RLE_COMPRESS          0x00000010
#define F_FLUSH_REQ             0x00000008
#define F_RENEGOTIATE           0x00000004
#define F_DIR_REVERSE           0x00000002
#define F_BYTE_MODE             0x00000001

#define MIN_RLE_COUNT           5


/* Timer IDs */
#define TIMER_ID_0              0       /* Polling Timer           */
#define TIMER_ID_1              1       /* InterCharacter Timeout  */
#define TIMER_ID_2              2       /* Elapsed Request Timeout */


#define MAX_LPT                 3

/*----------------------------------------------*/
/* LPTINFO defines adapter instance for strat1  */
/*----------------------------------------------*/
typedef struct _LPTINFO_t
{
  parInstance_t         *pInst;

} LPTInfo_t;

/*----------------------------------------------*/
/* IRQINFO defines irq and adapter instance     */
/* for interrupt routine.                       */
/* Use IRQINFO_t because IRQINFO declared in    */
/* other src\dev header files                   */
/*----------------------------------------------*/
typedef struct _IRQINFO_t
{
  USHORT                IRQLevel;
  USHORT                Flags;
  NPFN                  isrRtn;
  parInstance_t         *pInst;
} IRQInfo_t;

