/* SCCSID = "%W% %E%" */
/****************************************************************************/
/*                                                                          */
/*                           IBM Confidential                               */
/*                                                                          */
/*                 Copyright (c) IBM Corporation 1996                       */
/*                           All Rights Reserved                            */
/*                                                                          */
/****************************************************************************/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  PARPROTO.H                                            */
/*                                                                            */
/*   DESCRIPTIVE NAME:  Function prototypes provided by the PARALLEL port     */
/*                      device driver.                                        */
/*                                                                            */
/*   FUNCTION: This module is the PARALLEL port device driver                 */
/*             function prototype include file.                               */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          96/03/01  Frank Schroeder                                         */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

/* PARSTR1.C */
void far parLPT1();
void far parLPT2();
void far parLPT3();
void near parStrat1( parInstance_t *pInst, RPH FAR *pRP );
void   parDataRead( parInstance_t *pInst );
void   parDataWrite( parInstance_t *pInst );
void   parReadWrite( parInstance_t *pInst );
void data_xfer_setup( parInstance_t *pInst );
USHORT do_data_xfer( parInstance_t *pInst );
void parDataReadFlush( parInstance_t *pInst, RPH FAR *pRP);
void parDataWriteFlush( parInstance_t *pInst, RPH FAR *pRP);
void parDataFlush( parInstance_t *pInst,
                   USHORT        functionNumber,
                   USHORT        flushOpt );
void parDataFlushQueued( parInstance_t *pInst, USHORT functionNumber);
void parDataFlushActive( parInstance_t *pInst, USHORT functionNumber);
void parDeviceOpen( parInstance_t *pInst, RPH FAR *pRP);
void parDeviceClose( parInstance_t *pInst, RPH FAR *pRP);
void CmdError( parInstance_t *pInst, RPH FAR *pRP);
void parInitComplete( parInstance_t *pInst, RPH FAR *pRP);

/* PARDATA.C */
USHORT (*Strat1[])( parInstance_t *pInst, RPH FAR *pRP );
void (*QueueRouteTable[])( parInstance_t *pInst );
void (*IOCTLRouteTable[])( parInstance_t *pInst );
USHORT (*vidcRouteTable[])( ULONG var1, ULONG var2 );

/* PARQUEUE.C */
void parInstanceQueue( parInstance_t *pInst, RPH FAR *pRP );
void parInstanceDeQueue( parInstance_t *pInst, RPH FAR *pRP );
void parProcessQueue( parInstance_t *pInst );
void parBlockThread( parInstance_t *pInst );
void parRunThread( parInstance_t *pInst );
void SetRPErrorCode( parInstance_t *pInst );
void SetInstanceFlags( parInstance_t *pInst, ULONG Flags );
void ResetInstanceFlags( parInstance_t *pInst, ULONG Flags );
void LockInstance( parInstance_t *pInst );
void UnLockInstance( parInstance_t *pInst );

/* PARIOCTL.C */
void parGenIOCTL( parInstance_t *pInst );
void parFrameControlSet( parInstance_t *pInst );
void parInfinRetrySet( parInstance_t *pInst );
void parDeviceReset( parInstance_t *pInst );
void do_reset( parInstance_t *pInst );
void reset_timedout( parInstance_t *pInst );
void parWriteTimeoutSet( parInstance_t *pInst );
void parDirectAccessSet( parInstance_t *pInst );
void parCommModeSet( parInstance_t *pInst );
void parDataXferModeSet( parInstance_t *pInst );
void parFrameControlQuery( parInstance_t *pInst );
void parInfinRetryQuery( parInstance_t *pInst );
void parStatusPortQuery( parInstance_t *pInst );
void parWriteTimeoutQuery( parInstance_t *pInst );
void parDirectAccessQuery( parInstance_t *pInst );
void parCommModeQuery( parInstance_t *pInst );
void parDataXferModeQuery( parInstance_t *pInst );
void parDeviceIDQuery( parInstance_t *pInst );

/* PARECP.C     */
void do_read_ecp_mode( parInstance_t *pInst );
void service_ecp_read( parInstance_t *pInst );
void ecp_read_timeout( parInstance_t *pInst );
void do_write_ecp_mode( parInstance_t *pInst );
void service_ecp_write( parInstance_t *pInst );
void ecp_write_timeout( parInstance_t *pInst );

/* PAREPP.C     */
void do_read_epp_mode( parInstance_t *pInst );
void do_write_epp_mode( parInstance_t *pInst );

/* PARFPP.C     */
void do_write_fpp_mode( parInstance_t *pInst );
void service_fpp_write( parInstance_t *pInst );
void fpp_write_timeout( parInstance_t *pInst );

/* PARSPP.C     */
void do_read_byte_mode( parInstance_t *pInst );
UCHAR StatusToNibble( UCHAR StatusReg );
void byte_read_timeout( parInstance_t *pInst );
void read_completion_timeout( parInstance_t *pInst );
void do_write_spp_mode( parInstance_t *pInst );
USHORT service_spp_write( parInstance_t *pInst, UCHAR c );
void wspp_timeout( parInstance_t *pInst );

/* PARNEG.C     */
void do_negotiate( parInstance_t *pInst );
void negotiate_timeout( parInstance_t *pInst );
void ecp_setup_timeout( parInstance_t *pInst );
USHORT CommModeToExtReq( parInstance_t *pInst,
                         UCHAR         ReqCommMode,
                         UCHAR         *pExtReqByte );
void negotiate_mode( parInstance_t *pInst, UCHAR ReqCommMode );

/* PARISR.C     */
USHORT far parIRQEntry_0();
USHORT far parIRQEntry_1();
USHORT far parIRQEntry_2();
USHORT parISR( USHORT IRQIndex );
void far addTimerEventHandler();
void setDelayTimer( parInstance_t *pInst,
                    USHORT        TimerId,
                    void          (*TimeoutRtn)( parInstance_t *pInst ),
                    USHORT        TimeoutMS );
void cancelDelayTimer( parInstance_t *pInst,
                       USHORT        TimerId );
void cancelAllTimers( parInstance_t *pInst );

/* PARUTIL.C */
parInstance_t *AllocateInstance( void );
USHORT AllocateInstancePool( void );
USHORT StartInstanceTimer( void );
void DestroyInstance( parInstance_t *pInst );
void DeallocateInstance( parInstance_t *pInst );
USHORT StopInstanceTimer( void );
void DetermineFIFOThresholds( parInstance_t *pInst );
USHORT DetermineFIFOWriteThresh( parInstance_t *pInst );
USHORT DetermineFIFOReadThresh( parInstance_t *pInst );
USHORT FillFIFOTest( parInstance_t *pInst );
void EmptyFIFOTest( parInstance_t *pInst );

/* PARMISC.C */
void IOWrite8 (USHORT BaseAddr, USHORT BaseOffset, UCHAR Data);
UCHAR IORead8 (USHORT BaseAddr, USHORT BaseOffset);
void IOWrite32( USHORT BaseAddr, USHORT BaseOffset, ULONG Data );
ULONG IORead32( USHORT BaseAddr, USHORT BaseOffset );
void IODelay(void);
void  TimeExecutionStall( USHORT delay );

/* DPRINTF.ASM */
#ifdef DEBUG
void dprintf( char far *, ...);
#endif
#ifdef DEBUGECP
void dprintf( char far *, ...);
#endif

/* PARIDC.C */
void far pascal _loadds parLPTCMD_Entry( ULONG FuncCode,
                                             ULONG var1, ULONG var2 );
USHORT vdmRegister( ULONG var1, ULONG var2 );
USHORT vdmDeregister( ULONG var1, ULONG var2 );
USHORT parReqExclusive( ULONG var1, ULONG var2 );
USHORT CheckDirectAccess( parInstance_t *pInst, USHORT ExclusiveID,
                                                  BOOL bBlock );
USHORT parRelExclusive( ULONG var1, ULONG var2 );
USHORT FreeDirectAccess( parInstance_t *pInst, USHORT ExclusiveID );
USHORT vdmRetParBufSize( ULONG var1, ULONG var2 );
USHORT parRequestDirect( parInstance_t *pInst );
USHORT parReleaseDirect( parInstance_t *pInst );
USHORT parQueryDeniedAccess( USHORT PortID );
USHORT parPDD_Entry( USHORT FuncCode, USHORT Flags, USHORT PortID );

/* PARINIT.C */
void parInit( parInstance_t *pInst, RPH FAR *pRP );
BOOL parDetermineHardware( USHORT BusType );
BOOL DetectECP( USHORT PortAddr, USHORT *ECPPortAddr );
USHORT DetectIRQ( USHORT PortAddr );
USHORT DefaultIRQ( USHORT PortAddr, USHORT BusType );
void FAR IRQ7ISR();
void FAR IRQ5ISR();
void FAR PARTimeout();
USHORT PARAllocPort( USHORT baseport, PHRESOURCE phResource);
USHORT PARAllocIRQ( USHORT bustype, USHORT IRQlevel, PHRESOURCE phResource);
USHORT PARCreateAdapter( USHORT bustype, USHORT adaptnum, PHADAPTER phAdapter,
                         HRESOURCE hResPort, HRESOURCE hResIRQs);
void PARCreateDevice( parInstance_t *pInst );
PSZ getModel( PSZ pDevID );
BOOL stringncmp( PSZ s1, PSZ s2, USHORT Length );
