
;/*************************************************************************
;*
;* SOURCE FILE NAME = SGCB.INC
;*
;* DESCRIPTIVE NAME = Mouse Device Driver session control block
;*                    data structure.
;*
;* COPYRIGHT    COPYRIGHT IBM CORPORATION, 1991, 1992
;*              Copyright Microsoft Corporation, 1990
;*              LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
;*              REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
;*              RESTRICTED MATERIALS OF IBM
;*              IBM CONFIDENTIAL
;*
;* VERSION      V2.0
;*
;* DATE         07/08/91
;*
;* DESCRIPTION  The SGCB structure and related equates must reside
;*              in a seperate files because this files is also used
;*              by POINTDD.SYS.
;*
;* FUNCTIONS
;*
;*
;*
;*
;*
;*
;*
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;**************************************************************************


ScrGp_Data     STRUC

;*
;* SG CB data sub-table (40 Bytes)
;*

   RowScale_Fact    DW  ?  ; Row movement scaling factor
   ColScale_Fact    DW  ?  ; Column movement scaling factor
   Row_Remain       DW  ?  ; Row coord move remainder
   Col_Remain       DW  ?  ; Col coord move remainder
   D_Status         DW  ?  ; Device status flags
                           ;  High Byte:
                           ;   0000xxxx Reserved 0.
                           ;   xxxx1xxx Threshold calcs disabled.
                           ;   xxxxx1xx Single queue mode active.
                           ;   xxxxxx1x Report motion data in mickeys
                           ;               not display coordinates.
                           ;   xxxxxxx1 Intrpt time drawing disabled.
                           ;  Low Byte:
                           ;   0000xxxx Reserved 0
                           ;   xxxx1xxx Unsupported display mode.
                           ;   xxxxx1xx Event queue flush in progress.
                           ;   xxxxxx1x Process blocked on event data.
                           ;   xxxxxxx1 Event queue busy.
   E_Mask           DW  ?  ; Event mask - tells what events to report
                           ;  High byte:
                           ;   Reserved 0
                           ;  Low Byte:
                           ;   0xxxxxxx Reserved 0
                           ;   x1xxxxxx button 3 events w/o motion
                           ;   xx1xxxxx button 3 events w/motion
                           ;   xxx1xxxx button 2 events w/o motion
                           ;   xxxx1xxx button 2 events w/motion
                           ;   xxxxx1xx button 1 events w/o motion
                           ;   xxxxxx1x button 1 events w/motion
                           ;   xxxxxxx1 motion only events
   Hdle_Cntr        DW  ?  ; # of open device handles
   E_Queue          DW  ?  ; offset to start of event queue
   Eq_Head          DW  ?  ; Event queue head offset pointer
   Eq_Tail          DW  ?  ; Event queue tail offset pointer
   Eq_PID           DW  ?  ; PID blocked on event queue
   Eq_Size          DB  ?  ; # of elements in queue
   Chain_Size       DB  ?  ; # of monitors in chain
   Chain_Hdle       DW  ?  ; Monitor chain handle
   Screen_Entp      DD  0  ; Pointer draw device driver entry point address
   Screen_Tble      DD  0  ; @ to screen drivers data table
   Screen_Func      DW  ?  ; Pointer draw requested function code
   Screen_DOff      DW  ?  ; Pointer draw data segment offset
   Screen_DSeg      DW  ?  ; Pointer draw data segment selector

;*
;* Mon chain output buf (14 Bytes)
;*

   MB_Len           DW  ?  ; Monitor output Buffer Length (bytes)
   MFlags           DW  ?  ; Monitor flags
   EMask            DW  ?  ; Mouse event
   EMTime           DD  ?  ; Event's Milli-Second Time Stamp
   Row_Pos          DW  ?  ; Current pointer row coord
   Col_Pos          DW  ?  ; Current pointer col coord

;*
;* Base display Mode data. The length is the total mode data length.
;* The mode data is not contiguous.  The extended mode data is stored
;* later in this control block.                  (12 Bytes)
;*

   MLength          DW  ?  ; Display Mode length (bytes) (extended length also)
   Mtype            DB  ?  ; Mono text/color text/color graphics
   Color            DB  ?  ; # of color bits (graphics type only)
   TCol_Res         DW  ?  ; Column resolution (text)
   TRow_Res         DW  ?  ; Row resolution (text)
   GCol_Res         DW  ?  ; Column resolution (graphics)
   GRow_Res         DW  ?  ; Row resolution (graphics)

;*
;* Display mode cell sizes.  Ptr draw calculates these values during a
;* CheckModeReal and CheckModeProt function call.   (4 bytes)
;*

   Col_Cell_Size    DW  ?  ; Graphics col res/ text col res
   Row_Cell_Size    DW  ?  ; Graphics row res/ text row res

;*
;* Mouse/Pointer draw fields (38 Bytes)
;*

   Ptr_Flags        DW  0  ; Pointer image activity flags
                           ;  High Byte:
                           ;   Reserved 0
                           ;  Low Byte:
                           ;   00000xxx  Reserved 0
                           ;   xxxxx1xx  Disable drawing
                           ;   xxxxxx1x  Drawing requires retrace check
                           ;   xxxxxxx1  Ptr image is visible
   Ptr_Height       DW  ?  ; Height of ptr image (resolution units)
   Ptr_Width        DW  ?  ; Width of ptr image (resolution units)
   Ptr_Row_Pos      DW  ?  ; Current pointer row coord position
   Ptr_Col_Pos      DW  ?  ; Current pointer col coord position
   Ptr_Rowhot       DW  ?  ; Row index ptr shape reference pixel
   Ptr_Colhot       DW  ?  ; Col index ptr shape reference pixel
   Ptr_BuffLow      DW  ?  ; Physical address to ptr image buffer
   Ptr_BuffHigh     DW  ?  ;    "       "   High word
   Ptr_BuffLen      DW  ?  ; Pointer image total buffers len (bytes)
   Ptr_Imagelen     DW  ?  ; Pointer image buffer length (bytes)
   Ptr_Imageoff     DW  ?  ; Pointer image offset (bytes)
   Ptr_Linelen      DW  ?  ; Pointer image line length
   Ptr_Skiplen      DW  ?  ; Pointer image skip length
   Tot_Linelen      DW  ?  ; Pointer total line length
   Ptr_Savstart     DW  ?  ; Pointer save start pointer
   Ptr_Savend       DW  ?  ; Pointer save end pointer
   Ptr_Savstartodd  DW  ?  ; Pointer save start odd pointer
   Ptr_Savendodd    DW  ?  ; Pointer save end odd pointer

;*
;* Collision Area fields (10 Bytes)
;*

   Area_Flags       DW  ?  ; collision area definition flags
                           ;  High Byte:
                           ;   Reserved 0
                           ;  Low Byte:
                           ;   0000000x  Reserved 0
                           ;   xxxxxxx1  Collision area defined
                           ;   xxxxxxx0  No collision area defined
   Area_Top         DW  ?  ; starting row coord position
   Area_Left        DW  ?  ; starting col coord position
   Area_Bot         DW  ?  ; ending row coord position
   Area_Right       DW  ?  ; ending col coord position

;*
;* Cell remainders (4 bytes)
;*

   Col_Cell_Remain  DW  ?  ;  Column cell remainder
   Row_Cell_Remain  DW  ?  ;  Row cell remainder

;*
;* Extended mode data pointer (4 bytes)
;*

   ExtModePtr       DD  ?  ;  Pointer to any extended mode data

;*
;* Display configuration data. (6 bytes)
;*

   Cur_Config       DW  ?  ;  Current display configuration #
   CfgOffset        DW  ?  ;  Offset to display configuration data
   CfgSelector      DW  ?  ;  Selector to display configuration data

;*
;* Threshold levels and multipliers  (8 bytes)
;*

   Level1           dw  ?  ;  level 1 movement value in mickeys/interrupt
   Lvl1Mplr         dw  ?  ;  level 1 multiplier
   Level2           dw  ?  ;  level 2 movement value in mickeys/interrupt
   Lvl2Mplr         dw  ?  ;  level 2 multiplier

; GRADD START
   fTaskPtr         dd  0  ;  Task time cursor registered
   fBlocked         dd  0  ;  Blocked flag
   CursorBlockID    dd  0  ;  ID of blocked thread
   usLastX          dw  0  ;  Last X value given
   usLastY          dw  0  ;  Last Y value given
; GRADD END
;*
;* Constraint limits  (added for DAX)
;*
   ConstrX0         dw  ?  ;  Upper left limit (inclusive)
   ConstrY0         dw  ?  ;  Upper left limit (inclusive)
   ConstrX1         dw  ?  ;  Lower right limit (inclusive)
   ConstrY1         dw  ?  ;  Lower right limit (inclusive)

ScrGp_Data     ENDS

;*
;* These equates relate to the session control block explicitly
;*

SRec_Size        EQU  SIZE ScrGp_Data    ; && SG CB size (Bytes) (GRADD)                 (DD)
BaseModeLen      EQU  12                 ; Base mode data length
