/**************************************************************************
 *
 * SOURCE FILE NAME =  MSERM.C
 *
 * DESCRIPTIVE NAME =  Mouse interface to RM subsystem.
 *
 *
 * Copyright : COPYRIGHT IBM CORPORATION, 1994, 1995
 *             LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
 *             REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
 *             RESTRICTED MATERIALS OF IBM
 *             IBM CONFIDENTIAL
 *
 * VERSION = V0.1
 *
 * DATE  09/02/94
 *
 * DESCRIPTION : (see above)
 *
 * Purpose: (see above)
 *
 *
 *
 * FUNCTIONS  :
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 *
 *
 * EXTERNAL FUNCTIONS
 *
 * CHANGE ACTIVITY =
 *   DATE      FLAG        APAR   CHANGE DESCRIPTION
 *   --------  ----------  -----  --------------------------------------
 *   09/02/94                            opened file
 ****************************************************************************/
#define INCL_NOPMAPI
#include <os2.h>

#include "mserm.h"  // brings in rmcalls.h

extern UCHAR ABIOS_Mch;   /* Is ABIOS machine ? */

/*--------------------------------------------------------*/
/* # D E F I N E S                                        */
/*--------------------------------------------------------*/

// #defines in MSERM.H

#define    BUS_DEVICE  1
#define    MSS_DEVICE  2
#define    INP_DEVICE  3
#define    PDI_DEVICE  4

#define    MOUSESYS     1
#define    PCLOGICSYS   2

/*----------------------------------------------*/
/* GLOBAL VARS FOR RM                           */
/*                                              */
/* RM.LIB needs these declared                  */
/*----------------------------------------------*/
ULONG         RMFlags               = 0L;  /*VPNP*/
PFN           RM_Help0              = 0L;  /*VPNP*/
PFN           RM_Help3              = 0L;  /*VPNP*/
PFN           Device_Help           = NULL;

/*--------------------------------------------------------*/
/* Set the DRIVERSTRUCT and ADAPTERSTRUCT data areas      */
/*--------------------------------------------------------*/

/*----------------------------------------------*/
/* Driver Description                           */
/*----------------------------------------------*/
DRIVERSTRUCT DriverStruct =
{
   NULL,                                     /* DrvrName                */
   NULL,                                     /* DrvrDescript            */
   NULL,                                     /* VendorName              */
   CMVERSION_MAJOR,                          /* MajorVer                */
   CMVERSION_MINOR,                          /* MinorVer                */
   1994,9,06,                                /* Date                    */
   DRF_STATIC,                               /* DrvrFlags               */
   DRT_OS2,                                  /* DrvrType                */
   DRS_CHAR,                                 /* DrvrSubType             */
   NULL                                      /* DrvrCallback            */
};

/*----------------------------------------------*/
/* Adapter Description                          */
/*----------------------------------------------*/
ADAPTERSTRUCT AdapterStruct =
{
  NULL,                              /* AdaptDescriptName; */
  0,                                 /* AdaptFlags;        */
  AS_BASE_INPUT,                     /* BaseType;          */
  AS_SUB_MOUSE,                      /* SubType;           */
  AS_INTF_GENERIC,                   /* InterfaceType;     */
  NULL,                              /* HostBusType;       */
  AS_BUSWIDTH_8BIT,                  /* HostBusWidth;      */
  NULL                               /* pAdjunctList;      */
};

/************************************************/
/* Device Description                           */
/************************************************/
DEVICESTRUCT DeviceStruct =
{
  "MOUSE_0 IBM Compatible Mouse",            /* DevDescriptName;   */
  0,                                 /* DevFlags;          */
  DS_TYPE_IO,                        /* DevType;           */
  NULL                               /* pAdjunctList;      */
};


/*----------------------------------------------*/
/* GLOBAL HANDLE VARIABLES                      */
/*                                              */
/* These variables get the handles for          */
/* drivers, adapter (only 1), and resources.    */
/*                                              */
/*----------------------------------------------*/

HDRIVER   hDriver   = NULL;     // global handle to driver
HADAPTER  hAdapter  = NULL;     // global handle to adapter
HDEVICE   hDevice   = NULL;     // global handle to driver
HRESOURCE hResPorts = NULL;     // global handle to ports resource
HRESOURCE hResPort2 = NULL;     // global handle to ports resource
HRESOURCE hResIRQs  = NULL;     // global handle to IRQs resource

/*--------------------------------------------------------*/
/* RM_MSE_CreateDriver - registers to RM susbsystem       */
/*                       (which initializes the DD to     */
/*                        RM connection)                  */
/*                                                        */
/*--------------------------------------------------------*/

USHORT FAR RM_MSE_CreateDriver( USHORT DriverSys)
{
   if (DriverSys == MOUSESYS) {
       DriverStruct.DrvrName = "MOUSE.SYS";
       DriverStruct.DrvrDescript = "IBM Mouse Device Independent Driver";
       DriverStruct.VendorName = "IBM - OS/2";
   }
   else if (DriverSys == PCLOGICSYS) {
       DriverStruct.DrvrName = "PCLOGIC.SYS";
       DriverStruct.DrvrDescript = "Logitech Mouse Device Dependent Driver";
       DriverStruct.VendorName = "Logitec - OS/2";
   }
   else {
       DriverStruct.DrvrName = "???.SYS";
       DriverStruct.DrvrDescript = "Mouse Device Dependent Driver";
       DriverStruct.VendorName = "???";
   }

   /*---------------------------------------------------*/
   /* Allocate Driver Handle                            */
   /*---------------------------------------------------*/

   return( RMCreateDriver( &DriverStruct, &hDriver));

}

/*--------------------------------------------------------*/
/* RM_MSE_DestroyDriver - deregisters the driver from     */
/*                        RM sub-system and releases all  */
/*                        claimed resources               */
/*                                                        */
/*--------------------------------------------------------*/

VOID  FAR RM_MSE_DestroyDriver( VOID)
{
   if (hDriver) {
      RMDestroyDriver( hDriver);
   }
}

/*--------------------------------------------------------*/
/* RM_MSE_CreateAdapter - tells RM to associate adapter   */
/*                        to driver and resources to      */
/*                        adapater                        */
/*                                                        */
/* HINT (Using this generically):                         */
/*                                                        */
/* This function builds up the AHRESOURCE array for the   */
/* the call to RMCreateAdapter. To modify this for a      */
/* specfic DD the handles to resource variables set into  */
/* the array will have to be touched along with the lines */
/* that set the NumResource. Also, AdapterStruct (see     */
/* above) will have to be set up apropriately.            */
/*                                                        */
/*--------------------------------------------------------*/


USHORT FAR RM_MSE_CreateAdapter( USHORT bustype)
{
   UCHAR       ResourceBuf[ MAX_RES_BUF_SIZE];
   PAHRESOURCE pResourceList = (PAHRESOURCE)ResourceBuf;

   pResourceList->NumResource = 2;

   if (!(hResIRQs)) {
       pResourceList->NumResource--;
       if (!(hResPorts)) {
           pResourceList->NumResource--;
       }
   }

   pResourceList->hResource[0] = hResPorts;
   pResourceList->hResource[1] = hResIRQs;

   if (bustype == PDI_DEVICE) {
       AdapterStruct.AdaptDescriptName = "AUX_0 PS/2 Auxiliary Device Controller";
       AdapterStruct.HostBusType =  AS_HOSTBUS_PLANAR;
       pResourceList->NumResource = 3;
       pResourceList->hResource[1] = hResPort2;
       pResourceList->hResource[2] = hResIRQs;
   }
   else if (bustype == MSS_DEVICE) {
       AdapterStruct.AdaptDescriptName = "SERIAL_0 Serial Port Controller";
       AdapterStruct.HostBusType =  AS_HOSTBUS_PLANAR;
   }
   else if (bustype == INP_DEVICE) {
       AdapterStruct.AdaptDescriptName = "INPORT_0 Inport Mouse Controller";
       AdapterStruct.HostBusType =  AS_HOSTBUS_ISA;
   }
   else if (bustype == BUS_DEVICE) {
       AdapterStruct.AdaptDescriptName = "BUSMOUSE_0 Bus Mouse Controller";
       AdapterStruct.HostBusType =  AS_HOSTBUS_ISA;
   }
   else  {
       AdapterStruct.AdaptDescriptName = "Unknown Mouse Adapter";
       AdapterStruct.HostBusType =  AS_HOSTBUS_UNKNOWN;
   }




   return ( RMCreateAdapter( hDriver,
                             &hAdapter,
                             &AdapterStruct,
                             NULL,
                             pResourceList ));
}

/*--------------------------------------------------------*/
/* RM_MSE_CreateDevice - registers to RM susbsystem       */
/*                                                        */
/*--------------------------------------------------------*/

USHORT FAR RM_MSE_CreateDevice( VOID)
{
   return( RMCreateDevice( hDriver,
                           &hDevice,
                           &DeviceStruct,
                           hAdapter,
                           NULL));
}

/*--------------------------------------------------------*/
/* RM_MSE_AlllocPorts - attempts to claim a port resource */
/*                       from RM subsystem                */
/*                                                        */
/* ARGS:                                                  */
/*                                                        */
/* USHORT baseport - base IO port.                        */
/* USHORT nPorts   - number of prts inclusive of base port*/
/*                                                        */
/* HINT (Using this generically):                         */
/*                                                        */
/* Modifying this for a specific DD might consist of:     */
/*                                                        */
/* 1 Setting the res handle to a variable ptr passed in   */
/* 2 Assigning IOResource members proper values (see      */
/*   rmbase.h for all the allowed values)                 */
/*                                                        */
/*--------------------------------------------------------*/
USHORT FAR RM_MSE_AllocPorts( USHORT PortVal)
{

   RESOURCESTRUCT Resource;

   if ( hResPorts)
   {
         return( RM_MSE_ERR_RESOURCECLAIMED);
   }

   Resource.ResourceType              = RS_TYPE_IO;
   Resource.IOResource.BaseIOPort     = PortVal;
   Resource.IOResource.NumIOPorts     = 1;
   Resource.IOResource.IOFlags        = RS_IO_SHARED;
   Resource.IOResource.IOAddressLines = DECODE_WIDTH;

   /*---------------------------------------------------*/
   /* Allocate Driver Handle                            */
   /*---------------------------------------------------*/

   return( RMAllocResource( hDriver, &hResPorts , &Resource));

}


USHORT FAR RM_MSE_AllocExPorts( USHORT PortVal)
{

   RESOURCESTRUCT Resource;

   if ( hResPorts)
   {
         return( RM_MSE_ERR_RESOURCECLAIMED);
   }

   Resource.ResourceType              = RS_TYPE_IO;
   Resource.IOResource.BaseIOPort     = PortVal;
   Resource.IOResource.NumIOPorts     = 1;
   Resource.IOResource.IOFlags        = RS_IO_EXCLUSIVE;
   Resource.IOResource.IOAddressLines = DECODE_WIDTH;

   /*---------------------------------------------------*/
   /* Allocate Driver Handle                            */
   /*---------------------------------------------------*/

   return( RMAllocResource( hDriver, &hResPorts , &Resource));

}

/*--------------------------------------------------------*/
/* RM_MSE_AlllocPort2 - attempts to claim a port resource */
/*                       from RM subsystem                */
/*                                                        */
/* ARGS:                                                  */
/*                                                        */
/* USHORT baseport - base IO port.                        */
/* USHORT nPorts   - number of prts inclusive of base port*/
/*                                                        */
/* HINT (Using this generically):                         */
/*                                                        */
/* Modifying this for a specific DD might consist of:     */
/*                                                        */
/* 1 Setting the res handle to a variable ptr passed in   */
/* 2 Assigning IOResource members proper values (see      */
/*   rmbase.h for all the allowed values)                 */
/*                                                        */
/*--------------------------------------------------------*/
USHORT FAR RM_MSE_AllocPort2( USHORT PortVal)
{

   RESOURCESTRUCT Resource;

   if ( hResPort2)
   {
         return( RM_MSE_ERR_RESOURCECLAIMED);
   }

   Resource.ResourceType              = RS_TYPE_IO;
   Resource.IOResource.BaseIOPort     = PortVal;
   Resource.IOResource.NumIOPorts     = 1;
   Resource.IOResource.IOFlags        = RS_IO_SHARED;
   Resource.IOResource.IOAddressLines = DECODE_WIDTH;

   /*---------------------------------------------------*/
   /* Allocate Driver Handle                            */
   /*---------------------------------------------------*/

   return( RMAllocResource( hDriver, &hResPort2 , &Resource));

}

/*--------------------------------------------------------*/
/* RM_MSE_DeallocPorts - attempts to dealloc a port       */
/*                       resource from RM subsystem       */
/*                                                        */
/*--------------------------------------------------------*/
USHORT FAR RM_MSE_DeallocPorts( VOID)
{
   HRESOURCE  DeletePort = hResPorts;

   hResPorts = 0;
   return( RMDeallocResource( hDriver, DeletePort));
}

/*--------------------------------------------------------*/
/* RM_MSE_DeallocPort2 - attempts to dealloc a port       */
/*                       resource from RM subsystem       */
/*                                                        */
/*--------------------------------------------------------*/
USHORT FAR RM_MSE_DeallocPort2( VOID)
{
   HRESOURCE  DeletePort = hResPort2;

   hResPort2 = 0;
   return( RMDeallocResource( hDriver, DeletePort));
}

/*--------------------------------------------------------*/
/* RM_MSE_AllocIRQ   - attempts to claim a IRQ resource   */
/*                       from RM subsystem                */
/*                                                        */
/* ARGS:                                                  */
/*                                                        */
/* USHORT IRQlevel - IRQ level to claim                   */
/*                                                        */
/*                                                        */
/* HINT (Using this generically):                         */
/*                                                        */
/* Modifying this for a specific DD might consist of:     */
/*                                                        */
/* 1 Setting the IRQ handle to a variable ptr passed in   */
/* 2 Assigning IRQResource members proper values (see     */
/*   rmbase.h for all the allowed values)                 */
/*                                                        */
/*--------------------------------------------------------*/
USHORT FAR RM_MSE_AllocIRQ( USHORT IRQlevel)
{

   RESOURCESTRUCT Resource;

   if ( hResIRQs)
   {
         return( RM_MSE_ERR_RESOURCECLAIMED);
   }

   /*------------------------------------------------*/
   /* Request IRQ Resource  from RM......            */
   /*------------------------------------------------*/
   Resource.ResourceType          = RS_TYPE_IRQ;
   Resource.IRQResource.IRQLevel  = IRQlevel;
   Resource.IRQResource.PCIIrqPin = RS_PCI_INT_NONE;

   if(ABIOS_Mch){
      Resource.IRQResource.IRQFlags  = RS_IRQ_SHARED;
   } else {
      Resource.IRQResource.IRQFlags  = RS_IRQ_EXCLUSIVE;
   }


   /*---------------------------------------------------*/
   /* Allocate Driver Handle                            */
   /*---------------------------------------------------*/
   return( RMAllocResource( hDriver, &hResIRQs , &Resource));

}

