; SCCSID = src/dev/kbd/kbdbase.ssc/kbdswap.asm, kbd, c.basedd 98/01/16
     Page  58,132
     Title   KBDSWAP - Kbd Device Driver Swappable Subroutines
     Name    KBDSWAP

;/*************************************************************************
;*
;* SOURCE FILE NAME = KBDSWAP.ASM
;*
;* DESCRIPTIVE NAME = Kbd Device Driver Swappable Subroutines
;*
;* COPYRIGHT    COPYRIGHT IBM CORPORATION, 1991, 1992
;*              Copyright Microsoft Corporation, 1990
;*              LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
;*              REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
;*              RESTRICTED MATERIALS OF IBM
;*              IBM CONFIDENTIAL
;*
;* VERSION      V2.0
;*
;* DATE         03/15/92
;*
;* DESCRIPTION  This file contains the subroutines that are called ONLY by
;*              code residing in the SWAPCODE segment.  Code in this
;*              segment is in high memory and is swappable, so any critical
;*              time dependant paths shouldn't flow though these subroutines.
;*
;*
;* FUNCTIONS
;*              YieldProc
;*              SearchCPCB
;*              InitPSG
;*              IoctlAddrCheck
;*              FirstReadCheck
;*              NLS_Packet
;*              CopyXtable
;* NOTES
;*              RESTRICTIONS:  Machine must be a 386 or compatible with a 386.
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*
;*   This file originated on 12/28/89, for DCR 652. @IBM
;*             @V2.0XXX01  DCR 1546 Memory allocation for CPCB index 1 thru 3
;*
;*             @V2.0TRM01  B733926  Support Custom Translation Tables.
;*   UNKNOWN   J-DBCS001   DBCS enabling  (J-001)
;*   UNKNOWN   J-DBCS003   DBCS enabling  (ss0007,ss0012)          (S.Sakamoto)
;******************************************************************************/



.286p
.sall
.xcref
.xlist
  Include    basemaca.inc                ;* DOS macros.
  Include    osmaca.inc                  ;* Macro file for OS/2 kernel
  CPUMODE    286                         ;*
  Include    devsym.inc                  ;* Device driver header definitions.
  Include    devhlp.inc                  ;* DevHlp & Signal equates, char queue structure.
  Include    infoseg.inc                 ;* InfoSeg structure.
  Include    struc.inc                   ;* Structured assembly macros.
  Include    kbdseg.inc                  ;* Segment definitions.
  Include    kbdddr.inc                  ;* Keyboard Device Driver structures & equates.
  Include    kbdxlat.inc                 ;* Translate table structure defs Added for DCR 1546
.list                                    ;*
                                         ;*
 StkFrameVars                            ;* Define local storage stack variables.
                                         ;*
;* External Routines                     ;*
 EXTRNFAR AccessKCB                      ;* This routine is HYBRID,; @IBM DCR 652 introduced this
 Extrn    MonDispEntry   :Far            ;* This routine is in KBDCODE
                                         ;*
;* External Variables                    ;*
 Extrn       IntFlags          :Byte     ;* B722390  @IBM
 Extrn       MiscFlags         :Byte
 Extrn       CmdFlags          :Byte
 Extrn       CPCount           :Word
 Extrn       SInfoSeg          :Word
 Extrn       CurSG             :Word
 Extrn       PSGPointers       :Word
 Extrn       DeviceHelp        :DWord
 Extrn       CBDataSel         :Word
 Extrn       MLNotifyPct       :Word
ifdef DBCSKBD
 Extrn       KbdHWIDs          :Word                                    ;@IBM J-DBCS003(A)
endif ;DBCSKBD


StratCode Segment                        ;* @IBM This was introduced for DCR 652
Assume CS:StratCode,DS:DGROUP,ES:Nothing

BREAK <IOCtlAddrCheck subroutine>
Public IOCtlAddrCheck
IOCtlAddrCheck   Proc

;**********************************************************************
;*
;* FUNCTION NAME  =  IOCtlAddrCheck
;*
;* DESCRIPTION    =  Validate the Request Packet Parm List and Data
;*                   Buffer addresses given required lengths.
;*
;*                   Ensures that the IOCTL caller's pointers to necessary
;*                   data areas are visible, and that the limits of the
;*                   segments are valid.  If an error occurs, the General
;*                   Error code will eventually be set in the Request
;*                   Packet status field.
;*
;* NOTES          =  Major change to this routine to call VerifyAccess
;*                   DevHlp instead of performing Verw and Lsl
;*                   instructions. ; See PTM 3829.  @IBM
;*
;*
;* INPUT          =
;*                   CX = Allowed length of Parm List (0 = not used)
;*                   SI = Allowed length of Data Bfr  (0 = not used)
;*                   DH = Access type (0 = read only, 1 = read/write)
;*                   ES:BX = Request Packet address.
;*
;* EXIT-NORMAL    =  Return to caller of routine. Carry flag clear.
;*
;* EXIT-ERROR     =  Return to caller.  Carry flag set indicating access
;*                   denied.
;*
;* EFFECTS        =
;*                   Alters: CX (if not 0 on entry)?
;*
;*
;***************************************************************************


  Push    AX                               ;* Save caller's register.
  Push    DX                               ;*  "
  Push    DI                               ;*  "

  Mov     DL, DevHlp_VerifyAccess          ;* Set desired DevHlp function.
                                           ;*
  Or      SI,SI                            ;*   Check if Data Buffer pointer to be verified.
                                           ;*
 .If <nz>                                  ;* Is it?
    Push    CX                             ;* Yes, save CX for now.
    Mov     AX, ES:[BX+DataBfrPtr+2]       ;* Set data buffer seg/sel.
    Mov     CX, SI                         ;* Set length to check.
    Mov     DI, ES:[BX+DataBfrPtr]         ;* Set data buffer offset.
    Call    DeviceHelp                     ;* Verify Access to data buffer
    Pop     CX                             ;* Restore parm list length parm.
 .Endif                                    ;* End check data buffer.

 .If < nc >                                ;* If previous check okay,
    Or   CX,CX                             ;* CHeck if Parm List pointer to be verified.
   .If <nz>                                ;* If parm list to be checked,
      Mov   AX,ES:[BX+ParmListPtr+2]       ;* Set parm list seg/sel.
      Mov   DI,ES:[BX+ParmListPtr]         ;* Set parm list offset.
                                           ;* (CX already set to length)
      Call DeviceHelp                      ;* Verify Access to parm list.
   .Endif
 .Endif

 .If < c >                                 ;* Carry set = access denied.
    LES   BX, Dword Ptr StkRPO             ;* Restore request packet address.
    Mov   ES:[BX+PktStatus],ParmError      ;* Indicate invalid parameter in RP
 .Endif                                    ;* End if verify access failed.

  Pop   DI                                 ;* Restore caller's register.
  Pop   DX                                 ;*  "
  Pop   AX                                 ;*  "
  Ret
IOCtlAddrCheck Endp



BREAK <FirstReadCheck subroutine>
Public FirstReadCheck
FirstReadCheck   Proc

;**********************************************************************
;*
;* FUNCTION NAME  FirstReadCheck
;*
;* DESCRIPTION   Check for first read by active session.
;*
;*              Called on read or peek requests until a foreground
;*              session is the caller.  Ensures that the current
;*              session number is correct and clears the NoReadYet
;*              flag so that the interrupt handler can start
;*              processing keystrokes.
;*
;*
;* INPUT
;*              AX = Caller's session number.
;*              DI = PSDA pointer for caller's session.
;*
;* EXIT-NORMAL  Return to caller of routine.
;*
;* EXIT-ERROR   None. All exits are through NORMAL above.
;*
;* EFFECTS
;*              Saved Shift (and DBCS Shift) flags are copied to the
;*              PSDA if the session is active.  PSDA 0 shift/DBCS shift
;*              flags are zeroed in this case, too.
;*
;******************************************************************


  Push   ES                                ;* Save ES during following.
  Push   BX                                ;* Save BX for now.
  Mov    ES,[SInfoSeg]                     ;* Get segment of System infoseg.
  Mov    BL,ES:[SIS_CurScrnGrp]            ;* Get active SG number.
  Xor    BH,BH                             ;*
 .If <BX eq AX>                            ;* Is our SG the active one?
    Cli                                    ;* Yes! Don't allow ints while fixing things.
    And   [MiscFlags],Not NoReadYet        ;* We have our first read.
    Or    IntFlags, FReadDone              ;* B722320 @IBM
    Mov   [CurSG],AX                       ;* Make sure we ARE the active one.
    Push  AX                               ;* Save session number.
    Or    [DI].PSGFlags,ActiveSG           ;* Set indicators.               ;HZ00417

    ;** Establish addressability to the KCB for session 0.

    Push   DI                              ;* Save PSG offset.
    Mov    DI, PSGPointers                 ;* Get offset of PSG 0.
    Mov    DH, ES_DI                       ;* Indicate receiving registers
                                           ;*  for next call.
    CALLFAR AccessKCB                      ;* Get KCB for session 0.
    Mov    BX, ES:[DI].KCBShift            ;* Get saved shift flags from
                                           ;*  session 0.
    Mov    AL, ES:[DI].KCBDBCSSh           ;* Get saved DBCS shift flag
                                           ;*  from session 0.
    Mov    ES:[DI].KCBShift, 0             ;* Clear out saved shift flags
    Mov    ES:[DI].KCBDBCSSh, 0            ;*  and saved DBCS Shift from
                                           ;*  session 0.

    ;* BX and AL now contain the shift and DBCS shift states,
    ;* respectively, which were saved in session 0.  Put the saved
    ;* values in the respective fields of the current session.

    Pop    DI                             ;* Restore current PSG offset.
    Push   DI                             ;* Save current PSG offset
                                          ;*  again.
    Mov    DH, ES_DI                      ;* Signify receiving registers
                                          ;*  for next call.
    CALLFAR AccessKCB                     ;* Get the KCB for the current
                                          ;*  session.
    Mov    ES:[DI].KCBShift, BX           ;* Put saved shift state in
                                          ;*  this session's KCB.
    Mov    ES:[DI].KCBDBCSSh, AL          ;* Put saved DBCS shift state
                                          ;*  in this session's KCB.
                                          ;*
    Pop    DI                             ;* Restore current PSG offset.
    Pop    AX                             ;* Restore session number.
    Sti                                   ;* Allow ints now.
 .Endif
  Pop    BX
  Pop    ES
  Ret

FirstReadCheck Endp

BREAK <InitPSG Routine>


;***********************************************************************
;*
;* FUNCTION NAME  InitPSG
;*
;* DESCRIPTION    Initialize the PSG data area.
;*
;* FUNCTION       This routine is called at Device driver initial-
;*                ization time to initialize the PSG data areas.
;*
;*
;* INPUT:
;*                REGISTERS:
;*
;*                     DI = PSG pointer
;*
;* EXIT-NORMAL:
;*              DI = address of initialized PSG data area
;*
;* EXIT-ERROR:  None
;*
;*
;*************************************************************************


Procedure InitPSG

  ; Initialize ShiftFlags according to keyboard type

;; I don't think this test is needed because the kernal over writes the
;; LEDs to be the way he likes it anyway. (2.1 does not set NUMLOCK)

  Test MiscFlags,EnhancedKbd                 ;* Check if an Enhanced keyboard
 .If <nz>                                    ;* If so...
ifndef DBCSKBD
    Mov DX, NumTogl                          ;* Set shift status to NumLock on
else ;DBCSKBD
  ;Need to initialize the shift and LED flags for PAD-Less Keyboard       ;@IBM J-DBCS003(A)
    Mov DH, Byte Ptr [KbdHWIDs+1]       ;* Get 2nd Byte of Keyboard HW ID ;@IBM J-DBCS003(A)
   .If <DH eq ID2A> OR                  ;* If PAD-Less KBD is attached    ;@IBM J-DBCS003(A)
   .If <DH eq ID2A_2> OR                ;* (ID without Xlation)           ;@IBM J-DBCS003(A)
   .If <DH eq ID2P_J>                   ;* initialize shift and LED to    ;@IBM J-DBCS003(A)
      Xor DX,DX                         ;* non-NumLock state.             ;@IBM J-DBCS003(A)
   .Else
      Mov DX, NumTogl                        ;* Set shift status to NumLock on
   .Endif                                                                 ;@IBM J-DBCS003(A)
endif ;DBCSKBD
 .Else                                       ;* Else regular AT keyboard
    Xor DX,DX                                ;* so clear all shift flags
 .Endif                                      ;* Endif Enhanced keyboard or not
                                             ;*
  Mov [DI].DKCB.KCBShift, DX                 ;* Put toggle flags into
  Mov [DI].ShiftFlags, DX                    ;*  new session's PSG and KCB
ifdef DBCSKBD
  Mov [DI].DBCSShift, 00h                    ;* 0 clear DBCS shift flags  ;@IBM J-DBCS001(A)
endif ;DBCSKBD

  ;* Any further SG initialization goes here.

  Mov [DI].DKCB.KCBDBCSFl, DefaultDBCS       ;* Set default DBCS status.
ifdef DBCSKBD
  Mov [DI].DKCB.KCBDBCSSh, 00h               ;* 0 clear DBCS shift        ;@IBM J-DBCS001(A)
endif ;DBCSKBD
  Mov Word Ptr [DI].KCBAddress, 00h          ;* Make the PSG point
  Mov Word Ptr [DI].KCBAddress+2, 00h        ;*  to the Default KCB
                                             ;*  the first time.
                                             ;*
                                             ;* @IBM PTM 1811: ;Checking if CP_Enabled
                                             ;* replaces CPCount again.
  Test CmdFlags, CP_ENABLED                  ;* @IBM PTM 1512: ensure that default table
 .If < nz >                                  ;* is not indicated if op. CP's have
                                             ;*  been specified/downloaded.
    Mov [DI].DKCB.KCBIxOffCP, 1              ;* Set default code page index
                                             ;*  to entry 1 of the CPCB.
 .Else                                       ;* Code pages not enabled yet,
    Mov [DI].DKCB.KCBIxOffCP, 00h            ;*  so use table in CPCB(0).
 .Endif
  Ret
EndProc InitPSG



;* PTM 269 BEGIN @IBM

BREAK <SearchCPCB Routine>

;*******************************************************************
;*
;* FUNCTION NAME  SearchCPCB
;*
;* DESCRIPTION    Search the CPCB for a match on the desired
;*                code page value.
;*
;*                This routine searches the CPCB (starting with the
;*                first prepared code page) for a match on the desired
;*                value, and returns the CPCB index of the matching
;*                entry.
;*
;* NOTE           This routine should only be called when code pages
;*                are prepared.
;*
;*
;* INPUT
;*              REGISTERS:
;*                ES = Selector of CPCB (this could be a PhysToVirt'd value).
;*                AX = Code page value on which to search.
;*
;*
;* EXIT-NORMAL  CX contains index of matching CPCB entry.  The carry
;*              flag is cleared.
;*
;* EXIT-ERROR   The request packet is set with the invalid parm
;*              error code if the desired code page is not found
;*              in the CPCB, and the carry flag is set.
;*
;* OUTPUT:     NONE    (BX, CX, DI altered).
;*
;*
;******************************************************************

Procedure SearchCPCB

  Mov DI, CPCBOFFSET+CPCBEntrySize      ;* Set offset to start of CPCB[1].
  Mov BX, CPCount                       ;* Get number of CPCB entries.
  Mov CX, 1                             ;* Start with CPCB entry 1.
 .While < CX lt BX > AND                ;* Search the CPCB for the entry
 .While < ES:[DI].CPValue ne AX >       ;*  with the matching code page.
    Inc CX                              ;* Next entry.
    Add DI, CPCBEntrySize               ;* Adjust offset.
 .EndWhile                              ;* Loop will exit with CX set
                                        ;*  to index of matching entry
                                        ;*  or one more than the "highest"
                                        ;*  CPCB entry number.
 .If < CX eq BX >                       ;* CX = number CPCB entries is an
                                        ;*  error (CP value not found).
      LES BX, Dword Ptr StkRPO          ;* Restore request packet address.
      Mov ES:[BX+PktStatus],ParmError   ;* Indicate invalid parameter in RP
      Stc                               ;* Indicate as much to caller.
 .Else                                  ;* Else we found the desired CP,
    Clc                                 ;* Ensure carry is clear for caller.
 .Endif                                 ;* End check for passed CPCB end.

  Ret
EndProc SearchCPCB
;* PTM 269 END @IBM

BREAK <YieldProc subroutine>

;****************************************************************
;*
;* FUNCTION  NAME :  YieldProc
;*
;* DESCRIPTION    :  Yield the processor subroutine.
;*
;*                   Called the DevHlp_Yield function.
;*
;*
;* INPUT          :  NONE
;*
;* OUTPUT         :  NONE (The thread could yield the processor).
;*
;* EXIT-NORMAL    :  Return to caller of routine.
;*
;* EXIT-ERROR     :  None.  All exits are through NORMAL above.
;*
;*
;*
;******************************************************************

Procedure YieldProc

  Push     DX                               ;* Save register used by DevHlp
  Mov      DL,DevHlp_Yield                  ;* Set yield function.
  Call     [DeviceHelp]                     ;* Go do it.
  Pop      DX
  Ret
EndProc YieldProc

Public CopyXTable
CopyXTable Proc

;***************************************************************
;*
;* FUNCTION NAME : CopyXTable
;*
;* DESCRIPTION   : Copy the callers translation table into
;*                 the data area specified by a CPCB entry.
;*
;*                 Copy the callers translation table into the specified
;*                 data area.  Ensure enough memory has been allocated
;*                 for the length of the translation table, and if not,
;*                 allocate it.
;*
;*
;* INPUT         : SI = CPCB Index
;*                 CX = Code page value
;*
;* OUTPUT        : NONE
;*
;* EXIT-NORMAL   : Return to caller of routine.
;*
;* EXIT-ERROR    : KbdGenErr (with no return)
;*
;* EFFECTS       : Memory may be allocated for an additional translation
;*                 table.
;*
;*                 Alters ES,DI,DS,AX,CX,DX
;*
;* INTERNAL REFERENCES:
;*    ROUTINES        :
;*                       KbdGenErr (no return)
;*
;* EXTERNAL REFERENCES:
;*    ROUTINES        :  DevHlp (VMAlloc)
;*                       DevHlp (VMFree)
;*
;* HISTORY: Rewritten for DCR 1546.  Memory allocation for CPCB index @IBM
;*          1 through 3 is done here.  Previously this was done at    @IBM
;*          boot time in kbddd.asm code.  It is now done here because @IBM
;*          the translation table length may NOW be greater than 1251 @IBM
;*          so we must allocate accordingly.  At boot time we don't   @IBM
;*          know yet what the length will be. It used to be that all  @IBM
;*          translation tables were 1251 bytes.  They can now be 1251 @IBM
;*          or greater.                                               @IBM
;*
;*************************************************************************

      Mov   ES, CBDataSel                    ;* Get Sel of KIB/CPCB
      Mov   DI, CPCBOFFSET                   ;* Get offset of CPCB
      Push  SI                               ;* Save index value
      Push  CX                               ;* Save the codepage value
      Imul  SI, CPCBEntrySize                ;* Determine offset into 4th CPCB.
      Add   DI, SI                           ;* Add offset to CPCB offset
      push  ds                               ;* Save Data sel
      LDS   SI, Dword Ptr StkTmpL            ;* Get caller's sel/off from
      Mov   cx, [SI].XTLength                ;* Get the length, (dynamic value)
      pop   ds                               ;*

        ;*   Ŀ
        ;*     ALLOCATE ONLY ENOUGH MEMORY NEEDED  
        ;*   

     .If < CX ne ES:[DI].CPUseCount >        ;* If XTLength is not what is allocated
                                             ;* NOTE: CPUseCount=0 when NONE allocated
        .386p                                ;* Use 80386 instructions
         Push ECX                            ;* PB732916    @IBM
         Push EAX                            ;*
        .If < ES:[DI].CPUseCount ne 0 >      ;* If memory was allocated previously
           Mov  EAX, ES:[DI].XTLinear        ;* The linear address of mem to give up
           Mov  DL, DevHlp_VMFree            ;* Specify desired DevHlp.
           Call [DeviceHelp]                 ;* Remove from memory.
          .If <c>                            ;* Carry flag set means error.
              pop eax                        ;* Clean
              pop ecx                        ;* PB732916  @IBM
              pop cx                         ;* up
              pop si                         ;* stack
              Ret                            ;* Get out
          .Endif                             ;* Endif Carry flag set.
           Mov Word Ptr ES:[DI].CPUseCount, 0 ;* Zero out since memory given up
        .Endif                                ;* Endif
         Pop  EAX
         Push EDI                            ;* Save offset into 4th CPCB.
         Mov  EDI, NO_PHYSADDR               ;* Not used.
         Mov  EAX, VMDHA_FIXED+VMDHA_16M+VMDHA_SELMAP ;* Type of memory to alloc
         XOR  ECX, ECX                       ;* Clear out the whole register
         push ds                             ;*
         LDS  SI, Dword Ptr StkTmpL          ;* Get caller's sel/off from stack
         Mov  cx, [SI].XTLength              ;* Get xlation table length
         pop  ds                             ;*

         Mov  DL, DevHlp_VMAlloc             ;* Specify DevHlp fuction.
         Call [DeviceHelp]                   ;* Allocate memory.
        .If <c>                              ;* Carry flag set means error.
            Pop EDI                          ;*
            Pop ECX                          ;* PB732916 @IBM
            RestoreReg <CX,SI>               ;*
            Ret                              ;* Get out
        .Endif                               ;* Endif Carry flag set.
                                             ;* ECX holds selector:offset
         SHR  ECX, 16                        ;* Put selector into CX
         Pop  EDI                            ;* Restore offset CPCB entry
         Mov  Word Ptr ES:[DI].CPVAddr, CX   ;* Store selector to allocated
         Mov  Dword Ptr ES:[DI].XTLinear, EAX ;* Linear address of memory alloc
         push ds                             ;*
         LDS  SI, Dword Ptr StkTmpL          ;* Get caller's sel/off
         Mov  CX, Word Ptr [SI].XTLength     ;* Get xlation table length
         Mov  ES:[DI].CPUseCount, CX         ;* Save length for future reference
         pop  ds                             ;*
         Pop  ECX                            ;* PB732916  @IBM
        .286p                                ;* Use 80286 instructions
     .Endif                                  ;* Endif more memory is needed


     ;*    Ŀ
     ;*     LOAD THE TRANSLATION TABLE FROM CALLERS MEMORY TO KBD'S MEMORY 
     ;*    

      Pop CX                                 ;* Get Codepage value
      Pop SI                                 ;* Restore index value
     .If < si ne 0 >                         ;* If this is NOT the default xtable
                                             ;* Note:Default xtable is always index 0
        Or CmdFlags, CP_ENABLED              ;* Indicate optional code page available
     .Endif                                  ;*
      Mov  DI, SI                            ;* get code page index value.
      Imul DI, CPCBEntrySize                 ;* Determine offset into CPCB.
      Add  DI, CPCBOFFSET                    ;* Adjust for CPCB's offset
      LDS  SI, Dword Ptr StkTmpL             ;* Get caller's sel/off from stack
     .If <ES:[DI].CPValue eq 0>              ;* If codepage value NOT set yet
                                             ;* Note: This gets set once per boot up
         Mov ES:[DI].CPValue, CX             ;* Save Codepage value
     .Endif                                  ;* Endif
      Mov ES, Word Ptr ES:[DI].CPVaddr       ;* Get Selector of memory to copy to
      Xor DI,DI                              ;* Offset is assumed zero
      Mov cx, [SI].XTLength                  ;* Get xlation table length
      Cli                                    ;* Disable for a momment.
      Cld                                    ;* Set direction flag.
      Rep Movsb                              ;* Copy caller's table in.
      Mov DS, StkDS                          ;* Restore DD's DS.
      Sti                                    ;* Enable again.
      Ret

CopyXTable  endp


Public CopyCustom
CopyCustom Proc

;*****************************************************************************
;*
;* FUNCTION NAME : CopyCustom
;*
;* DESCRIPTION   : Copy the callers CUSTOM translation table into
;*                 virtual memory we allocate.
;*
;*                 Copy the callers translation table into the specified
;*                 data area.  Ensure enough memory has been allocated
;*                 for the length of the translation table, and if not,
;*                 allocate it.
;*
;*
;* INPUT         : STKTmpl has callers sel:offset of custom table
;*
;* EXIT-NORMAL   : Return to caller of routine.
;*
;* OUTPUT        : NONE.(Memory may be allocated for an additional translation
;*                       table).
;*
;*                 Alters ES,DI,DS,AX,CX,DX
;*
;* INTERNAL REFERENCES :
;*    ROUTINES         :
;*                          KbdGenErr (no return)
;*
;* EXTERNAL REFERENCES :
;*    ROUTINES         :    DevHlp (VMAlloc)
;*                          DevHlp (VMFree)
;*
;* IMPORTANT NOTE:  This code was added to support custom translation
;* tables.  In 1.X versions this was done much differently, the
;* sel:offset of caller was locked down and the callers memory was
;* accessed to do the translation.  In 2.0 this no longer worked
;* because memory management does not allow a process (the caller) to
;* end until its associated memory is ALL unlocked.  Hmm, this caused
;* us a problem as the process would "hang" until its memory was
;* unlocked.  So NOW we allocate memory of our own and copy the
;* callers data into our memory.;@IBM  Then we unlock the callers memory.
;* Routine added for PTR B733926 by TRM.@IBM
;*
;*****************************************************************************

 ;* @V2.0TRM01

      .386p                                         ;* Use 80386 instructions
       Mov  EDI, NO_PHYSADDR                        ;* Not used.
       Mov  EAX, VMDHA_FIXED+VMDHA_16M+VMDHA_SELMAP ;* Type of memory to alloc
       XOR  ECX, ECX                                ;* Clear out the whole register
       Push ds                                      ;*
       LDS  SI, Dword Ptr StkTmpL                   ;* Get caller's sel/off from stack
      ;* Mov  cx, [SI].XTLength                     ;* Get xlation table length
       Mov  cx, 04e3h                               ;* Get xlation table length
       Pop  ds                                      ;*
       Mov  DL, DevHlp_VMAlloc                      ;* Specify DevHlp fuction.
       Call [DeviceHelp]                            ;* Allocate memory.
      .If <c>                                       ;* Carry flag set means error.
          Ret                                       ;* Get out
      .Endif                                        ;* Endif Carry flag set.
                                                    ;* ECX holds selector:offset
       SHR  ECX, 16                                 ;* Put selector into CX
       Mov  DI,StkPSG                               ;* Get PSG pointer for SG that
       Mov  DH, ES_DI                               ;* Specify receiving registers.
       CALLFAR AccessKCB                            ;* ES:DI will point to the
                                                    ;* caller's KCB.
       Mov  Word Ptr ES:[DI].KCBCustSel, CX         ;* Store alloc selector value.
       Mov  Dword Ptr ES:[DI].KCBCustCPLH, EAX      ;* Lin addr of memory alloc.
      .286p                                         ;* Use 80286 instructions

      ;*   Ŀ
      ;*    LOAD THE TRANSLATION TABLE FROM CALLERS MEMORY TO KBD'S MEMORY 
      ;*   

      Mov   ES, CX                                  ;* Get Selector of memory to copy to
      Xor   DI,DI                                   ;* Offset is assumed zero
      LDS   SI, Dword Ptr StkTmpL                   ;* Get caller's sel/off from stack
     ;Mov   cx, [SI].XTLength                       ;* Get xlation table length
      Mov   cx, 04e3h                               ;* Get xlation table length
      Cli                                           ;* Disable for a momment.
      Cld                                           ;* Set direction flag.
      Rep   Movsb                                   ;* Copy caller's table in.
      Mov   DS, StkDS                               ;* Restore DD's DS.
      Sti                                           ;* Enable again.
      Ret

CopyCustom  endp


Public NLS_Packet
NLS_Packet Proc

;**********************************************************************
;*
;* FUNCTION NAME : NLS_Packet
;*
;* DESCRIPTION   : Send a NLS Notification Packet down the
;*                 monitor chain.
;*
;*                 Called by IOCTL's 50, 58, and 5C to send a NLS
;*                 notification packet down the monitor chain.  This
;*                 special packet is used for Multi-Layer NLS support.
;*                 The packet is sent down the monitor chain in order
;*                 to communicate changes in code page activity to BIDI
;*                 application monitors.
;*
;*                 This routine assumes that multilayer codepages
;*                 are supported.
;*
;*
;* INPUT        :  Reg AX = Originating IOCTL number
;*                 Reg CX = Codepage ID made active
;*                 Reg BX = Code Page index made active
;*
;* EXIT-NORMAL  :  Return to caller of routine.
;*
;* EXIT-ERROR   :  None.  All exits are through NORMAL above.
;*
;* OUTPUT       :  NONE (A Multi-Layer NLS Notification packet will be sent
;*                 down the monitor chain.  If the monitor doesn't
;*                 accept the packet, a parm will be set to later
;*                 beep the speaker).
;*
;*                 Alters AX,CX,DX,SI,DI
;*
;* INTERNAL REFERENCES:
;*    ROUTINES:
;*
;*
;* EXTERNAL REFERENCES:
;*    ROUTINES:  DevHlp MonWrite
;*
;*
;*************************************************************************

                                                 ;* DCR 408 Begin  @IBM
  Mov DI, StkPSG                                 ;* Ensure the PSG offset is in DI.
 .If <[DI].MonsInstalled gt 0>                   ;* If monitors registered.
                                                 ;*
     Mov SI,Offset MLNotifyPct                   ;* Point to Multi-Layer NLS notif. pct.
     Mov Word Ptr [SI].MOption.Ioctl, AX         ;* Put originating Ioctl # in packet.
     Mov Word Ptr [SI].MOption.CPID, CX          ;* Put codepage ID made active in pct.
     Mov Word Ptr [SI].MOption.CPIndex, BX       ;* Put codepage Index made active in pct.
     Mov Word Ptr [SI].MLDDFlags, MLNotification ;* Indicate to Monitors
                                                 ;* a Multi-Layer NLS notification pkt.
     Mov AX, [DI].MonHandle                      ;* Get Monitor Chain handle.
     Mov CX, KeyPacketLen                        ;* Set packet length
     Mov DX, 0100h + DevHlp_MonWrite             ;* NoWait for Monitor accept and func.
     Call DeviceHelp                             ;* Pass keypacket to monitors.
                                                 ;*
    .If < c >                                    ;* If error in passing packet
       KbdBeep 3,1000,13                         ;* Beep the speaker per ABIOS spec.
    .Endif                                       ;* Endif error in passing packet.
                                                 ;*
 .Endif                                          ;* Endif Monitors are registered.
  Ret                                            ;* Return
                                                 ;* DCR 408 End   @IBM
NLS_Packet endp

StratCode Ends
     End
