
;/*************************************************************************
;*
;* SOURCE FILE NAME =  KBD01.INC
;*
;* DESCRIPTIVE NAME =  Keyboard Device Driver Common Structures and Equates
;*
;* COPYRIGHT    COPYRIGHT IBM CORPORATION, 1991, 1992
;*              Copyright Microsoft Corporation, 1990
;*              LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
;*              REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
;*              RESTRICTED MATERIALS OF IBM
;*              IBM CONFIDENTIAL
;*
;* VERSION      V2.0
;*
;* DATE         11/17/90
;*
;* DESCRIPTION  Keyboard Device Driver Common Structures and Equates
;*
;* FUNCTIONS
;*
;*
;*
;*
;*
;* NOTES
;*
;*
;*
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*             @V2.0WCH03  63478  check kb controller inhibit bit before polling
;*             @V2.0XXX01  786970
;*             @V2.0XXX02  1193167
;*             @V2.0XXX03  DCR 75
;*             @V2.0XXX04  DCR 1173
;*             @V2.0XXX05  PTM 2744
;*             @V2.0XXX06  PTM 2189
;*             @VW.0XXX07  PTM 2382
;*             @V2.0XXX08  PTM 291
;*             @V2.0XXX09  AK00370
;**************************************************************************



.xlist
;include error.inc                      ; For request packet error codes.
.list

;**  Bit Definitions for the Controller Status Register

    OBF                 Equ 01h     ; @V2.0XXX01 Output Buffer Full bit.
    IBF                 Equ 02h     ; Input Buffer Full bit.
    Inhibited           Equ 80h     ; 0=Inhibited  1=Not Inhibited
    ReadInputPort       Equ 0C0h    ; @V2.0XXX01
    INH                 Equ 10h     ;@V2.0WCH03 keyboard controller inhibited bit

;** The following are the BIT definitions for HW_Status byte

    Disabled     Equ 1              ; Keyboard is currently disabled

      ;*
      ;* The following equate is the value to send to the 8254 for a kbd-
      ;* initiated beep tone.  The value given is the result of dividing the
      ;* magic timer oscillator frequency (@V2.0XXX02, see beep.asm in ibmdos)
      ;* by the desired frequency for a kbd beep (1000 Hz).
      ;*

  OSC_BEEP        equ 1193

  BASE_TIME       equ     200
  PEEK_BLOCK_TIME equ     100       ; Number of ms to block if 3xBox

; *****
; * MiscFlags3:
; * Use following equates to access the MiscFlags3 byte:
; *****
; * Define the bits...
; * MFlags3 Record mb7:1,mb6:1,mb5:1,mb4:1,mb3:1,mb2:1,mb1:1,mb0:1
; * SQon            = Mask mb0    ; @V2.0XXX03: indicates whether any SG is in SQ.
; * AltPacket       = Mask mb1    ; @V2.0XXX04: indicates that Alt-Numpad
;                                 ; accumulation is finished.
; * PauseLatch      = Mask mb2    ; @V2.OXXX05: indicates correct keystroke
;                                 ; sequence for a Ctrl-NumLock.
; * IOCTl1st        = Mask mb3    ; @V2.0XXX06: indicates first keyboard IOCTl for
;                                 ; SetCurrentSG received.
; * E0Packet        = Mask mb4    ; @VW.OXXX07  indicates that an E0 packet is
;                                 ; to be sent with the next packet.

   SENDTIMERNEEDED  equ  20h      ; We need the timer handler to flag an error.
   ;* SETSENDTIMER    = Mask mb6  ; @V2.0XXX08  indicates whether we need to reset
                                  ; the ticks for the timer handler.
   ;* SecAltNumPad  = Mask mb7    ; @V2.0XXX09 : indicates AltNumpad with R-Alt.

; *******
; * Following equates used for AT's  LED and SetTypamatic state machine
; *******

      NIU    Equ 2                ; Specify final state for state machine
      PARM   Equ 1                ; Specify data state for the state machine
      CMD    Equ 0                ; Specify command state for the state machine

;** @V2.OXXX08: END


      ;*
      ;* MiscFlags: Misc flags, mostly just used once by KBDDD.
      ;* Use following equates to access the MiscFlags byte:
      ;*

    ; MFlags Record m7:1,m6:1,m5:1,m4:1,m3:1,m2:1,m1:1,m0:1
    ; NoReadYet     = Mask m0     ; No read from keyboard yet.
    ; FirstInt16    = Mask m1     ; First Int 16 received.
    ; BeepSpeaker   = Mask m2     ; Beep speaker at right time.
  Beeping          equ 08h        ; Beep in progress.
    ; EnhancedKbd   = Mask m4     ; Enhanced Kbd is out there (must be Bit 4!).
    ; Passing2Paks  = Mask m5     ; Passing two Key Packets on 1 interrupt.
    ; InterruptExit = Mask m6     ; Interrupt routine must be exited.
  BEEPTIMERNEEDED  equ 80h        ; Beep timer handler usage flag.


SpeakerPort Equ 61h               ;Speaker controller port.

;**Bit masks for the parameter of KBD_SETREPEAT

REPEAT_RATEMASK         EQU     01fh    ;typematic rate
REPEAT_DELAYMASK        EQU     060h    ;typematic delay

;*********************************************************************
;*     IDC_Entry defines the structure for each IDC handle given     *
;*     by KBDDI$ in the Start_IDC routine.                           *
;*********************************************************************

IDC_Entry   struc
            IDC_Flags   dw     ?   ; IDC flags per handle.
            IDC_Offset  dw     ?   ; IDC offset
            IDC_Segment dw     ?   ; IDC segment
            IDC_ds      dw     ?   ; IDC ds
            IDC_Return  dw     ?   ; IDC return value
IDC_Entry   EndS

MAXIDCS     equ      5             ; Maximum IDC handles allowed

;*********************************************************************
;*     IDC_Flags equate definitions                                  *
;*********************************************************************

IDC_ACTIVE         equ   0001h     ; This IDC handle is now active.

;*********************************************************************
;*     IDStruc defines the structure for each Keyboard ID given      *
;*     by KBDDD$                                                     *
;*********************************************************************

IDstruc   struc
        idlen       dw     ?         ; IDC flags per handle.
        idbytes     db     8  Dup(0) ; IDC activity status.
IDstruc   EndS



