; SCCSID = src/dev/kbd/kbdbase.ssc/kbdddr.inc, kbd, c.basedd 98/01/16
;/*****************************************************************************
;*
;* SOURCE FILE NAME = KBDDDR.INC
;*
;* DESCRIPTIVE NAME = Keyboard Device Driver Common Structures and Equates
;*
;* COPYRIGHT    COPYRIGHT IBM CORPORATION, 1991, 1992
;*              Copyright Microsoft Corporation, 1990
;*              LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
;*              REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
;*              RESTRICTED MATERIALS OF IBM
;*              IBM CONFIDENTIAL
;*
;* VERSION      V2.0
;*
;* DATE         15/01/92
;*
;* DESCRIPTION  This file defines various equates,structures, and macros     *
;*              used by the Physical Keyboard Device Driver.
;*
;* FUNCTIONS    NONE
;*
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*             @V2.0XXX01  46723  Set HPInterrupt flag in IDHandlerHP to prevent
;*                                IPE when a Yield is issued at interupt time.
;*             @V2.0XXX02  B787292 Scan code sent to VKBD
;*             @V2.0XXX03  B786969
;*   UNKNOWN   J-DBCS001          DBCS enabling  (J-001)
;*   UNKNOWN   J-DBCS003          DBCS enabling  (ss001,ss0003,ss0012) (S.Sakamoto)
;*   08/04/93  J-DCR287           101 keyboard support                     (T.Itoh)
;*   03/23/94  JS06302     N/A    JS06302/JC20 MIFES/2 key hang with PF5    (M.Ida)
;*   11/07/95  JS08511   PJ20939  IMMON isn't loaded in boot if shutdown with
;*                                OS/2 FS opened. (DCAF support)      (H.Mori)
;*   11/20/95  JS08518     Side effect of JS07091                       ;H.Mori
;*
;*****************************************************************************/

.xlist
 include error.inc                      ; For request packet error codes.
.list

W_KBD_ESC   equ 1                                                       ;@IBM J-DBCS001(A)
INVALID_KEY equ 07Fh            ;Invalid Key value for DCP              ;@IBM J-DBCS001(A)
SetSftWithMsk   equ     0002h   ;Sub-func of Set Shift with mask        ;@IBM J-DBCS001(A)
InstDependDD    equ     0008h   ;Sub-func of Install Depend D/D         ;@IBM J-DBCS003(A) ms001
DeinstDependDD  equ     0009h   ;Sub-func of Deinstall Depend D/D       ;@IBM J-DBCS003(A) ms001

;**************************************************************************
;* IntFlags - Bit definitions for the Interrupt Time Flags.               *                                             *
;**************************************************************************

Claimed      equ 01h ; The int has been claimed by either the CR-RB or M-RB
Up_LEDs      equ 02h ; The LEDs need to be updated
Not_VScan    equ 04h ; @V2.0XXX02 This scan code should not be sent to the VKBD.
ScanBlockSet equ 08h ; @V2.0XXX03 set when ProcBloc for SG switch IOCTL 55
                     ; Pending BREAK scans must occur before SG switch
FReadDone    equ 10h ; B722320 First Read has been done                       ;@IBM
KcbBlockSet  equ 20h ; B724802 Set when ProcBloc for SetKCB IOCTL 57          ;@IBM
                     ; Pending Breaks for Shift keys must occur before KCB Switches

;***********************************************************
;*  Equates used for accessing hardware devices:           *
;***********************************************************
KbdDataPort Equ 60h     ;Keyboard data port.
KbdStatPort Equ 64h     ;Keyboard status port.
NotEmpty    Equ 02h     ;Keyboard controller input buffer state flag.
WriteKbdOB  Equ 0D2h    ;PTM 1726:8042 command to write a value back     ;@IBM

;DCR 1187 added high bit set to indicate interrupt time call, see below: ;@IBM
;***********************************************************
;*  Equates used for calling the device dependent routiones *
;***********************************************************
DD_CMD_Open        Equ 0000h   ;Open dependent keyboard
DD_CMD_Close       Equ 0001h   ;Close dependent keyboard
DD_Cmd_QInhibit    Equ 0004h   ;Query if the keyboard is inhibited
DD_Cmd_WriteKbdStr Equ 0005h   ;DCR 1494 Write KBD String                 ;@IBM
DD_Cmd_Disable     Equ 0007h   ;Disable the keyboard
DD_Cmd_DisableI    Equ 8007h   ;Disable the keyboard
DD_Cmd_Enable      Equ 0008h   ;Enable the keyboard
DD_Cmd_EnableI     Equ 8008h   ;Enable the keyboard
DD_Cmd_Typematic   Equ 000ah   ;Set the typematic rate and delay
DD_Cmd_TypematicI  Equ 800ah   ;Set the typematic rate and delay at int time
DD_Cmd_Indicators  Equ 000bh   ;Set the indicators
DD_Cmd_IndicatorsI Equ 800bh   ;Set the indicators at interupt time

; ------------------------------------------------------------------
;   keyboard/8042 commands/mouse
; ------------------------------------------------------------------
RESET_CMD       equ     0FFh            ; reset command
SRD_CMD         equ     0F3h            ; rate command
ID_CMD          equ     0F2h            ; read keyboard id command
SM_CMD          equ     0F0h            ; keyboard set mode command
RM_CMD          equ     00h             ; read current mode
LED_CMD         equ     0EDh            ; set led command
DISABLE_CMD     equ     0ADh            ; 8042 disable
ENABLE_CMD      equ     0AEh            ; 8042 enable
KBD_ENABLE      equ     0F4h            ;Keyboard Enable command code.

SysINFOseg   Equ 1     ;These are DevHlp indexes.
LocINFOseg   Equ 2     ;         "
VectorSDF    Equ 4     ;         "
;;VectorReboot Equ 5     ;         "

QUERY_MOUSE  Equ 6     ;AIM Added for determining Mouse movement during
                       ;AIM  Shift/Click operations.
OPEN_MOUSE   Equ 4     ;AIM Added for getting Mouse IDC Handle

;********************************************************************
;* Equates added for support of MVDM in Cruiser.                    *
;********************************************************************
Beep_Freq         Equ   1000    ;Beep frequency in hertz
Beep_Dur          Equ   13      ;Beep Duration in milli seconds
sgidFirstVDM      Equ   16      ;sgid of first VDM - changed by DCR 549. ;@IBM
MAX_VDM_SC        Equ   25      ;Max VDM type ahead buffered keystrokes
VKBDCMD_KbdEvent  Equ   1

NUM_FS_PSG        Equ   10h     ;Temp.limitation until full dynamic alloc.


;********************************************************************   ;@IBM
;* DCR 408 Equates added for support of BIDI in Cruiser.            *   ;@IBM
;********************************************************************   ;@IBM
Secondary         Equ   1       ;code page layer to use.
Index0            Equ   0       ;0th CPCB entry to work with
Index1            Equ   1       ;1st CPCB entry to work with
Index2            Equ   2       ;2nd CPCB entry to work with
Index3            Equ   3       ;3rd CPCB entry to work with

Index4            Equ   4       ;4rd CPCB entry to work with

LSBreak           Equ 0AAh      ;Scan code of L Shift Key Break
RSBreak           Equ 0B6h      ;Scan code of R Shift Key Break

EntryCount        Equ   5       ;Number of CPCB entries to allocate

;*********************************************************************
;ID commands and ID bytes for the Keyboard hardware.                 *
;*********************************************************************
IDCMD             Equ     0F2h  ;Command to read keyboard ID.
ID1               Equ     0ABh  ;Common first ID byte for Enhanced.
ID2               Equ     41h   ;Various second ID bytes
ID2A              Equ     54h   ;returned for
ID2_2             Equ     83h   ;ID without Xlation                     ;@IBM J-DBCS003(A)
ID2A_2            Equ     84h   ;ID without Xlation                     ;@IBM J-DBCS003(A)
ID2B              Equ     85h   ;Enhanced keyboards.
ID2A_J            Equ     92h   ;A-KBD 5576-001                         ;@IBM J-DBCS001(A)
ID2G_J            Equ     90h   ;G-KBD 5576-002                         ;@IBM J-DBCS001(A)
ID2P_J            Equ     91h   ;P-KBD 5576-003                         ;@IBM J-DBCS001(A)
ID2W_J            Equ     9Bh   ;RICHO Wilson KBD                       ;@IBM J-DBCS001(A)
UNKNOWNKBD        Equ     00h   ;zero out ID bytes on unknown kbd.
PCATKBD           Equ     0100h ;ID byte indication for an AT kbd.
ChgSCTable        Equ     0f0h  ;Command to change Scan Code Table      ;@IBM J-DBCS001(A)
ReadCMDByte       Equ     20h   ;Command to read 8042 command byte      ;@IBM J-DBCS001(A)
WriteCMDByte      Equ     60h   ;Command to Write 8042 command byte     ;@IBM J-DBCS001(A)
SC81H             Equ     81h   ;Scan code set 81h                      ;@IBM J-DBCS001(A)
SC82H             Equ     82h   ;Scan code set 82h                      ;@IBM J-DBCS001(A)

;*****************************************************************
;* IDFlags:                                                      *
;* Use following equates to access the IDFlags byte:             *
;*****************************************************************
IDFlagbits Record md7:1,md6:1,md5:1,md4:1,md3:1,md2:1,md1:1,md0:1
KbdAcked        = Mask md0    ;Set means keyboard has responed with an ACK.
Recd1st         = Mask md1    ;Set on when KBDDD has seen the first ID byte.
Recd2nd         = Mask md2    ;Set on when KBDDD has seen the 2nd ID byte.
Good1stByte     = Mask md3    ;Indicate that KBDDD recognized 1st ID byte.
SuperSport      = Mask md4    ;Indicates that a 122 key keyboard is attached.
ResentOnce      = Mask md5    ;Set after KBDDD has reissued the read ID cmd.
IDResend        = Mask md6    ;Set on when keyboard HW has issued a resend.
IDFailed        = Mask md7    ;Indicates that we have timed out waiting for
                              ;an ACK or ID byte from the keyboard HW.

;*****************************************************************      ;@IBM J-DBCS001(A)
;* SCFlags:                                                      *      ;@IBM J-DBCS001(A)
;* Use following equates to access the SCFlags byte:             *      ;@IBM J-DBCS001(A)
;*****************************************************************      ;@IBM J-DBCS001(A)
SCFlagbits Record sc7:1,sc6:1,sc5:1,sc4:1,sc3:1,sc2:1,sc1:1,sc0:1       ;@IBM J-DBCS001(A)
SCOK            = Mask sc0    ;Set means SC & Xlate mode are OK.        ;@IBM J-DBCS001(A)
SCFAILED        = Mask sc1    ;Indicates that we have timed out.        ;@IBM J-DBCS001(A)
SCRESEND        = Mask sc2    ;Set on when KBD HW has issued a resend.  ;@IBM J-DBCS001(A)
SCRESENTONCE    = Mask sc3    ;Set after KBDDD has reissued the cmd.    ;@IBM J-DBCS001(A)
NORESEND        = Mask sc4    ;Indicates that we can't restart.         ;@IBM J-DBCS001(A)
SCNO81          = Mask sc5    ;Indicates that this KBD doesn't have 81. ;@IBM J-DBCS001(A)
SC81SET         = Mask sc6    ;Indicates that KBD Scan Code set is 81.  ;@IBM J-DBCS001(A)
SCFORCE81       = Mask sc7    ;8042 not attached.  force to set 81      ;@IBM J-DBCS003(A)

;*****************************************************************
;*Equates used in XReadOrPeek IOCTL                              *
;*****************************************************************
NoWait Equ 01h                ;Don't wait for more chars if this bit is on.
XPeek  Equ 02h                ;This is an Extended Peek.
;*
;* PTM 5626:  Changed request packet equates to reference newer values  ;@IBM
;* in dos/devsym.inc.                                                   ;@IBM
;* NOTE: DOS/ERROR.INC and DOS/DEVSYM.INC must be defined before the
;* following to pick up the ERROR_I24_... stuff.
;*
CmdComplete  Equ         STDON + 0          ;Complete, no error status.
CmdError     Equ STERR + STDON + ERROR_I24_BAD_COMMAND
GenError     Equ STERR + STDON + ERROR_I24_GEN_FAILURE
CCIError     Equ STERR + STDON + ERROR_I24_CHAR_CALL_INTERRUPTED
ParmError    Equ STERR + STDON + ERROR_I24_INVALID_PARAMETER
MonError     Equ STERR + STDON + ERROR_I24_NO_MONITOR_SUPPORT


                                ; Following are for IOCTL 74h/75h:
XferAddr     Equ PktData+1      ; Location of transfer count in req. block.
XferCount    Equ PktData+5      ; Location of transfer address in req. block.

ParmListPtr  Equ PktData+2      ; Generic IOCTL parm list pointer.
DataBfrPtr   Equ PktData+6      ; Generic IOCTL data buffer pointer.

DevHlpAddr   Equ PktData+1      ; Location of DevHlp address in Init req blk.
EntryArgsPtr Equ PktData+5      ; Location of Entry arguments in Init
                                ; Request Packet.  Currently, this field
                                ; contains the selector and (0) offset to
                                ; the pre-allocated KIB/CPCB data area.

;*********************************************************************
;* Definition of a Character Data record.                            *
;*********************************************************************
CharData Struc    ;Format of character data record.
   XChar  db  ?   ;The translated character.
   Scan   db  ?   ;The original scan code (unless "extended" char).
   Status db  ?   ;Status bits (init to "char available", and
                  ; Shift Report off).
   DShift db  ?   ;DBCS Shift state at time of keystroke.
   Shift  dw  ?   ;Shift state at time of keystroke.
   Time   dd  ?   ;PTM 2233: Timestamp of keystroke in ms since IPL.    ;@IBM
CharData Ends
ChDaRecLen  Equ Size CharData  ;Length of a CharData record.

;*************************************************************************
;* Definition of Char. Data record portion of a Read or Peek Not. packet.*
;*************************************************************************
NotifyData Struc          ; Format of character data record.
   ScrGrp  dw  ?          ; Screen Group of Read Request.
   Buffer  dw  ?          ; Buffer Contents Indicator.
   ReqType db  ?          ; Read Request Call Type, Wait or NoWait.
   Reserv  db  5 Dup (0)  ; Reserved, fills out length of a CharDataRec.
NotifyData Ends
NotifyRecLen  Equ Size NotifyData  ;Length of a CharData record.

;%% DCR 408      ;@IBM
;****************************************************************************
;* Definition of Char. Data record portion of Multi-Layer Notification pckt.*
;****************************************************************************
MLayerData Struc          ; Format of character data record.
   Ioctl   dw  ?          ; Originating Ioctl #
   CPID    dw  ?          ; Code page ID made active.
   CPIndex dw  ?          ; Code page INDEX made active.
   ResByte db  4 Dup (0)  ; Reserved bytes,fills out length of a CharDataRec.
MLayerData Ends
MLNotRecLen   Equ Size MLayerData  ;Length of a CharData record.
;%% DCR 408        ;@IBM

;************************************************************************
;* Definition of the packet to send to the monitors, if any registered. *
;* Even when none registered, is used during and after translation.     *
;* See just below for bit equates for the flagwords in the packet.      *
;************************************************************************
KPacket     Struc                  ; This is the packet.
  KPacketLen  dw 0                 ; Length of the KeyPacket.  Also used for
                                   ; MonFlags after translation is complete.
  Key         db ChDaRecLen Dup(0) ; pace for a CharData record.
  DDFlags     dw 0                 ; Device driver flags for the packet.
                                   ; See DDFlags equates below.
KPacket     Ends
KeyPacketLen Equ Size KPacket      ;Length of KeyPacket Sturcture.

;****************************************************************************
;* Definition of the Read or Peek Notification packet to send to monitors,  *
;* if any registered. See below for bit equates for flagwords in the packet.*
;****************************************************************************
NPacket      Struc                 ; This is the packet.
  NMonFlags  dw 0                  ; Flagword for mon's to see with key.
  Option     db NotifyRecLen Dup(0); Space for a NotifyData record.
  NDDFlags   dw 0                  ; Device driver flags for the packet.
                                   ; See DDFlags equates below.
NPacket     Ends
NPacketLen Equ Size NPacket        ;Length of this packet.

SQDRcount   Equ 60                 ; Count of SQDRs in the keyboard buffer.

;%% DCR 408 Begin                  ;@IBM
;****************************************************************************
;* Definition of the Multi-Layer Notification packet to send to monitors,   *
;* if any registered. See below for bit equates for flagwords in the packet.*
;****************************************************************************
MLPacket     Struc                 ; This is the packet.
  MLMonFlags  dw 0                 ; Flagword for mon's to see with key.
  MOption     db MLNotRecLen Dup(0); Space for a MLayerData record.
  MLDDFlags   dw 0                 ; Device driver flags for the packet.
MLPacket     Ends                  ; End of the packet.
MLPacketLen Equ Size MLPacket      ; Length of this packet.
;%% DCR 408 End                    ;@IBM

;DCR 1195                          ;@IBM
;*********************************************************************
;* Definition of a HKTable record.                           *
;*********************************************************************
HKTable Struc                      ;Format of character data record.
   Shft   dw  ?                    ;The shift state
   HKB    db  ?                    ;The scan code of the Hot Key break
HKTable Ends
HKTableSiz  Equ Size HKTable       ;Length of a HKTable record.

;*********************************************************************
;* Definition of a IDstruc record.                           *
;*********************************************************************
IDstruc Struc                      ;Format of character data record.
      dw  ?                        ;ID length
      db  8  Dup(0)                ;buffer for ID bytes
IDstruc Ends

;**************************************************************************
;* Following equates apply to the low byte of the MonFlags word in        *
;* a Key Packet:                                                          *
;**************************************************************************
OpenPacket   Equ  01h    ;Packet is an open request (we don't use this).
ClosePacket  Equ  02h    ;Packet is a close request (we don't use this).
FlushPacket  Equ  04h    ;Packet is a flush request.
;;NOTE: following must match bit being defined by Mike Peters!!!
NotInserted  Equ  80h    ;Key wasn't inserted by a monitor.

;**************************************************************************
;* Following equates apply to the DDFlags word in a Key Packet:           *
;**************************************************************************
NotSQPacket    Equ  0400h  ; Don't put this packet in SQ buffer
AccentedKey    Equ  0200h  ; Key was translated using previous accent.
MultiMake      Equ  0100h  ; Key was repeated make of a toggle key.
SecondaryKey   Equ  0080h  ; Previous scan code was the E0 prefix code.
KeyBreak       Equ  0040h  ; This is the break of the key.
KeyTypeMask    Equ  003Fh  ; Isolates the Key Type field of DDFlags.
UndefKey       Equ  003Fh  ; Key packet is undefined
CPChg          Equ  0033h  ; This packet is code page change            ;@IBM J-DBCS001(A)
FocusChg       Equ  0032h  ; This packet is logical keyboard change     ;@IBM J-DBCS001(A)
StatusChg      Equ  0030h  ; This packet is shift status change notify  ;@IBM J-DBCS001(A)
SysReqKey      Equ  0017h  ; This key packet is the SysReq key (4990)
PrintFlushKey  Equ  0016h  ; This packet is Ct-Alt-PrtScr
PSPrintEchoKey Equ  0015h  ; This packet is Ctl-P
PrintEchoKey   Equ  0014h  ; This packet is Ctl-PrtScr
PrtScrKey      Equ  0013h  ; This packet is PrtScr
PSBreakKey     Equ  0012h  ; This packet is Ctl-C
BreakKey       Equ  0011h  ; This packet is Ctl-Break
AccentKey      Equ  0010h  ; This packet is an accent key
XRorPNot       Equ  000Dh  ; This packet is a Read or Peek Notification Pct.
MLNotification Equ  000Eh  ; packet is a Multi-Layer NLS packet
HotKeyPacket   Equ  000Ch  ; This packet is the hot key.
BadKeyCombo    Equ  000Bh  ; Accent/char combo undefined, beep only.
WakeUpKey      Equ  000Ah  ; This packet is one following PAUSEKEY
PSPauseKey     Equ  0009h  ; This packet is Ctl-S
PauseKey       Equ  0008h  ; This packet is Ctl-Numlock or PAUSE
ShiftMask      Equ  0007h  ; Key is a shift Key
DumpKey        Equ  0006h  ; This packet is Ctl-Numlock-NumLock
RebootKey      Equ  0005h  ; This packet is Ctl-Alt-Del
ResendCode     Equ  0004h  ; This packet is resend code from controller
OverRunCode    Equ  0003h  ; This packet is overrun code from controller
SecPrefixCode  Equ  0002h  ; This packet is E0/E1 scan code
AckCode        Equ  0001h  ; This packet is ack code from keyboard


;**************************************************************************
;* SFlags - Equates to use when accessing the ShiftFlags word in a Char-  *
;* Data rec. These equates are used when accessing Key Packets, etc.      *
;**************************************************************************
SysRqFlag  = 8000h  ;SysRq key down.
CapsFlag   = 4000h  ;Capslock key down.
NumFlag    = 2000h  ;Numlock key down.
ScrollFlag = 1000h  ;Scroll lock key down.
RAltFlag   = 0800h  ;Right Alt key down.
RCtlFlag   = 0400h  ;Right Ctrl key down.
LAltFlag   = 0200h  ;Left Alt key down.
LCtlFlag   = 0100h  ;Left Ctrl key down.

;Following can be used when accessing low-byte only, also.

InsTogl    = 0080h  ;Insert key toggled on.
CapsTogl   = 0040h  ;Capslock key toggled on.
NumTogl    = 0020h  ;Numlock key toggled on.
ScrollTogl = 0010h  ;Scroll lock key toggled on.
AltFlag    = 0008h  ;An Alt key is down.
CtlFlag    = 0004h  ;A Ctrl key is down.
LShiftFlag = 0002h  ;Left shift key down.
RShiftFlag = 0001h  ;Right shift key down.

;***********************************************************************;@IBM J-DBCS001(A)
;* DBCS Shift Definition                                               *;@IBM J-DBCS001(A)
;***********************************************************************;@IBM J-DBCS001(A)
;------ Japan ------------;                                             ;@IBM J-DBCS001(A)
Zenkaku       = 0001h     ;zenkaku mode                                 ;@IBM J-DBCS001(A)
Katakana      = 0002h     ;katakana mode                                ;@IBM J-DBCS001(A)
hiragana      = 0004h     ;hiragana mode                                ;@IBM J-DBCS001(A)
S_disable     = 0008h     ;shift disable                                ;@IBM J-DBCS001(A)
S_period      = 0010h     ;shift period                                 ;@IBM J-DBCS001(A)
Kan_shift     = 0020h     ;conversion is at shift status line           ;@IBM J-DBCS001(A)
romaji_mode   = 0040h     ;romaji mode                                  ;@IBM J-DBCS001(A)
kanji_mode    = 0080h     ;kana-kanji conversion mode                   ;@IBM J-DBCS001(A)
                                                                        ;@IBM J-DBCS001(A)
;------ Taiwan -----------;                                             ;@IBM J-DBCS001(A)
Fullsize      = 0001h     ;fullsize mode                                ;@IBM J-DBCS001(A)
Phonetic_mode = 0002h     ;phonetic mode                                ;@IBM J-DBCS001(A)
tsangjye      = 0004h     ;tsangjye mode                                ;@IBM J-DBCS001(A)
                                                                        ;@IBM J-DBCS001(A)
;------ Korea ------------;                                             ;@IBM J-DBCS001(A)
Jeonja        = 0001h     ;Jeonja mode                                  ;@IBM J-DBCS001(A)
Jamo_mode     = 0002h     ;Jamo mode                                    ;@IBM J-DBCS001(A)
hangeul       = 0004h     ;hangeul input mode                           ;@IBM J-DBCS001(A)
hanja_csr     = 0040h     ;hangeul-hanja conversion mode(Cursor)        ;@IBM J-DBCS001(A)
hanja_25      = 0080h     ;hangeul-hanja conversion mode(25 line)       ;@IBM J-DBCS001(A)
                                                                        ;@IBM J-DBCS001(A)
                                                                        ;@IBM J-DBCS001(A)
;***********************************************************************;@IBM J-DBCS001(A)
;* DBCS Status Definition                                              *;@IBM J-DBCS001(A)
;***********************************************************************;@IBM J-DBCS001(A)
Interim       = 80h       ; interim console flag                        ;@IBM J-DBCS001(A)
final         = 40h       ; interim / final                             ;@IBM J-DBCS001(A)
input_disable = 20h       ; system input method enable / disable        ;@IBM J-DBCS001(A)
shift_report  = 01h       ; shift report                                ;@IBM J-DBCS001(A)
                                                                        ;@IBM J-DBCS001(A)
                                                                        ;@IBM J-DBCS001(A)
;***********************************************************************;@IBM J-DBCS001(A)
;* DBCS Code Page Value                                                *;@IBM J-DBCS001(A)
;***********************************************************************;@IBM J-DBCS001(A)
CP_JAPAN    = 932                                                       ;@IBM J-DBCS001(A)
CP_JAPAN_2  = 942                                                       ;@IBM J-DBCS001(A)
CP_TAIWAN   = 938                                                       ;@IBM J-DBCS001(A)
CP_TAIWAN_2 = 948                                                       ;@IBM J-DBCS001(A)
CP_KOREA    = 949                                                       ;[@IBM K-JI001]
CP_KOREA_2  = 1361                                                      ;[@IBM K-JI001]


;@@ PTM 3377:  Following equate used for checking reserved bits for Set  ;@IBM
;@@ SM Hot Key IOCTL (56h):                                              ;@IBM

HKResMask    Equ  InsTogl+CapsTogl+NumTogl+ScrollTogl+AltFlag+CtlFlag ;@@

;**********************************************************************
;* Following is the structure of the Flag variable data areas used    *
;* by KbdXlate, for both interrupt, strategy, and VDM time translation*
;**********************************************************************

KBXTFlagData    Struc                ; The flag area structure.
  KBXTFlLen     dw 0                 ; Length of the flag area.
  XlateFlags    db 0                 ; Various translation component flags.
  XKeyFlags     db 0                 ; Flags for key toggle state info.
  XSpecFlags    db 0                 ; Flags for multi-keypacket events.
  XInputMode    db 0                 ; Copy of the desired input mode.
  XAltKeyPad    db 0                 ; Accumulator for Alt-nnn entry
  XDshiftDown   db 0                 ; Dshift down information          ;@IBM J-DBCS001(A)
  XHotKeyShift  dw 0                 ; Interrupt driven shift status
                                     ; Introduced this new byte for
  XAccent       db 0                 ; extended accents in range 7 - 255
KBXTFlagData    Ends                 ; End flag area stucture.
KBXTFlagsSIZE   Equ     Size KBXTFlagData ; Get the size of this area.

XCOMPLETE       Equ 0001h               ; Indicates strategy time
                                        ;  translation is complete.

;***************************************************************
;* Equates for using XlateFlags byte in translation data area: *
;***************************************************************

PrevAccent   Equ  07h     ; Bits where accent number saved til next keystroke.
SGPaused     Equ  08h     ; This session currently paused.
PauseSt      Equ  10h     ; Pause key sequence has started.
PseudoCtl    Equ  20h     ; Ctl key was emulated by Enhanced kbd
E1Prefix     Equ  40h     ; Enhanced keyboard E1 prefix just seen
Use3Index    Equ  80h     ; Use character 3 in translate table as index into
                          ; accent table

;***************************************************************
;* Equates for using XKeyFlags byte in translation data area:  *
;***************************************************************

DumpKeyOnce  Equ  01h     ; Dump key sequence has been hit once.
PSKeyDown    Equ  02h     ; Print Screen key is down right now.
SecPrefix    Equ  04h     ; G keyboard E0 prefix scan code just seen.
NormalAlt    Equ  08h     ; Normal Alt (not AltGraph) is down

ScrollTogl   Equ  10h     ; Scroll lock key toggled on.
NumTogl      Equ  20h     ; Numlock key toggled on.
CapsTogl     Equ  40h     ; Capslock key toggled on.
InsKeyDown   Equ  80h     ; Insert key is down right now.

TKeyDown    = ScrollTogl+NumTogl+CapsTogl   ;Latches for toggle keys.

;****************************************************************
;* Equates for using XSpecFlags byte in translation data area:  *
;****************************************************************

UseTwoAlt    Equ  01h     ; Both KeyPackets being used for an Alt-NumPad.
UseTwoE0     Equ  02h     ; Both KeyPackets being used for processing E0.
UseTwoAcc    Equ  04h     ; Both KeyPackets being used for invalid Accent.
UseOneAcc    Equ  08h     ; Only KeyPacket1 being used for invalid Accent
                          ; with NO beep AND NO accent displayed.
UseTwoPac    Equ  80h     ; Both KeyPackets contain valid translation
                          ; data.  KeyPacket2 should be used first.

;*************************************************************
;Equates for using XInputMode byte in translation data area: *
;*************************************************************

INPUTMODE    Equ  80h     ; Input mode flag. 1=Binary, 0=ASCII.
EXTENDEDCODE Equ  2       ; DCR 357: Define status bit for secondary keys. ;@IBM
SHIFTREPORT  Equ  1       ; Shift Report, input mode flag.
MODERESMASK  Equ  7Ch     ; PTM 667 - Reserved bit mask for input mode     ;@IBM


;********************************************************
; Equate for the 1.1, 1.2, 2.0 translation table length.*
;********************************************************

XTLen        Equ  1251     ;Derived below.

;      XlateTableHeader            =   40
;      127 KeyDefs @ 7 Bytes       =  889   @@
;      7 AccentEntries @ 46 Bytes  =  322
;                                     ---
;                                    1251 Bytes

;****************************************************************************
;* Equates for accessing the Data in XTHeader and Users IOCtl 7Bh data area.*
;****************************************************************************
CPOff       Equ 0       ; Offset to Code Page value in XT header.
CntyOff     Equ 16      ; Offset Country name in XT header.
CntyDOff    Equ 4       ; Data area offset for Country info (7Bh).
CntyLgth    Equ 2       ; Length of Country field.
SCntyOff    Equ 20      ; Offset SubCountry name in XT header.
SCntyDOff   Equ 7       ; Data area offset for SubCountry info (7Bh).
SCntyLgth   Equ 4       ; Length of SubCountry field.

;********************************************************************
;* Equates for accessing the XtableFlags1 translate table flagword: *
;********************************************************************
;;XTFlags1  Equ 2       ; Offset of XTableFlags1 in XTHead. ??? NEEDED?
ShftAlt     Equ 0001h   ; Use Shift+Alt instead of Ctl+Alt in CtlAltRemap.
AltGrafL    Equ 0002h   ; Use left Alt Key as an Alt-Graphics shift key.
AltGrafR    Equ 0004h   ; Use right Alt Key as an Alt-Graphics shift key.
ShiftLock   Equ 0008h   ; Keyboard uses ShiftLock rather than CapsLock.
DefTable    Equ 0010h   ; Default Table for the Language
ShiftToggle Equ 0020h   ; ShiftLock Toggle keyboard
AccentPass  Equ 0040h   ; Pass Accent key packet and beep
CapsShift   Equ 0080h   ; If CapsShift down, use character 5 from XTable
LayeredCP   Equ 0200h   ; DCR 408, Double layer codepage
LayeredTbl  Equ 0400h   ; DCR 408, Secondary layer translation table

ATKbd       Equ 0000h   ; XTKbdType it an AT kbd.
FERRARI_P   Equ 0AB54h  ; PTM 3128 Equate for 88/89 key keyboard.   ;@IBM
FERRARI_G   Equ 0AB41h  ; PTM 3128 Equate for 101/102 key keyboard. ;@IBM
JAGUAR      Equ 0AB86h  ; DCR 1085 Equate for Jaguar 122 key keyboard. ;@IBM
PCATKBD     Equ 0100h   ; ID byte indication for an AT kbd.

;***************************************************************
;* Masks for accessing the XlateOp fields in a keydef.         *
;***************************************************************
AccFlagsMask  Equ 0FE00h          ; Accent flags is now high 7 bits
ActionMask    Equ  01FFh          ; KeyType is now low 9 bits

;**************************************************************
;* Values for special keyboard scan codes                     *
;**************************************************************
BufferFull   Equ 0FFh   ; Keyboard overrun code sent by keyboard.
Resend       Equ 0FEh   ; Resend command request from keyboard.
Ack          Equ 0FAh   ; Command acknowledge from keyboard.
OtherKey     Equ 0E0h   ; Enhanced keyboard's secondary key prefix.
OtherKey2A   Equ 02Ah   ; Enhanced keyboard's third key prefix.
OtherKeyAA   Equ 0AAh   ; Enhanced keyboard's third key prefix.
OtherKey2    Equ 0E1h   ; Another secondary key prefix.
BreakBit     Equ 80h    ; Mask for break bit in a scan code.
Scan_R_Shift Equ 36h    ; Right shift key
Scan_L_Shift Equ 2ah    ; Left shift key
Scan_Ctrl    Equ 1dh    ; Ctrl key
Scan_Alt     Equ 38h    ; Alt Key
Scan_Scroll  Equ 46h    ; Scroll Lock Key
Scan_Num     Equ 45h    ; Num Lock Key
Scan_Caps    Equ 3ah    ; Caps Lock Key


;******************************************************************
;*                                                                *
;* KEYBOARD CONTROL BLOCK (KCB) DATA AREA STRUCTURE.              *
;*                                                                *
;* Memory for the DEFAULT KCBs (DKCB) is allocated at SYSINIT     *
;* time.  There is one DKCB for each session.                     *
;******************************************************************
;
;
KCBData Struc                   ; Structure of a Keyboard Control
                                ; Block Element.

   ;*
   ;* Following fields are for Base Subsystem KCB management. The KCB's
   ;* are part of a linked list on a per session basis.  For the
   ;* default KCB's, KCBNext and KCBPrev can be used as work areas.
   ;*

   KCBNext      dd      ?       ; Pointer to next KCB
   KCBPrev      dd      ?       ; Pointer to previous KCB

   ;* Following fields are identifiers of a particular KCB.

   KCBHandle    dw      ?       ; DOSOPEN handle.
   KCBPID       dw      ?       ; Process ID.

   ;* Following fields concern custom code page use.

   KCBFlags     dw      0       ;  .... .... .... ...1 = Use Custom
                                ;                        code page.
                                ;  .... .... .... ...0 = Use CPCB
                                ;  1111 1111 1111 111. = Reserved.
   KCBIxOffCP   dw      ?       ; CPCB index if flag above = 0
                                ; Custom code page offset if flag
                                ; above = 1.
   KCBCustSel    dw      ?      ; Custom code page selector.
   KCBCPPhysAddr dd      ?      ; Custom code page physical address
   KCBCustCPLH   dd      ?      ; Custom code page lock handle.

   ;*
   ;* Following fields are the various shift states and input mode used
   ;* when keystrokes occur.
   ;*

   KCBShift     dw      ?       ; See CharData.Shift above.
   KCBDBCSFl    db      ?       ; DBCS Flags.
   KCBDBCSSh    db      ?       ; DBCS Shift Flags.
   KCBInpMode   db      ?       ;  .... ...1 = Shift Report
                                ;  1... .... = Binary mode.
                                ;  0... .... = ASCII mode.
                                ;  .111 111. = Reserved.
   KCBRes1      db      ?       ; Reserved, for word alignment.

   ;* Following fields used for KIB tracking/manipulation

   KCBQueueCt   dw      0       ; Number of CharDataRecs queued for
                                ; this KCB.
   KCBInPtr     dw      -1      ; Pointer to newest element in KIB for
                                ; this KCB.
   KCBOutPtr    dw      -1      ; Pointer to oldest element in KIB
                                ; for this KCB.
   KCBDataBfrPtr dd    0        ; Holds caller's data buffer for
                                ; CharDataRec transfer.
   KCBBufferSem dd     0        ; PTM 5841: KIB serialization semaphore.  ;@IBM

   KCBLinearAddr  dd   0        ; PTR B712571 Holds KCB's linear address. ;@IBM
KCBData Ends                    ;
KCBSIZE Equ Size KCBData        ; Remember size of each element.

; *                                                               *
; *                                                               *
; *****  END OF KEYBOARD CONTROL BLOCK STRUCTURE DEFINITION  ******

; Equates for KCBFlags above.

CUSTOMCP     Equ 1         ; Mask used on KCBFlags field.

; *********************************************************************
;                                                                     *
; CODE PAGE CONTROL BLOCK (CPCB) DATA AREA STRUCTURE.                 *
;                                                                     *
;   CPCB memory is allocated at SYSINIT time.  There are N+1 CPCB     *
;   entries, where N is the number of codepages specified at system   *
;   configuration time.                                               *
; *********************************************************************

CPCBEntry Struc                 ; Structure of Code Page Control Block
   CPValue      dw      ?       ; Desired code page number, identical
                                ; to values specified in CONFIG.SYS
   CPUseCount   dw      ?       ; Use count, for segment (un)locking.
   CPVAddr      dd      ?       ; Physical address of translate table
   XTLinear     dd      ?       ; Keep Linear address for VMFree
CPCBEntry Ends                  ;
CPCBEntrySize equ Size CPCBEntry;
;
; *****  END OF CODE PAGE CONTROL BLOCK STRUCTURE DEFINITION  *****

; *******************************************************************
;                                                                   *
; PER-SESSION (PSG) DATA AREA STRUCTURE.                            *
;                                                                   *
; This area was formerly called the Per Screen Group Data Area in   *
; Version 1.0 of CP/DOS.                                            *
; *******************************************************************

PSG Struc                ;One of the Per-Session data areas.

 PSGNum         dw  ?    ;Session number of this session's data area.
 EventID        dd  0    ;If not 0, ProcRun using this when KIB grows.

 TOEventID      dd  0    ;If not 0, ProcRun uses this when a
                         ;thread is blocked due to a Wait on
                         ;Interrupt ABIOS return code.

 ;* Following fields hold KCB information.

 KCBFirst       dd  0    ; Physical address of first KCB in KCB chain.
 KCBLast        dd  0    ; Phys. address of last KCB in KCB chain.
 KCBAddress     dd  0    ; Phys. Address of a Keyboard Control Block,
                         ; either a valid physical address or zero,
                         ; which indicates use of the Default KCB
                         ; imbedded within the PSG.
 KCBLockHndl    dd  0    ; Lock Handle, when KCBAddress above is in
                         ; Keyboard Subsystem's (PL 3) memory.

 ;*
 ;* Following is an area allocated to contain the Default KCB area for
 ;* the session, which is used if there is no "user" KCB active for
 ;* this session.
 ;*

 DKCB           db KCBSIZE dup(?)       ; The Default KCB area.

 ;Following fields hold this session's current state.

 PSGFlags       dw  0    ; Misc flags needed in each session
                         ; (Expanded from byte to word (DCR8))
                         ; (see equates following this structure).
 ShiftFlags     dw  ?    ; same as shiftflags in CDR

 NotifyPID      dw  ?    ; Owner of Read or Peek IOCTL for this SG.
 NotifyFlags    dw  ?    ; flags needed for Read or Peek Notification
                         ; in each SG.

 DBCSFlags      db  40H  ; Interim char state, set by IOCTL.            ;@IBM J-DBCS001(A)
 DBCSShift      db  0    ; Shift flags maintained for DBCS translations.;@IBM J-DBCS001(A)
 PSGJFlags      db  0                                                   ;@IBM J-DBCS001(A)
 DshiftDown     db  0    ; Dshift down information                      ;@IBM J-DBCS001(A)

 ;* Following fields are used in Monitor management.

 MonHandle      dw  0    ; The handle for this session's monitor chain.
 MonsInstalled  db  0    ; How many monitors registered in this session.
 MonBlockID     db  0    ; Block ID for monitor if KIB full or
                         ; if monitor is running in the background
 MonEventID     dd  0    ; Event ID for blocking a high
                         ; priority event that was being yielded on
                         ; in a continuous loop.
 MonBlockID_F   db  0    ; Block ID for monitor if is flushing          ;@IBM JS08511(A)
 ;*
 ;* Following is the end-of-monitor-chain buffer. Its MonPktLen must be
 ;* initialized to the length of the buffer when the monitor chain is
 ;* created. The CharData record part of that buffer, along with the
 ;* two element indexes that follow it, are a KIB element sometimes.
 ;* Note that when this buffer is first filled by the monitor dispatcher,
 ;* the FwdPtr field is over-written with the DDFlags word of the monitor
 ;* packet (see definition way up above).

 MonChainEnd    dw KeyPacketLen+2    ;Where the packet length is put.
                dw 0                 ;Where the MonFlags word goes.
 ElementZero    db ChDaRecLen Dup(0) ;The CharData record from monitors.
 E0FwdPtr       dw -1                ;FwdPtr when used as element zero.
 E0RevPtr       dw -1                ;RevPtr when used as element zero.
 W_KbdCtlStatus dw 0                 ;KbdEsc status for SPECTACLE       ;@IBM J-DBCS001(A)
                                     ;                                *
PSG Ends                             ;                                *
SizePSG  Equ Size PSG                ;                                *

; *** END OF PER-SESSION DATA STRUCTURE DEFINITION ************

;**********************************************************************
;* Equates for PSGFlags - misc flags used by individual screen group. *
;* (Should be zeroed on session termination.)                         *
;* DCR8: Changed from byte to word to add single queue support.       *
;**********************************************************************
SQMODE     Equ 0200h    ; Indicates Single Queue mode processing.
SGInUse    Equ 0080h    ;This session has been initialized & not terminated.
SG3xBox    Equ 0040h    ;This session is the 3xBox.
ActiveSG   Equ 0020h    ;This session is the currently active one.
Flushing   Equ 0010h    ;Currently flushing monitors in this PSG.
NowPaused  Equ 0008h    ;This session currently paused.
SGInUseBG  Equ 0001h    ;This session has been initialized on the back ground. ;@IBM JS08518(A)


;****************************************************************************
;* Equates for NotifyFlags -  flags used by Read or Peek Notification Rtns. *
;****************************************************************************
Reserv0    Equ 0FFFEh   ; Mask to check if user has set any reserved fields.
NotPctSent Equ 0080h    ; Indicates that Monitor Chain did not accept packet.
                        ; monitor chain before returning from RorP IOCTL.
WaitOption Equ 0002h    ; Indicates not to wait for packet to go through the
SGEnabled  Equ 0001h    ; Indicates that RorP Not. is enabled for this PSG.


;***********************************************************************;@IBM J-DBCS001(A)
;* Equates for PSGJFlags - misc flags used by individual screen group. *;@IBM J-DBCS001(A)
;* (Should be zeroed on SG termination.)                               *;@IBM J-DBCS001(A)
;***********************************************************************;@IBM J-DBCS001(A)
Changing   Equ 80h  ;Shift Status update request now handling           ;@IBM J-DBCS001(A)


;***********************************************************************;@IBM J-DBCS001(A)
;* Equates for DshiftDown- DBCS shift down information                 *;@IBM J-DBCS001(A)
;***********************************************************************;@IBM J-DBCS001(A)
;------ Japan ------------------;                                       ;@IBM J-DBCS001(A)
down_alpha  EQU 80h             ;alpha key is down                      ;@IBM J-DBCS001(A)
down_kata   EQU 40h             ;hiragana key is down                   ;@IBM J-DBCS001(A)
down_hira   EQU 20h             ;katakana key is down                   ;@IBM J-DBCS001(A)
down_kanji  EQU 10h             ;kanji key is down                      ;@IBM J-DBCS001(A)
down_hankaku  EQU 08h           ;hankaku key is down                    ;@IBM J-DBCS001(A)
                                                                        ;@IBM J-DBCS001(A)
;------ Taiwan -----------------;                                       ;@IBM J-DBCS001(A)
down_phonetic   EQU 40h         ;phonetic key is down                   ;@IBM J-DBCS001(A)
down_tsangjye   EQU 20h         ;tsangjye key is down                   ;@IBM J-DBCS001(A)
down_halfsize   EQU 08h         ;halfsize key is down                   ;@IBM J-DBCS001(A)
                                                                        ;@IBM J-DBCS001(A)
;------ Korea ------------------;                                       ;@IBM J-DBCS001(A)
DOWN_JAMO       equ 40h         ;JAMO key down                          ;@IBM J-DBCS001(A)
down_hangeul    EQU 20h         ;hangeul key is down                    ;@IBM J-DBCS001(A)
down_hanja_25   EQU 10h         ;hanja_25 key is down                   ;@IBM J-DBCS001(A)
down_banja      EQU 08h         ;banja key is down                      ;@IBM J-DBCS001(A)
down_hanja_csr  EQU 04h         ;hanja_csr key is down                  ;@IBM J-DBCS001(A)


;***********************************************************************
;*    Following equate will set the KIB Free List to that length.      *
;***********************************************************************
;@IBM J-DBCS001(D) KIBElements Equ 120              ;Number of freelist elements in system.
;@IBM JS06302(D)   KIBElements Equ 240              ;Number of freelist elements in system.;@IBM J-DBCS001(A)
KIBElements Equ 120*8   ;Number of freelist elements in system.;@IBM JS06302(A)

;*********************************************************************
;* Structures  for Building the KIB Free List linked list.  (See     *
;* info near bottom of KBDDATA.ASM about linked list KIB structure). *
;*                                                                   *
;* Changed byte definitions in FlistHd to words for 1.1              *
;*********************************************************************
FListHd Struc    ;Struc for head of the freelist of elements for KIBs.
  TotalEls    dw KIBElements    ; How many KIB elements in the system.
  MaxThisTime dw KIBElements    ; Max available while session active.
  ElsInList   dw KIBElements    ; Elements currently in the list.
  FreeListIn  dw 1              ; Index of first element in the
                                ; freelist.
FListHd Ends


   ;* Following structure's db's changed to words for 1.1 of CP/DOS.

KIBElement Struc    ;Structure of an element of a KIB linked list.
  KIBCharData db ChDaRecLen Dup(0) ;Space for a CharData record.
  KIBFwdPtr   dw ?                 ; The linked list forward pointer.
  KIBRevPtr   dw ?                 ; The linked list reverse pointer.
KIBElement Ends
KIBElLen Equ Size KIBElement    ;
;Next Determine size of entire KIB area for SYSINIT routine.          *
KIBSIZE  Equ Size FlistHd + (KIBElements * KIBElLen)    ;             *
;                                                                     *
;***** END OF STRUCTURES FOR BUILDING KIB FREE LIST *******************

;********************************************************************
;* The following equates describe the offsets into the KIB/DKCB/CPCB*
;*  data area allocated by SYSINIT.  Starting at offset zero of the *
;*  segment, the data areas are arranged in the following order:    *
;*                                                                  *
;*    KIB                                                           *
;*    CPCB                                                          *
;*                                                                  *
;* NOTE:  The variable CBDataSize is set in KbdInit.  If new data   *
;*        areas are added to this Control Block data area, then     *
;*        CBDataSize may have to be calculated in a different way.  *
;********************************************************************
KIBOFFSET       Equ     0000h             ; At beginning of segment.
FLISTHEADER Equ KIBOFFSET                 ; The header starts the KIB.
FLISTOFFSET Equ KIBOFFSET + Size FlistHd  ; The free elements
                                          ; follow the header.
CPCBOFFSET      Equ     KIBSIZE           ; Beginning of CPCB is right
                                          ; after the KIB.

;*********************************************************************
;
;    NOTES ABOUT THE Keyboard Input Buffer (KIB) linked list queues
;
; 1) The KCBInPtr points to the NEWEST queue element added to the queue.
;    Any new elements added will be put between this pointer and that
;    last element that it is pointing to. If there are no queue elements
;    it holds -1. If it holds zero, it is pointing to the element within
;    the PSG (see note below about use of that element).
;
; 2) The KCBOutPtr points to the OLDEST queue element added to the
;    queue. That is the next element available to be read from the KIB.
;    If there are no queue elements, it holds -1.  If it holds zero, it
;    is pointing to the element within the PSG (see note below).
;
; 3) Traversing the linked list from Back to Front (i.e., "forward") is
;    to follow the InPtr to find the back element and follow the FwdPtr
;    indexes in the elements to proceed to the front.  The front element
;    holds -1 in its FwdPtr.
;
; 4) Traversing the linked list from Front to Back (i.e., "reverse") is
;    to follow the OutPtr to find the front element and follow the
;    RevPtr indexes in the elements to proceed to the back.  The back
;    of the queue holds -1 in its RevPtr.
;
; 5) Only the active SG can acquire new KIBElements from the FreeList.
;    A monitor passing CharData records to a background SG's KIB will
;    be blocked until that SG's KIB is empty. (See note below about
;    the monitor chain anchor element and how it's used.)
;
; 6) The active SG can queue a maximum of "n" elements, where n is
;    one-half the MAXIMUM number of elements available while that SG
;    is active. Example: if there are 80 elements available when a
;    SG is made active, the queue can grow to 40. If, during the time
;    this SG is active some background SGs have freed some elements
;    that they had queued, causing the maximum to grow to 100, then
;    this SG's queue can grow to 50. The reason for this limitation
;    is that the utilization of KIB elements by SGs is very unpredic-
;    table, and this scheme will help to be sure that SGs being entered
;    will have KIB elements available if background SGs are slow at
;    freeing their queued elements.
;
; 7) Every PSG has one element hard coded in. That element is part of
;    the buffer that is used for accepting CharData records back from
;    the keystroke monitor chains. When a SG is not active, and a
;    monitor passes a record into this buffer, this element becomes the
;    KIB tail and the monitor is blocked until the CharData record has
;    been read or a KIB flush request. If other elements had already
;    been queued prior to this write from the monitor, then all of
;    those records must be read, then this one, then the monitor is
;    unblocked. This element has index zero in the linked list chain.
;    In an active SG, any CharData record written into this element
;    is copied into an element from the FreeList, if available (see
;    previous note about availability). If not, the KIB is considered
;    to be full. When ANY element is freed by a read, the active SG
;    is checked to see if it is full (i.e., if its InPtr points to
;    zero). If so, the record in the active SG's zero element is
;    moved to the freed element.
;**********************************************************************

;************************************************************************
;* Structure/Equates used when processing session manager hot key data. *
;************************************************************************
HotKeyEntry     struc                   ; Definition of an entry in
                                        ;  the hot key table.
  HotKeyShift   dw      ?               ; Shift state for this hotkey.
  HotKeyMake    db      ?               ; Hot key's make scan code.
  HotKeyBreak   db      ?               ; Hot key's break scan code.
  HotKeyID      dw      ?               ; Hot key ID, sent to DevHlp.
HotKeyEntry     ends                    ; End hot key entry definition.
HKEntrySize     equ     Size HotKeyEntry; Size of each entry.
MaxHotKeyCt     equ     16              ; Current maximum number of
                                        ;  entries in the hot key table

;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
; This structure to obtain a scan code from a bit in the shift state word
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

SST  struc

  SST_Scan      db      ?         ; scan code of the shift key
  SST_Shift     dw      ?         ; shift bits associated with above scan
  SST_XKFlags   db      ?         ; needed for E0 preceeding shift keys
  SST_Sendit    db      0         ; if on scan needs to be sent

SST  ends
SST_Size     equ     Size SST     ; Size of the ShiftScanTable
SST_Entries  equ     6            ; Currently 7 SST entries
SST_Mask     equ     RShiftFlag+LShiftFlag+RCtlFlag+LCtlFlag+RAltFlag+LAltFlag+CtlFlag+AltFlag

;***************************************************************
;* Misc Equates used by various routines:                      *
;***************************************************************
DS_SI        Equ 0         ; For PhysToVirt DevHlp service
ES_DI        Equ 1         ; For PhysToVirt DevHlp service
INFINITETIME Equ -1        ; Used in blocking/semrequests.  (PTM 5841)

INPUTMODE    Equ 80h       ; Input mode flag. 1=Binary, 0=ASCII.
SHIFTREPORT  Equ 1         ; Shift Report, input mode flag.
MODERESMASK  Equ 7Ch       ; Reserved bit mask for input mode

LONGTERM     Equ 1         ; Duration for DevHlp Lock function.

                           ; Begin Function codes for Int 15h
SysIntKeyCode Equ 04fh     ; System Intercept - Key Code function
SysReqMCode  Equ 8500h     ; System Intercept - SysReq Make function
SysReqBCode  Equ 8501h     ; System Intercept - SysReq Break function
                           ; End

ShellSGNum   Equ 1         ; Session number of Shell.
Dos3xBoxSG   Equ 2         ; Screen Group assigned to Dos3xBox.
ProtInt      Equ 1         ; Flag in Machine Status Word set if
                           ;  processor is in Protect mode

; Following equates are for the Interim Character flag in the KCBs
; (i.e., KCBDBCSFl):

DefaultDBCS  Equ 40h       ;Default DBCS Status value for CharData recs.

  ;*
  ; PTM 3115/3377 BEGIN           ;@IBM
  ICResMask    Equ  01011111B     ; List of reserved bits.
  ;               ||||||||
  ;               |||||||+--------- Shift status returned at int. time.
  ;               |||++++---------- Reserved
  ;               ||+-------------- Pgm requested on-the-spot conv.
  ;               |+--------------- Final Character.
  ;               +---------------- Interim character flag on.
  ; PTM 3115/3377 END             ;@IBM

;*******************************************************************
;* KBDDD's record of what it thinks the LEDs are right now (note   *
;* these line up with the corresponding SFlags lower byte).        *
;* Use following equates to access the KbdLEDs byte:               *
;*******************************************************************
LEDFlags Record ig1:1,CapsLED:1,NumLED:1,ScrollLED:1,ig2:4
LEDMask = (Mask CapsLED)+(Mask NumLED)+(Mask ScrollLED)

;*******************************************************************
;* CmdFlags: Used when a command is sent to the keyboard.          *
;* Use following equates to access the CmdFlags byte:              *
;*******************************************************************
CFlags Record b7:1,b6:1,b5:1,b4:1,b3:1,b2:1,b1:1,b0:1
;;CmdInProgress = Mask b0   ; Sending a command right now.
;;AckRecvd      = Mask b1   ; Ack received on last byte sent.
;;ResendRecvd   = Mask b2   ; Resend received on last byte sent.
;;KbdError      = Mask b3   ; ABIOS error was detected.
;;MRBIU         = Mask b4   ; Misc. (ABIOS) Request Block In Use.
;;ISAR          = Mask b5   ; Interrupt handler Started ABIOS Request.
CP_ENABLED    = Mask b6   ; Indicates that optional code page 1 has
                          ; been loaded, enabling code page support.
;;WriteKbdStr   = Mask b7   ; write kbd string function
                          ; Only command(s) are sent but no corresponding parm


;*******************************************************************
;* OtherFlags: Misc flags (should be zeroed on a session switch).  *
;* Use following equates to access the OtherFlags byte:            *
;*******************************************************************
OFlags Record a7:1,a6:1,a5:1,a4:1,a3:1,a2:1,a1:1,a0:1
;Note: leave HotKeyDown & MHotKeyDown in bits 0 and 1!!!
HotKeyDown    = Mask a0    ; SM HotKey is down right now.
MHotKeyDown   = Mask a1    ; Monitor inserted SM HotKey down now.
InterruptTime = Mask a2    ; Currently processing an interrupt.
HotKeyFound   = Mask a3    ; Hot key was found in table
 ;*
 ;* Tortugas --- I will replace this flag below with a new flag that
 ;*              signals init time. The RecvdPMode bit is not used
 ;*              anymore.
 ;* RecvdPMode    = Mask a4    ; Interrupt time mode flag.
 ;*
InitTime      = Mask a4        ; Initialization time flag.
AlreadySwitch = Mask a5        ; Interrupt time mode flag.
IntInProgress = Mask a6        ; Int is in progress.
HotKeyBrkPend = Mask a7        ;%% PTR B786686      @IBM

;**************************************************************
;* MiscFlags: Misc flags, mostly just used once by KBDDD.     *
;* Use following equates to access the MiscFlags byte:        *
;**************************************************************
MFlags Record m7:1,m6:1,m5:1,m4:1,m3:1,m2:1,m1:1,m0:1
NoReadYet     = Mask m0   ; No read from keyboard yet.
BeepSpeaker   = Mask m1   ; Beep speaker at right time.
InitAttempted = Mask m2   ; Init cmd was attempted thru Strat Routine
EnhancedKbd   = Mask m3   ; Enhanced Kbd is out there (must be Bit 4!).
Passing2Paks  = Mask m4   ; Passing two Key Packets on 1 interrupt.
EZero         = Mask m5   ; E0 scan code is detected
QueryFlag     = Mask m6   ; PTR B786970
MLayerMode    = Mask m7   ; DCR 408, Multi layer code page support active

; *************************************************************
; * MiscFlags2: Misc flags, mostly just used once by KBDDD.   *
; * Use following equates to access the MiscFlags2 byte:      *
; *************************************************************
; Define the bits...
MFlags2 Record mt7:1,mt6:1,mt5:1,mt4:1,mt3:1,mt2:1,mt1:1,mt0:1
TIMER_NEEDED  = Mask mt0  ; Indicates whether KbdTimer should really
                          ;  do something.
INT_HANDLED   = Mask mt1  ; Indicates whether the interrupt has
                          ;  completed being processed.
TIME_OUT      = Mask mt2  ; Guards against spurious runs
KCB_FOUND     = Mask mt3  ; Used while searching linked list for KCBs.
KCB_FOUND2    = Mask mt4  ; Used while searching linked list for KCBs.
XDR_IN_USE    = Mask mt5  ; Used to control access of data areas by
                          ;  Translate Scan Code IOCTLs.

ReadOnce      = Mask m0   ; Tell us when to get out of
                          ;  the ABIOS mental state machine
SQon          = Mask m1   ; Tells us whether there is a
                          ; session with SQ turned on.
AltPacket     = Mask m2   ; Tells us whether an extra
                          ; packet will be sent. Alt-Num operation.
PauseLatch    = Mask m3   ; indicates correct keystroke
                          ; sequence for a Ctrl-NumLock.
IOCTl1st      = Mask m4   ; indicates first keyboard IOCTl for
                          ; SetCurrentSG received.
E0Packet      = Mask m5   ; indicates that an E0 packet is


; DCR 1187   @IBM

 ;* Bit definitions for word of flags "HPFlags" (Hot Plug Flags)

FFPrevScan    EQU       01h     ; Set when a FFh scan is seen
UpdatedSpeed  EQU       02h     ; Set when typamatic rate and delay is updated
Stage1Done    EQU       04h     ; Family 1 usage only because no ABIOS
HPReinit      EQU       08h     ; Hot Plug Reinit in progress, cleared when done
KbdSecure     EQU      010h     ; 8042 secure bit
HPHWError     EQU      020h     ; A hardware error occurred if this is set
HP_Up_LEDs    EQU      040h     ; Update the LED's when set
Up_Rate_Delay EQU      080h     ; Update the Typamatic rate and delay when set
Up_HWID       EQU      100h     ; update the Kbd HW ID when set
HPInterrupt   EQU      200h     ; Set when hot plug int in prograss, cleared when done
                                ; 46723 - WCH
;             EQU     0800h     ; Unused

; DCR 1187 Misc equates    @IBM
Up_Parms      EQU      Up_Rate_Delay + HP_Up_LEDs
AAScanCode    EQU      0AAh
FFScanCode    EQU      0FFh
KbdPW         EQU      010h     ; The kbd is secure, waiting for a password.
                                ; Bit 4 of the 8042 is "0"


;*********************************************************
;* Following equates used for ProcBlock                  *
;*********************************************************
INTERRUPTIBLE      Equ 0    ; Specify that sleep is interruptible
NONINTERRUPTIBLE   Equ 1    ; Specify that sleep is NOT interruptible
WAITTHRESHOLD      Equ 1000 ; # of microseconds for which blocking is
                            ; worthwhile

GetTime         Macro   gis,hireg,loreg ; Macro to get millisecond
                                        ;  timestamp from the Global infoseg
                Mov     ES, gis         ; Point to Global infoseg

                ;* Get low word of double-word time stamp

                Mov     loreg, Word Ptr ES:SIS_MsCount
                Mov     hireg, Word Ptr ES:SIS_MsCount+2

                Endm                    ; End GetTime macro.

UnPhysToVirt    Macro           ; Macro to do UnPhysToVirt DevHlp
                                ; service.  User must save necessary
                                ; registers.
  Push DX                                                               ;@IBM J-DBCS001(A)
  Mov DL, DevHlp_UnPhysToVirt   ; Set DevHlp service.
  Call DeviceHelp
  Pop DX                                                                ;@IBM J-DBCS001(A)
                Endm            ; End UnPhysToVirt macro.


KbdBeep Macro   Optparm,Freqparm,Durparm ;AIM Macro to Beep the speaker

    SaveReg <ax,bx,cx,dx>                ;AIM  save registers
                                         ;AIM
    mov     ax, Optparm                  ;AIM Beep_Timed parameter
    mov     bx, Freqparm                 ;AIM Frequency parameter
    mov     cx, Durparm                  ;AIM Duration parameter
    mov     dl,DevHlp_Beep               ;AIM DevHlp parameter
    call    DeviceHelp                   ;AIM Call it
                                         ;AIM
    RestoreReg <dx,cx,bx,ax>             ;AIM restore registers
                                         ;AIM
         Endm                            ;AIM End KbdBeep macro.
                                         ;AIM

StkFrameVars    Macro           ; Macro to set up the local variables
                                ; on the task time stack.  This is
                                ; used in both KBDSTRAT.ASM and
                                ; KBDDD.ASM (ThrowMeAway).
; *********************************************************************
; The invocations of the LocalVar macro below set up local storage on *
; the stack, which is used to contain all the selectors and offsets   *
; to all the necessary control blocks and/or data areas which will    *
; be referenced by the Interrupt Handler or Strategy routines.  This  *
; done to avoid excessive pushes and pops throughout the routines to  *
; access these many different segments of memory.                     *
;                                                                     *
; The LocalVars are set up in this include file, and the EnterProc    *
; and LeaveProc macros take care of allocating and freeing,           *
; respectively, the local stack space, and setting BP appropriately.  *
; For this reason, BP MUST NOT BE USED BY ROUTINE IN THE KEYBOARD     *
; DEVICE DRIVER.  Note that called (sub)routines can still access     *
; these stack variables, provided BP does NOT change.                 *
;                                                                     *
; The LocalVar, EnterProc, and LeaveProc macros can all be found in   *
; ./src/dos/dosmac.inc.                                               *
; *********************************************************************
?frame = 0                              ; Required by LocalVar macro.
LocalVar StkDS,WORD                     ; Data Segment Selector.
LocalVar StkPSG,WORD                    ; Per Session Data Area offset
LocalVar StkCBData,WORD                 ; Control Block Data Area.
LocalVar StkKCBS,WORD                   ; Caller's KCB seg/selector.
LocalVar StkKCBO,WORD                   ; Caller's KCB offset.
LocalVar StkRPS,WORD                    ; Request Packet Selector.
LocalVar StkRPO,WORD                    ; Request Packet Offset.
LocalVar StkPID,WORD                    ; Process ID.
LocalVar StkTmpH,WORD                   ; For miscellaneous work.
LocalVar StkTmpL,WORD                   ; For miscellaneous work.
LocalVar StkTmpReg,WORD                 ; More miscellaneous work.
                Endm                    ; End TaskStkVar macro.

VMDHA_16M       equ     1               ; Equates for VMAlloc
VMDHA_FIXED     equ     2
VMDHA_SWAP      equ     4
VMDHA_CONTIG    equ     8
VMDHA_PHYS      equ     16
VMDHA_PROCESS   equ     32
VMDHA_SGSCONT   equ     64
VMDHA_SELMAP    equ     128
NO_PHYSADDR     equ     -1

;****************************************************************************
;* Equates for LockupFlags -  flags used by Lockup support code DCR1131     *
;****************************************************************************
LockUp     Equ 01h             ; lock ALL hot key sequences and CTRL-ALT-DEL
Unlock     Equ 00h             ; DCR1131  @IBM
LockSpec   Equ 02h             ;lock specified hot key sequences/ CTRL-ALT-DEL

 ;*
 ;* PEN SUPPORT
 ;*  This packet is passed on READ_ENABLE. The packet and service routine is
 ;*  valid only during the READ_ENABLE call.
 ;*

SINFO   STRUC
sinfo_reserved          DD      ?   ;  reserved for now
sinfo_service_ds        DW      ?   ;  data segment to load for service routine
sinfo_service_rtn       DD      ?   ;  16:16 address for service routine
SINFO   ENDS

;****************************************************************************
; Equates for fkey - flags used by IBM U.S. English 101 support code DCR 287
;****************************************************************************
ignore_caps_brk     equ     00000001b       ; 1: Ignore next break of CaspLock ;@IBM J-DCR287(A)
ignore_key1_brk     equ     00000010b       ; 1: Ignore next break of Key #1   ;@IBM J-DCR287(A)
dos_fep             equ     00100000b       ; 1: Current VDM is DOS-FEP        ;@IBM J-DCR287(A)
inhibit_shift_conv  equ     01000000b       ; 1: Inhibit shift conv/noconv     ;@IBM J-DCR287(A)
inhibit_xlate       equ     10000000b       ; 1: Inhibit all of function of    ;@IBM J-DCR287(A)
                                            ;    scan code generator           ;@IBM J-DCR287(A)
