/*   
*   IBM Confidential
*
*   OCO Source Materials
*
*   (c) Copyright IBM Corp. 1994, 1998
*
*   The source code for this program is not published or otherwise divested of its
*   tradesecrets, irrespective of what has been deposited with the U.S. Copyright Office.
*/

 /**************************************************************************
 *
 * SOURCE FILE NAME =  KBDDD.H
 *
 * DESCRIPTIVE NAME =  Header file for ibmkbd
 *
 * VERSION = V0.1
 *
 * DATE  09/02/94
 *
 * DESCRIPTION : (see above)
 *
 * Purpose: (see above)
 *
 *
 *
 * FUNCTIONS  :
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 *
 *
 * EXTERNAL FUNCTIONS
 *
 * CHANGE ACTIVITY =
 *   DATE      FLAG        APAR   CHANGE DESCRIPTION
 *   --------  ----------  -----  ----------------------------------------
 *   09/02/94                     opened file
 *   06/20/98  LR_USB             Modified to support USB Keyboard Client.
 *
 ****************************************************************************/

/*-----------------------------*/
/*        Structures           */
/*-----------------------------*/

typedef struct {
   PVOID  Rmode;
   USHORT Rds;
   PVOID  Pmode;
   USHORT Pds;
} AttachDDStr;

typedef struct {
   USHORT DevFlags;
   USHORT KeyCount;
   USHORT MaxTypa;
   USHORT MinTypa;
   USHORT MaxDelay;
   USHORT MinDelay;
} CapStruc;

typedef struct {
   USHORT idlen;
   UCHAR idbytes[8];
} IDstruc;

typedef struct {
   USHORT wait_time;
   USHORT strlength;
   UCHAR strbytes[20];
} CmdStruc;

typedef struct {
   UCHAR key1;
   UCHAR key2;
} KeyStroke;

/*-----------------------------*/
/*     Defined Constants       */
/*-----------------------------*/
#define DEFSIZ  32                      /* size of queue for deferred scan */

#define   TURNOFF         0
#define   TURNON          1
#define   TRYAGAIN        2
#define   MAX_Tick       -1
#define   Wait_Time      10
#define   BTWait_Time    20             //SM148922: tick count fot block thread
#define   Fast_Type_Rate  5        /* Default keyboard type rate and delay.   */
#define   UnKnown         0
#define   AT              1
#define   ENH             2
#define   ENHPlus         3
#define   KBD84           0x84
#define   KBD88           0x54
#define   KBD101          0x41
#define   KBD101x         0x83
#define   KBD122          0x85
#define   KBD122x         0x86
#define   Enable_OFF      0
#define   INT_Enable      1
#define   HW_Enable       2
#define   TYPE_Enable     3
#define   LEDS_Enable     4
#define   GEN_Enable      5
#define   ScanCodeSet1    1
#define   ScanCodeSet2    2
#define   ScanCodeSet81   0x81      /* For DBCS without 8042     @IBM J-HM092794a */
#define   ScanCodeSet82   0x82      /* For DBCS with    8042     @IBM J-HM092794a */
#define   TRANSLATE_BIT   0x40

#ifndef WATCOM
#ifndef _usbcmmon_h_                //LR_USB
#define   CLI             _asm{cli}
#define   STI             _asm{sti}
#define   CLC             _asm{clc}
#endif                              //LR_USB
#define   INT3            _asm{int 3}
#define   PUSHF           _asm{pushf}
#define   POPF            _asm{popf}
#else
void _disable(void);
void _enable(void);
void _pushf(void);
void _popf(void);
void _clc(void);
void _int3(void);
USHORT DS(void);
USHORT CS(void);
#pragma aux _disable  "cli";
#pragma aux _enable   "sti";
#pragma aux _pushf    "pushf";
#pragma aux _popf     "popf";
#pragma aux _clc      "clc";
#pragma aux _int3     "int 3";
#pragma aux DS   "mov ax,ds";
#pragma aux CS   "mov ax,cs";
#define   CLI             _disable();
#define   STI             _enable();
#define   PUSHF           _pushf();
#define   POPF            _popf();
#define   CLC             _clc();
#define   INT3            _int3();
#endif

/*
 * Hang on tight... we have essentially three different types of 'interrupt
 * time' in this driver.  Enumerating:
 *   1. 'Asynchronous Keyboard Interrupt' - Triggered by a hardware IRQ
 *   2. 'Asynchronous Timer Callback'     - Triggered from timeout processing
 *   3. 'Synchronous Strategy Call'       - A strategy call requesting exclusion
 */
#define INTERRUPTTIME (AsyncInterruptTime|SyncInterruptTime)
#define INITTIME (InitTime)
#define ASYNC_KBDINT     0x0001
#define ASYNC_TIMER      0x0002
#define SYNC_STRAT       0x0001

/******* State Machine Valuse *********/

#define   S_NOCMDIPG      0
#define   S_RCVDE0SC      1
#define   S_HOTPLGPG      2
#define   S_SENTLEDC      3
#define   S_SENTLEDD      4
#define   S_SENTTYPC      5
#define   S_SENTTYPD      6
#define   S_GTKBDCMD      7
#define   S_SENTSCSC      8
#define   S_SENTSCSD      9
#define   S_SENTIDCM      10
#define   S_WAITIDB1      11
#define   S_WAITIDB2      12
#define   S_WAIT_ACK      13

/******* IDC Values *******************/

#define   Q_Open          0
#define   Q_Close         1
#define   Q_Cap           2
#define   Q_Type          3
#define   Q_LEDs          4
#define   Q_ID            5
#define   Q_Disabled      6
#define   Disable_K       7
#define   Enable_K        8
#define   Reset_Hw        9
#define   S_Type          10
#define   S_LED           11
#define   Send_Gen        14
#define   Q_Kbd_Rdy       15
#define   Flush_Pt        16
#define   Save_St         18
#define   Restore_St      19
#define   USB_Req         20    //LR_USB

#define   CMD_Open        0
#define   CMD_Close       1
#define   CMD_ScanCode    2
#define   CMD_Reinit      3

/* Prototypes from KBDSTRA.C */

void    Block_Thread(void);
void    Run_Thread(void);
USHORT  Query_Open(void);
USHORT  Query_Close(void);
USHORT  Query_Capabilites(USHORT CMD_Offset,USHORT CMD_Segment);
USHORT  Query_Typematic(void);
USHORT  Query_LEDs(void);
USHORT  Query_ID(USHORT CMD_Offset,USHORT CMD_Segment);
USHORT  Query_Disabled(void);
USHORT  Disable_Keyboard(void);
USHORT  Enable_Keyboard(void);
USHORT  CheckKBD(void);
USHORT  Reset_Hardware(void);
USHORT  Set_Typematic(BYTE New_Type_Rate);
USHORT  Set_LEDs(BYTE New_LED_State);
USHORT  Send_Generic(USHORT CMD_Offset, USHORT CMD_Segment);
USHORT  Query_Kbd_Rdy(void);
USHORT  Flush_Partial(void);
USHORT  Save_State(void);
USHORT  Restore_State(void);
USHORT  FAR _loadds IDC_Entry_Point(USHORT Req,USHORT Req_Off,USHORT Req_Seg);
void    FAR Strategy(void);

/* Prototypes from KBDSTATE.C */

void    IODelay(void);
void    KbdBeeper(void);
void    KeyERROR(void);
USHORT  KbdStatusWait(void);
void    SendPacket(BYTE First,BYTE Second);
void    GetID(void);
void    FAR KbdTimerHandler(void);
void    FAR KbdBTTimerHandler(void);    //SM148922
void    StartTimer(void);
void    StartBTTimer(void);             //SM148922
void    SendData(BYTE KbdData);
void    RESENDData(BYTE DataResend);
void    NoCmdIPg(BYTE keystroke);
void    RcvdE0SC(BYTE keystroke);
void    HotPlgPg(BYTE keystroke);
void    SentLEDC(BYTE kbdreturn);
void    SentLEDD(BYTE kbdreturn);
void    SentTYPC(BYTE kbdreturn);
void    SentTYPD(BYTE kbdreturn);
void    GTKbdCmd(BYTE kbdreturn);
void    SentSCSC(BYTE kbdreturn);
void    SentSCSD(BYTE kbdreturn);
void    SentIDCM(BYTE kbdreturn);
void    WaitIDB1(BYTE IDreturn);
void    WaitIDB2(BYTE IDreturn);
void    Wait_ACK(BYTE kbdreturn);
void    STATE_MACH_CTL(BYTE KeyInput);
void    FAR Kbd_Interrupt(void);
USHORT  Call_DI(int func,char *buffer);

/* Prototypes from KBDINIT.C */

void    Init(void);

/* Extra Prototypes needed */

USHORT APIENTRY DevHelp_Yield(void);

/*LR_USB    Prototypes from KBDUSB.C */

void USB_IDCfunc (USHORT RP_Offset, USHORT RP_Segment); //LR_USB
