
;**     RTC.INC - Real Time Clock include file
;
;       This file contains equates and macros that are useful in programming
;       Real Time Clock Plus CMOS RAM device (RTC).
;
;  The following equates control or are dependent on the clock interrupt
;  frequency.  These equates come from tables provided in Motorola Spec.
;  sheets for the MC146818 (Real-Time Clock Plus RAM - RTC)

DV32K   EQU     00100000B          ; 32.768KHz Base divider rate

IN002   EQU     00001111B          ;   2Hz int rate, period = 500ms
IN004   EQU     00001110B          ;   4Hz int rate, period = 250ms
IN008   EQU     00001101B          ;   8Hz int rate, period = 125ms
IN016   EQU     00001100B          ;  16Hz int rate, period =  62.5ms
IN032   EQU     00001011B          ;  32Hz int rate, period =  31.25ms
IN064   EQU     00001010B          ;  64Hz int rate, period =  15.625ms
IN128   EQU     00001001B          ; 128Hz int rate, period =   7.8125ms
IN256   EQU     00001000B          ; 256Hz int rate, period =   3.90625ms
IN512   EQU     00000111B          ; 512Hz int rate, period =   1.953125ms
IN1K    EQU     00000110B          ;  1KHz int rate, period = 976.562us
IN2K    EQU     00000101B          ;  2KHz int rate, period = 488.281us
IN4K    EQU     00000100B          ;  4KHz int rate, period = 244.141us
IN8K    EQU     00000011B          ;  8KHz int rate, period = 122.070us

ifdef profile
RABYTE  EQU     (DV32K OR IN512)        ; Alter this equ to change clock freq
else
RABYTE  EQU     (DV32K OR IN032)        ; Alter this equ to change clock freq
endif

cmos_port       equ     70h             ; command port for cmos
cmos_data       equ     71h             ; cmos data port
cmos_reg_d      equ     0dh             ; cmos data port
RTCCTL  EQU     070H                    ; RT/CMOS Register select port
RTCDTA  EQU     071H                    ; RT/CMOS Data I/O port

RBWRIT  EQU     11010010B               ; RT/CMOS Register 'B' Init byte
RBINIT  EQU     01010010B               ; RT/CMOS Register 'B' Init byte
                                        ; Values for byte shown are
                                        ; Bit 7 = Update inhibit
                                        ; Bit 6 = Periodic interrupt enable
                                        ; Bit 5 = Alarm interrupt disable
                                        ; Bit 4 = Update interrupt enable
                                        ; Bit 3 = Square wave disable
                                        ; Bit 2 = BCD data format
                                        ; Bit 1 = 24 hour time mode
                                        ; Bit 0 = Daylight Savings disable

PIMASK  EQU     01000000B               ; Reg C bit mask for periodic interrupt
UIMASK  EQU     00010000B               ; Reg C bit mask for update interrupt


; Input: al=address
; Output: al=data
cmos_read_clock macro
        OUT     CMOS_PORT,al            ; ADDRESS LOCATION AND DISABLE NMI
        JMP     $+2                     ; I/O DELAY
        IN      AL,CMOS_DATA            ; READ IN REQUESTED CMOS DATA
endm

; Input: ah=data
;        al=address
cmos_write_clock macro
        OUT     CMOS_PORT,al            ; ADDRESS LOCATION AND DISABLE NMI
        JMP     $+2                     ; I/O DELAY
        MOV     AL,ah                   ; write century
        OUT     CMOS_DATA,AL            ; PLACE IN REQUESTED CMOS LOCATION
        JMP     $+2                     ; I/O DELAY
endm

; set cmos RAM to read port with NMI enabled
cmos_reset macro
        MOV     AL,CMOS_REG_D           ; read only port/enable NMI
        OUT     CMOS_PORT,AL            ; SET DEFAULT TO READ ONLY REGISTER
        JMP     $+2                     ; I/O DELAY FOR WRANGLER 3 -- 06/04/87
        IN      AL,CMOS_DATA            ; OPEN STANDBY LATCH
        JMP     $+2                     ; I/O DELAY
endm
