;       SCCSID = @(#)ptt0.asm 6.1 91/02/18
   PAGE  ,132
   NAME  PTD
   TITLE Physical Timer Device Driver


;***  Physical Timer Device Driver (PTD)
;
;  SCCSID = @(#)ptt0.asm   1.00 90/10/13
;  Copyright (c) 1988 Microsoft Corporation
;
;  DESCRIPTION
;  This module contains the PTD's timer 0 ownership arbitration
;  services.
;
;  MODIFICATION HISTORY
;  10/13/90 MTS    Created.
;  4/1/96   Timur  Defect 150700: added HRT support


   .xlist
INCL_MI  EQU   1
   include mvdm.inc  ;mvdm definitions for dos macros
   include ptimer.inc   ;ptimer service public constants
   include timer.inc ;timer hardware constants
   include vtdptd.inc
INCL_ERRORS EQU   1
   include bseerr.inc   ;error numbers
   include clkseg.inc   ;segment definitions
   include clkdata.inc
   .list

   .386p

;***  Exports
;

ClkData SEGMENT

;***  Imports
;
   EXTRN fpfnVTProc:FWORD
   EXTRN fsPTFlags:WORD
   EXTRN IRQ0_Owner:BYTE   ; 150700 Timur

ClkData ENDS


ClkCode SEGMENT

T0FuncTable label word
   dw offset ClkCode:PTT0Open
   dw offset ClkCode:PTT0Close
T0MaxFunc   EQU   ($-T0FuncTable)/2-1


;***EP   PTTimer0(ulFunc) - Timer 0 Arbitration Services router
;
;   PTTimer0 provides the timer 0 arbitration services for
;   the kernel components.
;
;   ENTRY
;  ulFunc   = Timer 0 arbitration services: PTT0_OPEN, PTT0_CLOSE
;   EXIT-SUCCESS
;  (eax) = 0
;   EXIT-FAILURE
;  (eax) = error code - ERROR_INVALID_FUNCTION
;                     - ERROR_ACCESS_DENIED        150700
;
;   USES
;  All
;
;   CONTEXT
;  Task
;
;   PCODE
;  route to appropriate worker routines;

; 150700 change DS:NOTHING to DS:ClkData
   ASSUME   CS:ClkCode,DS:ClkData,ES:NOTHING,SS:NOTHING
Procedure PTTimer0,FAR

   ?abase   = 8 + 2     ;%%% ret. addr. is 8 bytes, bp 2 bytes
   ArgVar   ulFunc,ULONG      ; changed to support 16:32 type of
               ; procedure calling.
   EnterProc

   mov   si,WORD PTR [ulFunc] ;(si)=ulFunc

   cmp   si,T0MaxFunc      ;is it a valid function?
   ja pte         ;NO, goto error exit

   ;** 150700: Added Compare and the label NotOwner
   ;**  This gives error to calling function is Clock0X does not have
   ;*   IRQ0 because a PDD used the Clock0X IDC.
   mov   al, 1             ; since both of the called functions do an
                           ; xor eax,eax, we can use ax now
   cmp   IRQ0_Owner,al     ; does clock own IRQ0?
   jnz   NotOwner          ; no, then exit with error

   shl   si,1        ;adjust si as word index
   call  cs:T0FuncTable[si]   ;process requested function

   xor   eax,eax     ;(eax)=ERROR_NONE
ptx:  LeaveProc

   retfd ?aframe     ;%%%

pte:  mov   eax,ERROR_INVALID_FUNCTION
   jmp   short ptx

NotOwner:   mov   eax,ERROR_ACCESS_DENIED
            jmp   short ptx

EndProc PTTimer0


;***LP   PTT0Open() - Get timer 0 access
;
;   This routine is call to request access to the timer 0 hardware.
;   This is currently used by the profiler to program the profiling
;   tick rate.
;
;   ENTRY
;  None
;   EXIT
;  None
;
;   USES
;  All except ds,es
;
;   CONTEXT
;  Task
;
;   PCODE
;  if vtimer has the timer0 ownership
;      call vtimer to get it;

   ASSUME   CS:ClkCode,DS:NOTHING,ES:NOTHING,SS:NOTHING
Procedure PTT0Open,NEAR

   SaveReg <ds,es>
   mov   ax,CLkData
   mov   ds,ax
   ASSUME   DS:ClkData

   test  fsPTFlags,PTF_OWNT0  ;ptimer already has the ownership?
   jnz   ptox        ;YES, exit

   or fsPTFlags,PTF_OWNT0
   xor   eax,eax
   push  DWORD PTR VTDCMD_PREEMPTT0 ;(TOS+8)=VTDCMD_PREEMPTT0
   push  eax            ;(TOS+4)=0
   push  eax            ;(TOS)=0

   ;Should ASSERTNONZERO(fpfnVTProc)
   call  FWORD PTR [fpfnVTProc]

ptox: RestoreReg <es,ds>
   ASSUME   DS:NOTHING

   ret

EndProc PTT0Open


;***LP   PTT0Close() - Release timer 0 access
;
;   If ptimer has the timer0 ownership, call vtimer to release
;   the speaker.
;
;   ENTRY
;  None
;   EXIT
;  None
;
;   USES
;  All except ds,es
;
;   CONTEXT
;  Task
;
;   PCODE
;  if ptimer has the timer0 ownership and there is a vtimer
;      call vtimer to release ownership;

   ASSUME   CS:ClkCode,DS:NOTHING,ES:NOTHING,SS:NOTHING
Procedure PTT0Close,NEAR

   SaveReg <ds,es>
   mov   ax,CLkData
   mov   ds,ax
   ASSUME   DS:ClkData

   test  fsPTFlags,PTF_OWNT0  ;ptimer has the ownership?
   jz ptcx        ;NO, exit

   cmp   DWORD PTR fpfnVTProc,0  ;vtimer exist?
   je ptcx        ;NO, exit

   and   fsPTFlags,NOT PTF_OWNT0
   xor   eax,eax
   push  DWORD PTR VTDCMD_RELEASET0;(TOS+8)=VTDCMD_RELEASET0
   push  eax         ;(TOS+4)=0
   push  eax         ;(TOS)=0

   call  FWORD PTR [fpfnVTProc]

ptcx: RestoreReg <es,ds>

   ret

EndProc PTT0Close

ClkCode ENDS


   END
