;       SCCSID = @(#)atesp.inc	6.2 91/04/08
; ABIOS.INC contents

DEVICE_ID_DMA   EQU     0Fh

ABIOS_FUNC_ALLOCARB     EQU     0Bh
ABIOS_FUNC_DEALLOCARB   EQU     0Ch
ABIOS_FUNC_DISABLEARB   EQU     0Dh
ABIOS_FUNC_XFERSTATUS   EQU     0Eh
ABIOS_FUNC_ABORT        EQU     0Fh
ABIOS_FUNC_READMEM      EQU     10h
ABIOS_FUNC_WRITEMEM     EQU     11h
ABIOS_FUNC_RETURNPARMS  EQU     01h

GetParmsRB      struc
        len     dw      (?)             ; (00h) IN
        lid     dw      (?)             ; (02h) IN
        unit    dw      (?)             ; (04h) IN
        func    dw      (?)             ; (06h) IN
        res     dd      0               ; (08h) IN
        retval  dw      (?)             ; (0Ch) IN/OUT
        timeout dw      (?)             ; (0Eh) OUT
        irq     db      (?)             ; (10h) OUT
        getarb  db      (?)             ; (11h) OUT
        id      dw      (?)             ; (12h) OUT
        units   dw      (?)             ; (14h) OUT
        lidflag dw      (?)             ; (16h) OUT
        rblen   dw      (?)             ; (18h) OUT
        secndid db      (?)             ; (1Ah) IN/OUT
        rev     db      (?)             ; (1Bh) IN/OUT
        getres  dd      0               ; (1Ch) IN/OUT
GetParmsRB       ends

ArbLevelRB      struc
        arblen  dw      (?)             ; (00h) IN
        arblid  dw      (?)             ; (02h) IN
        arbunit dw      (?)             ; (04h) IN
        arbfunc dw      (?)             ; (06h) IN
        arbres1 dd      0               ; (08h) IN
        arbrval dw      0FFFFh          ; (0Ch) IN/OUT
        arbtime dw      (?)             ; (0Eh) OUT
        arbres2 dw      0               ; (10h)
        arbp1   dd      (?)             ; (12h) IN
        arbres3 dd      0               ; (16h)
        arbp2   dd      (?)             ; (1Ah) IN
        arbres4 db      0               ; (1Eh) IN
        arb     db      (?)             ; (1Fh) IN
ArbLevelRB      ends    ; 16 byte len

TransCountRB    struc
        tclen   dw      (?)             ; (00h) IN
        tclid   dw      (?)             ; (02h) IN
        tcunit  dw      (?)             ; (04h) IN
        tcfunc  dw      (?)             ; (06h) IN
        tcres1  dd      0               ; (08h) IN
        tcrval  dw      0FFFFh          ; (0Ch) IN/OUT
        tctime  dw      (?)             ; (0Eh) OUT
        tcaddr  dw      0               ; (10h) IN/OUT
        tcp1    dd      (?)             ; (12h) IN
        tcres3  dw      0               ; (16h) IN
        tcount  dd      (?)             ; (18h) OUT
        tcres4  db      3 DUP (0)       ; (1Ch) IN
        tcarb   db      (?)             ; (1Fh) IN
TransCountRB    ends    ; 16 byte len

ReadWriteRB     struc
        rwlen   dw      (?)             ; (00h) IN
        rwlid   dw      (?)             ; (02h) IN
        rwunit  dw      (?)             ; (04h) IN
        rwfunc  dw      (?)             ; (06h) IN
        rwres1  dd      0               ; (08h) IN
        rwrval  dw      0FFFFh          ; (0Ch) IN/OUT
        rwtime  dw      (?)             ; (0Eh) OUT
        memaddr dd      (?)             ; (10h)
        ioaddr  dd      (?)             ; (14h)
        count   dd      (?)             ; (18h)
        mode    db      (?)             ; (1Ch)
        rwtc1   db      (?)             ; (1Dh)
        rwtc2   db      (?)             ; (1Eh)
        rwarb   db      (?)             ; (1Fh)
ReadWriteRB     ends

DEVICE_ID_POS   EQU     10h

ABIOS_FUNC_READPOS      EQU     0Bh

ReadPOSRB         struc
        rplen   dw      (?)             ; (00h) IN
        rplid   dw      (?)             ; (02h) IN
        rpunit  dw      0               ; (04h) IN
        rpfunc  dw      (?)             ; (06h) IN
        rpres1  dd      0               ; (08h) IN
        rprval  dw      0FFFFh          ; (0Ch) IN/OUT
        rptime  dw      (?)             ; (0Eh) OUT
        rpslot  db      (?)             ; (10h) IN      *
        rpres2  db      (?)             ; (11h)
        rpid    dd      (?)             ; (12h) IN      *
        rpdata  dd      (?)             ; (16h) OUT     *
        rpfill  db      6 DUP (?)       ; (1A-1F)
ReadPOSRB     ends

; AT.INC contents

; DMA controller addresses and commands
AT_DMA_PAGE_CH1         EQU     83h
AT_DMA_PAGE_CH3         EQU     82h
AT_DMA_COUNT_CH1        EQU     03h
AT_DMA_COUNT_CH3        EQU     07h
AT_DMA_MODE        EQU     0Bh
AT_DMA_MODE_READ        EQU     08h
AT_DMA_MODE_WRITE       EQU     04h
AT_DMA_MASK        EQU     0Ah
AT_DMA_CLEAR        EQU     0Ch

IOWait  MACRO
        local   l1
        local   l2
        jmp     short   l1
l1      label   near
        jmp     short   l2
l2      label   near
        ENDM


;


MAX_ESPS                EQU     2
ESP_BUF_SIZE            EQU     1024

; Bit Masks for DIP switches on ESP-AT
ESP_DIP_PORT1   EQU     00000111b
ESP_DIP_PORT2   EQU     01110000b

; POS register definitions for ESP-PS/2
ESP_POS2_DMA            EQU     00011110b
ESP_POS2_IRQ            EQU     11000000b
ESP_POS2_IRQ_ENABLE     EQU     00100000b
ESP_POS3_PORT1_ENABLE   EQU     00000001b
ESP_POS3_STDADDR        EQU     00001110b
ESP_POS4_PORT2_ENABLE   EQU     00000001b
ESP_POS4_STDADDR        EQU     00001110b
ESP_POS5_ENH_ENABLE     EQU     00000001b
ESP_POS5_EADDR          EQU     00001110b
ESP_ID                  EQU     6F04h

; ESP register offsets
ESP_R_RDY       EQU     0
ESP_R_SID       EQU     1
ESP_R_RX1       EQU     2
ESP_R_TX1       EQU     2
ESP_R_RX2       EQU     3
ESP_R_TX2       EQU     3
ESP_R_STATUS1   EQU     4
ESP_R_CMD1      EQU     4
ESP_R_STATUS2   EQU     5
ESP_R_CMD2      EQU     5
ESP_R_DMA_RX    EQU     6
ESP_R_DMA_TX    EQU     6

; Ready Register bit masks
ESP_RDY_RX1     EQU     00000001b
ESP_RDY_TX1     EQU     00000010b
ESP_RDY_RX2     EQU     00000100b
ESP_RDY_TX2     EQU     00001000b
ESP_RDY_STATUS1 EQU     00010000b
ESP_RDY_CMD1    EQU     00100000b
ESP_RDY_STATUS2 EQU     01000000b
ESP_RDY_CMD2    EQU     10000000b

; Service ID bit masks
ESP_SID_RX1     EQU     00000001b
ESP_SID_TX1     EQU     00000010b
ESP_SID_ERROR1  EQU     00000100b
ESP_SID_DMAFIN  EQU     00001000b
ESP_SID_RX2     EQU     00010000b
ESP_SID_TX2     EQU     00100000b
ESP_SID_ERROR2  EQU     01000000b
ESP_SID_DMATO   EQU     10000000b
ESP_SID_RXBOTH  EQU     00010001b
ESP_SID_TXBOTH  EQU     00100010b
ESP_SID_PORT1   EQU     00000111b
ESP_SID_PORT2   EQU     01110000b

; Error Status bit masks
ESP_ERR1_RXTO    EQU    00000001b
ESP_ERR1_RXOF    EQU    00000010b
ESP_ERR1_PARITY  EQU    00000100b
ESP_ERR1_FRAME   EQU    00001000b
ESP_ERR1_BRK     EQU    00010000b
ESP_ERR1_MSR     EQU    00100000b
ESP_ERR1_FLOWTO  EQU    01000000b
ESP_ERR1_BRKFIN  EQU    10000000b
ESP_ERR2_OFFREMOTE      EQU     00000001b
ESP_ERR2_OFFLOCAL       EQU     00000010b
ESP_ERR2_ONLOCAL        EQU     00000100b

; Bit masks to build parameter for Set Mode command
ESP_MODE_S              EQU     00000000b
ESP_MODE_ENHANCED       EQU     00000001b
ESP_MODE_RX_DMA         EQU     00010000b
ESP_MODE_TX_DMA         EQU     00100000b
ESP_MODE_INIT           EQU     ESP_MODE_ENHANCED OR ESP_MODE_RX_DMA OR ESP_MODE_TX_DMA

; Bit masks to build paramters for Set IRQ command
ESP_IRQ_MASK            EQU     11000000b
ESP_DMA_MASK            EQU     00011110b
ESP_INT_ENABLE          EQU     00000001b
ESP_INT_DISABLE         EQU     00000000b

; ESP Command Codes
ESP_CMD_RESET           EQU     00h
ESP_CMD_GETTEST         EQU     01h
ESP_CMD_GDIPS           EQU     02h
ESP_CMD_DLOAD           EQU     03h
ESP_CMD_SETIRQ          EQU     04h
ESP_CMD_SETDMATIME      EQU     05h
ESP_CMD_SETSVCMASK      EQU     06h
ESP_CMD_SETERRMASK      EQU     07h
ESP_CMD_SETFCTYPE       EQU     08h
ESP_CMD_SETFCCHAR       EQU     09h
ESP_CMD_SETFCLEVEL      EQU     0Ah
ESP_CMD_SETTRIGGER      EQU     0Bh
ESP_CMD_SETRXTIME       EQU     0Ch
ESP_CMD_SETFCTIME       EQU     0Dh
ESP_CMD_WRITEUART       EQU     0Eh
ESP_CMD_READUART        EQU     0Fh
ESP_CMD_SETMODE         EQU     10h
ESP_CMD_CLEARDMAREQ     EQU     11h
ESP_CMD_GETERRS         EQU     12h
ESP_CMD_GETUARTS        EQU     13h
ESP_CMD_GETRXBYTES      EQU     14h
ESP_CMD_GETTXBYTES      EQU     15h
ESP_CMD_DMARX           EQU     16h
ESP_CMD_DMATX           EQU     17h
ESP_CMD_XOFFLOCAL       EQU     18h
ESP_CMD_XONLOCAL        EQU     19h
ESP_CMD_BREAK           EQU     1Ah
ESP_CMD_FLUSHRX         EQU     1Bh
ESP_CMD_FLUSHTX         EQU     1Ch
ESP_CMD_SETBAUD         EQU     1Dh

; Add these offsets commands to get port-specific command code
ESP_OFFSET_PORT1        EQU     00h
ESP_OFFSET_PORT2        EQU     80h


; Bit masks to build parameters for Set FCType command
ESP_FC1_RX_XO            EQU     00000001b
ESP_FC1_XPARENT_XO       EQU     00000010b
ESP_FC1_RX_RTS           EQU     00000100b
ESP_FC1_RX_DTR           EQU     00001000b
ESP_FC1_ON_RTS           EQU     00010000b
ESP_FC1_ON_DTR           EQU     00100000b
ESP_FC1_LOOP             EQU     01000000b
ESP_FC1_TX_XO            EQU     10000000b
ESP_FC2_TX_CTS           EQU     00010000b
ESP_FC2_TX_DSR           EQU     00100000b

; Bit masks to build parameters for SetSvcMask command
ESP_SVC_MASK_ALL        EQU     11111111b
ESP_SVC_MASK_NONE       EQU     00000000b
ESP_SVC_MASK_PORT1      EQU     00000111b
ESP_SVC_MASK_PORT2      EQU     01110000b
ESP_SVC_MASK_TX1        EQU     00000010b
ESP_SVC_MASK_TX2        EQU     00100000b

ESP_DEF_BAUD            EQU     1200
ESP_DEF_RX_TIME         EQU     4*8     ; 4 char times at 1200 baud
ESP_DEF_DMA_TIME        EQU     100

ESP_DEF_ERR1    EQU     ESP_ERR1_RXTO or ESP_ERR1_RXOF or ESP_ERR1_PARITY or ESP_ERR1_FRAME
ESP_DEF_ERR2    EQU     ESP_ERR2_OFFLOCAL or ESP_ERR2_ONLOCAL

ESP_DEF_FLOW_OFF        EQU     60
ESP_DEF_FC_LEVEL_OFF    EQU     768             ; (3/4 buffer size)
ESP_FC_LEVEL_OFF    EQU     768             ; (3/4 buffer size)
ESP_DEF_FC_LEVEL_ON     EQU     512             ; (1/2 buffer size)
ESP_FC_LEVEL_ON     EQU     512             ; (1/2 buffer size)
ESP_DEF_TRIGGER_RX      EQU     256             ; (1/4 buffer size)
ESP_DEF_TRIGGER_TX      EQU     768             ; (3/4 buffer size)
ESP_TRIGGER_TX_EMPTY    EQU     1023            ; room for 1023 bytes = buffer empty

DC1     EQU     11h
DC3     EQU     13h
DLE     EQU     7Fh
XMASK   EQU     21h
PMASK   EQU     0FFh

; The macros PWRITE, PREAD, and ISSUE may be used at interrupt time to
; communicate with the ESP.
PWRITE  MACRO   reg,value
        LOCAL   Loop

IF (reg EQ ESP_R_CMD1)
   bit = ESP_RDY_CMD1
ENDIF

IF (reg EQ ESP_R_CMD2)
   bit = ESP_RDY_CMD2
ENDIF

        mov     dx,[di].pi_address
Loop:   in      al,dx
        test    al,bit
        jz      Loop

        add     dx,reg
        mov     al,value
        out     dx,al

ENDM

PREAD   MACRO   reg
        LOCAL   Loop

IF (reg EQ ESP_R_STATUS1)
   bit = ESP_RDY_STATUS1
ENDIF

IF (reg EQ ESP_R_STATUS2)
   bit = ESP_RDY_STATUS2
ENDIF

; no waiting for RR or SID
IFE (reg EQ ESP_R_RDY) OR (reg EQ ESP_R_SID)
        mov     dx,[di].pi_address
Loop:   in      al,dx
        test    al,bit
        jz      Loop
ENDIF
        add     dx,reg
        in      al,dx
ENDM

ISSUE   MACRO   cmd,cmd2,cmd3,cmd4,cmd5

        PWRITE  ESP_R_CMD1,cmd

IFNB    <cmd2>
        PWRITE  ESP_R_CMD2,cmd2
ENDIF

IFNB    <cmd3>
        PWRITE  ESP_R_CMD2,cmd3
ENDIF

IFNB    <cmd4>
        PWRITE  ESP_R_CMD2,cmd4
ENDIF

IFNB    <cmd5>
        PWRITE  ESP_R_CMD2,cmd5
ENDIF

ENDM

GetAddressDIPs  MACRO
        TalkToESP     ESP_CMD_GDIPS,0,1
ENDM

SetIRQ  MACRO           irq
        TalkToESP     ESP_CMD_SETIRQ,1,0,irq
ENDM

SetDMATimeout   MACRO   to
        TalkToESP     ESP_CMD_SETDMATIME,1,0,to
ENDM

SetSvcMask      MACRO           mask
        TalkToESP     ESP_CMD_SETSVCMASK,1,0,mask
ENDM

SetErrorMask    MACRO           mask1,mask2
        TalkToESP     ESP_CMD_SETERRMASK,2,0,mask1,mask2
ENDM

SetFCType       MACRO           fc1,fc2
        TalkToESP     ESP_CMD_SETFCTYPE,2,0,fc1,fc2
ENDM

SetFCChar       MACRO           on,off,escape,exor,parity
        TalkToESP    ESP_CMD_SETFCCHAR,5,0,on,off,escape,exor,parity
ENDM

SetFCLevel      MACRO           msboff,lsboff,msbon,lsbon
        TalkToESP    ESP_CMD_SETFCLEVEL,4,0,msboff,lsboff,msbon,lsbon
ENDM

SetTriggers     MACRO           msbrx,lsbrx,msbtx,lsbtx
        TalkToESP    ESP_CMD_SETTRIGGER,4,0,msbrx,lsbrx,msbtx,lsbtx
ENDM

SetRxTimeout    MACRO           timeout
        TalkToESP     ESP_CMD_SETRXTIME,1,0,timeout
ENDM

SetFlowOffTimeout MACRO         timeout
        TalkToESP     ESP_CMD_SETFCTIME,1,0,timeout
ENDM

SetMode         MACRO           mode
        TalkToESP     ESP_CMD_SETMODE,1,0,mode
ENDM

WriteToUART     MACRO           reg,val
        TalkToESP     ESP_CMD_WRITEUART,2,0,reg,val
ENDM

ReadFromUART    MACRO           reg
        TalkToESP     ESP_CMD_READUART,1,1,reg
ENDM

GetErrorStatus  MACRO
        TalkToESP       ESP_CMD_GETERRS,0,2
ENDM

GetUARTStatus   MACRO
        TalkToESP     ESP_CMD_GETUARTS,0,2
ENDM

FlushRxFIFO     MACRO
        TalkToESP     ESP_CMD_FLUSHRX,0,0
ENDM

FlushTxFIFO     MACRO
        TalkToESP     ESP_CMD_FLUSHTX,0,0
ENDM

LocalXon        MACRO
        TalkToESP     ESP_CMD_XONLOCAL,0,0
ENDM

LocalXoff       MACRO
        TalkToESP     ESP_CMD_XOFFLOCAL,0,0
ENDM

GetRxBytes      MACRO
        TalkToESP     ESP_CMD_GETRXBYTES,0,2
ENDM

GetTxBytes      MACRO
        TalkToESP     ESP_CMD_GETTXBYTES,0,2
ENDM

ChangeBaud      MACRO           msbdiv,lsbdiv
        TalkToESP     ESP_CMD_SETBAUD,2,0,msbdiv,lsbdiv
ENDM

SendBreak       MACRO           duration
        TalkToESP     ESP_CMD_BREAK,1,0,duration
ENDM

TalkToESP     MACRO   cmd,nwrites,nreads,w1,w2,w3,w4,w5
                LOCAL   noadd

        SaveReg         <ax>
        mov     al,cmd
        cmp     al,ESP_CMD_SETSVCMASK
        jbe     noadd
        cmp     al,ESP_CMD_CLEARDMAREQ
        je      noadd
        ; All other commands have different codes for each ESP port
        add     al,[si].ci_cmd_offset
noadd:  mov     [si].ci_parm_area.cmd_code,al
        RestoreReg      <ax>
        mov     [si].ci_parm_area.num_writes,nwrites
        mov     [si].ci_parm_area.num_reads,nreads
        IFIDN   <nwrites>,<1>
                IFB   <w1>
                .ERR
                %OUT  ERROR - Missing 1st write parameter
                ELSE
                mov     [si].ci_parm_area.writes,w1
                ENDIF
        ENDIF

        IFIDN   <nwrites>,<2>
                  IFB   <w1>
                  .ERR
                  %OUT  ERROR - Missing  1st write parameter
                  ELSE
                  mov     [si].ci_parm_area.writes,w1
                  ENDIF

                  IFB   <w2>
                  .ERR
                  %OUT  ERROR - Missing 2nd write parameter
                  ELSE
                 mov     [si].ci_parm_area.writes+1,w2
                  ENDIF
                ENDIF

                IFIDN   <nwrites>,<3>
                  IFB   <w1>
                  .ERR
                  %OUT  ERROR - Missing 1st write parameter
                  ELSE
                  mov     [si].ci_parm_area.writes,w1
                  ENDIF

                  IFB   <w2>
                  .ERR
                  %OUT  ERROR - Missing 2nd write parameter
                  ELSE
                  mov     [si].ci_parm_area.writes+1,w2
                  ENDIF

                  IFB   <w3>
                  .ERR
                  %OUT  ERROR - Missing 3rd write parameter
                  ELSE
                  mov     [si].ci_parm_area.writes+2,w3
                  ENDIF
                ENDIF

               IFIDN   <nwrites>,<4>
                  IFB   <w1>
                  .ERR
                  %OUT  ERROR - Missing 1st write parameter
                  ELSE
                  mov     [si].ci_parm_area.writes,w1
                  ENDIF

                  IFB   <w2>
                  .ERR
                  %OUT  ERROR - Missing 2nd write parameter
                  ELSE
                  mov     [si].ci_parm_area.writes+1,w2
                  ENDIF

                  IFB   <w3>
                   .ERR
                  %OUT  ERROR - Missing 3rd write parameter
                  ELSE
                  mov     [si].ci_parm_area.writes+2,w3
                  ENDIF

                  IFB   <w4>
                 .ERR
                  %OUT  ERROR - Missing 4th write parameter
                  ELSE
                  mov     [si].ci_parm_area.writes+3,w4
                  ENDIF
                ENDIF

               IFIDN   <nwrites>,<5>
                  IFB   <w1>
                 .ERR
                  %OUT  ERROR - Missing 1st write parameter
                  ELSE
                  mov     [si].ci_parm_area.writes,w1
                  ENDIF

                  IFB   <w2>
                  .ERR
                  %OUT  ERROR - Missing 2nd write parameter
                  ELSE
                  mov     [si].ci_parm_area.writes+1,w2
                  ENDIF

                  IFB   <w3>
                  .ERR
                  %OUT  ERROR - Missing 3rd write parameter
                  ELSE
                  mov     [si].ci_parm_area.writes+2,w3
                  ENDIF

                  IFB   <w4>
                  .ERR
                  %OUT  ERROR - Missing 4th write parameter
                  ELSE
                  mov     [si].ci_parm_area.writes+3,w4
                  ENDIF

                  IFB   <w5>
                  .ERR
                  %OUT  ERROR - Missing 5th write parameter
                  ELSE
                  mov     [si].ci_parm_area.writes+4,w5
                  ENDIF

                ENDIF

                CALL    IssueESPCmd

                IFIDN   <nreads>,<1>
                mov     al,[si].ci_parm_area.reads
                ENDIF

                IFIDN   <nreads>,<2>
                mov     al,[si].ci_parm_area.reads
                mov     ah,[si].ci_parm_area.reads+1
                ENDIF
ENDM

