/******************************************************************************/
/*                                                                            */
/* COPYRIGHT:                                                                 */
/* ----------                                                                 */
/* Copyright (C) International Business Machines Corp., 1994.                 */
/* Copyright:(C) Apple Computer, Inc., 1994                                   */
/*                                                                            */  
/* DISCLAIMER OF WARRANTIES:                                                  */
/* -------------------------                                                  */
/* The following [enclosed] code is sample code created by IBM                */
/* Corporation.  This sample code is not part of any standard IBM product     */
/* and is provided to you solely for the purpose of assisting you in the      */
/* development of your applications.  The code is provided "AS IS",           */
/* without warranty of any kind.  IBM shall not be liable for any damages     */
/* arising out of your use of the sample code, even if they have been         */
/* advised of the possibility of such damages.                                */
/*                                                                            */
/******************************************************************************/
/*
   File:    CntnrPrt.h

   Contains:   definition for class ContainerPart

   Written by: Joshua Susser

   Change History (most recent first):

*/

#ifndef _CNTNRPRT_
#define _CNTNRPRT_

#if 1
   extern "C" {
      class ODMenuBar;
      void EXPENTRY AddMenuResourceLast( Environment *ev, HMODULE hmodDLL, long resid, ODMenuBar *menubar, ODMenuID menuid);
   }
#else   
   #ifndef _PLFMTYPE_
      #include "PlfmType.h"
   #endif
   
   #ifndef _IBP_
      #include "ibp.h"
   #endif
   
   // define constants for type names of part classes
   #ifndef _PARTTYPE_
      #include "PartType.h"
   #endif                   
   
   #ifndef __MENUS__
      #include <Menus.h>
   #endif
   
   #define APPLEINCL_QuickDraw
   #ifndef APPLEINCLUDED
      #include <Apple.h>
   #endif
   
   #ifndef __DRAWDEF__
      #include "DrawDef.h"
   #endif
                   
   #ifndef _CNTNRRES_
   #include "cntnrres.h"
   #endif
   
   //==============================================================================
   // Classes defined in this interface
   //==============================================================================
   
   class ContainerPart;
   class ContainerPartEmbeddedFramesIterator;
   
   //==============================================================================
   // Classes used by this interface
   //==============================================================================
   
   class OrderedCollection;
   class OrderedCollectionIterator;
   class XMPEmbeddedFramesIterator;
   class XMPFacet;
   class XMPFrame;
   class XMPMenuBar;
   class XMPFocusSet;
   class XMPSemanticInterface;
   class ContainerPartPropAccessor;
   class XMPDragItemIterator;
   class XMPWindow;
   class XMPSession;
   
      //--------------------------------------------------------------------------
      // Class Types
      //--------------------------------------------------------------------------
   
      struct Proxy {
         XMPRgnHandle region;
         XMPFrame* frame;
         XMPTransform* transform;
         // XMPBoolean isSelected;
   
         Proxy(XMPRgnHandle r, XMPFrame* f, XMPTransform* t)
            {region = r; frame = f; transform = t; /* isSelected = kXMPFalse; */ }
      };
   
   //==============================================================================
   // Types
   //==============================================================================
   
      typedef RGB RGBColor;
   
      class PartInfoRec
      {
      public:
         PartInfoRec() { fIsActive = kXMPFalse; fNeedsActivating = kXMPFalse; }
         virtual ~PartInfoRec() { }
         RGBColor bgColor;
         RgnHandle   bgClipRegion;
         XMPBoolean  fIsActive;  // Does this frame have its focus set?
         XMPBoolean  fNeedsActivating; // should this be activated when its window is activated?
      };
   
   //==============================================================================
   // ContainerPart
   //==============================================================================
   
   extern "C" {
      XMPPart* EXPENTRY CreatePart(void);
   }
   
   class ContainerPart : public ImplBasePart
   {
      //--------------------------------------------------------------------------
      // Class Friends
      //--------------------------------------------------------------------------
   
      friend class XMPDraft;
      friend class ContainerPartEmbeddedFramesIterator;
      friend class ContainerPartPropAccessor;
   
   public:
   
      // -Extension-
      XMPMethod XMPBoolean    HasExtension(XMPType extensionName);
      XMPMethod XMPExtension* GetExtension(XMPType extensionName);
   
      // -Drag&Drop-
      XMPMethod void FulfillPromise(XMPStorageUnitView *promiseSUView);
      XMPMethod void DropCompleted(XMPPart* destPart, XMPDropResult dropResult);
      XMPMethod MRESULT DragEnter(XMPDragItemIterator* dragInfo, XMPFacet* facet, XMPPoint where);  //dwf
      XMPMethod MRESULT DragWithin(XMPDragItemIterator* dragInfo, XMPFacet* facet, XMPPoint where);   //dwf
      XMPMethod void DragLeave(XMPFacet* facet, XMPPoint where);
      XMPMethod XMPDropResult Drop(XMPDragItemIterator* dropInfo, XMPFacet* facet, XMPPoint where);
   
      // -Embedding-
      XMPMethod XMPStorageUnit* GetContainingPartProperties(XMPFrame* displayFrame);
      XMPMethod XMPEmbeddedFramesIterator* CreateEmbeddedFramesIterator();
      XMPMethod XMPSLong CountEmbeddedFrames();
   
      // -Frame-
      XMPMethod void AddDisplayFrame(XMPFrame* frame);
      XMPMethod void AttachSourceFrame(XMPFrame* frame, XMPFrame* sourceFrame);
      XMPMethod void RemoveDisplayFrame(XMPFrame* frame);
      XMPMethod void CloseDisplayFrame(XMPFrame* frame);
      XMPMethod void FrameShapeChanged(XMPFrame* frame);
      XMPMethod void ViewTypeChanged(XMPFrame* frame);
      XMPMethod void PresentationChanged(XMPFrame* frame);
      XMPMethod void WritePartInfo(XMPPtr partInfo, XMPStorageUnitView* storageUnitView);
      XMPMethod XMPPtr ReadPartInfo(XMPFrame* frame, XMPStorageUnitView* storageUnitView);
      XMPMethod XMPID Open(XMPFrame* frame); //Override
      XMPMethod XMPFrame* CreateEmbeddedFrame(XMPFrame* containingFrame,
                                    XMPShape* frameShape,
                                    XMPTransform* externalTransform,
                                    XMPPart* embedPart,
                                    XMPTypeToken viewType,
                                    XMPTypeToken presentation,
                                    XMPID frameGroupID,
                                    XMPBoolean isOverlaid);
      XMPMethod void RemoveEmbeddedFrame(XMPFrame* embeddedFrame);
      XMPMethod XMPShape* RequestFrameShape(XMPFrame* embeddedFrame, XMPShape* frameShape);
      XMPMethod void UsedShapeChanged(XMPFrame* embeddedFrame);
   
      // -Facet-
      XMPMethod void FacetAdded(XMPFacet* facet);
      XMPMethod void FacetRemoved(XMPFacet* facet);
      XMPMethod void ClipShapeChanged(XMPFacet* facet);
      XMPMethod void ExternalTransformChanged(XMPFacet* facet);
   
      // -Imaging-
      XMPMethod void Draw(XMPFacet* facet, XMPShape* invalidShape);
   
      // -Memory Management-
      XMPMethod XMPSize Purge(XMPSize size);
   
      // -Part Activation-
      XMPMethod void CommitRelinquishFocus(XMPTypeToken focus,
                                   XMPFrame* ownerFrame,
                                   XMPFrame* proposedFrame);
      XMPMethod void FocusAcquired(XMPTypeToken focus, XMPFrame* ownerFrame);
      XMPMethod void FocusLost(XMPTypeToken focus, XMPFrame* ownerFrame);
   
      // -Storage-
      XMPMethod void Externalize();
      XMPMethod void CloneInto(XMPDraftKey key, XMPStorageUnit* storageUnit, XMPStorageUnit* initiatingFrameSU);
   
      // -UI Events-
      XMPMethod XMPBoolean HandleEvent(XMPEventData event, XMPFrame* frame, XMPFacet* facet);
      XMPMethod void AdjustMenus(XMPFrame* frame);
   
      // -Undo-
      XMPVMethod void UndoAction(XMPActionData actionState);
      XMPVMethod void RedoAction(XMPActionData actionState);
      XMPVMethod void DisposeActionState(XMPActionData actionState,
                                 XMPDoneState doneState);
   
         //PRIVATE BY CONVENTION -- needed by ContainerPart's object accessors
      XMPMethod XMPSemanticInterface* GetSemanticInterface(){return fSemtIntf;}
      XMPMethod void SetNewBounds( XMPFrame* frame, Rect* r ) ;
      XMPMethod Proxy* ProxyForFrame(XMPFrame* frame);
      XMPMethod void UpdateProxyRegion(Proxy* proxy);
      XMPMethod void CreateProxySelectionBorder(Proxy* p);
      XMPMethod void InvalidateSelection(XMPFrame* frame);
      XMPMethod void ClipEmbeddedFrames(XMPFrame* frame);
   
   protected:
   
      friend XMPPart* EXPENTRY CreatePart(void);
      // -constructor/destructor-
      ContainerPart();
      virtual ~ContainerPart();
   
      // JYS: submenu stuff
      static HWND hwndArrangeSubMenu;
      static HWND hwndEmbedSubMenu;
      static HWND hwndColorSubMenu;
      static HWND hwndFrameSubMenu;
      static ULONG ulRefCnt;
      //JYS: end of submenu
   
      XMPMethod void InitPart(XMPStorageUnit* storageUnit);
      XMPMethod void InitPartFromStorage(XMPStorageUnit* storageUnit);
      XMPNVMethod void CommonInitContainerPart();
      XMPMethod void LoadIcons();
   
      XMPMethod void Release();
   
      // -Embedding-
      XMPMethod OrderedCollection* GetEmbeddedFrames();
      XMPMethod Proxy* ProxyForFrameID(XMPID frameID);
   
      // -Imaging-
      XMPMethod void HighlightSelection(XMPFacet* facet);
      XMPMethod void HighlightProxyBorder(Proxy* p, XMPFacet *facet);
      XMPMethod void HighlightContentObject(Proxy* p, XMPFacet* facet);
      XMPMethod void ClipEmbeddedFacets(XMPFacet* facet);
   
      XMPMethod void EmptySelection();
   
      // -UI Events-
      XMPMethod XMPBoolean HandleMouseDown(XMPFacet* facet,
                                  XMPPoint where,
                                  XMPEventData event);
      XMPMethod XMPBoolean HandleMouseMove(XMPFacet* facet,
                                  XMPPoint where,
                                  XMPEventData event);
      XMPMethod XMPBoolean HandleMouseDownDrag(XMPFacet* facet, Proxy* selection, XMPEventData event);
      XMPMethod XMPBoolean HandleMouseDownEdgeResize(XMPFacet* facet, Proxy* selection, Point mouse);
      XMPMethod XMPBoolean HandleMouseDownCornerResize(XMPFacet* facet, Proxy* selection, Point mouse);
      XMPMethod XMPBoolean HandleMouseDownInEmbeddedFrame(XMPFacet* container,
                                             XMPFacet* facet,
                                             XMPPoint where,
                                             XMPEventData event);
      XMPMethod XMPBoolean HandleKeyDown(XMPFrame* focusFrame, XMPEventData event);
      XMPMethod XMPBoolean HandleMenuEvent(XMPFrame* focusFrame, XMPEventData event);
   
      // -Menu Commands-
      XMPMethod XMPBoolean DoCut(XMPFrame* frame);
      XMPMethod XMPBoolean DoCopy(XMPFrame* frame);
      XMPMethod XMPBoolean DoPaste(XMPFrame* frame);
      XMPMethod XMPBoolean DoPasteLink(XMPFrame* frame);
      XMPMethod XMPBoolean DoClear(XMPFrame* frame);
      XMPMethod XMPBoolean DoSelectAll(XMPFrame* frame);
   
      // -utilities-
      XMPMethod void ActivateFrame(XMPFrame* frame);
      XMPMethod void DeActivateFrame(XMPFrame* frame);
      XMPMethod void ActivatingWindow(XMPFrame* frame);
      XMPMethod void DeActivatingWindow(XMPFrame* frame);
      XMPMethod void InstallMenus(XMPFrame* aFrame);
      XMPMethod void RemoveMenus(XMPFrame* aFrame);
      XMPMethod void SetBGColor(XMPFrame* aFrame, XMPCommandID whichColor);
      XMPMethod void UserSetBGColor(XMPFrame* frame, RGBColor whichColor);
      XMPMethod void SetBGColor(XMPFrame* aFrame, RGBColor whichColor);
      XMPMethod void Embed(long item, XMPFrame* frame, XMPPart** newPart=kXMPNULL);
      XMPMethod void SetGrafPortOrigin(XMPFacet* facet);
      XMPMethod void InvalEmbedFrameAfterResize(XMPFacet* facet, Proxy* selection,
                                      XMPShape* oldShape, XMPShape* newShape,
                                      Point transOffset);
      XMPMethod Rect* GetSelectionRectLocal(Proxy* selection);
   
      XMPMethod   void CreatePalette();
      XMPMethod void DestroyPalette();
      XMPMethod   void ShowPalette();
      XMPMethod void HidePalette();
      XMPMethod void GetBGColor(XMPUShort whichColor, RGBColor* newColor);
      XMPMethod XMPWindow* CreateWindow(XMPFrame* sourceFrame);
   
      XMPMethod XMPBoolean MoveToFront(XMPFrame* frame);
      XMPMethod XMPBoolean MoveToBack(XMPFrame* frame);
      XMPMethod XMPBoolean MoveForward(XMPFrame* frame);
      XMPMethod XMPBoolean MoveBackward(XMPFrame* frame);
   
   private:
      int ExtractMenuPartStrings( char * fullstring , char * * dllstring , int * dllstringlength , char * * descripstring );
   
      OrderedCollection*   fDisplayFrames;
      OrderedCollection*   fEmbeddedFrames;
      XMPID          fWindowID;        // ID of View As Window window
   
      XMPULong       fFrameGroupIDCounter;
      Point          fDragStart;
   
      RGBColor        fDefaultColor; // Initial background color of all display frames
      OrderedCollection*   fContents;
      OrderedCollection*   fSelection;
   
      RgnHandle         fSelectRgn;
      RgnHandle         fCornerHandleRgn;
      RgnHandle         fEdgeHandleRgn;
   
      MenuHandle        fEmbedMenu;
      MenuHandle        fColorMenu;
      MenuHandle        fFrameMenu;
   
      XMPIcon           fLargeIcons;
      XMPIcon           fSmallIcons;
   
      XMPMenuBar*       fMenuBar;
      XMPFocusSet*      fFocusSet;
      XMPTypeToken      fSelectionFocus;
      XMPTypeToken      fMenuFocus;
      XMPTypeToken      fKeyFocus;
   
      XMPSemanticInterface*   fSemtIntf;
   
      XMPWindow*        fPalette;
      XMPBoolean        fPaletteUp;
      XMPBoolean        fPaletteWasShown;
   
      XMPSession*       fSession;
   
      HPS               hpsMem;
      HDC               hdcMem;
   
      POINTL            mouseStart;   //dwf
   };
   
   
   //==============================================================================
   // ContainerPartEmbeddedFramesIterator
   //==============================================================================
   
   class ContainerPartEmbeddedFramesIterator : public XMPEmbeddedFramesIterator
   {
      friend class ContainerPart;
   
   public:
   
      XMPMethod XMPFrame* First();
      XMPMethod XMPFrame* Next();
      XMPMethod XMPBoolean IsNotComplete();
   
   protected:
   
      ContainerPartEmbeddedFramesIterator(XMPPart* part);
      virtual ~ContainerPartEmbeddedFramesIterator();
   
   private:
   
      OrderedCollectionIterator* fOCIter;
   };
#endif


#endif // _CNTNRPRT_
