/* 
 *      File:           CntnrPrt.cpp //(rlt 3-8-95)
 *
 *   Contains:  IDL description of Container Part
 *
 *   Written by:        Jason Crawford
 *
 *
 *   Change History (most recent first):
 *      
 *        <7>    3/07/95   rlt       Added Frame->Invalidate after UsedShapeChanged
 *        <6>    2/24/95   rlt       Enabled "grid" toggle
 *        <5>    2/22/95   rlt       Enabled "View As" thumbnail
 *        <4>   12/08/94   rlt       Changed su->focus to use property/value instead of
 *                                        using index     
 *        <3>   11/05/94   ced      Modifications required because root facet
 *                                  external transform now scales from OpenDoc
 *                                  72 dpi coordinate space to device coordinate
 *                                  space.  Changes are labed with (CED - 110594).
 *        <2>   10/7/94    ced      Added example code for using mouse focus
 *                                  to draw rubber-band tracking rectangle.
 *       <1>      7/6/94        jlc             first checked in
 *
 *
 */

/*
 *  This file was generated by the SOM Compiler.
 *  Generated using:
 *     SOM incremental update: 2.38
 */


#ifndef SOM_Module_cntnrprt_Source
#define SOM_Module_cntnrprt_Source
#endif
#define ContainerPart_Class_Source
#define VARIABLE_MACROS

#define INCL_DOSMODULEMGR
#define INCL_DOSRESOURCES
#define INCL_GPIBITMAPS
#define INCL_GPICONTROL
#define INCL_GPIPRIMITIVES
#define INCL_GPIREGIONS
#define INCL_GPITRANSFORMS
#define INCL_WINACCELERATORS
#define INCL_WINFRAMEMGR
#define INCL_WININPUT
#define INCL_WINMENUS
#define INCL_WINMESSAGEMGR
#define INCL_WINPOINTERS
#define INCL_WINSTDDRAG
#define INCL_WINTRACKRECT
#define INCL_WINWINDOWMGR
#define INCL_DEV

#define INCL_ODARBITRATOR
#define INCL_ODCANVAS
#define INCL_ODDRAGANDDROP
#define INCL_ODDRAFT
#define INCL_ODERRORS
#define INCL_ODFACET
#define INCL_ODFOCUSSET
#define INCL_ODFRAME
#define INCL_ODMENUBAR
#define INCL_ODSESSION
//#define INCL_ODSEMANTICINTERFACE
#define INCL_ODSHAPE
#define INCL_ODSTORAGEUNIT
#define INCL_ODSTORAGEUNITVIEW
#define INCL_ODTRANSFORM
#define INCL_ODUNDO
#define INCL_ODWINDOW
#define INCL_ODWINDOWSTATE
#include <os2.h>

#include <CNNotebk.xh>
#include "cntnrprt.xih"

#ifndef SOM_XEmbeddedFramesIterator_xh
   #include <XFrmIter.xh>
#endif

#ifndef _ORDCOLL_
#include "OrdColl.h"
#endif

#ifndef SOM_ODActiveFrameMenuBar_xh
   #include <menubact.xh>
#endif

#ifndef SOM_ODSelectedContainerPartExtension_xh
   #include <cntnrspe.xh>
#endif

#ifndef SOM_ODContainerRootFrameMenuBar_xh
   #include <CntnrRMB.xh>
#endif

#ifndef SOM_ODPopupContainerMenu_xh
   #include <CntnrPUM.xh>
#endif

#define USE_PARTINFO_TO_RECALL_AMENU
// we stash the menubar in the part info, because the AdjustMenus()
//    method doesn't receive a menubar parameter.  We may not need
//    to do this since AdjustMenus does receive a frame parameter 
//    which can be mapped to a window and for which we can call
//    GetMenuBar().  The menubar returned should be our menu.  Anyway,
//    for now I'll stick to using the partinfo since I know that works.
//    


#include "debug.hpp"
#include "cntnrprt.h"
#include "common.hpp"

// I use THISDLL to designate the name of my own DLL for the
//    sake of loading resources.  Code could be added to determine
//    the name of the DLL at runtime, but this is quicker to code up.
//    Maybe later, I'll code up a TermInit routine to determine the 
//    dll name.  (jlc 94-12-06)
//#define THISDLL "cntnrprt.dll"
#define THISDLL "cntnrprt"

#define UNDONEEDSFIXINMAYBE

#if 1
   // we may want to make PartInfoRec public and declare it in its
   // own IDL file.   I'll wait until after the port before attempting
   // that. (jlc 94-8)
   class PartInfoRec
   {
   public:
      PartInfoRec() { fIsActive = kODFalse; fNeedsActivating = kODFalse; mbActive = kODNULL; }
      virtual ~PartInfoRec() { }
      RGBColor bgColor;
      ODBoolean  fGridOn;  // Is the grid on? //(rlt 3-8-95)
      ODBoolean  fIsActive;  // Does this frame have its focus set?
      ODBoolean  fNeedsActivating; // should this be activated when its window is activated?
      ODActiveFrameMenuBar * mbActive;
   };
#endif

// SetBGColorRec is used for Undo/Redo.
struct SetBGColorRec
{
  SetBGColorRec(RGBColor oldColor, RGBColor newColor, ODFrame* frame)
          {_fOldColor = oldColor; _fNewColor = newColor;
            _fFrame = frame;}
  RGBColor   _fOldColor;
  RGBColor   _fNewColor;
  ODFrame*  _fFrame;
};


#ifndef _CNTNRRES_
   #include "cntnrres.h"
#endif
#include "print.h"

#if 1
   // temporary stuff to get things compiling
   #define GetQDRegion GetRegion
   ODIText * PStrToIntl( const char * str, ODIText ** result ) { NOTDONE2("PStrToIntl"); return 0;}
   const ODCommandID cODMaxEmbedParts = 25;
   const long        cODMaxEmbedPartString = 200;
   char partStrings[cODMaxEmbedParts][cODMaxEmbedPartString];
#endif
//+(rlt 3-8-95)
const int YGRID = 32;
const int XGRID = 32;
static int defcolor = 1;
//-
const short kODBorderWidth = 5;
const short kODHandleLenMultiplier = 3;

static const ODPropertyName  kPropFrameInfo = "ContainerPart:Property:FrameInfo";
static const ODPropertyName  kPropMouseDownOffset = "ContainerPart:Property:MouseDownOffset";

// todo: The following entry almost certainly needs to be placed in a public location
static const ODValueType    kOS2POINTL = "Bento:OS2:IBM:POINTL";

const ODType   kContainerPartPresNormal  = "ContainerPart:Presentation:Normal";
#define kKindTestContainer "IBM:Kind:TestContainer"

struct Proxy {
/*
 * We no longer use proxy regions associated with frame because now that the
 * root facet external transform scales from OpenDoc's 72 dpi coordinate
 * space to device coordinates, we can no longer simply offset a region in
 * frame coordinates when we need to use it.  Since a region can be obtained
 * from a frame shape by transforming the frame shape using the facet's content
 * transform, it would be more appropriate to maintain the region in the facet's
 * part info, however, since we were only using the proxy region for creating the
 * proxy selection border, we'll just do away with the proxy region and transform
 * the frame shape when we need to.  (CED - 110594)
 *
 * HRGN region;
 */
   ODFrame* frame;
   ODTransform* transform;
// Proxy(HRGN r, ODFrame* f, ODTransform* t) {region = r; frame = f; transform = t; }
   Proxy(ODFrame* f, ODTransform* t) {frame = f; transform = t; }
};


// stuff for the Embed menu (94-09-12 jlc)
#include <stdio.h>
ODMenuBar *    mbPartHandlers = 0;


#if 1
   // the following compile well enough, so I'm commenting them out
   //  to save compile time and avoid the distraction of the remaining
   //  warnings.

   SOM_Scope ODSemanticInterface*  SOMLINK ContainerPartGetSemanticInterface(ContainerPart *somSelf,
                                                                              Environment *ev)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartGetSemanticInterface");

       NOTDONE2("GetSemanticInterface");
       /* Return statement to be customized: */
       { ODSemanticInterface* retVal;  return (retVal); }
   }

   SOM_Scope Proxy*  SOMLINK ContainerPartProxyFromFrame(ContainerPart *somSelf,
                                              Environment *ev, ODFrame *frame)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartProxyFromFrame");

       if (_fEmbeddedFrames->Contains(frame))
       {
         Proxy* p;
         ODxOrderedCollectionIterator i(_fContents);
         for (p = (Proxy*) i.First(); i.IsNotComplete(); p = (Proxy*) i.Next())
           if (p->frame == frame) return p;
         return kODNULL;
       }
       else
         THROW(kODErrInvalidFrame);

       return kODNULL;
   }

   SOM_Scope Proxy*  SOMLINK ContainerPartProxyForFrame(ContainerPart *somSelf,
                                                         Environment *ev,
                                                        ODFrame* frame)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartProxyForFrame");

       if (_fEmbeddedFrames->Contains(frame))
       {
         Proxy* p;
         ODxOrderedCollectionIterator i(_fContents);
         for (p = (Proxy*) i.First(); i.IsNotComplete(); p = (Proxy*) i.Next())
           if (p->frame == frame) return p;
         return kODNULL;
       }
       else
         THROW(kODErrInvalidFrame);

       return kODNULL;
   }
#if 0
/*
 * We are no longer using proxy regions associated with frame partinfo because
 * frame does not contain the info we need to transform a shape to device
 * coords so we can get a region.  This info is contained in the facet's
 * content (or window frame) transform.  Therefor, if we still wanted to use
 * a proxy region, we would associate it with the facet partinfo instead of
 * frame partinfo. (CED - 110594)
 */
   SOM_Scope void  SOMLINK ContainerPartUpdateProxyRegion(ContainerPart *somSelf,
                                                           Environment *ev,
                                                          Proxy* proxy)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartUpdateProxyRegion");

       ODShape* scratch = new ODShape();
       scratch->CopyFrom(ev, proxy->frame->GetFrameShape(ev));
       scratch->Transform(ev, proxy->transform);
       HRGN scratchRgn = scratch->GetRegion(ev);
       GpiCombineRegion( _hpsMem, proxy->region, scratchRgn, 0, CRGN_COPY );
       delete scratch;
   }
#endif
   SOM_Scope void  SOMLINK ContainerPartCreateProxySelectionBorder(ContainerPart *somSelf,
                                                                    Environment *ev,
                                           /* (CED - 110594) */    ODFacet* facet,
                                                                   Proxy* p)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartCreateProxySelectionBorder");

       RECTL arcl[4], borderRect;
       HRGN tempRgn = GpiCreateRegion(_hpsMem, 0, NULL);

       // -- selection border region --
#if 1
/*
 * Get region rectangle by transforming points of frame rectangle using the
 * content transform for the proxy (our facet content transform combined with the
 * proxy frame's external transform).  Don't forget to increment the top right
 * coner because region rectangles are inclusive/exclusive. (CED - 110594)
 */
       ODRect boundingBox;
       ODTransform* transform = p->transform->Copy(ev);
       transform->PostCompose(ev, facet->GetContentTransform(ev));
       p->frame->GetFrameShape(ev)->GetBoundingBox(ev, &boundingBox);
       ODPoint botLeft = {boundingBox.left, boundingBox.bottom};
       ODPoint topRight = {boundingBox.right, boundingBox.top};
       arcl[0] = ODRECTL(transform->TransformPoint(ev, &botLeft),
                         transform->TransformPoint(ev, &topRight));
       delete transform;
#else
       GpiQueryRegionBox(_hpsMem, p->region, arcl);
#endif
       GpiSetRegion(_hpsMem, tempRgn, 1, arcl);
       arcl[1] = arcl[0];
       InflateRect(&arcl[1],kODBorderWidth, kODBorderWidth);
       GpiSetRegion(_hpsMem, _fSelectRgn, 1, &arcl[1]);
       GpiCombineRegion(_hpsMem, _fSelectRgn, _fSelectRgn, tempRgn, CRGN_XOR);

       GpiQueryRegionBox(_hpsMem, _fSelectRgn, &borderRect);

       // -- corner region --

       LONG handleWidth = (kODHandleLenMultiplier * kODBorderWidth);
       arcl[1] = arcl[0] = borderRect;
       arcl[0].xLeft += handleWidth;
       arcl[0].xRight -= handleWidth;
       arcl[1].yBottom +=  handleWidth;
       arcl[1].yTop -=  handleWidth;
       GpiCombineRegion(_hpsMem, _fCornerHandleRgn, _fSelectRgn, 0, CRGN_COPY);
       GpiSetRegion(_hpsMem, tempRgn, 2, arcl);
       GpiCombineRegion(_hpsMem, _fCornerHandleRgn, _fCornerHandleRgn, tempRgn, CRGN_DIFF);

       // -- edge region --

       arcl[0] = arcl[1] = arcl[2] = arcl[3] = borderRect;
       arcl[0].xRight -= (borderRect.xRight - borderRect.xLeft) / 2;
       arcl[0].yTop -= (borderRect.yTop - borderRect.yBottom) / 2;
       arcl[1].xLeft = arcl[0].xRight + 1;
       arcl[1].yTop = arcl[0].yTop;
       arcl[2].xLeft = arcl[0].xRight + 1;
       arcl[2].yBottom = arcl[0].yTop + 1;
       arcl[3].xRight = arcl[0].xRight;
       arcl[3].yBottom = arcl[0].yTop + 1;

       if ((borderRect.xRight - borderRect.xLeft) >= (5 * kODHandleLenMultiplier * kODBorderWidth))
       {
          /* top and bottom handles */

          LONG hdist = (kODHandleLenMultiplier * kODBorderWidth) / 2;
          arcl[0].xRight -= hdist;
          arcl[1].xLeft += hdist;
          arcl[2].xLeft = arcl[1].xLeft;
          arcl[3].xRight = arcl[0].xRight;
       }

       if ((borderRect.yTop - borderRect.yBottom) >= (5 * kODHandleLenMultiplier * kODBorderWidth))
       {
          /* left and right handles */

          LONG vdist = (kODHandleLenMultiplier * kODBorderWidth) / 2;
          arcl[0].yTop -= vdist;
          arcl[1].yTop = arcl[0].yTop;
          arcl[2].yBottom += vdist;
          arcl[3].yBottom = arcl[2].yBottom;
       }
       GpiCombineRegion(_hpsMem, _fEdgeHandleRgn, _fSelectRgn, 0, CRGN_COPY);
       GpiSetRegion(_hpsMem, tempRgn, 4, arcl);
       GpiCombineRegion(_hpsMem, _fEdgeHandleRgn, _fEdgeHandleRgn, tempRgn, CRGN_DIFF);

    #if 0

       // clip by obscuring frames

       Proxy* q;
       ODxOrderedCollectionIterator i(fContents);
       ODBoolean above = true;
       for (q = (Proxy*) i.First(); i.IsNotComplete(); q = (Proxy*) i.Next())
       {  if (p == q) {above = false; continue;}
          if (!above) {continue;}
          GpiCombineRegion(_hpsMem, _fSelectRgn, _fSelectRgn, q->region, CRGN_DIFF);
          GpiCombineRegion(_hpsMem, _fCornerHandleRgn, _fCornerHandleRgn, q->region, CRGN_DIFF);
          GpiCombineRegion(_hpsMem, _fEdgeHandleRgn, _fEdgeHandleRgn, q->region, CRGN_DIFF);
       };
    #endif
       GpiDestroyRegion(_hpsMem, tempRgn);

       // clip path from obscured frames
       somSelf->ClipEmbeddedFrames(ev, p->frame->GetContainingFrame(ev));
   }

   SOM_Scope void  SOMLINK ContainerPartInvalidateSelection(ContainerPart *somSelf,
                                                Environment *ev,
                                               ODFrame* frame)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartInvalidateSelection");

       ODShape* selectShape = new ODShape();
       HRGN invalidRgn = GpiCreateRegion(_hpsMem, 0, NULL);
       GpiCombineRegion( _hpsMem, invalidRgn, _fSelectRgn, _fCornerHandleRgn, CRGN_OR);
       GpiCombineRegion( _hpsMem, invalidRgn, invalidRgn, _fEdgeHandleRgn, CRGN_OR);
       selectShape->SetPlatformShape(ev, kODGPI, invalidRgn);

       // transform shape from region coords to frame coords (CED - 110594)
       ODFrameFacetIterator* facets = frame->CreateFacetIterator(ev);
       selectShape->InverseTransform(ev, facets->First(ev)->GetWindowFrameTransform(ev));
       delete facets;

       frame->Invalidate(ev, selectShape);
       delete selectShape;
   }

   SOM_Scope void  SOMLINK ContainerPartClipEmbeddedFrames(ContainerPart *somSelf,
                                               Environment *ev,
                                              ODFrame* frame)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartClipEmbeddedFrames");

       ODFrameFacetIterator* facets = frame->CreateFacetIterator(ev);
       for (ODFacet* facet = facets->First(ev); facets->IsNotComplete(ev); facet = facets->Next(ev))
          somSelf->ClipEmbeddedFacets(ev, facet);
       delete facets;
   }


/*
 *@jlc whatisit? void InstallObjectAccessors();
 */

   SOM_Scope void  SOMLINK ContainerPartCommonInitContainerPart(ContainerPart *somSelf,
                                                    Environment *ev)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartCommonInitContainerPart");

       _fDisplayFrames = new ODxOrderedCollection;
       _fEmbeddedFrames = new ODxOrderedCollection;

//+(rlt 3-8-95(
       _fDefaultColor = 0;  // pick white as default for root frame only
//-
       _fContents = new ODxOrderedCollection;
       _fSelection = new ODxOrderedCollection;
       SIZEL sizlPage = {0, 0};
       _hdcMem = DevOpenDC   (1 , OD_MEMORY, "*", 0L, NULL, (HDC)0) ;
       _hpsMem = GpiCreatePS (1 , _hdcMem, &sizlPage, PU_PELS      | GPIF_DEFAULT |
                                                    GPIT_MICRO   | GPIA_ASSOC) ;

       _fSelectRgn = GpiCreateRegion( _hpsMem, 0, NULL);
       _fCornerHandleRgn = GpiCreateRegion( _hpsMem, 0, NULL);
       _fEdgeHandleRgn = GpiCreateRegion( _hpsMem, 0, NULL);

       _fSession = somSelf->GetStorageUnit(ev)->GetSession(ev);

       _fSelectionFocus = _fSession->Tokenize(ev, kODSelectionFocus);
       _fMenuFocus = _fSession->Tokenize(ev, kODMenuFocus);
       _fKeyFocus = _fSession->Tokenize(ev, kODKeyFocus);
       _fMouseFocus = _fSession->Tokenize(ev, kODMouseFocus);

       _fFocusSet = new ODFocusSet();
       _fFocusSet->InitFocusSet(ev);
       _fFocusSet->Add(ev, _fSelectionFocus);
       _fFocusSet->Add(ev, _fMenuFocus);
       _fFocusSet->Add(ev, _fKeyFocus);
       _fNotebook = new CNNotebook();
       _fNotebook->InitNotebookExtension(ev, somSelf);
   }

   SOM_Scope ODxOrderedCollection*  SOMLINK ContainerPartGetEmbeddedFrames(ContainerPart *somSelf,
                                                            Environment *ev)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartGetEmbeddedFrames");

      return _fEmbeddedFrames;
   }

   SOM_Scope Proxy*  SOMLINK ContainerPartProxyForFrameID(ContainerPart *somSelf,
                                              Environment *ev, ODID frameID)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartProxyForFrameID");

       ODFrame* frame = somSelf->GetStorageUnit(ev)->GetDraft(ev)->GetFrame(ev, frameID);
       Proxy* p = somSelf->ProxyForFrame(ev, frame);
       frame->Release(ev);
       return p;
   }

   SOM_Scope void  SOMLINK ContainerPartHighlightSelection(ContainerPart *somSelf,
                                               Environment *ev,
                                              ODFacet* facet)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartHighlightSelection");

       switch (_fSelection->Count())
       {
          case 0:     // no selection
             break;

          case 1:     // single selection
             {  ODxOrderedCollectionIterator i(_fSelection);
                somSelf->HighlightProxyBorder(ev, (Proxy*)i.First(), facet);
             };
             break;

          default: // multiple selection
             {  Proxy* p;
                ODxOrderedCollectionIterator i(_fSelection);
                for (p = (Proxy*) i.First(); i.IsNotComplete(); p = (Proxy*) i.Next())
                {  if (_fSelection->Contains(p))
                      somSelf->HighlightContentObject(ev, p, facet);
                };
             };
       };
   }

   SOM_Scope void  SOMLINK ContainerPartHighlightProxyBorder(ContainerPart *somSelf,
                                                 Environment *ev,
                                                Proxy* p, ODFacet* facet)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartHighlightProxyBorder");

       HPS hps = facet->GetCanvas(ev)->GetPlatformCanvas(ev);

       HRGN shapeRgn = GpiCreateRegion(hps, 0, NULL);
       Rect rect;
// (CED - 110594) ODPoint pt = {0,0};
       SIZEL sizlThickness = {1, 1};

// (CED - 110594) pt = facet->GetContentTransform(ev)->TransformPoint(ev, &pt);
// (CED - 110594) ODPOINTL ptl(pt);

       // draw frame border
       GpiSavePS(hps);
       GpiSetPattern(hps, PATSYM_DENSE5);
       GpiSetColor(hps, CLR_BLACK);

       GpiCombineRegion(hps, shapeRgn, _fSelectRgn, 0, CRGN_COPY);
// (CED - 110594) GpiOffsetRegion(hps, shapeRgn, &ptl);
       GpiPaintRegion(hps, shapeRgn);

       GpiSetPattern(hps, PATSYM_SOLID);
       GpiSetColor(hps, CLR_WHITE);
       GpiCombineRegion(hps, shapeRgn, _fCornerHandleRgn, 0, CRGN_COPY);
// (CED - 110594) GpiOffsetRegion(hps, shapeRgn, &ptl);
       GpiPaintRegion(hps, shapeRgn);
       GpiSetColor(hps, CLR_BLACK);
       GpiFrameRegion(hps, shapeRgn, &sizlThickness);

       GpiSetColor(hps, CLR_WHITE);
       GpiCombineRegion(hps, shapeRgn, _fEdgeHandleRgn, 0, CRGN_COPY);
// (CED - 110594) GpiOffsetRegion(hps, shapeRgn, &ptl);
       GpiPaintRegion(hps, shapeRgn);
       GpiSetColor(hps, CLR_BLACK);
       GpiFrameRegion(hps, shapeRgn, &sizlThickness);

       GpiDestroyRegion(hps, shapeRgn);
       GpiRestorePS(hps, -1);

       facet->GetCanvas(ev)->ReleasePlatformCanvas(ev);
   }

   SOM_Scope void  SOMLINK ContainerPartHighlightContentObject(ContainerPart *somSelf,
                                                   Environment *ev,
                                                  Proxy* p, ODFacet* facet)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartHighlightContentObject");

       NOTDONE2("HighlightContentObject");
   }

   SOM_Scope void  SOMLINK ContainerPartClipEmbeddedFacets(ContainerPart *somSelf,
                                               Environment *ev,
                                              ODFacet* facet)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartClipEmbeddedFacets");

       ODTransform* wclipTrans = new ODTransform;

       ODShape* workingClip = new ODShape();
       workingClip->CopyFrom(ev, facet->GetClipShape(ev));
//     ODShape* contentClip = (ODShape*)facet->GetPartInfo(ev);
       ODRect emptyRect = {0,0,0,0};
//     contentClip->SetRectangle(ev, &emptyRect);
/*
 * These two lines were moved here from down below because we now need to
 * transform workingClip before subtracting the selection region since the
 * selection region is in device coords. (CED - 110594)
 */
       wclipTrans->CopyFrom(ev, facet->GetWindowFrameTransform(ev));
       workingClip->Transform(ev, wclipTrans);    // now in window coordinates

       // let selection obscure embedded parts

       HRGN tempRgn;
       ODShape* tempShape = new ODShape;


       RECTL rclBox;
       LONG lComplexity = GpiQueryRegionBox(_hpsMem, _fSelectRgn, &rclBox);
       if (_fSelectRgn &&  lComplexity != RGN_NULL && lComplexity != RGN_ERROR)
       {
          tempRgn = GpiCreateRegion(_hpsMem, 0, NULL);
          GpiCombineRegion(_hpsMem, tempRgn, _fSelectRgn, 0, CRGN_COPY);
          GpiCombineRegion(_hpsMem, tempRgn, tempRgn, _fCornerHandleRgn, CRGN_OR);
          GpiCombineRegion(_hpsMem, tempRgn, tempRgn, _fEdgeHandleRgn, CRGN_OR);
          tempShape->SetPlatformShape(ev, kODGPI, tempRgn); // shape owns rgn now
          workingClip->Subtract(ev, tempShape);
       }
       delete tempShape;

// (CED - 110594) wclipTrans->CopyFrom(ev, facet->GetWindowFrameTransform(ev));
// (CED - 110594) workingClip->Transform(ev, wclipTrans);    // now in window coordinates

       ODFacet* embFacet;
       ODFacetIterator* facets = facet->CreateFacetIterator(ev, kODChildrenOnly, kODFrontToBack);
       for (embFacet = facets->First(ev);
             facets->IsNotComplete(ev);
             embFacet = facets->Next(ev))
       {
          ODShape* newClipShape = new ODShape();
          newClipShape->CopyFrom(ev, embFacet->GetFrame(ev)->GetUsedShape(ev));

          wclipTrans->CopyFrom(ev, embFacet->GetWindowFrameTransform(ev));
          wclipTrans->Invert(ev);
          workingClip->Transform(ev, wclipTrans);    // now in frame coordinates
//        contentClip->Transform(ev, wclipTrans);

          newClipShape->Intersect(ev, workingClip);
          workingClip->Subtract(ev, newClipShape);
//        contentClip->Union(ev, newClipShape);

          wclipTrans->Invert(ev);
          workingClip->Transform(ev, wclipTrans);    // now in window coordinates
//        contentClip->Transform(ev, wclipTrans);

          embFacet->ChangeGeometry(ev, newClipShape, kODNULL);  // facet now owns shape storage
       }
       delete facets;
       delete wclipTrans;
   }

   SOM_Scope void  SOMLINK ContainerPartEmptySelection(ContainerPart *somSelf,
                                           Environment *ev)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartEmptySelection");

       for(ODULong i = _fSelection->Count(); i > 0; i--)
          _fSelection->RemoveFirst();
       if ( _fSPEMenuOfSelection ) {
          _fSPEMenuOfSelection->Release(ev);
          _fSPEMenuOfSelection = kODNULL;
       } /* endif */
       GpiSetRegion( _hpsMem, _fSelectRgn, 0, NULL);
       GpiSetRegion( _hpsMem, _fCornerHandleRgn, 0 ,NULL);
       GpiSetRegion( _hpsMem, _fEdgeHandleRgn, 0, NULL);
   }


   SOM_Scope ODBoolean  SOMLINK ContainerPartHandleMouseDown(ContainerPart *somSelf,
                                                           Environment *ev,
                                                          ODFacet* facet,
                                                          ODPoint* where,
                                                          ODEventData* event)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartHandleMouseDown");

       if (!facet->GetWindow(ev)->IsActive(ev))
          facet->GetWindow(ev)->Select(ev);
       else
          if (event->msg==WM_BUTTON1DOWN) {
             somSelf->ActivateFrame(ev, facet->GetFrame(ev));
          } /* endif */

// (CED - 110594) ODPOINTL mouse(facet->GetWindowContentTransform(ev)->InvertPoint(ev, where));
       ODPOINTL mouse(*where);      // Keep in window coords (CED - 110594)

       {

          ODxOrderedCollectionIterator i(_fSelection);
          Proxy* p = (Proxy*)i.First();

          if (GpiPtInRegion(_hpsMem, _fCornerHandleRgn, &mouse) == PRGN_INSIDE)
             return somSelf->HandleMouseDownCornerResize(ev, facet, p, &mouse);
          else if (GpiPtInRegion(_hpsMem, _fEdgeHandleRgn, &mouse) == PRGN_INSIDE)
             return somSelf->HandleMouseDownEdgeResize(ev, facet, p, &mouse);
          else if (GpiPtInRegion(_hpsMem, _fSelectRgn, &mouse) == PRGN_INSIDE)
             return somSelf->HandleMouseDownDrag(ev, facet, p, event);
          else
             switch (_fSelection->Count())
             {
                case 0:
                   break;

                case 1:
                   if (event->msg==WM_BUTTON1DOWN) {
                      somSelf->InvalidateSelection(ev, facet->GetFrame(ev));
                      somSelf->EmptySelection(ev);
                      somSelf->ClipEmbeddedFrames(ev, facet->GetFrame(ev));
                   } /* endif */
                   break;

                default:
                   // !!! handle multiple selection
                   break;
             }

             #if 1
                // Start rubber band selection.  We don't actually support
                //   rubber band selection, but this demonstrates one way to
                //   handle the difficult aspects.  Scan this file
                //   for instances of _fTracking to see related code.

                ODFrame* frame = facet->GetFrame(ev);

                if (event->msg == WM_BUTTON1DOWN &&
                    _fSession->GetArbitrator(ev)->RequestFocus(ev, _fMouseFocus,
                                                               frame))
                {
                  if (WinSetCapture(HWND_DESKTOP, event->hwnd))
                  {
                    if (WinLockWindowUpdate(HWND_DESKTOP, event->hwnd))
                    {
                      ODPOINTL ptlMouse = *where;
                      PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo(ev);
                      _fTracking = kODTrue;
                      _ptlOrigin = _ptlEnd = ptlMouse;

                      if (_hrgnTrackingClip)
                        GpiDestroyRegion(_hpsMem, _hrgnTrackingClip);

                      ODShape* clipShape = new ODShape;
                      clipShape->CopyFrom(ev, facet->GetAggregateClipShape(ev) );
                      clipShape->Transform(ev, facet->GetWindowFrameTransform(ev));
                      _hrgnTrackingClip = clipShape->GetRegion(ev);
                    }
                    else
                    {
                      WinSetCapture(HWND_DESKTOP, 0);
                      _fSession->GetArbitrator(ev)->RelinquishFocus(ev, _fMouseFocus,
                                                                    frame);
                    }
                  }
                  else
                  {
                    _fSession->GetArbitrator(ev)->RelinquishFocus(ev, _fMouseFocus,
                                                                  frame);
                  }
                }
             #endif
       }
       return kODTrue;
   }

   SOM_Scope ODBoolean  SOMLINK ContainerPartHandleMouseUp(ContainerPart *somSelf,
                                                           Environment *ev,
                                                          ODFacet* facet,
                                                          ODFrame* frame,
                                                          ODPoint* where,
                                                          ODEventData* event)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartHandleMouseUp");

       if (_fTracking)
       {
         _fSession->GetArbitrator(ev)->RelinquishFocus(ev, _fMouseFocus, frame);
         somSelf->FocusLost(ev, _fMouseFocus, frame);
       }
       /*
        * Add code here to select objects within the tracking rectange
        */

       return kODTrue;
   }


   SOM_Scope void  SOMLINK ContainerPartMoveResize(ContainerPart *somSelf,
                                                   Environment *ev,
                                                   ODFacet* facet,
                                                   Proxy* selection,
                                                   ODSLong fs)

   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartMoveResize");

       TRACKINFO trackInfo;
// (CED - 110594) ODPoint pt = {0, 0};

       memset(&trackInfo, 0, sizeof(trackInfo));
       trackInfo.fs = fs;
       trackInfo.cxBorder = kODBorderWidth;
       trackInfo.cyBorder = kODBorderWidth;
       trackInfo.cxGrid = trackInfo.cyGrid = 1;
       trackInfo.cxKeyboard = trackInfo.cyKeyboard = 8;
       trackInfo.ptlMinTrackSize.x = 2 * kODBorderWidth * kODHandleLenMultiplier
                                     + 2;
       trackInfo.ptlMinTrackSize.y = 2 * kODBorderWidth * kODHandleLenMultiplier
                                     + 2;
// (CED - 110594) pt = facet->GetContentTransform(ev)->TransformPoint(ev, &pt);
// (CED - 110594) ODPOINTL ptl(pt);
       GpiQueryRegionBox(_hpsMem, _fSelectRgn, &trackInfo.rclTrack);
// (CED - 110594) OffsetRect(&trackInfo.rclTrack, ptl.x, ptl.y);
       Rect oldRect = trackInfo.rclTrack;
       InflateRect(&oldRect, -kODBorderWidth, -kODBorderWidth);

       ODShape *boundingShape = new ODShape();
       ODRect bounds;
       boundingShape->CopyFrom(ev, facet->GetFrame(ev)->GetFrameShape(ev));
       boundingShape->Transform(ev, facet->GetWindowFrameTransform(ev));
       boundingShape->GetBoundingBox(ev, &bounds);
       trackInfo.rclBoundary = ODRECTL(bounds);
       delete boundingShape;

       trackInfo.ptlMaxTrackSize.x = trackInfo.rclBoundary.xRight;
       trackInfo.ptlMaxTrackSize.y = trackInfo.rclBoundary.yTop;

       HWND hwnd = facet->GetWindow(ev)->GetPlatformWindow(ev);

       // Get the window handle of the client window to track over.
       // Shouldn't GetPlatformWindow return the client window handle? - CED

       hwnd = WinWindowFromID(hwnd, FID_CLIENT);

       if (WinTrackRect(hwnd, NULLHANDLE, &trackInfo)) {
          InflateRect(&trackInfo.rclTrack, -kODBorderWidth, -kODBorderWidth);

#if 1   // (CED - 110594)

          ODPoint offset = {
             MAKEFIXED(trackInfo.rclTrack.xLeft, 0),
             MAKEFIXED(trackInfo.rclTrack.yBottom, 0)
          };
          offset = facet->GetWindowFrameTransform(ev)->InvertPoint(ev, &offset);

          // offset now in my frame coordinates.

          ODTransform* newTransform = new ODTransform;
          newTransform->MoveBy(ev, &offset);
          newTransform->PostCompose(ev, facet->GetWindowFrameTransform(ev));

          // newTransform now represents the window frame transform of frame
          // being moved.

          ODShape* newShape = new ODShape;
          ODRect newBounds = downcastToODRECTL(trackInfo.rclTrack);
          newShape->SetRectangle(ev, &newBounds);

          // Shape is in window coords.  Transform it to local frame coords of
          // the frame being moved.

          newShape->InverseTransform(ev, newTransform);

          // Set the new external transform of the frame being moved.
          newTransform->SetOffset(ev, &offset);

          somSelf->InvalEmbedFrameAfterResize(ev, facet, selection, newShape, newTransform);
          // newShape & newTransform are no longer my responsiblility
#else
          Point transOffset = { trackInfo.rclTrack.xLeft - oldRect.xLeft,
                                trackInfo.rclTrack.yBottom - oldRect.yBottom };
          OffsetRect(&trackInfo.rclTrack, -trackInfo.rclTrack.xLeft,
                                          -trackInfo.rclTrack.yBottom);
          ODShape* newShape = new ODShape;
          ODRect newBounds = downcastToODRECTL(trackInfo.rclTrack);
          newShape->SetRectangle(ev, &newBounds);

          ODShape* oldShape = selection->frame->GetFrameShape(ev);
          somSelf->InvalEmbedFrameAfterResize(ev, facet, selection, oldShape, newShape, &transOffset);
#endif
       }
   }


   SOM_Scope ODBoolean  SOMLINK ContainerPartHandleMouseDownDrag(ContainerPart *somSelf,
                                                               Environment *ev,
                                                              ODFacet* facet,
                                                              Proxy* selection,
                                                              ODEventData* event)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartHandleMouseDownDrag");

       ODBoolean handled = kODFalse;

       ODPart* destPart;
       ODPoint pt = {0, 0};
       ODShape* scratch;
       Point mdOffset = {0,0};
       HRGN dragRgn, tempRgn;
       ODID frameInfoData;
       ODDragAndDrop*   dad;
       ODStorageUnit*   unit;
       ODDropResult dropResult;

       handled = kODTrue;
       if (event->msg==WM_BUTTON1DOWN) {

          somSelf->MoveResize(ev, facet, selection, TF_MOVE);

       } else if  (event->msg==WM_BUTTON2DOWN) {
          POINTL pts[13];
          ODPOINTL odptlMouse(SHORT1FROMMP(event->mp1), SHORT2FROMMP(event->mp1));
          ODDragAndDrop*   dad = _fSession->GetDragAndDrop(ev);
          dad->Clear(ev);
          {
             Rect shapeRect;
             #if 1
                ODShape *trackingShape = new ODShape();
                trackingShape->CopyFrom(ev, selection->frame->GetFrameShape(ev));
                trackingShape->Transform(ev, selection->transform);
                trackingShape->Transform(ev, facet->GetWindowFrameTransform(ev));
                //GpiQueryRegionBox( _hpsMem, trackingShape->GetQDRegion(ev), &shapeRect);
                GpiQueryRegionBox( _hpsMem, trackingShape->GetRegion(ev), &shapeRect);
                //Rect oldRect = shapeRect;
                //InflateRect(&shapeRect, kODBorderWidth, kODBorderWidth);
                shapeRect.xLeft   -= odptlMouse.x;
                shapeRect.xRight  -= odptlMouse.x;
                shapeRect.yBottom -= odptlMouse.y;
                shapeRect.yTop    -= odptlMouse.y;
                delete trackingShape;
             #endif
             // specify inner box
             pts[ 0].x = 0;   pts[0].y = 0;
             pts[ 1].x = shapeRect.xLeft ;  pts[ 1].y = shapeRect.yBottom;
             pts[ 2].x = shapeRect.xLeft ;  pts[ 2].y = shapeRect.yTop;
             pts[ 3].x = shapeRect.xRight;  pts[ 3].y = shapeRect.yTop;
             pts[ 4].x = shapeRect.xRight;  pts[ 4].y = shapeRect.yBottom;
             pts[ 5].x = shapeRect.xLeft ;  pts[ 5].y = shapeRect.yBottom;
             // do another slightly larger box
             pts[ 6].x = pts[ 1].x - 2   ;  pts[ 6].y = pts[ 1].y - 2;
             pts[ 7].x = pts[ 2].x - 2   ;  pts[ 7].y = pts[ 2].y + 2;
             pts[ 8].x = pts[ 3].x + 2   ;  pts[ 8].y = pts[ 3].y + 2;
             pts[ 9].x = pts[ 4].x + 2   ;  pts[ 9].y = pts[ 4].y - 2;
             pts[10].x = pts[ 5].x - 2   ;  pts[10].y = pts[ 5].y - 2;
             // return to inner box
             pts[11].x = shapeRect.xLeft ;  pts[11].y = shapeRect.yBottom;
             // return to origin to erase xor vector out to edge of box
             pts[12].x = 0;  pts[12].y = 0;
          }
          DRAGIMAGE dimg;         /* DRAGIMAGE structure                   */
          HBITMAP   hbm;          /* Bit-map handle                        */

          /*************************************************************/
          /* Initialize the DRAGIMAGE structure                        */
          /*************************************************************/
          dimg.cb = sizeof(DRAGIMAGE); /* Size control block           */

          // jlc changed the following code to use a polygon rather than
          //    a bitmap because he wanted to put something on the screen
          //    quickly and didn't want to take the time to code up a
          //    bitmap.  The following code should be changed to
          //    actually provide an outline of the object, or an icon.

          dimg.cptl        = 13;  // number of points
          dimg.hImage = (ULONG)(PPOINTL)pts;           /* Image handle passed to       */
                                       /* DrgDrag                      */
          dimg.sizlStretch.cx = 20L;   /* Size to stretch ico or bmp to*/
          dimg.sizlStretch.cy = 20L;
          dimg.fl = DRG_POLYGON;       /* Flags passed to DrgDrag      */
                 //   DRG_STRETCH;       /* Stretch to size specified    */
                                       /* in sizlStretch               */
          dimg.cxOffset = 0;           /* Offset of the origin of      */
          dimg.cyOffset = 0;           /* the image from the pointer   */
                                       /* hotspot                      */

          // jlc - rest of the system needs to know that this frame is
          //       responsible for starting the drag.  We will need
          //       to code up some additional support later to insure
          //       that source messages like DM_DRAGOVERNOTIFY get
          //       back here. todo:

          // *** Fill DAD SU with Props n' Vals
          //unit = dad->GetStorageUnit(ev);
          unit = dad->GetContentStorageUnit(ev);

          ODDraft* fromDraft = somSelf->GetStorageUnit(ev)->GetDraft(ev);
          ODDraftKey key = fromDraft->BeginClone(ev, kODCloneCut);
          selection->frame->GetPart(ev)->CloneInto(ev, key, unit, selection->frame->GetStorageUnit(ev));
          fromDraft->EndClone(ev, key);

          // *** save ID of frame being dragged

          frameInfoData = selection->frame->GetID(ev);
          unit->AddProperty(ev, kPropFrameInfo)->AddValue(ev, kODID);
          unit->SetValue(ev, sizeof(ODID), (ODValue) &frameInfoData);

          // *** Save the frame's part info.  This is a kludge because
          // *** some of the sample parts we have now save their content
          // *** to the frame's partinfo rather than  adding properties
          // *** for part content in the storage unit.  The frame's partinfo
          // *** data should not normally be copied on a drag/drop operation.
          // *** This code will be removed once the sample parts are fixed
          // *** up to externalize properly.

          PartInfoRec* pInfo = (PartInfoRec*) selection->frame->GetPartInfo(ev);
          unit->AddProperty(ev, kODPropPartInfo)->AddValue(ev, kODPartInfo);
          ODStorageUnitView *suView = new ODStorageUnitView();
          suView->InitStorageUnitView(ev, unit, unit->CreateCursor(ev));
          ODInfoType fPartInfo = selection->frame->GetPartInfo(ev);
          selection->frame->GetPart(ev)->WritePartInfo(ev, (ODPtr)fPartInfo, suView);
          delete suView;

          // *** (optional) save offset between mousedown pt and topLeft pt of selection

          // assuming event->where is in window coordinates.
          _mouseStart = ODPoint(odptlMouse);

#if 1 // (CED - 110594)
          ODPoint botLeft;       // elsewhere refered to as topLeft (Mac heratige)
          ODPoint offset(odptlMouse);  // offset of mouse in window coords

          selection->transform->GetOffset(ev, &botLeft);

          // botLeft contains offset of frame being dragged in my frame coords.

          offset = facet->GetWindowFrameTransform(ev)->InvertPoint(ev, &offset);

          // offset contains the offset of the mouse in my frame coords

          offset.x -= botLeft.x;
          offset.y -= botLeft.y;

          // offset contains offset of mouse relative to position of frame
          // being dragged in my frame coords (same coords as frame shape).

          unit->AddProperty(ev, kPropMouseDownOffset)->AddValue(ev, kODPoint);
          unit->SetValue(ev, sizeof(mdOffset), (ODValue) &offset);
#else
          ODFrameFacetIterator* faceti = selection->frame->CreateFacetIterator(ev);
          //Point topLeft = faceti->First(ev)->GetWindowFrameTransform(ev)->GetQDOffset(ev);
          ODPoint topLeft;
          faceti->First(ev)->GetWindowFrameTransform(ev)->GetOffset(ev, &topLeft);

          facet->GetWindow(ev)->GetFacetUnderPoint( ev, &(_mouseStart) );

          mdOffset = odptlMouse;

             ODPOINTL odplTL(topLeft);
             mdOffset.x -= odplTL.x;
             mdOffset.y -= odplTL.y;

             unit->AddProperty(ev, kPropMouseDownOffset)->AddValue(ev, kOS2POINTL);
             unit->SetValue(ev, sizeof(mdOffset), (ODValue) &mdOffset);
#endif
          // *** (optional) if dragging one frame, save its external transform (not aggregate)

#if 1 // (CED - 110594)
             ODMatrix m;
             selection->transform->GetMatrix(ev, &m);
             unit->AddProperty(ev, kODPropExternalTransform)->AddValue(ev, kODTransform);
             unit->SetValue(ev, sizeof(m), (ODValue) &m);
#else
             unit->AddProperty(ev, kODPropExternalTransform)->AddValue(ev, kOS2POINTL);
             unit->SetValue(ev, sizeof(odplTL), (ODValue) &odplTL);
#endif
          // *** if dragging one frame, write its shape   [jpa]

          unit->AddProperty(ev, kODPropFrameShape);
          selection->frame->GetFrameShape(ev)->WriteShape(ev, unit);

          selection->frame->SetDragging(ev, kODTrue);

          dropResult = dad->StartDrag(ev, facet->GetFrame(ev), 0, (ODPtr)&dimg, &destPart, &event);

          if ((dropResult == kODDropCopy) || (dropResult == kODDropMove))
          {
             if (destPart)
             {
                // The frame was dropped in the same document
                if (destPart == somSelf)
                {
                   beepprintf("debuginfo: cntnrprt: drag was copied/moved to the same parent");
                   // If this was a move to the same part
                   facet->GetFrame(ev)->Invalidate(ev, NULL);
                   selection->frame->SetDragging(ev, kODFalse);
                }
                else
                {
                   beepprintf("debuginfo: cntnrprt: drag was copied/moved to a different parent");
                   //<crs> - it was alway's forcing a move ??
                   if ( dropResult == kODDropMove )
                      {
                      // This was a move to a different part
                      ODPart *oldPart = selection->frame->GetPart(ev);
                      oldPart->IncrementRefCount(ev);
                      facet->GetFrame(ev)->Invalidate(ev, NULL);
                      somSelf->InvalidateSelection(ev, selection->frame);
                      somSelf->EmptySelection(ev);

                      ODxOrderedCollection* tempFacets = new ODxOrderedCollection;

                      ODFrameFacetIterator* facets = selection->frame->CreateFacetIterator(ev);
                      for (ODFacet* f1 = facets->First(ev);
                            facets->IsNotComplete(ev);
                            f1 = facets->Next(ev))
                      {
                         tempFacets->AddLast(f1);
                      }
                      delete facets;

                      ODxOrderedCollectionIterator t(tempFacets);
                      for (ODFacet* f2 = (ODFacet*)t.First();
                            t.IsNotComplete();
                            f2 = (ODFacet*)t.Next())
                      {
                         f2->GetContainingFacet(ev)->RemoveFacet(ev, f2);
                         ODDeleteObject(f2);
                      }
                      delete tempFacets;

                      somSelf->RemoveEmbeddedFrame(ev, selection->frame);
                      somSelf->GetStorageUnit(ev)->GetDraft(ev)->SetChangedFromPrev(ev);
                      }
                   else
                      {
                      selection->frame->SetDragging(ev, kODFalse);
                      } //<crs> end
                }
             }
             else
             {
                // The frame was dropped in a different document
                selection->frame->SetDragging(ev, kODFalse);
             }

             handled = kODTrue;
          }
          else
          {
                beepprintf("debug info: cntnrprt: drag was copied/moved to a null document");
             selection->frame->SetDragging(ev, kODFalse);
          }
       } else {
          // some other button used.  Undefined action.
       } /* endif */

       return handled;
   }


   SOM_Scope ODBoolean  SOMLINK ContainerPartHandleMouseDownEdgeResize(ContainerPart *somSelf,
                                                                     Environment *ev,
                                                                    ODFacet* facet,
                                                                    Proxy* selection,
                                                                    POINTL* mouse)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartHandleMouseDownEdgeResize");

       ODSLong fs;
       Rect selectRect;
       GpiQueryRegionBox(_hpsMem, _fSelectRgn, &selectRect);
       InflateRect(&selectRect, -kODBorderWidth, -kODBorderWidth);

       if      (mouse->y >= selectRect.yTop)    fs = TF_TOP;
       else if (mouse->x <= selectRect.xLeft)   fs = TF_LEFT;
       else if (mouse->y <= selectRect.yBottom) fs = TF_BOTTOM;
       else if (mouse->x >= selectRect.xRight)  fs = TF_RIGHT;

       somSelf->MoveResize(ev, facet, selection, fs);

       return kODTrue;
   }


   SOM_Scope ODBoolean  SOMLINK ContainerPartHandleMouseDownCornerResize(ContainerPart *somSelf,
                                                                       Environment *ev,
                                                                      ODFacet* facet,
                                                                      Proxy* selection,
                                                                      POINTL* mouse)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartHandleMouseDownCornerResize");

       ODSLong fs;
       Rect selectRect;
       GpiQueryRegionBox(_hpsMem, _fSelectRgn, &selectRect);

       Point center = {(selectRect.xRight + selectRect.xLeft) / 2 ,
                       (selectRect.yBottom + selectRect.yTop) / 2 };

       if      ((mouse->y <= center.y) && (mouse->x <= center.x)) fs = TF_BOTTOM | TF_LEFT;
       else if ((mouse->y <  center.y) && (mouse->x >  center.x)) fs = TF_BOTTOM | TF_RIGHT;
       else if ((mouse->y >  center.y) && (mouse->x <  center.x)) fs = TF_TOP | TF_LEFT;
       else if ((mouse->y >  center.y) && (mouse->x >  center.x)) fs = TF_TOP | TF_RIGHT;

       somSelf->MoveResize(ev, facet, selection, fs);

       return kODTrue;
   }


   SOM_Scope ODBoolean  SOMLINK ContainerPartHandleMouseDownInEmbeddedFrame(ContainerPart *somSelf,
                                                                          Environment *ev,
                                                                         ODFacet* container,
                                                                         ODFacet* facet,
                                                                         ODPoint* where,
                                                                         ODEventData* event)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartHandleMouseDownInEmbeddedFrame");

       somSelf->ActivateFrame(ev, container->GetFrame(ev));
       Proxy* p = somSelf->ProxyForFrame(ev, facet->GetFrame(ev));

       switch (_fSelection->Count())
       {
          case 0:
             if ( event->msg != WM_BUTTON2DOWN ) {
                _fSelection->AddFirst((ElementType)p);
                somSelf->CreateProxySelectionBorder(ev, container, p);
                somSelf->ClipEmbeddedFrames(ev, container->GetFrame(ev));
                somSelf->InvalidateSelection(ev, container->GetFrame(ev));
             } /* endif */
             break;

          case 1:
             if ( event->msg != WM_BUTTON2DOWN ) {
                somSelf->InvalidateSelection(ev, container->GetFrame(ev));
                #if 1
                   somSelf->EmptySelection( ev );
                #else
                   _fSelection->RemoveFirst();
                #endif
                _fSelection->AddFirst((ElementType)p);
                somSelf->CreateProxySelectionBorder(ev, container, p);
                somSelf->ClipEmbeddedFrames(ev, container->GetFrame(ev));
                somSelf->InvalidateSelection(ev, container->GetFrame(ev));
             } /* endif */
             break;

          default:
             // !!! handle multiple selection
             break;
       }

       somSelf->InvalidateSelection(ev, container->GetFrame(ev));

       return kODTrue;
   }


   SOM_Scope ODBoolean  SOMLINK ContainerPartHandleKeyDown(ContainerPart *somSelf,
                                                         Environment *ev,
                                                        ODFrame* focusFrame,
                                                        ODEventData* event)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartHandleKeyDown");

       ODBoolean handled = kODFalse;

       if ((SHORT1FROMMP(event->mp1) & KC_VIRTUALKEY) &&
           (SHORT2FROMMP(event->mp2) == VK_DELETE))
       {
          handled = somSelf->DoClear(ev, focusFrame);
       }
       else if (SHORT1FROMMP(event->mp2) == '/' &&
                SHORT1FROMMP(event->mp1) & KC_ALT)
       {
          handled = somSelf->MoveToFront(ev, focusFrame);
       }
       else if (SHORT1FROMMP(event->mp2) == '\\' &&
                SHORT1FROMMP(event->mp1) & KC_ALT)
       {
          handled = somSelf->MoveToBack(ev, focusFrame);
       }
       else if (SHORT1FROMMP(event->mp2) == '/' &&
                SHORT1FROMMP(event->mp1) & KC_CTRL)
       {
          handled = somSelf->MoveForward(ev, focusFrame);
       }
       else if (SHORT1FROMMP(event->mp2) == '\\' &&
                SHORT1FROMMP(event->mp1) & KC_CTRL)
       {
          handled = somSelf->MoveBackward(ev, focusFrame);
       }
       return handled;
   }


   SOM_Scope ODBoolean  SOMLINK ContainerPartHandleMenuEvent(ContainerPart *somSelf,
                                                           Environment *ev,
                                                          ODFrame* focusFrame,
                                                          ODEventData* event)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartHandleMenuEvent");

       ODBoolean handled = kODFalse;
       ODCommandID command = LONGFROMMP(event->mp1);

       switch (command)
       {
          case IDMA_COLOR_GRAY      :
          case IDMA_COLOR_RED       :
          case IDMA_COLOR_GREEN     :
          case IDMA_COLOR_YELLOW    :
          case IDMA_COLOR_BLUE      :
          case IDMA_COLOR_MAGENTA   :
          case IDMA_COLOR_CYAN      :
          case IDMA_COLOR_WHITE     :
             {  //!!! This whole method do with some cleanup
                // Change SetBGColor to use a command number
                somSelf->SetBGColor1(ev, focusFrame, command);
                handled = kODTrue;
             }
             break;

          case IDMA_FREEZE:
             {
               Proxy* p;
               ODxOrderedCollectionIterator i(_fSelection);
               for (p = (Proxy*) i.First(); i.IsNotComplete(); p = (Proxy*) i.Next())
               {
                  p->frame->SetFrozen(ev, true);
               }
             }
             break;

          case IDMA_THAW:
             {
               Proxy* p;
               ODxOrderedCollectionIterator i(_fSelection);
               for (p = (Proxy*) i.First(); i.IsNotComplete(); p = (Proxy*) i.Next())
               {
                  p->frame->SetFrozen(ev, false);
               }
             }
             break;
          case IDMA_DELETE     :
                  somSelf->DoClear(ev, focusFrame);
                  break;
          case IDMA_CUT       :
                  somSelf->DoCut(ev, focusFrame);
                  break;
          case IDMA_COPY      :
                  somSelf->DoCopy(ev, focusFrame);
                  break;
          case IDMA_PASTE     :
                  somSelf->DoPaste(ev, focusFrame);
                  break;
          case IDMA_MOVETOFRONT :
                  somSelf->MoveToFront(ev, focusFrame);
                  break;
          case IDMA_MOVETOBACK  :
                  somSelf->MoveToBack(ev, focusFrame);
                  break;
          case IDMA_MOVEFORWARD :
                  somSelf->MoveForward(ev, focusFrame);
                  break;
          case IDMA_MOVEBACKWARD:
                  somSelf->MoveBackward(ev, focusFrame);
                  break;
          case IDMR_PRINT :
                  somSelf->HandlePrinting(ev,  focusFrame );
                  break;
          case IDMA_CNT_DEMOITEM1:
          case IDMR_ROOTITEM1:
                  _DemoState++;
                  break;
//+(rlt 3-8-95)
          case IDMA_TOGGLE_GRID:
           {  
           PartInfoRec* pInfo = (PartInfoRec*) focusFrame->GetPartInfo(ev);
                if (pInfo->fGridOn) pInfo->fGridOn = kODFalse;
                  else  pInfo->fGridOn = kODTrue;
                focusFrame->SetPartInfo(ev, (ODInfoType) pInfo);
                focusFrame->Invalidate(ev, kODNULL);
           }
                break;      

          case IDMA_SA_LICONS:
             {
               Proxy* p;
               ODxOrderedCollectionIterator i(_fSelection);
               for (p = (Proxy*) i.First(); i.IsNotComplete(); p = (Proxy*) i.Next())
               {
                  p->frame->ChangeViewType(ev, _fSession->Tokenize(ev, kODViewAsLargeIcon));
               }
             }
                  break;

          case IDMA_SA_SICONS:
             {
               Proxy* p;
               ODxOrderedCollectionIterator i(_fSelection);
               for (p = (Proxy*) i.First(); i.IsNotComplete(); p = (Proxy*) i.Next())
               {
                  p->frame->ChangeViewType(ev, _fSession->Tokenize(ev, kODViewAsSmallIcon));
               }
             }
                  break;

          case IDMA_SA_THUMBNAIL:
             {
               Proxy* p;
               ODxOrderedCollectionIterator i(_fSelection);
               for (p = (Proxy*) i.First(); i.IsNotComplete(); p = (Proxy*) i.Next())
               {
                  p->frame->ChangeViewType(ev, _fSession->Tokenize(ev, kODViewAsThumbnail));
               }
             }
                  break;
               
          case IDMA_SA_FRAME:
             {
               Proxy* p;
               ODxOrderedCollectionIterator i(_fSelection);
               for (p = (Proxy*) i.First(); i.IsNotComplete(); p = (Proxy*) i.Next())
               {
                  p->frame->ChangeViewType(ev, _fSession->Tokenize(ev, kODViewAsFrame));
               }
             }
                  break;
//-
          case IDMA_CNT_SETTINGS:
                  _fNotebook->Display(ev);
                  break;
          default:
                if((command >= (IDMA_CNT_SELECTEDREMAP_FIRST)) && (command <= IDMA_CNT_SELECTEDREMAP_LAST) ) {
                   // The menu item selected was provided by the selected part.  We have
                   //    remapped those ID's, and now we'll need to map them back and
                   //    forward the event.
                   ODActiveFrameMenuBar * mb;
                   #ifdef USE_PARTINFO_TO_RECALL_AMENU
                      PartInfoRec* pInfo = (PartInfoRec *) focusFrame->GetPartInfo(ev);
                      mb = pInfo->mbActive;
                   #else
                      mb = (ODActiveFrameMenuBar*)focusFrame->GetWindow(ev)->GetMenuBar( ev);
                   #endif
                   if ( _fRemappedSPEMenuOfSelection ) {
                      ODCommandID commandOld = _fRemappedSPEMenuOfSelection->GetOldMenuID( ev, command );

                      ODEventData eventTmp = *event;
                      eventTmp.mp1 = MPFROMSHORT( commandOld);
   
                      ODMenuBar * SPEMenu = somSelf->GetSPEMenuOfSelection( ev);
                      if (SPEMenu) {
                         return SPEMenu->HandleEvent( ev, &eventTmp );
                      } else {
                         // internal error?
                      } /* endif */
                   } else {
                      // internal error?
                   } /* endif */
                } else if((command < (IDMA_EMBED_BASE+1 + cODMaxEmbedParts)) && (command >=  IDMA_EMBED_BASE+1) )
                   {
                    somSelf->InvalidateSelection(ev, focusFrame);
                    somSelf->EmptySelection(ev);
                    // somSelf->ClipEmbeddedFrames(ev, focusFrame);
                    somSelf->Embed(ev, command, focusFrame, /*newPart:*/kODNULL);
                    handled = kODTrue;
                   }
             break;
       }
       return handled;
   }


   SOM_Scope ODBoolean  SOMLINK ContainerPartHandleMouseMove(ContainerPart *somSelf,
                                                           Environment *ev,
                                                          ODFacet* facet,
                                                          ODFrame* frame,
                                                          ODPoint* where,
                                                          ODEventData* event)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartHandleMouseMove");

       ODBoolean handled = kODFalse;
       RECTL rclBox;

       PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo(ev);
       if (_fTracking)
       {
         ODPOINTL ptlMouse = *where;
         if (!SHORT1FROMMP(event->mp2))     // Mouse still captured?
         {
           somSelf->UpdateTrackRect(ev, &ptlMouse, event->hwnd);
           _ptlEnd = ptlMouse;
         }
         else                            // mouse is no longer captured
         {
           _fSession->GetArbitrator(ev)->RelinquishFocus(ev, _fMouseFocus, frame);
           somSelf->FocusLost(ev, _fMouseFocus, frame);
         }
       }
       else if (facet->GetWindow(ev)->IsActive(ev) )
       {
          if (_fSelection->Count() >= 1)
          {
// (CED - 110594) ODPOINTL ptlMouse = facet->GetWindowContentTransform(ev)->InvertPoint(ev, where);
             ODPOINTL ptlMouse(*where);     // Keep in device coords (CED - 110594)

             if (GpiPtInRegion(_hpsMem, _fCornerHandleRgn, &ptlMouse) == PRGN_INSIDE)
             {
                GpiQueryRegionBox(_hpsMem, _fCornerHandleRgn, &rclBox);
                ptlMouse.x -= (rclBox.xLeft + rclBox.xRight) / 2;
                ptlMouse.y -= (rclBox.yBottom + rclBox.yTop) / 2;
                WinSetPointer(HWND_DESKTOP,
                   WinQuerySysPointer(
                       HWND_DESKTOP,
                       (ptlMouse.x * ptlMouse.y > 0) ? SPTR_SIZENESW : SPTR_SIZENWSE,
                       FALSE));
                handled = kODTrue;
             }
             else if (GpiPtInRegion(_hpsMem, _fEdgeHandleRgn, &ptlMouse) == PRGN_INSIDE)
             {
                GpiQueryRegionBox(_hpsMem, _fCornerHandleRgn, &rclBox);
                ptlMouse.x -= (rclBox.xLeft + rclBox.xRight) / 2;
                ptlMouse.y -= (rclBox.yBottom + rclBox.yTop) / 2;
                WinSetPointer(HWND_DESKTOP,
                   WinQuerySysPointer(
                       HWND_DESKTOP,
                       (abs(ptlMouse.x) > abs(ptlMouse.y)) ? SPTR_SIZEWE : SPTR_SIZENS,
                       FALSE));
                handled = kODTrue;
             }
             else if (GpiPtInRegion(_hpsMem, _fSelectRgn, &ptlMouse) == PRGN_INSIDE)
             {
                WinSetPointer(HWND_DESKTOP,
                   WinQuerySysPointer( HWND_DESKTOP, SPTR_MOVE, FALSE));
                handled = kODTrue;
             }
          }
       }
       return handled;
   }
#endif


   SOM_Scope void SOMLINK ContainerPartUpdateTrackRect(ContainerPart *somSelf,
                                                          Environment *ev,
                                                          POINTL* pptlMouse,
                                                          ODPlatformWindow hwnd)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartUpdateTrackRect");

       HRGN hrgnOld;
       HPS hps = WinGetClipPS(hwnd, 0, PSF_LOCKWINDOWUPDATE);
       GpiSetClipRegion(hps, _hrgnTrackingClip, &hrgnOld);
       GpiSetMix(hps, FM_INVERT);
       GpiMove(hps, &_ptlOrigin);
       GpiBox(hps, DRO_OUTLINE, &_ptlEnd, 0, 0);
       GpiMove(hps, &_ptlOrigin);
       GpiBox(hps, DRO_OUTLINE, pptlMouse, 0, 0);
       GpiSetClipRegion(hps, 0, &hrgnOld);
       WinReleasePS(hps);
   }

   SOM_Scope void SOMLINK ContainerPartMouseFocusLost(ContainerPart *somSelf,
                                                       Environment *ev,
                                                       ODFrame* ownerFrame)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartMouseFocusLost");

       HWND hwndFrame = ownerFrame->GetWindow(ev)->GetPlatformWindow(ev);
       HWND hwndClient = WinWindowFromID(hwndFrame, FID_CLIENT);
       somSelf->UpdateTrackRect(ev, &_ptlOrigin, hwndClient);
       _fTracking = kODFalse;
       if (_hrgnTrackingClip)
       {
          GpiDestroyRegion(_hpsMem, _hrgnTrackingClip);
         _hrgnTrackingClip = 0;
       }
       if (WinQueryCapture(HWND_DESKTOP) == hwndClient)
         WinSetCapture(HWND_DESKTOP, 0);

       WinLockWindowUpdate(HWND_DESKTOP, 0);
   }

//------------------------------------------------------------------------------
//  PRINTING  PRINTING  PRINTING  PRINTING  PRINTING  PRINTING  PRINTING
//------------------------------------------------------------------------------
typedef struct {
  USHORT size, dummy;
  PSZ    szQueue;
} PRNDLGINFO , *PPRNDLGINFO;

#define PRINT_QUEUE_LENGTH 100


ULONG _System ViewPrintGetQueue( HWND hwnd, PSZ szQueue) { NOTDONE2("ViewPrintGetQueue"); return 0; };
#if 0
   ULONG _System ViewPrintGetQueue( HWND hwnd, PSZ szQueue)
   { ULONG rc=0;
     //HWND  hwnd = FrameToWindow( frame, fSession );
     if (hwnd) {
       PRNDLGINFO pdi;
       HMODULE hmod = 0;
       DosQueryModuleHandle( THISDLL, &hmod);
       pdi.size = sizeof(PRNDLGINFO);
       pdi.szQueue = szQueue;
       rc = WinDlgBox( HWND_DESKTOP, hwnd,
                       ViewPrintDefDlgProc, hmod, ID_PRINT, &pdi ) ? 0 : 1;
     } else {
       rc = ViewPrintGetDefQueue( szQueue );
     } /* endif */
     return(rc);
   }
#endif

static HDC _Optlink printer_HDC( PSZ szQueue ) { return (HDC)0; NOTDONE2("printer_HDC"); };
#if 0
   static HDC _Optlink printer_HDC( PSZ szQueue )
   {
     HDC          hdc;
     PPRQINFO3    prq;                    // pointer to PRQINFO3 struct
     DEVOPENSTRUC DevData;                // Printer DevOpen
     CHAR         szDDName[81];           // Buffer for driver full name

     if ( (prq = QueueInfoBlock(szQueue)) != NULL ) {
       StrToken( szDDName, prq->pszDriverName, '.', 1 );
       DevData.pszQueueProcName  = prq->pszPrProc;          // pick up PMPLOT!!
       DevData.pdriv = prq->pDriverData;
     } else {
       szDDName[0] = '\0';
       DevData.pszQueueProcName = NULL;
       DevData.pdriv = NULL;
     } /* endif */

     DevData.pszLogAddress      = szQueue   ;
     DevData.pszDriverName      = szDDName  ;
     DevData.pszDataType        = "PM_Q_STD";
     DevData.pszComment         = "OpenDoc";
     DevData.pszQueueProcParams = "COL=C"   ;
     DevData.pszSpoolerParams   = NULL      ;
     DevData.pszNetworkParams   = NULL      ;

     hdc = DevOpenDC( (HAB)0, OD_QUEUED, "*", 9L,
                      (PDEVOPENDATA)&DevData, (HDC)NULL );

     if ( prq ) delete prq;
     return hdc;
   }
#endif

#if 1
   SOM_Scope ODBoolean  SOMLINK ContainerPartHandlePrinting(ContainerPart *somSelf,
                                                Environment *ev,
                                               ODFrame* frame)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartHandlePrinting");

       ULONG   rc=0;
       SIZEL   szlPrn;
       PRNINFO PI;
       CHAR    szQueue[PRINT_QUEUE_LENGTH];
       //LogFlow(C_ENTER, ("ViewPrint: self=%p, options=%#X", (PVOID)somSelf, flOptions));
       if (somThis) {
         memset(&PI,0,sizeof(PRNINFO));
         rc = ViewPrintGetQueue( frame->GetWindow( ev)->GetPlatformWindow( ev), szQueue );
         if (!rc) {
            PI.hdc = printer_HDC(szQueue);
            if (PI.hdc) {
               szlPrn.cx = szlPrn.cy = 0;
               PI.hps = GpiCreatePS( (HAB)0, PI.hdc, &szlPrn,
                                     /*PU_TWIPS*/ PU_PELS | GPIT_NORMAL | GPIA_ASSOC );
               if (PI.hps) {
                  GpiQueryPS( PI.hps, &szlPrn );
               } else {
                  rc=2;                              // get hps failure
               } /* endif */
            } else {
               rc=1;                                 // get hdc failure
            } /* endif */
         } /* endif */
         if ( !rc ) {
           // STARTDOC
           if ( DevEscape( PI.hdc, DEVESC_STARTDOC,
                           (LONG)strlen("test"), "test", NULL, NULL ) == DEV_OK ) {
             // set up bounds
             PI.bounds.xLeft = PI.bounds.yBottom =  0;
             PI.bounds.xRight = szlPrn.cx-1;
             PI.bounds.yTop = szlPrn.cy-1;
             PI.pagenum = 1;
             //PI.somMaster = somSelf;
             rc = somSelf->PrintPages( ev, frame, &PI );
             DevEscape( PI.hdc, DEVESC_ENDDOC, 0, NULL, NULL, NULL );
             #if 0
                if (!rc) {
                  HWND hwnd = /*_ViewQueryWindow()*/ frame->GetWindow( ev)->GetPlatformWindow( ev);
                  if (hwnd) {
                    CHAR szInfo[80];
                    sprintf(szInfo, "Error printing to %s, page %d", szQueue, PI.pagenum );
                    WinMessageBox( HWND_DESKTOP, hwnd, szInfo,
                                  "OpenDoc container part printing", 0, MB_OK | MB_MOVEABLE);
                  } /* endif */
                } /* endif */
             #endif
           } else {
             rc=3;                                 // STARTDOC failure
           } /* endif */
         } /* endif */
         if (PI.hps) {
            GpiDestroyPS( PI.hps );
         } /* endif */
         if (PI.hdc) {
            DevCloseDC( PI.hdc );
         } /* endif */
       } else {
         rc=4;                                     // NULL somSelf
       } /* endif */

       return kODTrue;
   }

   SOM_Scope ODFacet*  SOMLINK ContainerPartBeginPrinting(ContainerPart *somSelf,
                                              Environment *ev, ODFrame* rootFrame,
                                             PRNINFO* pPI)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartBeginPrinting");

       ODTransform* xtransform = new ODTransform;

       ODShape* clipshape = new ODShape;
       ODRect cliprect(downcastToODRECTL(pPI->bounds));

       clipshape->SetRectangle(ev, &cliprect);

       ODCanvas* prCanvas = new ODCanvas;
       prCanvas->InitCanvas(ev, kODGPI, (ODPlatformCanvas)pPI->hps, kODFalse, kODFalse);

       ODFacet* prFacet = new ODFacet;
       prFacet->InitFacet(ev, rootFrame, clipshape, xtransform, /*(rootpart)*/kODNULL);
       prFacet->SetCanvas(ev, prCanvas);  // jys says this should go before InitFacet, as soon
                                      //   as we have facet windows.  Right now, this remains
                                      //   here because it traps if moved.


       rootFrame->FacetAdded(ev, prFacet);

       return prFacet;
   }

   SOM_Scope void  SOMLINK ContainerPartPrintPage(ContainerPart *somSelf,  Environment *ev,
                                     ODFacet* prFacet, ODUShort pagenum,
                                     PRNINFO* pPI)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartPrintPage");

       ODRect bbox;

       prFacet->GetFrame(ev)->GetFrameShape(ev)->GetBoundingBox(ev, &bbox);
       ODRECTL frect = bbox;

       ODULong height = bbox.top;
       ODULong width  = bbox.right;

       ODPoint    pt = {0,0};
       ODUShort   locator = pagenum-1;

       int height_in_pages = 1 + ((bbox.top-1) / (pPI->bounds.yTop));
       pt.y =  height - (1 + (locator % height_in_pages)) * pPI->bounds.yTop;
       pt.x =  (locator / height_in_pages)    * pPI->bounds.xRight;

       ODTransform* xtransform = new ODTransform;

       xtransform->MoveBy(ev, &pt);

       //Rect pagerect = (**fPrintRecord).prInfo.rPage;

       ODShape* clipshape = new ODShape;
       ODShape* invalshape = new ODShape;
       ODRect cliprect(downcastToODRECTL(pPI->bounds));

       clipshape->SetRectangle(ev, &cliprect);
       invalshape->CopyFrom(ev, clipshape);
       clipshape->Transform(ev, xtransform);
       xtransform->Invert(ev);
       prFacet->ChangeGeometry(ev, clipshape, xtransform);

       prFacet->Update(ev, invalshape);
   }

   SOM_Scope long  SOMLINK ContainerPartPrintPages(ContainerPart *somSelf,
                                                    Environment *ev,
                                                   ODFrame* frame,
                                                   PRNINFO* pPI)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartPrintPages");

       #if 1
          NOTDONE2("PrintPages");  // uncomment code and pick up partner functions from
                      //   old .cpp file when get time.
          return 0;
       #else
          ODUShort
                   firstPage,
                   lastPage,
                   realNumberOfPagesinDoc,
                   pageNumber;
          ODFacet*   prFacet;

          if (1/*PrError() == noErr*/)
          {
             realNumberOfPagesinDoc = DetermineNumberOfPagesinDoc(frame, pPI->bounds );

             //numberOfCopies = 1;

             firstPage = 1/*(**fPrintRecord).prJob.iFstPage*/;
             lastPage = realNumberOfPagesinDoc/*(**fPrintRecord).prJob.iLstPage*/;

             if (realNumberOfPagesinDoc < lastPage)
                lastPage = realNumberOfPagesinDoc;

             //for (copies = 1; copies <= numberOfCopies; copies++)
             {

                if (1/*PrError() == noErr*/)
                {
                   TRY
                      prFacet = this->BeginPrinting(frame, pPI);
                      THROW_IF_NULL(prFacet);

                      pageNumber = firstPage;
                      while (pageNumber <= lastPage /*&& PrError() == noErr*/)
                      {
                         LONG lOut=0;
                         LONG rc = 0;
                         this->PrintPage(prFacet, pageNumber, pPI);
                         if (DevEscape( pPI->hdc, DEVESC_NEWFRAME,
                                      0, NULL, &lOut, (PBYTE)&rc ) != DEVESC_ERROR ) {
                            // no particular action
                         }
                         pageNumber++;
                      }

                      this->EndPrinting(prFacet);
                   CATCH_ALL
                      // garbage collection needs to be improved
                   ENDTRY

                }
             }
          }

          return 0; // no error
       #endif
   }

   SOM_Scope void  SOMLINK ContainerPartEndPrinting(ContainerPart *somSelf,  Environment *ev,
                                       ODFacet* prFacet)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartEndPrinting");

       ODCanvas* prCanvas = prFacet->GetCanvas(ev);

       prFacet->GetFrame(ev)->FacetRemoved(ev, prFacet);

       delete prCanvas;
       delete prFacet;
   }

   SOM_Scope ODBoolean  SOMLINK ContainerPartDoCut(ContainerPart *somSelf,  Environment *ev,
                                      ODFrame* frame)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartDoCut");

       NOTDONE2("DoCut");
       return kODFalse;
   }

   SOM_Scope ODBoolean  SOMLINK ContainerPartDoCopy(ContainerPart *somSelf,  Environment *ev,
                                       ODFrame* frame)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartDoCopy");

       NOTDONE2("DoCopy");
       return kODFalse;
   }

   SOM_Scope ODBoolean  SOMLINK ContainerPartDoPaste(ContainerPart *somSelf,
                                         Environment *ev, ODFrame* frame)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartDoPaste");

       NOTDONE2("DoPaste");
       return kODFalse;
   }

   SOM_Scope ODBoolean  SOMLINK ContainerPartDoPasteLink(ContainerPart *somSelf,
                                             Environment *ev, ODFrame* frame)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartDoPasteLink");

       NOTDONE2("DoPasteLink");
       return kODFalse;
   }

   SOM_Scope ODBoolean  SOMLINK ContainerPartDoClear(ContainerPart *somSelf,
                                         Environment *ev, ODFrame* frame)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartDoClear");

       Proxy* p;
       ODxOrderedCollectionIterator i(_fSelection);
       for (p = (Proxy*) i.First(); i.IsNotComplete(); p = (Proxy*) i.Next())
       {
          p->frame->Invalidate(ev, NULL);

          /* Make a copy of the frame's facet collection so that we can  */
          /* iterate through the copy.  The reason for this is that when */
          /* we call RemoveFacet, the facet is removed from the frame's  */
          /* collection of facet's thereby invalidating the iterator     */
          /* cursor.  By iterating through the copy collection, we avoid */
          /* this side effect.                                           */

          ODxOrderedCollection* tempFacets = new ODxOrderedCollection;

          ODFrameFacetIterator* facets = p->frame->CreateFacetIterator(ev);
          for (ODFacet* f1 = facets->First(ev);
                facets->IsNotComplete(ev);
                f1 = facets->Next(ev))
          {
             tempFacets->AddLast(f1);
          }
          delete facets;

          ODxOrderedCollectionIterator t(tempFacets);
          for (ODFacet* f2 = (ODFacet*)t.First();
                t.IsNotComplete();
                f2 = (ODFacet*)t.Next())
          {
             f2->GetContainingFacet(ev)->RemoveFacet(ev, f2);
             ODDeleteObject(f2);
          }
          delete tempFacets;
          somSelf->RemoveEmbeddedFrame(ev, p->frame);
       }
       somSelf->InvalidateSelection(ev, frame);
       somSelf->EmptySelection(ev);
       somSelf->ClipEmbeddedFrames(ev, frame);
       somSelf->GetStorageUnit(ev)->GetDraft(ev)->SetChangedFromPrev(ev);
       return kODTrue;
   }

   SOM_Scope ODBoolean  SOMLINK ContainerPartDoSelectAll(ContainerPart *somSelf,
                                             Environment *ev, ODFrame* frame)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartDoSelectAll");

       NOTDONE2("DoSelectAll");
       return kODFalse;
   }

   SOM_Scope void  SOMLINK ContainerPartActivateFrame(ContainerPart *somSelf,
                                          Environment *ev, ODFrame* frame)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartActivateFrame");

       if (frame != kODNULL) {
          PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo(ev);
          if (!(pInfo->fIsActive))
          {
            ODBoolean succeeded = false;

            succeeded = _fSession->GetArbitrator(ev)->RequestFocusSet(ev, _fFocusSet,frame);

            if (succeeded)
            {
               somSelf->FocusAcquired(ev, _fSelectionFocus, frame);
               somSelf->FocusAcquired(ev, _fMenuFocus, frame);
               somSelf->FocusAcquired(ev, _fKeyFocus, frame);
            }
          }
       }
   }

   SOM_Scope void  SOMLINK ContainerPartDeActivateFrame(ContainerPart *somSelf,
                                            Environment *ev, ODFrame* frame)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartDeActivateFrame");

       if (frame != kODNULL) {
          _fSession->GetArbitrator(ev)->RelinquishFocusSet(ev, _fFocusSet,frame);
          somSelf->FocusLost(ev, _fSelectionFocus, frame);
          somSelf->FocusLost(ev, _fMenuFocus, frame);
          somSelf->FocusLost(ev, _fKeyFocus, frame);
       }
   }

   SOM_Scope void  SOMLINK ContainerPartActivatingWindow(ContainerPart *somSelf,
                                             Environment *ev, ODFrame* frame)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartActivatingWindow");

       PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo(ev);
       if (pInfo->fNeedsActivating)
       {
          somSelf->ActivateFrame(ev, frame);
          //somSelf->ShowPalette(ev);
          pInfo->fNeedsActivating = kODFalse;
       }
   }

   SOM_Scope void  SOMLINK ContainerPartDeActivatingWindow(ContainerPart *somSelf,
                                               Environment *ev,
                                              ODFrame* frame)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartDeActivatingWindow");

       PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo(ev);
       if (frame == _fSession->GetArbitrator(ev)->GetFocusOwner(ev, _fSelectionFocus))
       {
          pInfo->fNeedsActivating = kODTrue;
          if (_fTracking)
          {
            _fSession->GetArbitrator(ev)->RelinquishFocus(ev, _fMouseFocus, frame);
            somSelf->FocusLost(ev, _fMouseFocus, frame);
          }
          //somSelf->DeActivateFrame(ev, frame);
       }
       else
          pInfo->fNeedsActivating = kODFalse;
   }


   int ExtractMenuPartStrings( char * fullstring , char * * dllstring , int * dllstringlength , char * * descripstring );
   #if 1
      int ExtractMenuPartStrings( char * fullstring
                                                , char * * dllstring
                                                , int * dllstringlength
                                                , char * * descripstring
                                                )
      {
         char * tempstr = fullstring;
         while ((*tempstr) && (tempstr[0]==' ')) tempstr++;
         if (!*tempstr) return 1;  // skip this line. has no contents
         *dllstring = tempstr;
         tempstr = strchr(tempstr, ' ' );
         if (tempstr) {
            *dllstringlength = tempstr - *dllstring;
            while ((*tempstr) && (tempstr[0]==' ')) tempstr++;
            if (*tempstr) {
               *descripstring = tempstr;
            } else {
               *descripstring = *dllstring;
            } /* endif */
         } else {
            *descripstring = *dllstring;
            *dllstringlength = strlen(*dllstring);
         } /* endif */
         return 0;
      }
   #endif

   void CollectHandlers( Environment *ev, ODSession * pSession );
   #if 1
      void CollectHandlers( Environment *ev, ODSession * pSession )
      {
         if (!mbPartHandlers) {
            ODMenuBar * mbNew = new ODMenuBar;
            mbNew->InitMenuBar(ev, pSession, 0);
            FILE* partsFile = fopen("parts.dat", "r");
            char inbuf[60];
            ODPlatformMenuItem mi;
            mi.afAttribute = 0;
            mi.afStyle = MIS_TEXT;
            mi.hwndSubMenu = 0;

            for( int i = 0; i < cODMaxEmbedParts
                            && fgets( inbuf, sizeof(inbuf), partsFile); i++)
            {
               char *ptr;
               char *dllstring;
               char *descripstring;
               int  dllslen;
               if(ptr = strchr(inbuf, '\n')) *ptr = '\0';
               int rc = ExtractMenuPartStrings( inbuf
                                           , &dllstring
                                           , &dllslen
                                           , &descripstring
                                           );
               if (rc) {
                  i--;  // skip this one bogus entry
               } else {
                  dllstring[dllslen] = 0;
                  strcpy( partStrings[i], dllstring);
                  mi.id = i+IDMA_EMBED_BASE+1;
                  mi.hItem = (ULONG)descripstring;
                  mbNew->AddItemLast( ev, &mi, ODMENUID_ROOT );
               } /* endif */
            } /* endif */
            fclose(partsFile);
            mbPartHandlers = mbNew;
         } /* endif */
      }
   #endif

   SOM_Scope void  SOMLINK ContainerPartInstallMenus(ContainerPart *somSelf,
                                         Environment *ev, ODFrame* aFrame)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartInstallMenus");

       #if 1
          #ifdef _PLATFORM_OS2_
             ODActiveFrameMenuBar * mb = new ODActiveFrameMenuBar;
             mb->InitMenuBar( ev, _fSession, kODNULL);
             mb->SetOwner( ev, aFrame );

             #ifdef USE_PARTINFO_TO_RECALL_AMENU
                PartInfoRec* pInfo = (PartInfoRec *) aFrame->GetPartInfo(ev);
                if (!pInfo)
                {  pInfo = new PartInfoRec;
                  aFrame->SetPartInfo(ev, (ODInfoType) pInfo);
                }
                pInfo->mbActive = mb;
             #endif

             ODWindow * window = aFrame->GetWindow( ev);
             window->SetMenuBar( ev, mb );
             mb->Release(ev);  // when SetMenuBar is called again, it will be deleted
          #else
             if (aFrame && _fMenuBar)
               _fMenuBar->Display(ev);
          #endif
       #endif
   }

   SOM_Scope void  SOMLINK ContainerPartRemoveMenus(ContainerPart *somSelf,  Environment *ev,
                                       ODFrame* aFrame)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartRemoveMenus");

       #ifdef _PLATFORM_OS2_
          ODWindow * window = aFrame->GetWindow( ev);
          window->SetMenuBar(ev,  0 );
          PartInfoRec* pInfo = (PartInfoRec *) aFrame->GetPartInfo(ev);
          pInfo->mbActive = 0;
       #endif
   }

   SOM_Scope void  SOMLINK ContainerPartUserSetBGColor(ContainerPart *somSelf,
                                           Environment *ev, ODFrame* frame,
                                          RGBColor whichColor)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartUserSetBGColor");

       PartInfoRec* pInfo = (PartInfoRec *) frame->GetPartInfo(ev);
       if (!pInfo)
       {  pInfo = new PartInfoRec;
         frame->SetPartInfo(ev, (ODInfoType) pInfo);
       }
       if (whichColor != pInfo->bgColor)
       {
         ODIText*  undoActionName;
         ODIText*  redoActionName;

         undoActionName = PStrToIntl("Undo Set Color", kODNULL );
         redoActionName = PStrToIntl("Redo Set Color", kODNULL );
         SetBGColorRec* undoRec = new SetBGColorRec(pInfo->bgColor, whichColor,
                               frame);
     #ifndef UNDONEEDSFIXINMAYBE
         _fSession->GetUndo(ev)->AddActionToHistory(ev, somSelf, (ODActionData)undoRec,
                             kODSingleAction,
                             (ODName*)undoActionName,
                             (ODName*)redoActionName);
     #endif
         somSelf->SetBGColor2(ev, frame, whichColor);
       }
   }

   RGBColor RGBColorFromMenuColor( ODUShort whichColor )
   {
       switch (whichColor)
       {
         case  IDMA_COLOR_GRAY   : return  CLR_DARKGRAY  ; break;
         case  IDMA_COLOR_RED    : return  CLR_RED       ; break;
         case  IDMA_COLOR_GREEN  : return  CLR_GREEN     ; break;
         case  IDMA_COLOR_YELLOW : return  CLR_YELLOW    ; break;
         case  IDMA_COLOR_BLUE   : return  CLR_BLUE      ; break;
         case  IDMA_COLOR_MAGENTA: return  CLR_DARKPINK  ; break;
         case  IDMA_COLOR_CYAN   : return  CLR_CYAN      ; break;
         case  IDMA_COLOR_WHITE  : return  CLR_WHITE     ; break;
         default: break;
       }
       return  CLR_PINK;
   }

   ODUShort MenuColorFromRGBColor( RGBColor inColor )
   {
       switch (inColor)
       {
         case  CLR_DARKGRAY  : return  IDMA_COLOR_GRAY   ; break;
         case  CLR_RED       : return  IDMA_COLOR_RED    ; break;
         case  CLR_GREEN     : return  IDMA_COLOR_GREEN  ; break;
         case  CLR_YELLOW    : return  IDMA_COLOR_YELLOW ; break;
         case  CLR_BLUE      : return  IDMA_COLOR_BLUE   ; break;
         case  CLR_DARKPINK  : return  IDMA_COLOR_MAGENTA; break;
         case  CLR_CYAN      : return  IDMA_COLOR_CYAN   ; break;
         case  CLR_WHITE     : return  IDMA_COLOR_WHITE  ; break;
         default: break;
       }
       return IDMA_COLOR_GRAY;
   }

   SOM_Scope void  SOMLINK ContainerPartSetBGColor1(ContainerPart *somSelf,  Environment *ev,
                                       ODFrame* aFrame, ODUShort whichColor)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartSetBGColor1");

       PartInfoRec* pInfo = (PartInfoRec *) aFrame->GetPartInfo(ev);
       if (!pInfo)
       {  pInfo = new PartInfoRec;
         aFrame->SetPartInfo(ev, (ODInfoType) pInfo);
       };

       //RGBColor newColor = pInfo->bgColor;
       RGBColor newColor = RGBColorFromMenuColor( whichColor );

       //switch (whichColor)
       //{
       //  case  IDMA_COLOR_GRAY   : newColor = CLR_DARKGRAY  ; break;
       //  case  IDMA_COLOR_RED    : newColor = CLR_RED       ; break;
       //  case  IDMA_COLOR_GREEN  : newColor = CLR_GREEN     ; break;
       //  case  IDMA_COLOR_YELLOW : newColor = CLR_YELLOW    ; break;
       //  case  IDMA_COLOR_BLUE   : newColor = CLR_BLUE      ; break;
       //  case  IDMA_COLOR_MAGENTA: newColor = CLR_DARKPINK  ; break;
       //  case  IDMA_COLOR_CYAN   : newColor = CLR_CYAN      ; break;
       //  case  IDMA_COLOR_WHITE  : newColor = CLR_WHITE     ; break;
       //  default: break;
       //}
       somSelf->UserSetBGColor(ev, aFrame,newColor);
   }

   SOM_Scope void  SOMLINK ContainerPartSetBGColor2(ContainerPart *somSelf,  Environment *ev,
                                       ODFrame* aFrame, RGBColor whichColor)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartSetBGColor2");

       PartInfoRec* pInfo = (PartInfoRec *) aFrame->GetPartInfo(ev);
       if (!pInfo)
       {  pInfo = new PartInfoRec;
         aFrame->SetPartInfo(ev, (ODInfoType) pInfo);
       }
       if (whichColor != pInfo->bgColor)
       {
         pInfo->bgColor = whichColor;
         somSelf->GetStorageUnit(ev)->GetDraft(ev)->SetChangedFromPrev(ev);
         aFrame->Invalidate(ev, NULL);
       }
   }

   SOM_Scope void  SOMLINK ContainerPartEmbed(ContainerPart *somSelf,  Environment *ev,
                                 short item, ODFrame* frame, ODPart** newPart)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartEmbed");

       ODPart* embeddedPart;
       ODFrame* embeddedFrame;
       ODTransform* externalXForm = new ODTransform;
       ODSLong count = 1 + _fContents->Count();

       ODStorageUnit* su = somSelf->GetStorageUnit(ev);

       #if 1
          #ifdef _PLATFORM_OS2_
             embeddedPart = su->GetDraft(ev)->CreatePart(ev, partStrings[item - (IDMA_EMBED_BASE+1)], kODNULL);
             if(!embeddedPart) {
                //<crs>-12/01/94-display messagebox on error 
                // print error message and return if unable to load dll
                char errmsg[100];
                sprintf(errmsg, "Unable to load module for %s, verify DLL exists and retry!",
                         partStrings[item - (IDMA_EMBED_BASE+1)] );
                WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, errmsg, "Error Information", 0, MB_ERROR | MB_OK);
                delete externalXForm;
                return;
             }
          #else
             switch (item)
             {
               case 1:
                 embeddedPart = su->GetDraft(ev)->CreatePart(ev, kODPartDrawPart,kODNULL);
                 break;
               case 2:
                 embeddedPart = su->GetDraft(ev)->CreatePart(ev, kODPartDragPart,kODNULL);
                 break;
               case 3:
                 embeddedPart = su->GetDraft(ev)->CreatePart(ev, kODPartClockPart,kODNULL);
                 break;
               default:
                 break;
             }
          #endif

          //Point ptTemp;
          //SetPt(&ptTemp,(short)(count*20),(short)(count*20));
          #if 0
             Point ptTemp = {(count*20),(count*20)};
             externalXForm->SetQDOffset(ev, &ptTemp);
          #else
             ODPoint ptTemp = {MAKEFIXED(count*20,0),MAKEFIXED(count*20,0)};
             externalXForm->SetOffset(ev, &ptTemp);
          #endif
          embeddedFrame = somSelf->MakeEmbeddedFrame(ev, frame,
                                 NULL,
                                 externalXForm,
                                 embeddedPart,
                                 kODFalse);

          ODFrameFacetIterator* facets = frame->CreateFacetIterator(ev);
          for (ODFacet* facet = facets->First(ev); facets->IsNotComplete(ev);
              facet = facets->Next(ev))
          {
            ODShape* clip = new ODShape;
            clip->CopyFrom(ev, embeddedFrame->GetFrameShape(ev));
            ODTransform* xform = new ODTransform;
            xform->CopyFrom(ev, somSelf->ProxyForFrame(ev, embeddedFrame)->transform);
            facet->CreateEmbeddedFacet(ev, embeddedFrame, clip, xform, kODNULL, kODFrameInFront);
          }
          delete facets;
          somSelf->ClipEmbeddedFrames(ev, frame);
          frame->Invalidate(ev, NULL);

          if (newPart)
            *newPart = embeddedPart;
          else
            ODReleaseObject(ev,embeddedPart);
       #endif
   }

   SOM_Scope void  SOMLINK ContainerPartSetGrafPortOrigin(ContainerPart *somSelf,
                                              Environment *ev, ODFacet* facet)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartSetGrafPortOrigin");

       #ifdef _PLATFORM_OS2_
          ODTransform* localToGlobal = facet->GetContentTransform(ev);
          HPS hps = facet->GetCanvas(ev)->GetPlatformCanvas(ev);
          MATRIXLF mtx;
          facet->GetContentTransform(ev)->GetMATRIXLF(ev, &mtx);

            #if 0 // debug
               // move this code to learn about Gpi's transforms
               {
                  POINTL ptl;
                  HPS hpsDraw = hps;
                  ptl.y = 0;
                  ptl.x = 0;
                  GpiMove(hpsDraw, &ptl);
                  ptl.x = 300;
                  GpiLine( hpsDraw, &ptl);
                  ptl.y = 300;
                  GpiLine( hpsDraw, &ptl);
                  ptl.x = 500;
                  GpiLine( hpsDraw, &ptl);
                  ptl.y = 500;
                  GpiLine( hpsDraw, &ptl);
                  ptl.x = 700;
                  GpiLine( hpsDraw, &ptl);
                  ptl.y = 700;
                  GpiLine( hpsDraw, &ptl);
                  ptl.x = 800;
                  GpiLine( hpsDraw, &ptl);
                  ptl.y = 800;
                  GpiLine( hpsDraw, &ptl);
                  ptl.x = 900;
                  GpiLine( hpsDraw, &ptl);
                  ptl.y = 900;
                  GpiLine( hpsDraw, &ptl);
                  ptl.x = 1200;
                  GpiLine( hpsDraw, &ptl);
                  ptl.y = 1200;
                  GpiLine( hpsDraw, &ptl);

                  MATRIXLF mlf;
                  GpiQueryModelTransformMatrix( hpsDraw, 9, &mlf );
                  GpiQueryDefaultViewMatrix( hpsDraw, 9, &mlf );
                  GpiQueryViewingTransformMatrix( hpsDraw, 9, &mlf );
                  DosBeep(200, 200);
               }
            #endif
          GpiSetModelTransformMatrix(hps, 9, &mtx, TRANSFORM_REPLACE);
          facet->GetCanvas(ev)->ReleasePlatformCanvas(ev);
       #else
          ODTransform* localToGlobal = facet->GetContentTransform(ev);
          ODPoint offset(0,0);
          offset = localToGlobal->TransformPoint(ev, &offset);
          SetOrigin(-offset.IntX(), -offset.IntY());
       #endif
   }


   SOM_Scope void  SOMLINK ContainerPartInvalEmbedFrameAfterResize(ContainerPart *somSelf,
                                                                 Environment *ev,
                                                                ODFacet* facet,
                                                                Proxy* selection,
                                       // (CED - 110594)        ODShape* oldShape,
                                                                ODShape* newShape,
                                       /* (CED - 110594) */     ODTransform* newTransform)
                                       // (CED - 110594)        POINTL* transOffset)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartInvalEmbedFrameAfterResize");

       // invalidate old frame shape
       ODShape* oldShape = selection->frame->GetFrameShape(ev)->Copy(ev); //(CED - 110594)
       oldShape->Transform(ev, selection->transform);
       facet->GetFrame(ev)->Invalidate(ev, oldShape);
       delete oldShape;                                 // (CED - 110594)

       ODShape* newShapeCopy = new ODShape;
       newShapeCopy->CopyFrom(ev, newShape);    // save to invalidate later

       selection->frame->ChangeFrameShape(ev, newShape);  // already in frame coords

#if 1  // (CED - 110594)
       // if transform has changed then update facets with new transform
       if (!selection->transform->IsSameAs(ev, newTransform))
       {
         selection->transform->CopyFrom(ev, newTransform);
#else
       // if the left or top side of the frame was adjusted, the transform will be updated
       if ((transOffset->x != 0) || (transOffset->y != 0))
       {
         ODPoint ODtransOffset (downcastToODPOINTL(*transOffset));
         selection->transform->MoveBy(ev, &ODtransOffset);
#endif
         _fNeedToExternalize = kODTrue;
         // $$$$$ move facets for selected frame - this is slightly hackish
         ODTransform* newTrans;
         ODFacetIterator* facets =
           facet->GetWindow(ev)->GetRootFacet(ev)->CreateFacetIterator(ev, kODTopDown, kODFrontToBack);
         for (ODFacet* child = facets->First(ev);
             facets->IsNotComplete(ev); child = facets->Next(ev))
         {
           if (child->GetFrame(ev) == selection->frame)
           {
             newTrans = new ODTransform;
             newTrans->CopyFrom(ev, selection->transform);
             child->ChangeGeometry(ev, kODNULL, newTrans);
             facets->SkipChildren(ev);
           }
         }
         delete facets;
       }
       delete newTransform;              // (CED - 110594)

       // invalidate changed areas
       newShapeCopy->Transform(ev, selection->transform);
       facet->GetFrame(ev)->Invalidate(ev, newShapeCopy);
       delete newShapeCopy;

       somSelf->InvalidateSelection(ev, facet->GetFrame(ev));
// (CED - 110594) somSelf->UpdateProxyRegion(ev, selection);
       somSelf->CreateProxySelectionBorder(ev, facet, selection);
       somSelf->ClipEmbeddedFrames(ev, facet->GetFrame(ev));
       somSelf->InvalidateSelection(ev, facet->GetFrame(ev));

       somSelf->GetStorageUnit(ev)->GetDraft(ev)->SetChangedFromPrev(ev);
   }


   SOM_Scope RECTL*  SOMLINK ContainerPartGetSelectionRectLocal(ContainerPart *somSelf,
                                                              Environment *ev,
                                                             Proxy* selection)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartGetSelectionRectLocal");

       //HRGN shapeRgn = selection->frame->GetFrameShape(ev)->GetQDRegion(ev);
       HRGN shapeRgn = selection->frame->GetFrameShape(ev)->GetRegion(ev);
       ODRECTL shapeRect;
       GpiQueryRegionBox(_hpsMem, shapeRgn, &shapeRect);

       ODRECTL * localRect = new ODRECTL(shapeRect);
       //SetRect(localRect, shapeRect.left, shapeRect.top,
        //         shapeRect.right, shapeRect.bottom);

       #if 0
          Point offset = selection->transform->GetQDOffset(ev);
          OffsetRect(&localRect, offset.x, offset.y);
       #else
          ODPoint ptTemp;
          selection->transform->GetOffset(ev, &ptTemp);
          OffsetRect(localRect, ptTemp.x, ptTemp.y);
       #endif

       return localRect;
   }

   #ifdef _PLATFORM_OS2_
      // GetBGColor isn't needed
   #else
      SOM_Scope void  SOMLINK ContainerPartGetBGColor(ContainerPart *somSelf,  Environment *ev,
                                         ODUShort whichColor, RGBColor* newColor)
      {
          ContainerPartData *somThis = ContainerPartGetData(somSelf);
          ContainerPartMethodDebug("ContainerPart","ContainerPartGetBGColor");

      }
   #endif
#endif

SOM_Scope ODFrame*  SOMLINK ContainerPartMakeEmbeddedFrame(ContainerPart *somSelf,
                                                            Environment *ev,
                                                           ODFrame* containingFrame,
                                                           ODShape* frameShape,
                                                           ODTransform* externalTransform,
                                                           ODPart* embedPart,
                                                           ODBoolean isOverlaid)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartMakeEmbeddedFrame");

    ODShape* newShape = NULL;

    // decide what newShape should be - for now, give it what it asked for
    if (frameShape)
    {
      newShape = frameShape;
    }
    else
    {  // no frameShape specified, use a default size
      ODRect rect = { 0, MAKEFIXED(200,0), MAKEFIXED(200,0), 0};
      newShape = new ODShape;
      newShape->SetRectangle(ev, &rect);
    };

    // create the new frame
    // kODNullTypeToken
    ODFrame* newFrame = somSelf->GetStorageUnit(ev)->GetDraft(ev)->
        CreateFrame(ev, containingFrame, newShape, embedPart,
              kODNullTypeToken, kODNullTypeToken, kODFalse,
              isOverlaid);
    _fEmbeddedFrames->AddFirst(newFrame);

# if 0  // (CED - 110594)  No longer using proxy regions
    // create a proxy to hold the embedded frame
    ODShape* scratch = new ODShape;
    scratch->CopyFrom(ev, newShape);
    scratch->Transform(ev, externalTransform);
    //HRGN scratchRgn = scratch->CopyQDRegion(ev);
    HRGN scratchRgn = scratch->CopyRegion(ev);
    delete scratch;
    Proxy* p = new Proxy(scratchRgn, newFrame, externalTransform);  // new for Facets
#else
    Proxy* p = new Proxy( newFrame, externalTransform);  // new for Facets
#endif
    // put proxy into contents, possibly adjusting other content
    _fContents->AddFirst(p);
    _fNeedToExternalize = kODTrue;

    return newFrame;
}

SOM_Scope ODWindow*  SOMLINK ContainerPartCreateWindow(ContainerPart *somSelf,
                                           Environment *ev, ODFrame* sourceFrame)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartCreateWindow");

    #ifdef _PLATFORM_OS2_
       Rect windRect;
       ODPlatformWindow platformWindow = kODNULL;
       ODWindow* window = kODNULL;

       platformWindow = _fSession->CreatePlatformWindow(ev);
       window =  _fSession->GetWindowState(ev)->CreateWindow(ev, platformWindow,
                                            (sourceFrame==kODNULL),  // Keeps draft open
                                            kODTrue,  // Is resizable
                                            kODFalse, // Is floating
                                            kODTrue,  // should save
                                         somSelf, kODNullTypeToken, kODNullTypeToken, sourceFrame);
       return window;
    #else
       Rect windRect;
       ODPlatformWindow platformWindow = kODNULL;
       ODWindow* window = kODNULL;

       if (sourceFrame)
       {
         SetRect(&windRect, 100, 100, 300, 300);
       }
       else
       {
         const  ODSShort    kOnePageWidth = 600;
         // Get the menu bar height, for figuring the top of our windows
         ODSShort  mbHeight  = 24; //(*(ODSShort*)MBarHeight);  //get it from lomem
         SetRect(&windRect, 4, mbHeight+16,
             ODQDGlobals.screenBits.bounds.right - 64,
             ODQDGlobals.screenBits.bounds.bottom - 4);

         if (windRect.right-windRect.left > kOnePageWidth)
         {
           windRect.right = windRect.left + kOnePageWidth;
         }
       }

       Str255 aStr255;
       ODULong maxsize = 32+sizeof(ODName);
       ODName* partName = ODGetPOName( somSelf, kODNULL, &maxsize );
       IntlToPStr(partName,(StringPtr)&aStr255);
       ODDisposePtr(partName);

       platformWindow = NewCWindow(kODNULL, &windRect, aStr255, false, zoomDocProc, (WindowPtr)-1L, true, kODNULL);
       window =  _fSession->GetWindowState(ev)->CreateWindow(ev, platformWindow,
                                (sourceFrame==kODNULL),  // Keeps draft open
                                kODTrue,  // Is resizable
                                kODFalse,  // Is floating
                                kODTrue,  // should save
                              somSelf, kODNullTypeToken, kODNullTypeToken, sourceFrame);

       return window;
    #endif
}

SOM_Scope ODBoolean  SOMLINK ContainerPartMoveToFront(ContainerPart *somSelf,
                                                       Environment *ev,
                                                      ODFrame* frame)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartMoveToFront");

    if (_fSelection->Count() == 1)
    {
       ODxOrderedCollectionIterator i(_fSelection);
       ODxOrderedCollection *tempFacets = new ODxOrderedCollection;
       Proxy* p = (Proxy*) i.First();

       _fEmbeddedFrames->Remove(p->frame);
       _fEmbeddedFrames->AddFirst(p->frame);
       _fContents->Remove(p);
       _fContents->AddFirst(p);
       _fNeedToExternalize = kODTrue;
       ODFrameFacetIterator* facets = p->frame->CreateFacetIterator(ev);
       for (ODFacet* facet = facets->First(ev); facets->IsNotComplete(ev); facet = facets->Next(ev))
       {
          tempFacets->AddFirst(facet);
       }
       ODxOrderedCollectionIterator iter(tempFacets);
       for (facet = (ODFacet*)iter.First();
            iter.IsNotComplete();
            facet = (ODFacet*)iter.Next())
       {
          facet->GetContainingFacet(ev)->MoveBefore(ev, facet, kODNULL);
       }
       somSelf->ClipEmbeddedFrames(ev, frame);
       p->frame->Invalidate(ev, kODNULL);
       somSelf->GetStorageUnit(ev)->GetDraft(ev)->SetChangedFromPrev(ev);

       delete tempFacets;
    }
    return kODTrue;
}

SOM_Scope ODBoolean  SOMLINK ContainerPartMoveToBack(ContainerPart *somSelf,
                                                      Environment *ev,
                                                     ODFrame* frame)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartMoveToBack");

    if (_fSelection->Count() == 1)
    {
       ODxOrderedCollectionIterator i(_fSelection);
       ODxOrderedCollection *tempFacets = new ODxOrderedCollection;
       Proxy* p = (Proxy*) i.First();

       _fEmbeddedFrames->Remove(p->frame);
       _fEmbeddedFrames->AddLast(p->frame);
       _fContents->Remove(p);
       _fContents->AddLast(p);
       _fNeedToExternalize = kODTrue;
       ODFrameFacetIterator* facets = p->frame->CreateFacetIterator(ev);
       for (ODFacet* facet = facets->First(ev); facets->IsNotComplete(ev); facet = facets->Next(ev))
       {
          tempFacets->AddLast(facet);
       }
       ODxOrderedCollectionIterator iter(tempFacets);
       for (facet = (ODFacet*)iter.First();
            iter.IsNotComplete();
            facet = (ODFacet*)iter.Next())
       {
          facet->GetContainingFacet(ev)->MoveBehind(ev, facet, kODNULL);
       }
       p->frame->Invalidate(ev, kODNULL);
       somSelf->ClipEmbeddedFrames(ev, frame);
       somSelf->GetStorageUnit(ev)->GetDraft(ev)->SetChangedFromPrev(ev);

       delete tempFacets;
    }
    return kODTrue;
}

SOM_Scope ODBoolean  SOMLINK ContainerPartMoveForward(ContainerPart *somSelf,
                                                       Environment *ev,
                                                      ODFrame* frame)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartMoveForward");

    if (_fSelection->Count() == 1)
    {
       ODxOrderedCollectionIterator i(_fSelection);
       ODxOrderedCollection *tempFacets = new ODxOrderedCollection;
       Proxy* p = (Proxy*) i.First();

       ODFrame* siblingFrame = (ODFrame*)_fEmbeddedFrames->Before(p->frame);
       if (siblingFrame)
       {
          _fEmbeddedFrames->Remove(p->frame);
          _fEmbeddedFrames->AddBefore(siblingFrame, p->frame);
          Proxy* siblingProxy = (Proxy*)_fContents->Before(p);
          _fContents->Remove(p);
          _fContents->AddBefore(siblingProxy, p);
          _fNeedToExternalize = kODTrue;

          ODFrameFacetIterator* facets = p->frame->CreateFacetIterator(ev);
          for (ODFacet* facet = facets->First(ev); facets->IsNotComplete(ev); facet = facets->Next(ev))
          {
             tempFacets->AddFirst(facet);
          }
          ODxOrderedCollectionIterator iter(tempFacets);
          ODFrameFacetIterator* siblingFacets = siblingFrame->CreateFacetIterator(ev);
          ODFacet* siblingFacet = siblingFacets->First(ev);

          for (facet = (ODFacet*)iter.First();
               iter.IsNotComplete();
               facet = (ODFacet*)iter.Next())
          {
             facet->GetContainingFacet(ev)->MoveBefore(ev, facet, siblingFacet);
             siblingFacet = facet;
          }
          somSelf->ClipEmbeddedFrames(ev, frame);
          p->frame->Invalidate(ev, kODNULL);
          somSelf->GetStorageUnit(ev)->GetDraft(ev)->SetChangedFromPrev(ev);
       }
       delete tempFacets;
    }
    return kODTrue;
}

/*
 * -utilities
 */

SOM_Scope ODBoolean  SOMLINK ContainerPartMoveBackward(ContainerPart *somSelf,
                                                        Environment *ev,
                                                       ODFrame* frame)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartMoveBackward");

    if (_fSelection->Count() == 1)
    {
       ODxOrderedCollectionIterator i(_fSelection);
       ODxOrderedCollection *tempFacets = new ODxOrderedCollection;
       Proxy* p = (Proxy*) i.First();

       ODFrame* siblingFrame = (ODFrame*)_fEmbeddedFrames->After(p->frame);
       if (siblingFrame)
       {
          _fEmbeddedFrames->Remove(p->frame);
          _fEmbeddedFrames->AddAfter( siblingFrame, p->frame);
          Proxy* siblingProxy = (Proxy*)_fContents->After(p);
          _fContents->Remove(p);
          _fContents->AddAfter(siblingProxy, p);
          _fNeedToExternalize = kODTrue;

          ODFrameFacetIterator* facets = p->frame->CreateFacetIterator(ev);
          for (ODFacet* facet = facets->First(ev); facets->IsNotComplete(ev); facet = facets->Next(ev))
          {
             tempFacets->AddLast(facet);
          }

          ODFrameFacetIterator* siblingFacets = siblingFrame->CreateFacetIterator(ev);
          ODFacet* siblingFacet;
          for (facet = siblingFacets->First(ev);
               siblingFacets->IsNotComplete(ev);
               facet = siblingFacets->Next(ev))
          {
             siblingFacet = facet;
          }

          ODxOrderedCollectionIterator iter(tempFacets);
          for (facet = (ODFacet*)iter.First();
               iter.IsNotComplete();
               facet = (ODFacet*)iter.Next())
          {
             facet->GetContainingFacet(ev)->MoveBehind(ev, facet, siblingFacet);
             siblingFacet = facet;
          }
          p->frame->Invalidate(ev, kODNULL);
          somSelf->ClipEmbeddedFrames(ev, frame);
          somSelf->GetStorageUnit(ev)->GetDraft(ev)->SetChangedFromPrev(ev);
       }
       delete tempFacets;
    }
    return kODTrue;
}

SOM_Scope void  SOMLINK ContainerPartClearAccelTable(ContainerPart *somSelf,
                                                      Environment *ev,
                                                     ODFrame* oldOwner)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartClearAccelTable");

    HWND hwndFrame = oldOwner->GetWindow( ev)->GetPlatformWindow( ev);
    HACCEL hAccelOld;

    hAccelOld = WinQueryAccelTable( (HAB)0, hwndFrame);
    if (hAccelOld) {
       WinDestroyAccelTable( hAccelOld );
       WinSetAccelTable( (HAB)0, 0, hwndFrame);
    } /* endif */
}

SOM_Scope void  SOMLINK ContainerPartSetAccelTable(ContainerPart *somSelf,
                                                    Environment *ev,
                                                   ODFrame* newOwner)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartSetAccelTable");

    HWND hwndFrame = newOwner->GetWindow( ev)->GetPlatformWindow( ev);
    ULONG rc;
    HMODULE hmodDLL;
    HACCEL hAccelOld;
    HACCEL hAccel;

    hAccelOld = WinQueryAccelTable( (HAB)0, hwndFrame);
    rc = DosQueryModuleHandle( THISDLL, &hmodDLL);
    if ( rc == 0) {
       hAccel = WinLoadAccelTable(1, hmodDLL, ID_ACCELTABLE);
       WinSetAccelTable(1, hAccel, hwndFrame);
       if (hAccelOld) WinDestroyAccelTable( hAccelOld );
    } /* endif */
}

SOM_Scope long  SOMLINK ContainerPartGetDemoState(ContainerPart *somSelf,
                                                   Environment *ev)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartGetDemoState");

    /* Return statement to be customized: */
    return _DemoState;
}

SOM_Scope void  SOMLINK ContainerPartsomInit(ContainerPart *somSelf)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartsomInit");

    ContainerPart_parent_ODPart_somInit(somSelf);

    _fDisplayFrames = kODNULL;
    _fEmbeddedFrames = kODNULL;
    _fWindowID = 0;

    _fContents = kODNULL;
    _fSelection = kODNULL;
    _fNeedToExternalize = kODFalse;

    _fSelectRgn = kODNULL;
    _fCornerHandleRgn = kODNULL;
    _fEdgeHandleRgn = kODNULL;

    _fFocusSet = kODNULL;

    _fSemtIntf = kODNULL;
    //_fTestDrawSU = kODNULL;

    _fSPEMenuOfSelection = kODNULL;
    _fRemappedSPEMenuOfSelection = kODNULL;

    //_fLargeIcons = kODNULL;
    //_fSmallIcons = kODNULL;

    _DemoState = 0;
    _DemoOpenCount = 0;

    _fSession = kODNULL;

    _fNotebook = kODNULL;
}

SOM_Scope void  SOMLINK ContainerPartsomUninit(ContainerPart *somSelf)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartsomUninit");

    Environment* ev = somGetGlobalEnvironment();
    if (_fContents != kODNULL)
      delete _fContents;
    if (_fSelection != kODNULL)
      delete _fSelection;
    if (_fSelectRgn) GpiDestroyRegion(_hpsMem, _fSelectRgn);
    if (_fCornerHandleRgn) GpiDestroyRegion(_hpsMem, _fCornerHandleRgn);
    if (_fEdgeHandleRgn) GpiDestroyRegion(_hpsMem, _fEdgeHandleRgn);
    if (_hpsMem) GpiDestroyPS(_hpsMem);
    if (_hdcMem) DevCloseDC(_hdcMem);
    if ( _fSPEMenuOfSelection ) {
       _fSPEMenuOfSelection->Release(ev);
    } /* endif */
    if ( _fRemappedSPEMenuOfSelection ) {
       _fRemappedSPEMenuOfSelection->Release(ev);
    } /* endif */


    if (_fDisplayFrames != kODNULL)
      delete _fDisplayFrames;    // make sure it's empty first
    if (_fEmbeddedFrames != kODNULL)
      delete _fEmbeddedFrames;    // make sure it's empty first

    #define SEMANTIC_INTERFACES_NOT_DONE
    #ifndef SEMANTIC_INTERFACES_NOT_DONE
       if (_fSemtIntf != kODNULL)
           delete _fSemtIntf;
    #endif

    //ODReleaseObject(ev,_fTestDrawSU);
    ContainerPart_parent_ODPart_somUninit(somSelf);
}

SOM_Scope void  SOMLINK ContainerPartFulfillPromise(ContainerPart *somSelf,
                                        Environment *ev, ODStorageUnitView* promiseSUView)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartFulfillPromise");

    NOTDONE2("FulfillPromise");
    ContainerPart_parent_ODPart_FulfillPromise(somSelf, ev, promiseSUView);
}

SOM_Scope void  SOMLINK ContainerPartDropCompleted(ContainerPart *somSelf,
                                       Environment *ev, ODPart* destPart,
                                      ODDropResult dropResult)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartDropCompleted");

    NOTDONE2("DropCompleted");
//    ContainerPart_parent_ODPart_DropCompleted(somSelf, ev, destPart,
//<crs>                                              dropResult);
}


#if 0
                                                   // helpful debug routine
  DumpRegionRects( PSZ prompt, HPS hps, HRGN hrgn )
  {
    RECTL rects[5];
    BOOL  retval;
    RGNRECT rr;
    rr.ircStart = 1;
    rr.crc = 5;
    rr.ulDirection = RECTDIR_LFRT_TOPBOT;
    retval = GpiQueryRegionRects( hps
                                , hrgn
                                , /*prclBound:*/0
                                , &rr
                                , rects
                                );
    rrprintf( "rects for \"%s\" hrgn(", prompt);
    rrprintf( "%lx", hrgn);
    rrprintf( ") ");
    if (retval) {
       int ix;
       for (ix=0; ix<rr.crcReturned; ix++) {
          rrprintf( "(x=%ld..%ld,"
                    , rects[ix].xLeft
                    , rects[ix].xRight
                    );
          rrprintf( "y=%ld..%ld)"
                    , rects[ix].yBottom
                    , rects[ix].yTop
                    );
       } /* endfor */
    } else {
       rrprintf( "error" );
    } /* endif */
    rrprintf( "\r\n" );
  }
#endif


   void InvertDragHilite( Environment * ev, ODFacet* facet)
   {
      HWND hwnd = facet->GetWindow(ev)->GetPlatformWindow(ev);
      hwnd = WinWindowFromID( hwnd, FID_CLIENT );
         // the following code was added because with the new facet window
         //   design, we appear to need to need to draw on the topmost
         //   facet window.  If we don't, nothing appears. (jlc 94/9/19)
         {
            //<crs>-12/07/94-validate facet via metaclass method
            HWND prevhwnd;
            M_ODFacet *m = new M_ODFacet;
            while (hwnd) {
               prevhwnd = hwnd;
               hwnd = WinQueryWindow( hwnd, QW_TOP );
               if ( (hwnd) && (m->clsODFacetFromHWND( ev, hwnd ) == kODNULL ))
                  {
                  hwnd = prevhwnd;
                  break;
                  }  
            }
            hwnd = prevhwnd;
            delete m;
         }

      HPS hps = DrgGetPS( hwnd );

      LONG mixOld = GpiQueryMix( hps );
      LONG colorOld = GpiQueryColor( hps);
      GpiSetMix( hps, FM_XOR );
      GpiSetColor( hps, CLR_TRUE );

      RECTL rectl;
      ODShape *clipShape = new ODShape();
      HRGN saveClip;
      ODShape *trackingShape = new ODShape();

      // for people just learning about the various OpenDoc facet/frame shapes,
      //   modifying the following code to set the trackingShape to be the Active,
      //   Used, Clip, AggregateClip, or various other shapes can be very
      //   educational.  For the best results, turn off the clipping while
      //   experimenting.

      trackingShape->CopyFrom( ev, facet->GetFrame(ev)->GetFrameShape(ev) );
      trackingShape->Transform( ev, facet->GetWindowFrameTransform(ev) );

      // Specify that the highlight painting will clip off portions of
      //         highlight that are covered by descendants/uncles or
      //         clipped by parentage.
      {
         // todo: determine which of these two is prefered.
         #if 1
            clipShape->CopyFrom(ev, facet->GetAggregateClipShape(ev) );
         #else
            clipShape->CopyFrom(ev, facet->GetClipShape(ev) );
         #endif
         clipShape->Transform(ev, facet->GetWindowFrameTransform(ev));
         HRGN clip = clipShape->GetRegion(ev);
         GpiSetClipRegion(hps, clip, &saveClip);
      }

      #if 1
         SIZEL szl;
         szl.cx = 5;
         szl.cy = 5;
         /*LONG  APIENTRY*/ GpiFrameRegion( hps
                                      , trackingShape->GetRegion(ev)
                                      , /*thickness:*/&szl);
         delete trackingShape;
      #endif

      GpiSetClipRegion(hps, saveClip, (PHRGN)0);
      delete clipShape;

      GpiSetColor( hps, colorOld );
      GpiSetMix( hps, mixOld );

      DrgReleasePS(hps);
   }

#if 1
   SOM_Scope MRESULT  SOMLINK ContainerPartDragEnter(ContainerPart *somSelf,
                                                      Environment *ev,
                                                     ODDragItemIterator* dragInfo,
                                                     ODFacet* facet,
                                                     ODPoint* where)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartDragEnter");

       InvertDragHilite( ev, facet );

       return MRFROM2SHORT (DOR_DROP, DO_MOVE);
   }


   SOM_Scope MRESULT  SOMLINK ContainerPartDragWithin(ContainerPart *somSelf,
                                                       Environment *ev,
                                                      ODDragItemIterator* dragInfo,
                                                      ODFacet* facet,
                                                      ODPoint* where)
   {
       ContainerPartData *somThis = ContainerPartGetData(somSelf);
       ContainerPartMethodDebug("ContainerPart","ContainerPartDragWithin");

       return MRFROM2SHORT (DOR_DROP, DO_MOVE);
   }
#endif

SOM_Scope void  SOMLINK ContainerPartDragLeave(ContainerPart *somSelf,  Environment *ev,
                                  ODFacet* facet, ODPoint* where)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartDragLeave");

    InvertDragHilite( ev, facet );
}

SOM_Scope ODDropResult  SOMLINK ContainerPartDrop(ContainerPart *somSelf,
                                      Environment *ev, ODDragItemIterator* dropInfo,
                                     ODFacet* facet, ODPoint* where)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartDrop");

    #if 0
       NOTDONE2("Drop");
       return (ODDropResult)0;
    #else
       #ifdef _PLATFORM_OS2_
          ODDraft       *theDraft = somSelf->GetStorageUnit(ev)->GetDraft(ev);
          ODULong        attributes;
          //DragReference   theDrag;
          ODPoint           delta;
          Point           dragPoint, dropPoint, pinnedPoint;
          //MATRIXLF        newXTrans;
          short           mouseDownModifiers, mouseUpModifiers, movePart;
          ODStorageUnit *dropSU, *newSU;
          ODID           draggedFrameID;
          Proxy          *p;
          ODFrame       *frameDroppedIn;
          ODFrame       *newFrame = kODNULL;
          ODPart        *newPart;
          ODShape       *clipShape, *newFrameShape;
          ODTransform   *newExternalXForm;
          ODBoolean      canHandleDrop = kODFalse;

          ODDropResult  dropResult = kODDropMove;
          InvertDragHilite(ev, facet);  // presumably I've highlighted myself, so turn it off now.

          // Check to see if we can handle the info in this drag (right now only parts)
          for (dropSU = dropInfo->First(ev); dropSU; dropSU = dropInfo->Next(ev))
             if (dropSU->Exists(ev, kODPropPart, kODISOStr, 0))
                canHandleDrop = kODTrue;

          if (canHandleDrop == kODFalse)
                return kODDropFail;

          // Get the attributes for this drag
          attributes = _fSession->GetDragAndDrop(ev)->GetDragAttributes(ev);
          //theDrag = _fSession->GetDragAndDrop(ev)->GetDragReference(ev);
          movePart = (attributes & kODdragIsInSourceFrame);

          ODBoolean  notDone = kODTrue;
          for (dropSU = dropInfo->First(ev); dropSU && notDone; dropSU = dropInfo->Next(ev))
          {
             if (movePart)
             {
                // Get where drag started and tweak our own structures to do the move.
                ODPoint ms = facet->GetWindowFrameTransform(ev)->InvertPoint(ev, &_mouseStart);
                delta.x = where->x - ms.x;
                delta.y = where->y - ms.y;

                dropSU->Focus(ev, kPropFrameInfo, kODPosUndefined, kODID, 0, kODPosFirstSib);
                dropSU->GetValue(ev, sizeof(ODID), (ODValue) &draggedFrameID);
                p = somSelf->ProxyForFrameID(ev, draggedFrameID);

                // !!! this is a single-facet hack
                p->transform->MoveBy(ev, &delta);
                newExternalXForm = new ODTransform;
                newExternalXForm->CopyFrom(ev, p->transform);
                ODFrameFacetIterator* facets = p->frame->CreateFacetIterator(ev);
                #if 0
                   facets->First(ev)->ChangeExternalTransform(ev, newExternalXForm);
                #else
                   facets->First(ev)->ChangeGeometry(ev, kODNULL, newExternalXForm);
                   //NOTDONE2("ChangeExternalTransform.3184");
                #endif
                delete facets;
                _fNeedToExternalize = kODTrue;

// (CED 110594) somSelf->UpdateProxyRegion(ev, p);
// (CED 110594) somSelf->CreateProxySelectionBorder(ev, p);
                somSelf->CreateProxySelectionBorder(ev, facet, p);


                notDone = kODFalse;
             }
             else
             {
                ODDraftKey key;

                //ODVolatile(dropSU);
                //ODVolatile(key);

                try{
                   key = dropSU->GetDraft(ev)->BeginClone(ev, kODClonePaste);
                   newSU = dropSU->CloneTo(ev, key, theDraft, kODNULL);
                   dropSU->GetDraft(ev)->EndClone(ev, key);
                } catch (... ) {
                   dropSU->GetDraft(ev)->AbortClone(ev, key);
                   throw;
                } /* end catch */

                ODPoint newTransPt = {MAKEFIXED(10,0), MAKEFIXED(10,0)};
#if 1  // (CED - 110594)
                if (dropSU->Exists(ev, kPropMouseDownOffset, kODPoint, 0))
                {
                   ODPoint offset;
                   dropSU->Focus(ev, kPropMouseDownOffset, kODPosUndefined, kODPoint, 0, kODPosFirstSib);
                   dropSU->GetValue(ev, sizeof(offset), (ODValue) &offset);
                   newTransPt.x = where->x - offset.x;
                   newTransPt.y = where->y - offset.y;
                }
#else
                if (dropSU->Exists(ev, kPropMouseDownOffset, kOS2POINTL, 0))
                {
                   ODPOINTL mdOffset(0,0);
                   newTransPt = *where;

                   dropSU->Focus(ev, kPropMouseDownOffset, kODPosUndefined, kOS2POINTL, 0, kODPosFirstSib);
                   dropSU->GetValue(ev, sizeof(mdOffset), (ODValue) &mdOffset);
                   newTransPt.x -= MAKEFIXED(mdOffset.x,0);
                   newTransPt.y -= MAKEFIXED(mdOffset.y,0);
                }
#endif

                newExternalXForm = new ODTransform;
                newExternalXForm->MoveBy(ev,  &newTransPt );

                if (dropSU->Exists(ev, kODPropFrameShape, NULL, 0))
                {
                   dropSU->Focus(ev, kODPropFrameShape, kODPosUndefined, NULL, 1, kODPosUndefined);
                   newFrameShape = new ODShape;
                   newFrameShape = newFrameShape->ReadShape(ev, dropSU);
                }
                else
                {
                   newFrameShape = kODNULL;     // use default size {80,80}
                }

                newPart = theDraft->GetPart(ev, newSU->GetID(ev));
                newSU->Release(ev);

                frameDroppedIn = facet->GetFrame(ev);

                // We should be internalizing the frame from the storage unit
                #if 1
                   // jlc Apple appears to have replaced tCreateEmbeddedFrame
                   // jlc with MakeEmbeddedFrame.  I've converted the names of
                   // jlc the invocations here, but I haven't had a chance to
                   // jlc test this.  todo jlc 94/8
                   #if 1
                      newFrame = somSelf->MakeEmbeddedFrame(ev, frameDroppedIn,
                                                  newFrameShape,
                                                  newExternalXForm,
                                                  newPart,
                                                  /*
                                                  viewtype:     kODNullTypeToken,
                                                  presentation: kODNullTypeToken,
                                                  groupID:      0,
                                                  */
                                                  kODFalse);
                   #else
                      newFrame = somSelf->CreateEmbeddedFrame(ev, frameDroppedIn,
                                                  newFrameShape,
                                                  newExternalXForm,
                                                  newPart,
                                                  kODNullTypeToken,
                                                  kODNullTypeToken,
                                                  0,
                                                  kODFalse);
                   #endif
                #endif

                #if 1
                   // *** Set the frame's part info.  This is a kludge because
                   // *** some of the sample parts we have now save their content
                   // *** to the frame's partinfo rather than  adding properties
                   // *** for part content in the storage unit.  The frame's partinfo
                   // *** data should not normally be copied on a drag/drop operation.
                   // *** This code will be removed once the sample parts are fixed
                   // *** up to externalize properly.
                   // ************************************************************************
                   // I believe the code (and the comment above) in this #if was
                   //    written by DougF.  Apple's code is much simplier, but I
                   //    don't think it will work when the containing frames has
                   //    multiple facets because Apple's code only adds one embedded
                   //    facet rather than one per container facet.
                   // Also I don't believe Apple's code will handle the situation where
                   //    a part has multiple frames.  I'm not sure if Doug's code will
                   //    handle that.  I suspect not.
                   // I don't understand Doug's comment about storing things in the
                   //    part info.  Apple's draw part handles storage the same way
                   //    and they don't require and partinfo related code here.
                   //    I'll dig further when I get a chance.
                   // todo: Talk to Apple or try out their code to determine if their
                   //    code is deficient. (jlc 94/9/16)

                   dropSU->Focus(ev, kODPropPartInfo, kODPosUndefined, kODPartInfo, 0, kODPosUndefined);
                   ODStorageUnitView *suView = new ODStorageUnitView();
                   suView->InitStorageUnitView(ev, dropSU, dropSU->CreateCursor(ev));
                   ODInfoType fPartInfo = (ODInfoType)(newPart->ReadPartInfo(ev, newFrame, suView));
                   newFrame->SetPartInfo(ev, fPartInfo);
                   delete suView;

                   ODFrameFacetIterator* facets = frameDroppedIn->CreateFacetIterator(ev);
                   for (ODFacet* facet = facets->First(ev); facets->IsNotComplete(ev); facet = facets->Next(ev))
                   {
                      ODShape* clip = new ODShape;
                      clip->CopyFrom(ev, newFrame->GetFrameShape(ev));
                      ODTransform* xform = new ODTransform;
                      xform->CopyFrom(ev, somSelf->ProxyForFrame(ev, newFrame)->transform);
                      facet->CreateEmbeddedFacet(ev, newFrame, clip, xform, kODNULL, kODFrameInFront);
                   }
                   delete facets;
                   somSelf->ClipEmbeddedFrames(ev, frameDroppedIn);
                #endif
                frameDroppedIn->Invalidate(ev, NULL);

                newPart->Release(ev);

                notDone = kODFalse;
             }
          }
          somSelf->GetStorageUnit(ev)->GetDraft(ev)->SetChangedFromPrev(ev);

          return dropResult;
       #else
          ODDraft       *theDraft = somSelf->GetStorageUnit(ev)->GetDraft(ev);
          ODULong        attributes;
          DragReference   theDrag;
          Point           delta, dragPoint, dropPoint, pinnedPoint, newXTrans;
          short           mouseDownModifiers, mouseUpModifiers;
          ODStorageUnit *dropSU, *newSU;
          ODID           draggedFrameID;
          Proxy          *p;
          ODFrame       *frameDroppedIn;
          ODFrame    *newFrame = kODNULL;
          ODPart        *newPart;
          ODShape     *clipShape, *newFrameShape;
          ODTransform   *newExternalXForm;
          ODBoolean    canHandleDrop = kODFalse;

          ODDropResult  dropResult = kODDropMove;

          // Check to see if we can handle the info in this drag (right now only parts)
          for (dropSU = dropInfo->First(ev); dropSU; dropSU = dropInfo->Next(ev))
            if (dropSU->Exists(ev, kODPropPart, kODISOStr, 0))
              canHandleDrop = kODTrue;

          if (canHandleDrop == kODFalse)
              return kODDropFail;

          // Get the attributes and other stuff for this drag
          attributes = _fSession->GetDragAndDrop(ev)->GetDragAttributes(ev);
          theDrag = _fSession->GetDragAndDrop(ev)->GetDragReference(ev);
          GetDragModifiers(theDrag, 0L, &mouseDownModifiers, &mouseUpModifiers);
          if ((mouseDownModifiers & optionKey) || (mouseUpModifiers & optionKey))
            dropResult = kODDropCopy;

          ODBoolean  notDone = kODTrue;
          for (dropSU = dropInfo->First(ev); dropSU && notDone;
              dropSU = dropInfo->Next(ev))
          {
            if ((attributes & kODdragIsInSourceFrame) && (dropResult == kODDropMove))
            {
              // Get where drag started and tweak our own structures to do the move.
              GetDragOrigin(theDrag, &dragPoint);
              GetDragMouse(theDrag, &dropPoint, &pinnedPoint);
              delta.h = dropPoint.h - dragPoint.h;
              delta.v = dropPoint.v - dragPoint.v;
              dropSU->Focus(ev, kPropFrameInfo, kODPosUndefined, kODID, 0, kODPosFirstSib);
              dropSU->GetValue(ev, sizeof(ODID), (ODValue) &draggedFrameID);
              p = somSelf->ProxyForFrameID(ev, draggedFrameID);

              // $$$$$ this is a single-facet hack
              ODPoint ODDelta (delta);
              p->transform->MoveBy(ev, &ODDelta);
              newExternalXForm = new ODTransform;
              newExternalXForm->CopyFrom(ev, p->transform);
              ODFrameFacetIterator* facets = p->frame->CreateFacetIterator(ev);
              facets->First(ev)->ChangeGeometry(ev, kODNULL, newExternalXForm);
              delete facets;

              somSelf->UpdateProxyRegion(ev, p);
              somSelf->CreateProxySelectionBorder(ev, p);

              notDone = kODFalse;
            }
            else
            {
              // Create a new storage unit for the part
        //      newSU = theDraft->CreateStorageUnit(ev);

              ODDraftKey  key;

              // $$$$$ OBSOLETE: Volatile(dropSU);
              // $$$$$ OBSOLETE: Volatile(key);

              TRY
                key = dropSU->GetDraft(ev)->BeginClone(ev, kODClonePaste);
                newSU = dropSU->CloneTo(ev, key, theDraft, kODNULL);
                dropSU->GetDraft(ev)->EndClone(ev, key);

              CATCH_ALL
                dropSU->GetDraft(ev)->AbortClone(ev, key);
                RERAISE;
              ENDTRY

              if (dropSU->Exists(ev, kPropMouseDownOffset, kQDPoint, 0))
              {
                Point mdOffset = {0,0};
                newXTrans = where->AsQDPoint();

                dropSU->Focus(ev, kPropMouseDownOffset, kODPosUndefined, kQDPoint, 0, kODPosFirstSib);
                dropSU->GetValue(ev, sizeof(Point), (ODValue) &mdOffset);

                SubPt(mdOffset,&newXTrans);
              }
              else
              {
                SetPt(&newXTrans, 20, 20);
              }

              newExternalXForm = new ODTransform;
              newExternalXForm->SetQDOffset(ev, &newXTrans);

              if (dropSU->Exists(ev, kODPropFrameShape, NULL, 0))
              {
                dropSU->Focus(ev, kODPropFrameShape, kODPosUndefined, NULL, 1, kODPosUndefined);
                newFrameShape = new ODShape;
                newFrameShape = newFrameShape->ReadShape(ev, dropSU);
              }
              else
              {
                newFrameShape = kODNULL;    // use default size {80,80}
              }

              newPart = theDraft->GetPart(ev, newSU->GetID(ev));
              newSU->Release(ev);

              frameDroppedIn = facet->GetFrame(ev);
              newFrame = somSelf->MakeEmbeddedFrame(ev, frameDroppedIn,
                  newFrameShape, newExternalXForm, newPart, kODFalse);

              clipShape = new ODShape;
              clipShape->CopyFrom(ev, newFrame->GetFrameShape(ev));

              newExternalXForm = new ODTransform;
              newExternalXForm->CopyFrom(ev, somSelf->ProxyForFrame(ev, newFrame)->transform);
              facet->CreateEmbeddedFacet(ev, newFrame, clipShape, newExternalXForm,
                            kODNULL, kODFrameInFront);
              frameDroppedIn->Invalidate(ev, kODNULL);
              newPart->Release(ev);

              notDone = kODFalse;
            }
          }
          somSelf->GetStorageUnit(ev)->GetDraft(ev)->SetChangedFromPrev(ev);

          return dropResult;
       #endif
    #endif
}

SOM_Scope void  SOMLINK ContainerPartContainingPartPropertiesChanged(ContainerPart *somSelf,
                                                         Environment *ev,
                                                        ODFrame* frame,
                                                        ODStorageUnit* propertyUnit)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartContainingPartPropertiesChanged");

    // nothing to do yet
}

SOM_Scope ODStorageUnit*  SOMLINK ContainerPartGetContainingPartProperties(ContainerPart *somSelf,
                                                               Environment *ev,
                                                              ODFrame* frame)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartGetContainingPartProperties");

    // this part has no properties to return
    return kODNULL;
}

SOM_Scope ODMenuBar*  SOMLINK ContainerPartCreateRootMenuBar(ContainerPart *somSelf,
                                                              Environment *ev,
                                                             ODFrame* frame)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartCreateRootMenuBar");

    ODContainerRootFrameMenuBar * mb = new ODContainerRootFrameMenuBar;
    mb->InitMenuBar( ev, _fSession, kODNULL);
    mb->SetOwner( ev, frame );

    ODWindowState * windowState = _fSession->GetWindowState( ev);
    ODMenuBar * mbold = windowState->GetBaseMenuBar(ev);
    mb->SetDependeeMenuBar( ev, mbold );
    return mb;
}

SOM_Scope void  SOMLINK ContainerPartRevealFrame(ContainerPart *somSelf,  Environment *ev,
                                    ODFrame* embeddedFrame, ODShape* revealShape)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartRevealFrame");

    NOTDONE2("RevealFrame"); // even Apple hasn't finished this one.
    ContainerPart_parent_ODPart_RevealFrame(somSelf, ev, embeddedFrame,
                                            revealShape);
}

SOM_Scope void  SOMLINK ContainerPartEmbeddedFrameSpec(ContainerPart *somSelf,
                                           Environment *ev, ODFrame* embeddedFrame,
                                          ODObjectSpec spec)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartEmbeddedFrameSpec");

    NOTDONE2("EmbeddedFrameSpec");
    ContainerPart_parent_ODPart_EmbeddedFrameSpec(somSelf, ev,
                                                  embeddedFrame,
                                                  spec);
}

SOM_Scope ODEmbeddedFramesIterator*  SOMLINK ContainerPartCreateEmbeddedFramesIterator(ContainerPart *somSelf,
                                                                           Environment *ev,
                                                                          ODFrame* frame)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartCreateEmbeddedFramesIterator");

               // todo: this method is required to set up the iterator so that
               //   it only iterates though the children of the given
               //   frame.  Clearly this code it is not doing this...
               //   or is assuming that a single display frame will
               //   be created.  The Apple code is no better yet.
               //   (jlc 94-9-16)

    XEmbeddedFramesIterator * xefi = new XEmbeddedFramesIterator();
    xefi->InitXEmbeddedFramesIterator( ev, _fEmbeddedFrames );
    return xefi;
}

SOM_Scope void  SOMLINK ContainerPartAddDisplayFrame(ContainerPart *somSelf,
                                         Environment *ev, ODFrame* frame)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartAddDisplayFrame");

    if (frame->GetPart(ev) == somSelf)    // frame belongs to me
    {
      ODxOrderedCollectionIterator  displayFramesIter(_fDisplayFrames);
      ODFrame* displayFrame = (ODFrame*) displayFramesIter.First();
      if (displayFramesIter.IsNotComplete() == kODFalse) {
        ODxOrderedCollectionIterator  contentsIter(_fContents);
        Proxy*            proxy;

        for (proxy = (Proxy*) contentsIter.First();
            contentsIter.IsNotComplete();
            proxy = (Proxy*) contentsIter.Next())
        {
          proxy->frame->SetContainingFrame(ev, frame);
        }
      }

      // !!! do something with viewType and partInfo...
      PartInfoRec* pInfo = new PartInfoRec;
//+(rlt 3-8-95)
        pInfo->fGridOn = kODFalse;      //Default is grid off
//-
      //pInfo->bgClipRegion = frame->GetFrameShape(ev)->CopyQDRegion(ev);      // <12> was GetQDRegion()

      if (frame->IsRoot(ev))
//+(rlt 3-8-95)
        pInfo->fNeedsActivating = kODTrue;
        else 
         _fDefaultColor = (defcolor++) % 8;  // pick semi random color for non root frames
      
//-
      pInfo->bgColor = _fDefaultColor;
      frame->SetPartInfo(ev, (ODInfoType) pInfo);
      _fDisplayFrames->AddLast(frame);
      frame->IncrementRefCount(ev);
      frame->SetDroppable(ev, kODTrue);

      _fNeedToExternalize = kODTrue;

      if (frame->GetViewType(ev) == kODNullTypeToken)            // if frame view is set don't change it
        frame->SetViewType(ev, _fSession->Tokenize(ev, kODViewAsFrame));    // if not, make it viewasframe
      if (frame->GetPresentation(ev) == kODNullTypeToken)
        frame->SetPresentation(ev, _fSession->Tokenize(ev, kContainerPartPresNormal));

      if (frame->GetContainingFrame(ev) == kODNULL)
      {
        //Wrong place. somSelf->ActivateFrame(ev, frame);
      }
    }
    else
      THROW(kODErrInvalidFrame);

    // render in frame?
}

SOM_Scope void  SOMLINK ContainerPartAttachSourceFrame(ContainerPart *somSelf,
                                           Environment *ev, ODFrame* frame,
                                          ODFrame* sourceFrame)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartAttachSourceFrame");

    if (_fDisplayFrames->Contains(frame)
       && sourceFrame && _fDisplayFrames->Contains(sourceFrame))
    {
      //RCR Note. DrawPart does not currently store embedded
      // frames on a per-containing-frame basis (eg. in the part info
      // of each frame). Since we can't add to the embedded frames list
      // while iterating over it, we make a temporary list here

        ODxOrderedCollection* embeddedFrames = new ODxOrderedCollection;
        {
          ODxOrderedCollectionIterator iter(_fEmbeddedFrames);
          for (ODFrame* embeddedFrame = (ODFrame*) iter.First();
              iter.IsNotComplete();
              embeddedFrame = (ODFrame*) iter.Next())
          {
            embeddedFrames->AddLast(embeddedFrame);
          }
        }

        ODxOrderedCollectionIterator iter(embeddedFrames);
        for (ODFrame* embeddedFrame = (ODFrame*) iter.First();
            iter.IsNotComplete();
            embeddedFrame = (ODFrame*) iter.Next())
        {
          if (embeddedFrame->GetContainingFrame(ev) == sourceFrame)
          {
            ODPart* embeddedPart = embeddedFrame->GetPart(ev);
            ODShape* newShape = new ODShape();
            newShape->CopyFrom(ev, embeddedFrame->GetFrameShape(ev));
            ODTransform* newXForm = new ODTransform();
            newXForm->CopyFrom(ev, somSelf->ProxyForFrame(ev, embeddedFrame)->transform);
            ODFrame* newFrame = somSelf->MakeEmbeddedFrame(ev, frame,
                newShape, newXForm, embeddedPart,
                embeddedFrame->IsOverlaid(ev));
          embeddedPart->AttachSourceFrame(ev, newFrame, embeddedFrame);
          }
        }
        delete embeddedFrames; // Delete the copy
      }
    else
      THROW(kODErrInvalidFrame);
}

SOM_Scope void  SOMLINK ContainerPartRemoveDisplayFrame(ContainerPart *somSelf,
                                            Environment *ev,
                                           ODFrame* frame)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartRemoveDisplayFrame");

    if (frame != kODNULL ) {
      if (_fDisplayFrames->Contains(frame))
      {
        ODxOrderedCollection* embeddedFrames = new ODxOrderedCollection;
        {
          ODxOrderedCollectionIterator iter(_fEmbeddedFrames);
          for (ODFrame* embeddedFrame = (ODFrame*) iter.First();
              iter.IsNotComplete();
              embeddedFrame = (ODFrame*) iter.Next())
          {
            embeddedFrames->AddLast(embeddedFrame);
          }
        }
        ODxOrderedCollectionIterator iter(embeddedFrames);
        for (ODFrame* embeddedFrame = (ODFrame*) iter.First();
            iter.IsNotComplete();
            embeddedFrame = (ODFrame*) iter.Next())
        {
          if (embeddedFrame->GetContainingFrame(ev) == frame)
          {
  ////        embeddedFrame->Close(ev);
  //          _fEmbeddedFrames->Remove(embeddedFrame);
  ////        embeddedFrame->Release(ev);
  //          embeddedFrame->Remove(ev);
            somSelf->RemoveEmbeddedFrame(ev, embeddedFrame);
          }
        }
        delete embeddedFrames; // Delete the copy

        _fSession->GetArbitrator(ev)->RelinquishFocusSet(ev, _fFocusSet,frame);

        PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo(ev);
        frame->SetPartInfo(ev, (ODInfoType) kODNULL);
        delete pInfo;
        _fDisplayFrames->Remove(frame);
        frame->Release(ev);

        _fNeedToExternalize = kODTrue;

        ODxOrderedCollectionIterator dIter(_fDisplayFrames);
        ODFrame*  displayFrame = (ODFrame*) dIter.First();
        if (dIter.IsNotComplete() == kODFalse) {
          //somSelf->DestroyPalette(ev);
        }
      }
      else
        THROW(kODErrInvalidFrame);
    }

    // any display frames left?
}

SOM_Scope void  SOMLINK ContainerPartCloseDisplayFrame(ContainerPart *somSelf,
                                           Environment *ev, ODFrame* frame)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartCloseDisplayFrame");

    if (_fDisplayFrames->Contains(frame))
    {
      ODxOrderedCollection* embeddedFrames = new ODxOrderedCollection;
      {
        ODxOrderedCollectionIterator iter(_fEmbeddedFrames);
        for (ODFrame* embeddedFrame = (ODFrame*) iter.First();
            iter.IsNotComplete();
            embeddedFrame = (ODFrame*) iter.Next())
        {
          embeddedFrames->AddLast(embeddedFrame);
        }
      }

      ODxOrderedCollectionIterator iter(embeddedFrames);
      for (ODFrame* embeddedFrame = (ODFrame*) iter.First();
          iter.IsNotComplete();
          embeddedFrame = (ODFrame*) iter.Next())
      {
        if (embeddedFrame->GetContainingFrame(ev) == frame)
        {
          embeddedFrame->Close(ev);
          _fEmbeddedFrames->Remove(embeddedFrame);
          ODReleaseObject(ev,embeddedFrame);
        }
      }
      delete embeddedFrames; // Delete the copy

      _fSession->GetArbitrator(ev)->RelinquishFocusSet(ev, _fFocusSet, frame);

      PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo(ev);
      frame->SetPartInfo(ev, (ODInfoType) kODNULL);
      delete pInfo;
      _fDisplayFrames->Remove(frame);
      ODReleaseObject(ev,frame);
      _fNeedToExternalize = kODTrue;
    }
    else
      THROW(kODErrInvalidFrame);
}

SOM_Scope void  SOMLINK ContainerPartFrameShapeChanged(ContainerPart *somSelf,
                                           Environment *ev, ODFrame* frame)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartFrameShapeChanged");

    if (_fDisplayFrames->Contains(frame))
    {
      /// !!! should leave UsedShape and ActiveShape null to inherit FrameShape
    }
    else
      THROW(kODErrInvalidFrame);
}

SOM_Scope void  SOMLINK ContainerPartViewTypeChanged(ContainerPart *somSelf,
                                         Environment *ev, ODFrame* frame)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartViewTypeChanged");

    if (_fDisplayFrames->Contains(frame))
      { NOTDONE2("ViewTypeChanged"); /* !!! change viewType of frame */ }
    else
      THROW(kODErrInvalidFrame);
}

SOM_Scope void  SOMLINK ContainerPartPresentationChanged(ContainerPart *somSelf,
                                             Environment *ev,
                                            ODFrame* frame)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartPresentationChanged");

    if (_fDisplayFrames->Contains(frame))
      { NOTDONE2("PresentationChanged"); /* !!! change presentation of frame */ }
    else
      THROW(kODErrInvalidFrame);
}

SOM_Scope void  SOMLINK ContainerPartSequenceChanged(ContainerPart *somSelf,
                                         Environment *ev, ODFrame* frame)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartSequenceChanged");

    ContainerPart_parent_ODPart_SequenceChanged(somSelf, ev,
                                                frame);
}

SOM_Scope void  SOMLINK ContainerPartWritePartInfo(ContainerPart *somSelf,
                                       Environment *ev, ODPtr partInfo,
                                      ODStorageUnitView* storageUnitView)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartWritePartInfo");

    if (partInfo)
    {
      RGBColor forDebuggingRGBColor ;
      forDebuggingRGBColor = ((PartInfoRec*)partInfo)->bgColor;
      storageUnitView->SetValue(ev, sizeof(RGBColor), (ODValue)&forDebuggingRGBColor);
      ODBoolean needsActivating = ((PartInfoRec*)partInfo)->fNeedsActivating
                    || ((PartInfoRec*)partInfo)->fIsActive;
      storageUnitView->SetValue(ev, sizeof(ODBoolean),
                    (ODValue)&needsActivating);
//+ (rlt 3-8-95)
      ODBoolean needsGrid = ((PartInfoRec*)partInfo)->fGridOn;
      storageUnitView->SetValue(ev, sizeof(ODBoolean),
                    (ODValue)&needsGrid);
//-
    }
}

SOM_Scope ODPtr  SOMLINK ContainerPartReadPartInfo(ContainerPart *somSelf,
                                       Environment *ev, ODFrame* frame,
                                      ODStorageUnitView* storageUnitView)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartReadPartInfo");

    if (storageUnitView->GetSize(ev))
    {
      PartInfoRec* partInfo = new PartInfoRec;

      RGBColor forDebuggingRGBColor ;
      storageUnitView->GetValue(ev, sizeof(RGBColor),
                    (ODValue)&forDebuggingRGBColor);
      partInfo->bgColor = forDebuggingRGBColor;
  //    storageUnitView->GetValue(ev, sizeof(RGBColor),
  //                  (ODValue)&(partInfo->bgColor));
      ODBoolean needsActivating;
      storageUnitView->GetValue(ev, sizeof(ODBoolean),
                    (ODValue)&(needsActivating));
      partInfo->fNeedsActivating = needsActivating;
//+ (rlt 3-8-95)
      ODBoolean needsGrid;
      storageUnitView->GetValue(ev, sizeof(ODBoolean),
                    (ODValue)&(needsGrid));
      partInfo->fGridOn = needsGrid;
//-

      ODxOrderedCollectionIterator d(_fDisplayFrames);
      ODFrame* dispFrame = (ODFrame*) d.First();

      return partInfo;
    }
    else
      return ((ODPtr)kODNULL);
}

SOM_Scope ODID  SOMLINK ContainerPartOpen(ContainerPart *somSelf,  Environment *ev,
                             ODFrame* frame)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartOpen");

    ODWindow* window = kODNULL;

    if (frame) // Doing a View As Window
    {
      window = _fSession->GetWindowState(ev)->GetWindow(ev, _fWindowID);
      if (window)
        window->Select(ev);
      else
      {
        window = somSelf->CreateWindow(ev, frame);
        _fWindowID = window->GetID(ev);
        window->Open(ev);
        window->Show(ev);
        window->Select(ev);
      }
    }
    else
    {
      window = somSelf->CreateWindow(ev, frame);
      _fWindowID = window->GetID(ev);
      window->Open(ev);
      window->Show(ev);
      window->Select(ev);
    }
    return window->GetID(ev);
}

SOM_Scope ODFrame*  SOMLINK ContainerPartRequestEmbeddedFrame(ContainerPart *somSelf,
                                                  Environment *ev,
                                                 ODFrame* containingFrame,
                                                 ODFrame* baseFrame,
                                                 ODShape* frameShape,
                                                 ODPart* embedPart,
                                                 ODTypeToken viewType,
                                                 ODTypeToken presentation,
                                                 ODBoolean isOverlaid)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartRequestEmbeddedFrame");

// Original container part code did not properly handle embedded frame requests.
// Modifications are from ContainerPartEmbed method.  mcs 3/1/95
#if 0 
    return (ContainerPart_parent_ODPart_RequestEmbeddedFrame(somSelf,
                                                             ev,
                                                             containingFrame,
                                                             baseFrame,
                                                             frameShape,
                                                             embedPart,
                                                             viewType,
                                                             presentation,
                                                             isOverlaid));
#endif

  ODTransform *externalTransform = new ODTransform;
  externalTransform->InitTransform(ev);
  ODFrame *embeddedFrame = somSelf->MakeEmbeddedFrame(ev,
                                                      containingFrame,
                                                      frameShape,
                                                      externalTransform,
                                                      embedPart,
                                                      isOverlaid);

  ODFrameFacetIterator* facets = containingFrame->CreateFacetIterator(ev);
  for (ODFacet* facet = facets->First(ev); facets->IsNotComplete(ev);
      facet = facets->Next(ev))
  {
    ODShape* clip = new ODShape;
    clip->CopyFrom(ev, embeddedFrame->GetFrameShape(ev));
    ODTransform* xform = new ODTransform;
    xform->CopyFrom(ev, somSelf->ProxyForFrame(ev, embeddedFrame)->transform);
    facet->CreateEmbeddedFacet(ev, embeddedFrame, clip, xform, kODNULL, kODFrameInFront);
  }
  delete facets;
  somSelf->ClipEmbeddedFrames(ev, containingFrame);
  containingFrame->Invalidate(ev, NULL);

  ODReleaseObject(ev,embedPart);

  return embeddedFrame;

}

SOM_Scope void  SOMLINK ContainerPartRemoveEmbeddedFrame(ContainerPart *somSelf,
                                             Environment *ev,
                                            ODFrame* embeddedFrame)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartRemoveEmbeddedFrame");

    if (_fEmbeddedFrames->Contains(embeddedFrame))
    {
      ODFrame* containingFrame = embeddedFrame->GetContainingFrame(ev);
      Proxy* p = somSelf->ProxyForFrame(ev, embeddedFrame);
      if (p)
      {
        _fNeedToExternalize = kODTrue;
        _fContents->Remove(p);
        ODDeleteObject(p->transform);
// (CED - 110594) GpiDestroyRegion( _hpsMem, p->region);
        delete p;
      }
      _fEmbeddedFrames->Remove(embeddedFrame);
      embeddedFrame->Remove(ev);
      //somSelf->GetStorageUnit(ev)->GetDraft(ev)->RemoveFrame(ev, embeddedFrame);

      somSelf->ClipEmbeddedFrames(ev, containingFrame);

    }
    else
      THROW(kODErrInvalidFrame);
}

SOM_Scope ODShape*  SOMLINK ContainerPartRequestFrameShape(ContainerPart *somSelf,
                                               Environment *ev,
                                              ODFrame* embeddedFrame,
                                              ODShape* frameShape)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartRequestFrameShape");

    if (_fEmbeddedFrames->Contains(embeddedFrame))
    {  // find frame proxy and fix cached region
      Proxy* p = somSelf->ProxyForFrame(ev, embeddedFrame);
      if (p)
      {
#if 0 // (CED - 110594) Proxy regions no longer used
        ODShape* scratch = new ODShape();
        scratch->CopyFrom(ev, frameShape);
        scratch->Transform(ev, p->transform);
        //p->region = scratch->CopyQDRegion(ev);
        p->region = scratch->CopyRegion(ev);
        delete scratch;
#endif
        p->frame->Invalidate(ev, kODNULL);
        p->frame->Invalidate(ev, frameShape);

        if (_fSelection->Contains(p)) { /* !!! fix highlighting */ };

        // fix clipping of obscured frames
//        somSelf->ClipEmbeddedFrames(ev, embeddedFrame->GetContainingFrame(ev));
      }
    }
    else
      THROW(kODErrInvalidFrame);

    return frameShape;
}

SOM_Scope void  SOMLINK ContainerPartUsedShapeChanged(ContainerPart *somSelf,
                                          Environment *ev, ODFrame* embeddedFrame)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartUsedShapeChanged");

    if (_fEmbeddedFrames->Contains(embeddedFrame))
    {
      somSelf->ClipEmbeddedFrames(ev, embeddedFrame->GetContainingFrame(ev));
      embeddedFrame->Invalidate(ev, kODNULL); // RLT for DevCon 7
    }
    else
      THROW(kODErrInvalidFrame);
}

SOM_Scope ODShape*  SOMLINK ContainerPartAdjustBorderShape(ContainerPart *somSelf,
                                               Environment *ev,
                                              ODFrame* embeddedFrame,
                                              ODShape* shape)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartAdjustBorderShape");

    return shape;
}

SOM_Scope void  SOMLINK ContainerPartFacetAdded(ContainerPart *somSelf,  Environment *ev,
                                   ODFacet* facet)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartFacetAdded");

    ODFrame* dispFrame = facet->GetFrame(ev);
    if (!_fDisplayFrames->Contains(dispFrame))
      THROW(kODErrInvalidFacet);

    ODShape* workingClip = new ODShape;
    workingClip->InitShape(ev);
    facet->SetPartInfo(ev, (ODInfoType)workingClip);

    ODxOrderedCollectionIterator frames(_fEmbeddedFrames);
    for (ODFrame* frame = (ODFrame*) frames.First();
        frames.IsNotComplete();
        frame = (ODFrame*) frames.Next())
    {
      if (frame->GetContainingFrame(ev) == dispFrame)
      {
        ODShape* clip = new ODShape;
        clip->CopyFrom(ev, frame->GetFrameShape(ev));
        ODTransform* xform = new ODTransform;
        xform->CopyFrom(ev, somSelf->ProxyForFrame(ev, frame)->transform);
        facet->CreateEmbeddedFacet(ev, frame,
                      clip, xform,
                      kODNULL, kODFrameBehind);
      }
    }

    somSelf->ClipEmbeddedFacets(ev, facet);
}

SOM_Scope void  SOMLINK ContainerPartFacetRemoved(ContainerPart *somSelf,
                                      Environment *ev, ODFacet* facet)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartFacetRemoved");

    ODFrame* dispFrame = facet->GetFrame(ev);
    if (!_fDisplayFrames->Contains(dispFrame))
      THROW(kODErrInvalidFacet);

    ODxOrderedCollection* children = new ODxOrderedCollection;
    ODFacetIterator* facets = facet->CreateFacetIterator(ev, kODChildrenOnly, kODFrontToBack);
    for (ODFacet* childFacet = facets->First(ev);
      facets->IsNotComplete(ev);
      childFacet = facets->Next(ev))
    {
      children->AddLast(childFacet);
    }
    delete facets;
    ODxOrderedCollectionIterator iter(children);
    for (childFacet = (ODFacet*)iter.First();
        iter.IsNotComplete();
        childFacet = (ODFacet*)iter.Next())
    {
      facet->RemoveFacet(ev, childFacet);
      delete childFacet;
    }
    #if 0
       // following line was in OS/2 version before SOM.  Not in Apple
       //   after SOM. Need to check if needed. todo. (jlc 94-8)
       delete (ODShape*)facet->GetPartInfo();
    #endif
    delete children;
}

SOM_Scope void  SOMLINK ContainerPartCanvasChanged(ContainerPart *somSelf,
                                       Environment *ev, ODFacet* facet)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartCanvasChanged");

}

SOM_Scope void  SOMLINK ContainerPartGeometryChanged(ContainerPart *somSelf,
                                         Environment *ev, ODFacet* facet)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartGeometryChanged");

    somSelf->ClipEmbeddedFacets(ev, facet);  // extra work, but gives correct display
}

SOM_Scope void  SOMLINK ContainerPartDraw(ContainerPart *somSelf,  Environment *ev,
                             ODFacet* facet, ODShape* invalidShape)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartDraw");

    ODBoolean drawing = facet->GetCanvas(ev)->IsDynamic(ev);

    ODFrame* displayFrame = facet->GetFrame(ev);
    if (_fDisplayFrames->Contains(displayFrame))
    {
      // transform grafport

      HPS hpsDraw = facet->GetCanvas(ev)->GetPlatformCanvas(ev);
      GpiSavePS(hpsDraw);


      PartInfoRec* pInfo = (PartInfoRec*) displayFrame->GetPartInfo(ev);
      #if 1  // (CED - 110594)
         ODRect rect;
         displayFrame->GetFrameShape(ev)->GetBoundingBox(ev, &rect);
         ODRECTL frameRect(rect);
      #else
         HRGN frameRgn = displayFrame->GetFrameShape(ev)->GetQDRegion(ev);
         Rect frameRect;
         GpiQueryRegionBox(hpsDraw, frameRgn, &frameRect);
      #endif
      // set up clipping
      HRGN saveClip;
      ODShape* clipShape = new ODShape;
      clipShape->CopyFrom(ev, facet->GetAggregateClipShape(ev));
//    clipShape->Transform(ev, facet->GetContentTransform(ev));
      clipShape->Transform(ev, facet->GetFrameTransform(ev)); // RT - <8>
      //clipShape->Subtract(ev, (ODShape*)facet->GetPartInfo(ev));

      HRGN clip = clipShape->GetRegion(ev);
      GpiSetClipRegion(hpsDraw, clip, &saveClip);

      if (facet->GetFrame(ev)->GetPresentation(ev) == _fSession->Tokenize(ev, kContainerPartPresNormal))
      {
         ODTypeToken curView = facet->GetFrame(ev)->GetViewType(ev);

         if (curView == _fSession->Tokenize(ev, kODViewAsFrame))
         {
            // paint the background

            GpiResetPS(hpsDraw, GRES_ATTRS);

            somSelf->SetGrafPortOrigin(ev, facet);

            RGBColor bgRGB = pInfo->bgColor;
            //ULONG ulRGB = (bgRGB.bRed << 16) + (bgRGB.bGreen << 8) + bgRGB.bBlue;
            //ULONG lColorIndex = GpiQueryColorIndex(hpsDraw, 0, ulRGB);
            GpiSetColor(hpsDraw, pInfo->bgColor);
            #if 1 // (CED - 110594)
               //<crs>-110694 GpiErase(hpsDraw);
               POINTL ptl = {0, 0};
               GpiMove(hpsDraw, &ptl);
               ptl.x = frameRect.xRight;
               ptl.y = frameRect.yTop;
               GpiBox(hpsDraw, DRO_FILL, &ptl, 0, 0);
            #else
               GpiPaintRegion(hpsDraw, invalidShape->GetQDRegion(ev));
            #endif
            GpiSetLineType(hpsDraw, LINETYPE_DOT);
            GpiSetColor(hpsDraw, CLR_BLACK);

           if (pInfo->fGridOn){
              for (int y = YGRID / 2; y < frameRect.yTop; y += YGRID) {
               ptl.y = y;
               ptl.x = 0;
               GpiMove(hpsDraw, &ptl);
               ptl.x = frameRect.xRight;
               GpiLine(hpsDraw, &ptl);
               }

               for (int x = XGRID / 2; x < frameRect.xRight; x += XGRID) {
               ptl.x = x;
               ptl.y = 0;
               GpiMove(hpsDraw, &ptl);
               ptl.y = frameRect.yTop;
               GpiLine(hpsDraw, &ptl);
               }
           } /* endif fGridOn */
            // highlite the selected frame.

            if (displayFrame == _fSession->GetArbitrator(ev)->GetFocusOwner(ev, _fSelectionFocus))
            {  // drawing active frame - highlight selection
               somSelf->HighlightSelection(ev, facet);
            }
            else
            {  // drawing inactive frame - do nothing for now
            }
         }
         else if (curView == _fSession->Tokenize(ev, kODViewAsLargeIcon))
         {
            /* Render as large Icon */
         }
         else if (curView == _fSession->Tokenize(ev, kODViewAsSmallIcon))
         {
            /* Render as small icon */
         }
      }
      GpiRestorePS(hpsDraw, -1);

      GpiSetClipRegion(hpsDraw, saveClip, (PHRGN)0);
      facet->GetCanvas(ev)->ReleasePlatformCanvas(ev);
      delete clipShape;
    }
    else
    {
      // !!! signal error: invalid frame
    }
}

SOM_Scope void  SOMLINK ContainerPartCanvasUpdated(ContainerPart *somSelf,
                                       Environment *ev, ODCanvas* canvas)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartCanvasUpdated");

}

SOM_Scope void  SOMLINK ContainerPartHighlightChanged(ContainerPart *somSelf,
                                          Environment *ev, ODFacet* facet)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartHighlightChanged");

}

SOM_Scope ODULong  SOMLINK ContainerPartGetPrintResolution(ContainerPart *somSelf,
                                               Environment *ev,
                                              ODFrame* frame)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartGetPrintResolution");

    NOTDONE2("GetPrintResolution");
                // this is what the Apple code doesn, but it almost certainly
                //  is incomplete.
    return 0;
}

SOM_Scope ODLink*  SOMLINK ContainerPartCreateLink(ContainerPart *somSelf,
                                       Environment *ev, ODPtr data,
                                      ODULong size)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartCreateLink");

    return kODNULL;
}

SOM_Scope void  SOMLINK ContainerPartLinkUpdated(ContainerPart *somSelf,  Environment *ev,
                                    ODLink* updatedLink, ODChangeID id)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartLinkUpdated");

}

SOM_Scope void  SOMLINK ContainerPartRevealLink(ContainerPart *somSelf,  Environment *ev,
                                   ODLinkSource* linkSource)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartRevealLink");

}

SOM_Scope void  SOMLINK ContainerPartEmbeddedFrameChanged(ContainerPart *somSelf,
                                              Environment *ev,
                                             ODFrame* frame,
                                             ODChangeID change)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartEmbeddedFrameChanged");

}

SOM_Scope void  SOMLINK ContainerPartLinkStatusChanged(ContainerPart *somSelf,
                                           Environment *ev, ODFrame* frame)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartLinkStatusChanged");

}

SOM_Scope ODBoolean  SOMLINK ContainerPartBeginRelinquishFocus(ContainerPart *somSelf,
                                                   Environment *ev,
                                                  ODTypeToken focus,
                                                  ODFrame* ownerFrame,
                                                  ODFrame* proposedFrame)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartBeginRelinquishFocus");

    return kODTrue;
}

SOM_Scope void  SOMLINK ContainerPartCommitRelinquishFocus(ContainerPart *somSelf,
                                               Environment *ev,
                                              ODTypeToken focus,
                                              ODFrame* ownerFrame,
                                              ODFrame* proposedFrame)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartCommitRelinquishFocus");

    somSelf->FocusLost(ev, focus, ownerFrame);
    //somSelf->HidePalette(ev);
}

SOM_Scope void  SOMLINK ContainerPartAbortRelinquishFocus(ContainerPart *somSelf,
                                              Environment *ev,
                                             ODTypeToken focus,
                                             ODFrame* ownerFrame,
                                             ODFrame* proposedFrame)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartAbortRelinquishFocus");

}

SOM_Scope void  SOMLINK ContainerPartFocusAcquired(ContainerPart *somSelf,
                                       Environment *ev, ODTypeToken focus,
                                      ODFrame* ownerFrame)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartFocusAcquired");

    if (focus == _fSelectionFocus)
    {
      PartInfoRec* pInfo = (PartInfoRec*) ownerFrame->GetPartInfo(ev);
      pInfo->fIsActive = kODTrue;

      //somSelf->ShowPalette(ev);
    }
    else if (focus == _fMenuFocus)
      somSelf->InstallMenus(ev, ownerFrame);
#ifdef _PLATFORM_OS2_
    else if (focus == _fKeyFocus)
       somSelf->SetAccelTable(ev, ownerFrame);
#endif
}

SOM_Scope void  SOMLINK ContainerPartFocusLost(ContainerPart *somSelf,  Environment *ev,
                                  ODTypeToken focus, ODFrame* ownerFrame)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartFocusLost");

    if (focus == _fSelectionFocus)
    {
      if (_fTracking)
      {
        _fSession->GetArbitrator(ev)->RelinquishFocus(ev, _fMouseFocus, ownerFrame);
        somSelf->FocusLost(ev, _fMouseFocus, ownerFrame);
      }
      PartInfoRec* pInfo = (PartInfoRec*) ownerFrame->GetPartInfo(ev);
      pInfo->fIsActive = kODFalse;
      somSelf->InvalidateSelection(ev, ownerFrame);
      if (_fSelection->Count())
      {
        somSelf->EmptySelection(ev);
        somSelf->ClipEmbeddedFrames(ev, ownerFrame);
      }
      //somSelf->HidePalette(ev);
    }
    else if (focus == _fMenuFocus)
      somSelf->RemoveMenus(ev, ownerFrame);
    else if (focus == _fKeyFocus)
       somSelf->ClearAccelTable(ev, ownerFrame);
    else if (focus == _fMouseFocus)
    {
      if (_fTracking)
        somSelf->MouseFocusLost(ev, ownerFrame);
    }
}

SOM_Scope void  SOMLINK ContainerPartCloneInto(ContainerPart *somSelf,  Environment *ev,
                                  ODDraftKey key, ODStorageUnit* storageUnit,
                                  ODStorageUnit* initiatingFrame)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartCloneInto");

    ODStorageUnit*  su = somSelf->GetStorageUnit(ev);

    somSelf->Externalize(ev);
    #if 0
       ODStorageUnit* destTestDrawSU = _fTestDrawSU
               ->CloneTo(ev, key, storageUnit->GetDraft(ev), initiatingFrame);
   
       storageUnit->AddProperty(ev, kODPropContents);
       storageUnit->AddValue(ev, kKindTestContainer);
       ODStorageUnitRef aSURef = storageUnit->GetStrongStorageUnitRef(ev, destTestDrawSU);
       storageUnit->SetValue(ev, sizeof(ODStorageUnitRef),&aSURef);
    #endif


    ODxOrderedCollectionIterator contentsIter(_fContents);
    Proxy* proxy;
    for (proxy = (Proxy*)contentsIter.First();
        contentsIter.IsNotComplete();
        proxy = (Proxy*)contentsIter.Next())
    {
      if ((initiatingFrame== kODNULL) ||
        (proxy->frame->GetContainingFrame(ev)->GetStorageUnit(ev) == initiatingFrame)) {
        ODStorageUnit* toFrameSU = proxy->frame->CloneTo(ev, key, storageUnit->GetDraft(ev));
        toFrameSU->Release(ev);
      }
    }
    #if 0
       destTestDrawSU->Release(ev);
    #endif

    su->CloneInto(ev, key, storageUnit, initiatingFrame);
}

SOM_Scope void  SOMLINK ContainerPartExternalizeKinds(ContainerPart *somSelf,
                                          Environment *ev, ODTypeList* kindset)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartExternalizeKinds");

    // This part only supports one kind and always externalizes it, so no
    //    could should be needed here.   (jlc 94-11-26)
}



SOM_Scope void  SOMLINK ContainerPartExternalize(ContainerPart *somSelf,  Environment *ev)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartExternalize");

    ODStorageUnit* su = somSelf->GetStorageUnit(ev);
    ODStorageUnitRef aSURef;
    ODULong offset;
    ODFrame* frame;
    Proxy* proxy;
    ODxOrderedCollectionIterator aIter(_fDisplayFrames);
    //ODxOrderedCollectionIterator bIter(_fEmbeddedFrames);
    ODxOrderedCollectionIterator cIter(_fContents);
    ODPOINTL xform;
   
    if ( _fNeedToExternalize ) {
       su->Focus(ev, kODPropDisplayFrames,kODPosUndefined,0,1,kODPosFirstSib);
       #ifndef SSREMOVEWORKAROUND
         su->Remove(ev);
         su->AddProperty(ev, kODPropDisplayFrames);
         su->AddValue(ev, kODIDs);
       #else
         ODULong oldValueSize = su->GetSize(ev);;
       #endif
       offset = 0;
       for (frame = (ODFrame*)aIter.First(); aIter.IsNotComplete();
           frame = (ODFrame*)aIter.Next(), offset+=sizeof(ODStorageUnitRef))
       {
         // jlc asserts that we don't need to externalize/clone our display frame because it
         //    is already externalized since it is the frame externization method that 
         //    (indirectly) calls this method.  As it turns out, if we have multiple display
         //    frames, we *might* need to externalize/clone our other display frames.  For now,
         //    I'm removing this code since in the case of externalization, it tends to slightly 
         //    reduce the size of resulting file. (jlc 94-11-26)
         //frame->Externalize(ev);
   
         // jlc asserts that we probably only want to store references to frames that
         //       descend from some root cloned frame.  In a future drop, the following
         //       code is likely to be conditionally executed. (jlc 94-11-26)
         aSURef = su->GetWeakStorageUnitRef(ev, frame->GetStorageUnit(ev));
         su->SetOffset(ev, offset);
         su->SetValue(ev, sizeof(ODStorageUnitRef), (ODValue)&aSURef);
       }
       #ifdef SSREMOVEWORKAROUND
         if (oldValueSize > offset)
           su->DeleteValue(ev, oldValueSize-offset);
       #endif
    } /* endif */
   
    // This Focus call was recently changed to focus on a property of a certain type 
    //   rather than just the first value/type.  This was done for the sake of subclassing 
    //   classes.  The subclass might add another type/value pair, and we
    //   don't want this code writing into the wrong type/value. <4> 
    su->Focus(ev, kODPropContents,kODPosUndefined,kKindTestContainer,0,kODPosUndefined);

    #ifndef SSREMOVEWORKAROUND
      if ( _fNeedToExternalize ) {
         su->Remove(ev);
         su->AddProperty(ev, kODPropContents);
         su->AddValue(ev, kKindTestContainer);
      } /* endif */
    #else
      oldValueSize = su->GetSize(ev);;
    #endif
    offset = 0;
    for (proxy = (Proxy*)cIter.First();
        cIter.IsNotComplete();
        proxy = (Proxy*)cIter.Next())
    {
      ODPoint ptxform;
      // When cloning, we explicitly need to externalize our embedded frames to insure
      //   that they actually get imbedded.  In actuality, I suspect that only descendent
      //   frames of a certain frame will need to be externalized, but for now, I'll just
      //   externalize all of them. (jlc 94-11-26)
      proxy->frame->Externalize(ev);

      if ( _fNeedToExternalize ) {
         aSURef = su->GetStrongStorageUnitRef(ev,
             proxy->frame->GetStorageUnit(ev));
         su->SetOffset(ev, offset);
         su->SetValue(ev, sizeof(ODStorageUnitRef), (ODValue)&aSURef);
         offset += sizeof(ODStorageUnitRef);
         proxy->transform->GetOffset(ev, &ptxform);
         su->SetOffset(ev, offset);
         su->SetValue(ev, sizeof(ptxform), (ODValue)&ptxform);
         offset += sizeof(ptxform);
      } /* endif */
    }
    #ifdef SSREMOVEWORKAROUND
      if ( _fNeedToExternalize ) {
         if (oldValueSize > offset)
           su->DeleteValue(ev, oldValueSize-offset);
      } /* endif */
    #endif
    _fNeedToExternalize = kODFalse;
}

SOM_Scope void  SOMLINK ContainerPartChangeKind(ContainerPart *somSelf,  Environment *ev,
                                   ODType kind)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartChangeKind");

}


SOM_Scope ODBoolean  SOMLINK ContainerPartHandleEvent(ContainerPart *somSelf,
                                                       Environment *ev,
                                                      ODEventData* event,
                                                      ODFrame* frame,
                                                      ODFacet* facet)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartHandleEvent");

    ODBoolean handled = kODFalse;

    switch (event->msg)
    {
       case WM_BUTTON1DOWN:
       case WM_BUTTON2DOWN:
        {
          ODPoint windowODPoint(ODPOINTL(SHORT1FROMMP(event->mp1),
                                         SHORT2FROMMP(event->mp1)));
          if (event->ulFlags & (kODInEmbedded | kODInBorder))
          {
                handled = somSelf->HandleMouseDownInEmbeddedFrame(ev, facet,
                                  (ODFacet*)event->mpExtra, &windowODPoint, event);
          }
          else
          {
                handled = somSelf->HandleMouseDown(ev, facet, &windowODPoint, event);
          }
          break;
        }
       case WM_CONTEXTMENU       :
          {
             ODPopupContainerMenu * pum = new ODPopupContainerMenu;
             pum->InitPopupContainerMenu( ev, _fSession, frame );
             pum->Display( ev );
             event->result = (MRESULT)1; // handled
             handled = kODTrue;
          }
          break;
       case WM_MOUSEMOVE:
          {
          ODPoint windowODPoint(ODPOINTL(SHORT1FROMMP(event->mp1),
                                         SHORT2FROMMP(event->mp1)));
          handled = somSelf->HandleMouseMove(ev, facet, frame, &windowODPoint, event);
          }
          break;

       case WM_BUTTON1UP:
          {
          ODPoint windowODPoint(ODPOINTL(SHORT1FROMMP(event->mp1),
                                         SHORT2FROMMP(event->mp1)));
          handled = somSelf->HandleMouseUp(ev, facet, frame, &windowODPoint, event);
          }
          break;

       /* JYS: use accelerator instead!
       case WM_CHAR:
          if (!(SHORT1FROMMP(event->mp1) & KC_KEYUP))
          {
            handled = somSelf->HandleKeyDown(ev, frame, event);
          }
          break;
       */
       case WM_ACTIVATE:
          handled = true; // actually ignored by dispatcher
          if (SHORT1FROMMP(event->mp1) != 0)
             somSelf->ActivatingWindow(ev, frame);
          else
             somSelf->DeActivatingWindow(ev, frame);
          break;

       case WM_COMMAND:
          if (SHORT1FROMMP(event->mp2) & CMDSRC_MENU ||
              SHORT1FROMMP(event->mp2) & CMDSRC_ACCELERATOR)
          {
            handled = somSelf->HandleMenuEvent(ev, frame, event);
          }
          break;

       default:
          return kODFalse;
    }
    return handled;
}


SOM_Scope ODBoolean  SOMLINK ContainerPartHandleEventInEmbedded(ContainerPart *somSelf,
                                                                 Environment *ev,
                                                                ODEventData* event,
                                                                ODFrame* frame,
                                                                ODFacet* facet,
                                                                ODFrame* embeddedFrame,
                                                                ODFacet* embeddedFacet)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartHandleEventInEmbedded");

    return kODFalse;
}

SOM_Scope void  SOMLINK ContainerPartMouseEnter(ContainerPart *somSelf,  Environment *ev,
                                   ODFacet* facet, ODPoint* where)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartMouseEnter");

    NOTDONE2("MouseEnter");  // need to add code here to change the pointer to whatever
                                      //   pointer type we prefer.
}

SOM_Scope void  SOMLINK ContainerPartMouseWithin(ContainerPart *somSelf,  Environment *ev,
                                    ODFacet* facet, ODPoint* where)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartMouseWithin");

}

SOM_Scope void  SOMLINK ContainerPartMouseLeave(ContainerPart *somSelf,  Environment *ev,
                                   ODFacet* facet)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartMouseLeave");

    // we may need to restore the pointer here.  I'll check later. todo (jlc 94-8)
}


ODMenuBar * SOMLINK ContainerPartGetSPEMenuOfSelection( ContainerPart *somSelf, Environment *ev )
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerGetSPEMenuOfSelection");

   if ( _fSPEMenuOfSelection) return _fSPEMenuOfSelection;

   ODMenuBar * mbx = kODNULL;

   if (_fSelection->Count() == 1 ) {
      ODxOrderedCollectionIterator i(_fSelection);
      Proxy *p = (Proxy*)i.First();
      ODPart * selectedPart = p->frame->GetPart( ev);
      ODSelectedPartExtension * spe;
      if ( selectedPart->HasExtension( ev, kODExtSelectedPartExtension)) {
         spe = (ODSelectedPartExtension*) selectedPart->GetExtension( ev, kODExtSelectedPartExtension);
      } else {
         spe = 0;
      } /* endif */
      if (spe) {
         mbx = spe->GetMenu( ev, p->frame);
         if (mbx) {
            mbx->UpdateMenuDependencyChain( ev, ODMENUID_ALL );
            if ( !mbx->GetFirstMenuID( ev, ODMENUID_ROOT) ) {
               mbx = 0;
            } else {
               // we do this to insure that it isn't released when we call ReleaseExtension.
               mbx->IncrementRefCount(ev );
               _fSPEMenuOfSelection = mbx;  
            } /* endif */
         } /* endif */
         selectedPart->ReleaseExtension( ev, spe );
      } else {
         // selected part didn't have an extension
      } /* endif */
   } /* endif */
   return mbx;
}

void SOMLINK ContainerPartRefreshRemappedSPEMenuOfSelection( ContainerPart *somSelf, Environment *ev )
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerRefreshRemappedSPEMenuOfSelection");

   if ( !_fSPEMenuOfSelection) return;

   ODMenuBar * mbTmp;
   if ( _fRemappedSPEMenuOfSelection ) {
      mbTmp = _fRemappedSPEMenuOfSelection;
      mbTmp->RemoveMenu( ev, ODMENUID_ROOT );
   } else {
      mbTmp = new ODMenuBar;
      mbTmp->InitMenuBar(ev,  /*_fSession*/0, /*menu:*/0 );
      _fRemappedSPEMenuOfSelection = mbTmp;
   } /* endif */

   mbTmp->AddMenuBLast(ev,  _fSPEMenuOfSelection, ODMENUID_ROOT );
   // I've just duplicated the menu.  Now I'll remap the ID's.
   ODMenuID toLow = IDMA_CNT_SELECTEDREMAP_FIRST;
   mbTmp->RemapIDs( ev, ODMENUID_SHELL_FIRST, ODMENUID_USER_LAST
                  ,     &toLow,               IDMA_CNT_SELECTEDREMAP_LAST  
                  );
}

SOM_Scope void  SOMLINK ContainerPartFillSelectedMenu( ContainerPart *somSelf,  Environment *ev,
        ODFrame * frame, ODMenuBar * menubar)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartFillSelectedMenu");

    HMODULE hmodDLL;
    
    if (DosQueryModuleHandle( THISDLL, &hmodDLL)) {
       beepprintf( "Isn't my DLL (%s) loaded?", THISDLL );   
    } /* endif */
    ODPlatformMenuBar   menuBar;


    ODBoolean ItemsAdded = kODFalse;
    if (_fSelection->Count() == 1 ) {
       AddMenuResourceLast( ev, hmodDLL, RESID_SELECTEDMENU, menubar, IDMS_SELECTED);

       ODMenuBar * mbx = somSelf->GetSPEMenuOfSelection( ev);
       if (mbx) {
          mbx->UpdateMenuDependencyChain( ev, ODMENUID_ALL );
          somSelf->RefreshRemappedSPEMenuOfSelection( ev );
          if ( _fRemappedSPEMenuOfSelection && _fRemappedSPEMenuOfSelection->GetFirstMenuID( ev, ODMENUID_ROOT) ) {
             ItemsAdded = kODTrue;
             menubar->AddMenuBLast( ev, _fRemappedSPEMenuOfSelection, IDMS_SELECTED );
          } /* endif */
       } /* endif */
    } else if (_fSelection->Count() > 1) {
          // if we supported multiple selection, we'd support the
          //    the our current (10/94) spectrum of commands on the
          //    selected menu, so we wouldn't need to disable any.
    } else {
          // there is no selection.  We'll disable the menu items
          //   here since they don't do anything.
          AddMenuResourceLast( ev, hmodDLL, RESID_NOTHINGSELECTEDMENU, menubar, IDMS_SELECTED);
    } /* endif */

    if (!ItemsAdded) {
       // remove the additional separator that we put in since
       //   it doesn't look very good if it is there, but there are
       //   no items below it.
       menubar->RemoveMenu( ev, IDMA_CNT_SEPARATOR5 );
    } /* endif */
}

SOM_Scope void  SOMLINK ContainerPartAdjustSPEMenu( ContainerPart *somSelf,  Environment *ev,
        ODFrame * frame, ODMenuBar * menubar, ODMenuID menuID )
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartAdjustSPEMenu");

    // the following code could be made more efficient, by only updating the 
    //     portion of the menubar designated by the menuID parameter.

    menubar->RemoveMenu( ev, ODMENUID_ROOT );

    HMODULE hmodDLL;
    if (DosQueryModuleHandle( THISDLL, &hmodDLL)) {
       beepprintf( "Isn't my DLL (%s) loaded?", THISDLL );   
    } /* endif */
    ODPlatformMenuBar   menuBar2;
    
    DosGetResource2( hmodDLL
                   , RT_MENU
                   , RESID_WHENSELECTEDMENU
                   , (PPVOID)&menuBar2
                   );
    menubar->AddMenuLast( ev, ODMENUID_ROOT, menuBar2, 0 );
    DosFreeResource( (PVOID)menuBar2 );
 
    AddMenuResourceLast( ev, hmodDLL, RESID_BACKGROUNDMENU, menubar, IDMSL_COLOR_BASE );

    PartInfoRec* pInfo = (PartInfoRec *) frame->GetPartInfo(ev);
    ODUShort mi = MenuColorFromRGBColor( pInfo->bgColor );
    menubar->CheckItem(  ev, mi, kODTrue );
}

SOM_Scope void  SOMLINK ContainerPartAdjustPopupMenu( ContainerPart *somSelf,  Environment *ev,
        ODFrame * frame, ODMenuBar * menubar,  ODMenuID menuID )
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartAdjustPopupMenu");

    // the following code could be made more efficient, by only updating the 
    //     portion of the menubar designated by the menuID parameter.

    enum { selectedMenu, selfMenu } WhichMenu;
    {
       // Right here one would normally have code that decides which
       //   menu to display.  One of the criterion would be if the click
       //   was in the selected area.  Right now, I haven't added any code
       //   to detect where the click was, so I'll just alter the menu 
       //   depending if there is a selection or not rather than if the click
       //   was over the selection.  In a few weeks I'll add code to 
       //   comply with the Human Interface Specification.

       WhichMenu = (_fSelection->Count() > 0)  ? selectedMenu :  selfMenu;
    }

    HMODULE hmodDLL;
    if (DosQueryModuleHandle( THISDLL, &hmodDLL)) {
       beepprintf( "Isn't my DLL (%s) loaded?", THISDLL );   
    } /* endif */
    ODPlatformMenuBar   menuBar;

    menubar->RemoveMenu( ev, ODMENUID_ROOT );

    if ( WhichMenu == selectedMenu ) {
   
       DosGetResource2( hmodDLL
                      , RT_MENU
                      , RESID_POPUPMENU_S
                      , (PPVOID)&menuBar
                      );
       {
          ODMenuBar * mbNew = new ODMenuBar;
          mbNew->InitMenuBar(ev,  _fSession, menuBar );
          menubar->AddMenuBLast(ev,  mbNew, ODMENUID_ROOT );
          delete mbNew;
       }
       DosFreeResource( (PVOID)menuBar );
   
       ODBoolean ItemsAdded = kODFalse;
       if (_fSelection->Count() == 1 ) {
          ODMenuBar * mbx = somSelf->GetSPEMenuOfSelection( ev);
          if (mbx) {
             mbx->UpdateMenuDependencyChain( ev, ODMENUID_ALL );
             somSelf->RefreshRemappedSPEMenuOfSelection( ev );
             if ( _fRemappedSPEMenuOfSelection && _fRemappedSPEMenuOfSelection->GetFirstMenuID( ev, ODMENUID_ROOT) ) {
                ItemsAdded = kODTrue;
                menubar->AddMenuBLast( ev, _fRemappedSPEMenuOfSelection, ODMENUID_ROOT );
             } /* endif */
          } /* endif */
       } else {
          // if we supported multiple selection, we'd support the
          //    the our current (10/94) spectrum of commands on the
          //    selected menu, so we wouldn't need to disable any.
       } /* endif */

       if (!ItemsAdded) {
          // remove the additional separator that we put in since
          //   it doesn't look very good if it is there, but there are
          //   no items below it.
          menubar->RemoveMenu( ev, IDMP_CNT_SEPARATOR8 );
       } /* endif */
    } else if ( WhichMenu == selfMenu ) {
       // this is the popup menu that I've chosen to display when a the
       //    RMB click is over the background.  
       DosGetResource2( hmodDLL
                      , RT_MENU
                      , RESID_POPUPMENU_O
                      , (PPVOID)&menuBar
                      );
       {
          ODMenuBar * mbNew = new ODMenuBar;
          mbNew->InitMenuBar(ev,  _fSession, menuBar );
          menubar->AddMenuBLast(ev,  mbNew, ODMENUID_ROOT );
//+ (rlt 3-8-95)
       PartInfoRec* pInfo = (PartInfoRec *) frame->GetPartInfo(ev);
       menubar->CheckItem( ev, IDMA_TOGGLE_GRID, pInfo->fGridOn);
//-
          delete mbNew;
       }

       DosGetResource2( hmodDLL
                      , RT_MENU
                      , RESID_BACKGROUNDMENU
                      , (PPVOID)&menuBar
                      );
       {

          ODMenuBar * mbNew = new ODMenuBar;
          mbNew->InitMenuBar(ev,  _fSession, menuBar );
          menubar->AddMenuBLast(ev,  mbNew, IDMP_COLOR_BASE );
          delete mbNew;
       }
       DosFreeResource( (PVOID)menuBar );

       PartInfoRec* pInfo = (PartInfoRec *) frame->GetPartInfo(ev);
       ODUShort mi = MenuColorFromRGBColor( pInfo->bgColor );
       menubar->CheckItem(  ev, mi, kODTrue );
    } else {
       // this part doesn't really have any intrinsic data, but if it did
       //   I might chose to build a special popup menu here that
       //   reflects the actions that can be performed on the piece
       //   of intrinsic data under the mouse pointer.
    } /* endif */
}

SOM_Scope void  SOMLINK ContainerPartAdjustMenus(ContainerPart *somSelf,  Environment *ev,
                                    ODFrame* frame)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartAdjustMenus");

    PartInfoRec* pInfo = (PartInfoRec *) frame->GetPartInfo(ev);
    #ifdef USE_PARTINFO_TO_RECALL_AMENU
       ODActiveFrameMenuBar * mb = pInfo->mbActive;
    #else
       ODActiveFrameMenuBar * mb = (ODActiveFrameMenuBar*)frame->GetWindow(ev)->GetMenuBar( ev);
    #endif

    mb->RemoveMenu( ev, ODMENUID_ROOT );

    ODWindow * window = frame->GetWindow( ev);
    ODMenuBar * mbold = window->GetBaseMenuBar(ev);
    mb->AddMenuBLast( ev, mbold, ODMENUID_ROOT );

    #if 1
       HMODULE hmodDLL;
       if (DosQueryModuleHandle( THISDLL, &hmodDLL)) {
          beepprintf( "Isn't my DLL (%s) loaded?", THISDLL );   
       } /* endif */
       ODPlatformMenuBar   menuBar;

       DosGetResource2( hmodDLL
                      , RT_MENU
                      , RESID_TOPMENU
                      , (PPVOID)&menuBar
                      );
       mb->AddMenuBefore(ev,  kODNULL, menuBar, somSelf, IDMS_HELP );
       DosFreeResource( (PVOID)menuBar );

       DosGetResource2( hmodDLL
                      , RT_MENU
                      , RESID_EDMENU
                      , (PPVOID)&menuBar
                      );
       {
          ODMenuBar * mbNew = new ODMenuBar;
          mbNew->InitMenuBar(ev,  _fSession, menuBar );
          mb->AddMenuBLast(ev,  mbNew, IDMS_EDIT );
          delete mbNew;
       }
       DosFreeResource( (PVOID)menuBar );

       DosGetResource2( hmodDLL
                      , RT_MENU
                      , RESID_BACKGROUNDMENU
                      , (PPVOID)&menuBar
                      );
       {
          ODMenuBar * mbNew = new ODMenuBar;
          mbNew->InitMenuBar(ev,  _fSession, menuBar );
          mb->AddMenuBLast(ev,  mbNew, IDMA_COLOR_BASE );
          delete mbNew;
       }
       DosFreeResource( (PVOID)menuBar );
       {
          CollectHandlers(ev, _fSession);
          mb->AddMenuBLast(ev,  mbPartHandlers, IDMA_EMBED_BASE);
       }
       somSelf->FillSelectedMenu( ev,
                          frame, mb );
    #endif


    // for demo purposes, we'll do some wacky things here with
    //   menu item text, check state, and enablement.
    #if 1
       _DemoOpenCount++;
       {
          char stagestring[40];
          sprintf( stagestring, "Menu open count: %d", _DemoOpenCount);
          mb->SetItemString( ev, IDMA_CNT_DEMOITEM2, stagestring);
       }

       mb->CheckItem(  ev, IDMA_CNT_DEMOITEM2, (_DemoState & 1) );
       mb->EnableItem( ev, IDMA_CNT_DEMOITEM2, (_DemoState & 2) );
    #endif
}


SOM_Scope ODExtension*  SOMLINK ContainerPartGetExtension(ContainerPart *somSelf, Environment *ev,
                              ODType extensionName )
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartGetExtension");

    if ( !strcmp(extensionName, kODExtSelectedPartExtension) ) {
       if (!_fSelectedPartExtension) {
          _fSelectedPartExtension = new ODSelectedContainerPartExtension;
          _fSelectedPartExtension->InitSCPExtension( ev, somSelf, _fSession );
       } /* endif */
       return _fSelectedPartExtension;
    } else {
       return ContainerPart_parent_ODPart_GetExtension(somSelf, ev, extensionName);
    } /* endif */
}


SOM_Scope boolean  SOMLINK ContainerPartHasExtension(ContainerPart *somSelf, Environment *ev,
                              ODType extensionName )
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartHasExtension");

    if ( !strcmp(extensionName, kODExtSelectedPartExtension) ) {
       return kODTrue;
    } else {
       return ContainerPart_parent_ODPart_HasExtension(somSelf, ev, extensionName);
    } /* endif */
}


SOM_Scope void  SOMLINK ContainerPartReleaseExtension(ContainerPart *somSelf, Environment *ev,
                              ODExtension * extension )
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartReleaseExtension");

    if ( !extension ) return;

    if (_fSelectedPartExtension  == extension) {
       _fSelectedPartExtension->Release( ev);
       _fSelectedPartExtension = 0;
    } else {
       ContainerPart_parent_ODPart_ReleaseExtension(somSelf, ev, extension);
    } /* endif */
}


SOM_Scope void  SOMLINK ContainerPartUndoAction(ContainerPart *somSelf,  Environment *ev,
                                   ODActionData actionState)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartUndoAction");

    // FOR NOW, WE JUST HAVE ONE ACTION THAT CAN BE UNDONE OR REDONE.
    SetBGColorRec*  undoRec = (SetBGColorRec*)actionState;

    somSelf->SetBGColor2(ev, undoRec->_fFrame, undoRec->_fOldColor);
}

SOM_Scope void  SOMLINK ContainerPartRedoAction(ContainerPart *somSelf,  Environment *ev,
                                   ODActionData actionState)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartRedoAction");

    // FOR NOW, WE JUST HAVE ONE ACTION THAT CAN BE UNDONE OR REDONE.
    SetBGColorRec*  undoRec = (SetBGColorRec*)actionState;

    somSelf->SetBGColor2(ev, undoRec->_fFrame, undoRec->_fNewColor);
}

SOM_Scope void  SOMLINK ContainerPartDisposeActionState(ContainerPart *somSelf,
                                            Environment *ev,
                                           ODActionData actionState,
                                           ODDoneState doneState)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartDisposeActionState");

    // FOR NOW, WE JUST HAVE ONE ACTION THAT CAN BE UNDONE OR REDONE.
    delete (SetBGColorRec*)actionState;
}

SOM_Scope void  SOMLINK ContainerPartWriteActionState(ContainerPart *somSelf,
                                          Environment *ev, ODPtr actionState,
                                         ODStorageUnitView* storageUnitView)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartWriteActionState");

}

SOM_Scope ODPtr  SOMLINK ContainerPartReadActionState(ContainerPart *somSelf,
                                          Environment *ev, ODStorageUnitView* storageUnitView)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartReadActionState");

    return kODNULL;
}

SOM_Scope void  SOMLINK ContainerPartInitPart(ContainerPart *somSelf,  Environment *ev,
                                 ODStorageUnit* storageUnit)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartInitPart");

    if (somSelf->IsInitialized(ev))
      return;

    somSelf->InitPersistentObject(ev, storageUnit);

    //    AppleTestDraw_DrawPart_parent_ODPart_InitPart(somSelf,ev,storageUnit);

    //  SimplePart::InitPart(storageUnit);

    somSelf->CommonInitContainerPart(ev);

    ODStorageUnit* msu = somSelf->GetStorageUnit(ev);

    msu->AddProperty(ev, kODPropDisplayFrames)->AddValue(ev, kODIDs);
    msu->AddProperty(ev, kODPropEmbeddedFrames)->AddValue(ev, kODIDs);
    msu->AddProperty(ev, kODPropContents)->AddValue(ev, kKindTestContainer);

    // I'm not even sure that we need this GroupID property, but I don't have time to 
    //    check right now.  (todo) (jlc 94-11)
    ODULong FrameGroupIDCounter = 1;
    msu->AddProperty(ev, kODPropFrameGroup)->AddValue(ev, kODULong);
    msu->SetValue(ev, sizeof(ODULong), (ODValue)&FrameGroupIDCounter);
}

SOM_Scope void  SOMLINK ContainerPartInitPartFromStorage(ContainerPart *somSelf,
                                             Environment *ev,
                                            ODStorageUnit* storageUnit)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartInitPartFromStorage");

    if (somSelf->IsInitialized(ev))
      return;

    somSelf->InitPersistentObjectFromStorage(ev, storageUnit);

  //    AppleTestDraw_DrawPart_parent_ODPart_InitPartFromStorage(somSelf,ev,storageUnit);


  //  SimplePart::InitPartFromStorage(storageUnit);

    somSelf->CommonInitContainerPart(ev);


    ODStorageUnit* su;
     ODStorageUnitRef aSURef;
    ODFrame* frame;
    ODShape* newShape;
    ODULong offset, offsetLimit;
    //HRGN newRegion;
    ODPoint  ptOffset;
    ODTransform* transform;

    su = somSelf->GetStorageUnit(ev);
    //su->Focus(ev, kODPropContents,kODPosSame,kKindTestContainer,1,kODPosFirstSib);
    //su->GetValue(ev, sizeof(ODStorageUnitRef),&aSURef);
    //_fTestDrawSU = su->GetDraft(ev)->GetStorageUnit(ev, su->GetIDFromStorageUnitRef(ev, aSURef));
    //su = _fTestDrawSU;

    su->Focus(ev, kODPropDisplayFrames, kODPosSame, 0, 1, kODPosFirstSib);
    offsetLimit = su->GetSize(ev);
    for (offset = 0; offset < offsetLimit; offset += sizeof(ODStorageUnitRef))
    {
      su->SetOffset(ev, offset);
      su->GetValue(ev, sizeof(ODStorageUnitRef), (ODValue)&aSURef);

      try {

        frame = su->GetDraft(ev)->GetFrame(ev, su->GetIDFromStorageUnitRef(ev, aSURef));
        _fDisplayFrames->AddLast((ElementType)frame);
        frame->SetDroppable(ev, kODTrue);

      } catch (... ) {

        frame = kODNULL;

      } /* endcatch */
    }

// Fix to focus on value instead of index <4> rlt
    su->Focus(ev, kODPropContents,kODPosUndefined,kKindTestContainer,0,kODPosUndefined);

    offsetLimit = su->GetSize(ev);
    newShape = new ODShape();
    for (offset = 0; offset < offsetLimit;)
    {
      su->SetOffset(ev, offset);
      su->GetValue(ev, sizeof(ODStorageUnitRef), (ODValue)&aSURef);
      offset += sizeof(ODStorageUnitRef);
      frame = su->GetDraft(ev)->GetFrame(ev, su->GetIDFromStorageUnitRef(ev, aSURef));
      _fEmbeddedFrames->AddLast((ElementType)frame);

      su->SetOffset(ev, offset);
      su->GetValue(ev, sizeof(ptOffset), (ODValue)&ptOffset);
      offset += sizeof(ptOffset);
      transform = new ODTransform;
      transform->SetOffset(ev, &ptOffset);

      newShape->CopyFrom(ev, frame->GetFrameShape(ev));
      newShape->Transform(ev, transform);
#if 0 // (CED -110594)
      HRGN newRegion = newShape->CopyRegion(ev);
      _fContents->AddLast((ElementType)(new Proxy(newRegion, frame, transform)));
#else
      _fContents->AddLast((ElementType)(new Proxy(frame, transform)));
#endif
    }
    delete newShape;
}

SOM_Scope void  SOMLINK ContainerPartRelease(ContainerPart *somSelf,  Environment *ev)
{
    ContainerPartData *somThis = ContainerPartGetData(somSelf);
    ContainerPartMethodDebug("ContainerPart","ContainerPartRelease");

    Proxy*    p;
    ODFrame*  frame;

    ContainerPart_parent_ODPart_Release(somSelf, ev);
    if (somSelf->GetRefCount(ev) == 0) {
      //somSelf->HidePalette(ev);
      frame = (ODFrame*) _fDisplayFrames->First();
      while (frame != kODNULL) {
        _fDisplayFrames->Remove(frame);
        ODReleaseObject(ev,frame);
        frame = (ODFrame*) _fDisplayFrames->First();
      }
      frame = (ODFrame*) _fEmbeddedFrames->First();
      while (frame != kODNULL) {
        p = somSelf->ProxyForFrame(ev, frame);
        _fContents->Remove(p);
        _fEmbeddedFrames->Remove(frame);
        ODReleaseObject(ev,frame);
        frame = (ODFrame*) _fEmbeddedFrames->First();
      }
      somSelf->GetStorageUnit(ev)->GetDraft(ev)->ReleasePart(ev, somSelf);
    }
}

#ifdef __IBMC___
  #pragma lnkage (SOMInitModule, system)
#endif

SOMEXTERN void SOMLINK SOMInitModule (long majorVersion, long minorVersion,
                                 string className)
{
   SOM_IgnoreWarning (majorVersion);  /* This function makes   */
   SOM_IgnoreWarning (minorVersion);  /* no use of the passed  */
   SOM_IgnoreWarning (className);     /* arguments.            */

   ContainerPartNewClass ( ContainerPart_MajorVersion, ContainerPart_MinorVersion);
}
 
void EXPENTRY AddMenuResourceLast( Environment *ev, HMODULE hmodDLL, long resid, ODMenuBar *menubar, ODMenuID menuid)
{
    ODPlatformMenuBar   menuBar;
    DosGetResource2( hmodDLL
                   , RT_MENU
                   , resid
                   , (PPVOID)&menuBar
                   );
    {
       ODMenuBar * mbNew = new ODMenuBar;
       mbNew->InitMenuBar(ev,  /*_fSession*/0, menuBar );
       menubar->AddMenuBLast(ev,  mbNew, menuid );
       delete mbNew;
    }
    DosFreeResource( (PVOID)menuBar );
}
