#ifndef _ICUST_
  #define _ICUST_
/*******************************************************************************
* FILE NAME: icust.hpp                                                         *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class(es):                                              *
*    ICustomer - IBM sample customer part.                                     *
*                                                                              *
* COPYRIGHT:                                                                   *
*   Licensed Materials - Property of IBM                                       *
*   (C) Copyright IBM Corporation 1994, 1995                                   *
*   All Rights Reserved                                                        *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
* DISCLAIMER OF WARRANTIES:                                                    *
*   The following [enclosed] code is sample code created by IBM                *
*   Corporation.  This sample code is not part of any standard IBM product     *
*   and is provided to you solely for the purpose of assisting you in the      *
*   development of your applications.  The code is provided "AS IS",           *
*   without warranty of any kind.  IBM shall not be liable for any damages     *
*   arising out of your use of the sample code, even if they have been         *
*   advised of the possibility of such damages.                                *
*******************************************************************************/

#include <ipart.hpp>
#include <istring.hpp>
#include <idate.hpp>
#include <itime.hpp>

class IAddress;

#if 0
/*-------------------------- Pragma Library Support --------------------------*/
#ifndef __NO_DEFAULT_LIBS__
  #ifdef IC_PM
    #ifdef __IMPORTLIB__
       #pragma library("CPPOV03I.LIB")
    #else
       #pragma library("CPPOV03O.LIB")
    #endif
  #endif
  #ifdef IC_WIN
    #ifdef __IMPORTLIB__
       #pragma library("CPPWV03I.LIB")
    #else
       #pragma library("CPPWV03O.LIB")
    #endif
  #endif
#endif
#endif  /* #if 0 */


/*----------------------------------------------------------------------------*/
/* Align classes on four byte boundary.                                       */
/*----------------------------------------------------------------------------*/
#pragma pack(4)

class ICustomer : public IPart
{
public:
/*--------------------------- PUBLIC -----------------------------------------*/

/*------------------------- Constructors/Destructor ----------------------------
------------------------------------------------------------------------------*/
  ICustomer ();
  ICustomer (const IString& aName);
  ICustomer (const ICustomer& partCopy);
virtual
  ~ICustomer ();

/*-------------------------------- Operators -----------------------------------
|   operator ==       - Operator == (return true if equal).                    |
|   operator !=       - Operator != (return true if not equal).                |
------------------------------------------------------------------------------*/
  ICustomer& operator= (const ICustomer& aICustomer);
Boolean
  operator == (const ICustomer& aValue) const,
  operator != (const ICustomer& aValue) const,
  operator == (const ICustomer* aValue) const,
  operator != (const ICustomer* aValue) const;

virtual IString
  asString    ( ) const;

/*-------------------------------- Attributes ----------------------------------
| List of query and set members functions for this class:                      |
|                                                                              |
|   name              - Query the name (IString) attribute.                    |
|   address           - Query the address (IAddress*) attribute.               |
|   homePhone         - Query the homePhone (IString) attribute.               |
|   workPhone         - Query the workPhone (IString) attribute.               |
|   date              - Query the date (IDate) attribute.                      |
|   time              - Query the time (ITime) attribute.                      |
|   setName           - Set the name (IString) attribute.                      |
|   setAddress        - Set the address (IAddress*) attribute.                 |
|   setHomePhone      - Set the homePhone (IString) attribute.                 |
|   setWorkPhone      - Set the workPhone (IString) attribute.                 |
|   setDate           - Set the date (IDate) attribute.                        |
|   setTime           - Set the time (ITime) attribute.                        |
------------------------------------------------------------------------------*/

virtual IString
  name () const;
virtual ICustomer
 &setName (const IString& aName);

virtual IAddress*
  address () const;
virtual ICustomer
 &setAddress (IAddress* aAddress),
 &setAddress (const IAddress& aAddress);

virtual IString
  homePhone () const;
virtual ICustomer
 &setHomePhone (const IString& aHomePhone);

virtual IString
  workPhone () const;
virtual ICustomer
 &setWorkPhone (const IString& aWorkPhone);

virtual IDate
  date () const;
virtual ICustomer
 &setDate (const IDate& aDate);

virtual ITime
  time () const;
virtual ICustomer
 &setTime (const ITime& aTime);

/*-------------------------------- Actions -------------------------------------
| List of operations or services provided by this class:                       |
|                                                                              |
|   setNameToDefault  - Perform the setNameToDefault action.                   |
|   setAddressToDefault - Perform the setAddressToDefault action.              |
|   setHomePhoneToDefault - Perform the setHomePhoneToDefault action.          |
|   setWorkPhoneToDefault - Perform the setWorkPhoneToDefault action.          |
------------------------------------------------------------------------------*/
virtual ICustomer
  &setNameToDefault (),
  &setAddressToDefault (),
  &setHomePhoneToDefault (),
  &setWorkPhoneToDefault ();

/*----------------------- Notification Event Descriptions ----------------------
| List of attribute and event notification identifiers:                        |
|                                                                              |
|   nameId            - Notification ID provided to observers when the         |
|                       name attribute changes.                                |
|   addressId         - Notification ID provided to observers when the         |
|                       address attribute changes.                             |
|   homePhoneId       - Notification ID provided to observers when the         |
|                       homePhone attribute changes.                           |
|   workPhoneId       - Notification ID provided to observers when the         |
|                       workPhone attribute changes.                           |
|   dateId            - Notification ID provided to observers when the         |
|                       date attribute changes.                                |
|   timeId            - Notification ID provided to observers when the         |
|                       time attribute changes.                                |
------------------------------------------------------------------------------*/
static INotificationId const
  nameId,
  addressId,
  homePhoneId,
  workPhoneId,
  dateId,
  timeId;


private:
/*--------------------------- PRIVATE ----------------------------------------*/
  IString iName;                        //Data member for name attribute
  IAddress* iAddress;                   //Data member for address attribute
  IString iHomePhone;                   //Data member for homePhone attribute
  IString iWorkPhone;                   //Data member for workPhone attribute
  IDate iDate;                          //Data member for date attribute
  ITime iTime;                          //Data member for time attribute
};

/*----------------------------------------------------------------------------*/
/* Resume compiler default packing.                                           */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif
