#ifndef _IADD_
  #define _IADD_
/*******************************************************************************
* FILE NAME: iadd.hpp                                                          *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class(es):                                              *
*    IAddress - IBM sample address part.                                       *
*                                                                              *
* COPYRIGHT:                                                                   *
*   Licensed Materials - Property of IBM                                       *
*   (C) Copyright IBM Corporation 1994, 1995                                   *
*   All Rights Reserved                                                        *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
* DISCLAIMER OF WARRANTIES:                                                    *
*   The following [enclosed] code is sample code created by IBM                *
*   Corporation.  This sample code is not part of any standard IBM product     *
*   and is provided to you solely for the purpose of assisting you in the      *
*   development of your applications.  The code is provided "AS IS",           *
*   without warranty of any kind.  IBM shall not be liable for any damages     *
*   arising out of your use of the sample code, even if they have been         *
*   advised of the possibility of such damages.                                *
*******************************************************************************/

#include <ipart.hpp>

#ifndef _ISTRING_
  #include <istring.hpp>
#endif


#if 0
/*-------------------------- Pragma Library Support --------------------------*/
#ifndef __NO_DEFAULT_LIBS__
  #ifdef IC_PM
    #ifdef __IMPORTLIB__
       #pragma library("CPPOV03I.LIB")
    #else
       #pragma library("CPPOV03O.LIB")
    #endif
  #endif
  #ifdef IC_WIN
    #ifdef __IMPORTLIB__
       #pragma library("CPPWV03I.LIB")
    #else
       #pragma library("CPPWV03O.LIB")
    #endif
  #endif
#endif
#endif  /* #if 0 */

/*----------------------------------------------------------------------------*/
/* Align classes on four byte boundary.                                       */
/*----------------------------------------------------------------------------*/
#pragma pack(4)

class IAddress : public IPart
{
public:
/*--------------------------- PUBLIC -----------------------------------------*/

/*------------------------- Constructors/Destructor ----------------------------
------------------------------------------------------------------------------*/
  IAddress ();
  IAddress (const IAddress& partCopy);
virtual
  ~IAddress ();

/*-------------------------------- Operators -----------------------------------
|   operator ==       - Operator == (return true if equal).                    |
|   operator !=       - Operator != (return true if not equal).                |
------------------------------------------------------------------------------*/
  IAddress& operator= (const IAddress& aIAddress);
Boolean
  operator == (const IAddress& aValue) const,
  operator != (const IAddress& aValue) const,
  operator == (const IAddress* aValue) const,
  operator != (const IAddress* aValue) const;


/*-------------------------------- Attributes ----------------------------------
| List of query and set members functions for this class:                      |
|                                                                              |
|   street            - Query the street (IString) attribute.                  |
|   city              - Query the city (IString) attribute.                    |
|   state             - Query the state (IString) attribute.                   |
|   zip               - Query the zip (IString) attribute.                     |
|   setStreet         - Set the street (IString) attribute.                    |
|   setCity           - Set the city (IString) attribute.                      |
|   setState          - Set the state (IString) attribute.                     |
|   setZip            - Set the zip (IString) attribute.                       |
------------------------------------------------------------------------------*/

virtual IString
  street () const;
virtual IAddress
 &setStreet (const IString& aStreet);

virtual IString
  city () const;
virtual IAddress
 &setCity (const IString& aCity);

virtual IString
  state () const;
virtual IAddress
 &setState (const IString& aState);

virtual IString
  zip () const;
virtual IAddress
 &setZip (const IString& aZip);

/*-------------------------------- Actions -------------------------------------
| List of operations or services provided by this class:                       |
|                                                                              |
|   setStreetToDefault - Perform the setStreetToDefault action.                |
|   setCityToDefault  - Perform the setCityToDefault action.                   |
|   setStateToDefault - Perform the setStateToDefault action.                  |
|   setZipToDefault   - Perform the setZipToDefault action.                    |
|   setToDefault      - Perform the setToDefault action.                       |
------------------------------------------------------------------------------*/
virtual IAddress
  &setStreetToDefault (),
  &setCityToDefault (),
  &setStateToDefault (),
  &setZipToDefault (),
  &setToDefault ();

/*----------------------- Notification Event Descriptions ----------------------
| List of attribute and event notification identifiers:                        |
|                                                                              |
|   streetId          - Notification ID provided to observers when the         |
|                       street attribute changes.                              |
|   cityId            - Notification ID provided to observers when the         |
|                       city attribute changes.                                |
|   stateId           - Notification ID provided to observers when the         |
|                       state attribute changes.                               |
|   zipId             - Notification ID provided to observers when the         |
|                       zip attribute changes.                                 |
------------------------------------------------------------------------------*/
static INotificationId const
  streetId,
  cityId,
  stateId,
  zipId;


private:
/*--------------------------- PRIVATE ----------------------------------------*/
  IString iStreet;                      //Data member for street attribute
  IString iCity;                        //Data member for city attribute
  IString iState;                       //Data member for state attribute
  IString iZip;                         //Data member for zip attribute
};

/*----------------------------------------------------------------------------*/
/* Resume compiler default packing.                                           */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif
