#ifndef _CUSTVIEW_
#define _CUSTVIEW_

/*******************************************************************************
* FILE NAME: CUSTVIEW.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the declaration(s) of the class(es):                    *
*     MyCustomerView - Class representing an OpenDoc view (frame + facet) which*
*                    takes the form of a panel or dialog full of controls.     *
*                    This class behaves in most case like a UICL ICanvas.      *
*     MySecondaryCustomerView - Class representing an 2nd OpenDoc view         *
*                    (frame + facet) of the same model object.                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   Licensed Materials - Property of IBM                                       *
*   (C) Copyright IBM Corporation 1994                                         *
*   All Rights Reserved                                                        *
*   US Government Users Restricted Rights - Use, duplication, or               *
*   disclosure                                                                 *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
******************************************************************************   */

// ----- UICL Includes -----
#include <oformv.hpp>    //always first (achieve proper definition of "true", "false", etc.)

#include <iconnect.hpp>
#include <irect.hpp>
#include <ientryfd.hpp>
#include <ispinnum.hpp>
#include <ilistbox.hpp>
#include <imcelcv.hpp>
#include <istattxt.hpp>

//------ Local includes -------
#include <icust.hpp>
#include <icompany.hpp>
#include <iadd.hpp>
#include <custmodl.hpp>

// ----- OpenDoc Includes (if this part deals with OpenDoc directly anywhere) -----


// Forward declarations for other classes:
class IResourceId;


/*----------------------------------------------------------------------------  */
/* Align classes on four byte boundary.                                         */
/*----------------------------------------------------------------------------  */
#pragma pack(4)

class MyCustomerView : public ODFFormView {
/*******************************************************************************
* Class representing an view onto a CustomerModel object                       *
*******************************************************************************/
public:
   typedef ODFFormView Inherited;

/*-----------------------Constructor -------------------------------------------
| Constructor                                                                  |
------------------------------------------------------------------------------*/
  MyCustomerView (unsigned long windowId,
              CustomerModel *model,
              const ISize &initialSize = ISize(),
              const Style &style = defaultStyle ( ) );
  virtual  ~MyCustomerView();

  virtual CustomerModel *model();
  virtual MyCustomerView &makeConnections();

/*-----------------------View Connection to Model Object------------------------
| Methods in this view which respond to model and view changes.                |
------------------------------------------------------------------------------*/
   virtual void customerNameEFChanged();
   virtual void customerNameChanged();

   virtual void balanceEFChanged();
   virtual void balanceChanged();

   virtual MyCustomerView &drawView();


/*--------------------------------- Private ----------------------------------  */
private:
   MyCustomerView(const MyCustomerView &);
   MyCustomerView &operator =(const MyCustomerView &);

   IEntryField *customerNameEF, *balanceEF;
   IModelViewSynchConnection *customerNameConn, *balanceConn;
}; // MyCustomerView


class MySecondaryCustomerView : public ODFFormView {
/*******************************************************************************
* Class representing an view onto a CustomerModel object                       *
*******************************************************************************/
public:
   typedef ODFFormView Inherited;

/*-----------------------Constructor -------------------------------------------
| Constructor                                                                  |
------------------------------------------------------------------------------*/
  MySecondaryCustomerView (unsigned long windowId,
                       CustomerModel *model,
                       const ISize &initialSize = ISize(),
                       const Style &style = defaultStyle ( ) );
  virtual  ~MySecondaryCustomerView();

  virtual CustomerModel *model();
  virtual MySecondaryCustomerView &makeConnections();

/*-----------------------View Connection to Model Object------------------------
| Methods in this view which respond to model and view changes.                |
------------------------------------------------------------------------------*/
   virtual void customerNameEFChanged();
   virtual void customerNameChanged();

   virtual void customerStateLBChanged();
   virtual void customerStateChanged();

   virtual void companyEFChanged();
   virtual void companyChanged();



/*--------------------------------- Private ----------------------------------  */
private:
   MySecondaryCustomerView(const MySecondaryCustomerView &);
   MySecondaryCustomerView &operator =(const MySecondaryCustomerView &);

   IMultiCellCanvas  *multiCell;
   IEntryField customerNameEF;  //note in this view we use "solid" control objects
   IEntryField companyEF;
   IListBox stateListBox;
   IStaticText        custLabel, companyLabel, stateLabel;
   IModelViewSynchConnection *customerNameConn, *companyConn, *stateConn;

}; // MySecondaryCustomerView

/*----------------------------------------------------------------------------  */
/* Resume compiler default packing.                                             */
/*----------------------------------------------------------------------------  */
#pragma pack()
#endif /* _CUSTVIEW_ */
