/*******************************************************************************
* FILE NAME: custview.cpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in custview.hpp.                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   Licensed Materials - Property of IBM                                       *
*   (C) Copyright IBM Corporation 1994                                         *
*   All Rights Reserved                                                        *
*   US Government Users Restricted Rights - Use, duplication, or               *
*   disclosure                                                                 *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
// Priority INT_MIN (-2147483647 - 1) + 1024 + 512
#pragma priority( -2147482112 )

// ------- UICL and local includes ------------
#include <custview.hpp>
#include <ireslib.hpp>

#include <mydefs.h>
#include <icolor.hpp>

// Segment definitions 
#ifdef IC_PAGETUNE
  #define _CUSTVIEW _CPP_
  #include <ipagetun.h>
#endif


/*------------------------------------------------------------------------------
| MyCustomerView ::MyCustomerView                                              |
|                                                                              |
| Constructor to create a form view                                            |
------------------------------------------------------------------------------*/
MyCustomerView :: MyCustomerView (unsigned long ulId,
                          CustomerModel* model,
                          const ISize& sizeInit,
                          const Style& style)
   : ODFFormView (ulId,
                  (ODFModel*)model,
                  sizeInit,
                  style)
{
  IApplication::current().setUserResourceLibrary ("custpart.dll");
 
/******************************************************************************/
/* To RC compile this you must have the blues bitmap in the build directory   */
/* or substitute with another .bmp file.                                      */
/******************************************************************************/

  customerNameEF = new IEntryField(ID_CUST,  //Create entry field for customer name
                                this,
                                this,
                                IRectangle(10, 50, 190, 70) );
  balanceEF = new IEntryField(ID_BALANCE,  //Create entry field for account balance
                               this,
                               this,
                               IRectangle(10, 10, 150, 30) );

  // Don't set control values (or just set to a default); framework initializes
  //   you by calling your modelChangedFunctions shortly after this ctor completes.

  customerNameEF->setFocus();                //Set focus to customer entry field
}



/*------------------------------------------------------------------------------
| MyCustomerView ::~MyCustomerView                                             |
|                                                                              |
------------------------------------------------------------------------------*/
MyCustomerView  :: ~MyCustomerView ()
{
   removeConnection (customerNameConn);
   removeConnection (balanceConn);
   // All IWindow-derived children of our view (e.g., background, customerNameEF)
   //  are automatically deleted when our view is deleted.
}

/*------------------------------------------------------------------------------
| MyCustomerView ::makeConnections                                             |
|                                                                              |
------------------------------------------------------------------------------*/
MyCustomerView &MyCustomerView  :: makeConnections ()
{
  // Not all controls have to be modeled; some can be unrelated to any data in the
  // model object, simply part of canned view-related information such as titles.
  // Make note of the ones which are modeled.
  customerNameConn = new IModelViewSynchConnection( 
                           *(model()->customer()), 
                           ICustomer::nameId,
                           new IThreadMemberFn<MyCustomerView>
                                  (*this, customerNameChanged),
                           *this,
                           *customerNameEF,
                           new IThreadMemberFn<MyCustomerView>
                                  (*this, customerNameEFChanged)  );
  balanceConn = new IModelViewSynchConnection(
                           *(model()->balance()), Balance::balanceId,
                           new IThreadMemberFn<MyCustomerView>
                                  (*this, balanceChanged),
                           *this,
                           *balanceEF,
                           new IThreadMemberFn<MyCustomerView>
                                  (*this, balanceEFChanged)  );
}

/*------------------------------------------------------------------------------
| MyCustomerView ::drawView                                                    |
|                                                                              |
| Gives derived classes an opportunity to draw in the view. At this time,      |
| the view is already populated with controls. Default behavior is nothing.    |
------------------------------------------------------------------------------*/
MyCustomerView &MyCustomerView :: drawView()
{
   //Don't do any drawing (but we could...)
  return *this;
}


/*------------------------------------------------------------------------------
| MyCustomerView ::model                                                       |
|                                                                              |
| Override of ODFFormView method, so we return OUR type of model instead of    |
| a pointer typed to the base model class.                                     |
------------------------------------------------------------------------------*/
CustomerModel *MyCustomerView :: model()
{
  return (CustomerModel*)Inherited::model();
}


/*------------------------------------------------------------------------------
| MyCustomerView::customerNameEFChanged                                        |
|                                                                              |
------------------------------------------------------------------------------*/
void MyCustomerView :: customerNameEFChanged()
{
   if ( isViewEnabled() ) {
      model()->customer()->setName( customerNameEF->text() );
  } /* endif */
}

/*------------------------------------------------------------------------------
| MyCustomerView::customerNameChanged                                          |
|                                                                              |
------------------------------------------------------------------------------*/
void MyCustomerView :: customerNameChanged()
{
   if ( isViewEnabled() ) {
     customerNameEF->setText( model()->customer()->name() );
   } /* endif */
}


/*------------------------------------------------------------------------------
| MyCustomerView::balanceEFChanged                                             |
|                                                                              |
------------------------------------------------------------------------------*/
void MyCustomerView :: balanceEFChanged()
{
   if ( isViewEnabled() ) {
     // NOTE: is this an example of where primitive objects
     // are actually useful after all? Is this what Avalon uses it's primitive
     // objects for? see Steve, Dave L and also Steve Miller...
     // Or is it better to force the user to create a class (as I did here) with
     // only one attribute, with the assumption that the class will grow later?
     model()->balance()->setValue( (unsigned long) (balanceEF->text().asUnsigned()) );
   } /* endif */
}

/*------------------------------------------------------------------------------
| MyCustomerView::balanceChanged                                               |
|                                                                              |
------------------------------------------------------------------------------*/
void MyCustomerView :: balanceChanged()
{
   if ( isViewEnabled() ) {
      balanceEF->setText( model()->balance()->asString() );
   } /* endif */
}





/*------------------------------------------------------------------------------
| MySecondaryCustomerView ::MySecondaryCustomerView                            |
|                                                                              |
| Constructor to create a form view using a multicell canvas.                  |
| NOTE                                                                         |
|   Illustrates the use of a multi-cell canvas in a view.  Contrary to the     |
|   recommended approach of setting the parent and owner of controls within    |
|   the canvas to the canvas itself, this sample sets the owner of             |
|   the controls to the view. This is to achieve proper event handling in      |
|   particular cases. This practice may be changed in later driver.            |
------------------------------------------------------------------------------*/
MySecondaryCustomerView :: MySecondaryCustomerView (unsigned long ulId,
                                            CustomerModel* model,
                                            const ISize& sizeInit,
                                            const Style& style)
  : ODFFormView (ulId,
                 (ODFModel*)model,
                 sizeInit,
                 style),

   multiCell (new IMultiCellCanvas(ID_CANVAS, this, this)),
   customerNameEF(ID_CUST, multiCell, this, IRectangle(5, 210, 190, 230)),
   companyEF(ID_COMPANY, multiCell, this, IRectangle(5, 170, 190, 190)),
   stateListBox(ID_STATE, multiCell, this, IRectangle(60, 15, 220, 90)),
   custLabel (ID_CUST_LABEL, multiCell, this),
   companyLabel (ID_COMPANY_LABEL, multiCell, this),
   stateLabel (ID_STATE_LABEL, multiCell, this)

{
  IApplication::current().setUserResourceLibrary ("custpart.dll");

  custLabel.setText (ID_CUST_LABEL);
  custLabel.setLimit (custLabel.textLength());
  companyLabel.setText (ID_COMPANY_LABEL);
  companyLabel.setLimit (companyLabel.textLength());
  stateLabel.setText (ID_STATE_LABEL);
  stateLabel.setLimit (stateLabel.textLength());

  // Set the view's "client" to the multiCell so it will size when view is sized.
  setViewClient (multiCell);

  // Add controls to the multi-cell canvas.
  multiCell->addToCell (&custLabel, 2, 1, 2);
  multiCell->addToCell (&customerNameEF, 2, 2, 2);
  multiCell->addToCell (&companyLabel, 2, 4, 2);
  multiCell->addToCell (&companyEF, 2, 5, 2);
  multiCell->addToCell (&stateLabel, 2, 13, 2);
  multiCell->addToCell (&stateListBox, 2, 14, 2);
  multiCell->setColumnWidth (5, 10, true);
 
  //initialize the state listbox with it's three (view-specific) entries
  stateListBox.add(1, "New York");
  stateListBox.add(2, "North Carolina");
  stateListBox.add(3, "California");

  // Don't set control values (or just set to a default); framework initializes
  //   you by calling your modelChangedFunctions shortly after this ctor completes.

  customerNameEF.setFocus();                //Set focus to customer entry field
}


/*------------------------------------------------------------------------------
| MySecondaryCustomerView ::~MySecondaryCustomerView                                   |
|                                                                              |
------------------------------------------------------------------------------*/
MySecondaryCustomerView  :: ~MySecondaryCustomerView ()
{
   removeConnection (customerNameConn);
   removeConnection (companyConn);
   removeConnection (stateConn);
}


/*------------------------------------------------------------------------------
| MySecondaryCustomerView ::model                                              |
|                                                                              |
| Override of ODFFormView method, so we return OUR type of model instead of    |
| a pointer typed to the base model class.                                     |
------------------------------------------------------------------------------*/
CustomerModel *MySecondaryCustomerView :: model()
{
  return (CustomerModel*)Inherited::model();
}


/*------------------------------------------------------------------------------
| MySecondaryCustomerView ::makeConnections                                        |
|                                                                              |
------------------------------------------------------------------------------*/
MySecondaryCustomerView &MySecondaryCustomerView  :: makeConnections ()
{
  // Not all controls have to be modeled; some can be unrelated to any data in the
  // model object, simply part of canned view-related information such as titles.
  // Make note of the ones which are modeled.
  customerNameConn = new IModelViewSynchConnection( 
                           *(model()->customer()), ICustomer::nameId,
                           new IThreadMemberFn<MySecondaryCustomerView>
                                  (*this, customerNameChanged),
                           *this,
                           customerNameEF,
                           new IThreadMemberFn<MySecondaryCustomerView>
                                  (*this, customerNameEFChanged) );
  companyConn = new IModelViewSynchConnection(
                           *(model()->company()), ICompany::nameId,
                           new IThreadMemberFn<MySecondaryCustomerView>
                                  (*this, companyChanged),
                           *this,
                           companyEF,
                           new IThreadMemberFn<MySecondaryCustomerView>
                                  (*this, companyEFChanged) );
  stateConn = new IModelViewSynchConnection(
                           *(model()->customer()->address()), IAddress::stateId,
                           new IThreadMemberFn<MySecondaryCustomerView>
                                  (*this, customerStateChanged),
                           *this,
                           stateListBox,
                           new IThreadMemberFn<MySecondaryCustomerView>
                                  (*this, customerStateLBChanged) );
}


void MySecondaryCustomerView :: customerNameEFChanged()
{
   if ( isViewEnabled() ) {                             
     model()->customer()->setName( customerNameEF.text() );
  } /* endif */
}


void MySecondaryCustomerView :: customerNameChanged()
{
   if ( isViewEnabled() ) {
     customerNameEF.setText( model()->customer()->name() );
   } /* endif */
}


void MySecondaryCustomerView :: customerStateLBChanged()
{
   if ( isViewEnabled() ) {
     model()->customer()->address()->setState( stateListBox.itemText(stateListBox.selection()) );
   } /* endif */
}
void MySecondaryCustomerView :: customerStateChanged()
{
   if ( isViewEnabled() ) {
     unsigned long index = stateListBox.locateText( model()->customer()->address()->state() );
     stateListBox.select(index);
   } /* endif */
}


void MySecondaryCustomerView :: companyEFChanged()
{
   if ( isViewEnabled() ) {                             
     model()->company()->setName( companyEF.text() );
  } /* endif */
}


void MySecondaryCustomerView :: companyChanged()
{
   if ( isViewEnabled() ) {
     companyEF.setText( model()->company()->name() );
   } /* endif */
}
