#
# This makefile should be run in the directory
#   $(ODDIR)\samples\customer
# This build uses BETA2 code of UICL, you must have installed CSet++ V3.0 BETA2
#
# The actions included in this makefile are:
#   COMPILE::C Set ++ Compile

ODDIR = e:\opendoc7
ODFRKDIR = $(ODDIR)\odfrk
SMARTDIR = $(ODDIR)\samples\parts\simplprt
PUBLIC = $(ODDIR)\samples\parts\public
TOOLKIT = d:\toolkit
UICLBETA = d:\cppbeta
CCLBETA = d:\cppbeta
CPPBETA = d:\cppbeta
ODLIB = $(ODDIR)\lib
CRTLIB = $(CPPBETA)\lib\dde4mbsi.lib

WARN    =  /W1 /Wcns- /Wini-
INCLUDES = /I. \
           /I$(ODFRKDIR) \
           /I$(SMARTDIR) \
           /I$(ODDIR)\samples\parts\public \
           /I$(ODDIR)\hh \
           /I$(ODDIR)\include \
           /I$(ODDIR)\os2h \
           /I$(UICLBETA)\ibmclass \
#           /I$(CCLBETA)\ibmclass \
           /I$(CPPBETA)\include \
           /I$(CPPBETA)\include\os2 \
           /I$(CPPBETA)\inc \
           /I$(CPPBETA)\include\som \
           /I$(TOOLKIT)\som\include \
           /I$(TOOLKIT)\h \
           /I$(TOOLKIT)\inc

DEBUG   =  /Ti- /O+
#OPT     =  /Gm+ /Ge- /Fi /Si /Tdp /Gd
OPT     =  /Gm+ /Ge- /Tdp /Gd
OBJECTS = .\custmodl.obj .\custview.obj .\icust.obj .\icompany.obj .\iadd.obj .\balance.obj
# "NONTOBJ" is same list as in "OBJECTS" but without any Collection Classes-generated .cpps
NONTOBJ = .\custmodl.obj .\custview.obj .\icust.obj .\icompany.obj .\iadd.obj .\balance.obj

.all: \
  .\custpart.res \
  $(ODDIR)\bin\custpart.dll\
  $(ODLIB)\custpart.lib

makefile:  "$(BUILDDRIVE)\DESKTOP\OPENDOC\OPENDOC - BUILD\PARTS"
    -@echo Warning: If any action options have changed,
    -@echo you should re-run MakeMake.

.SUFFIXES:

.SUFFIXES: .cpp .rc

.cpp.obj:
      @echo WF::COMPILE::C Set ++ Compile
      icc.exe $(WARN) $(OPT) $(DEBUG) $(INCLUDES) /C %s

.rc.res:
    rc -r %s

.\custpart.def: $(OBJECTS)
    echo LIBRARY custpart INITINSTANCE TERMINSTANCE    >$@
    echo PROTMODE                                     >>$@
    echo DATA MULTIPLE NONSHARED READWRITE LOADONCALL >>$@
    echo CODE LOADONCALL                              >>$@
    echo EXPORTS                                      >>$@
    cppfilt /B /P /S $(OBJECTS)                       >>$@

$(ODDIR)\bin\custpart.dll: $(OBJECTS) \
    $(ODLIB)\opendoc.lib \
    .\custpart.def \
    .\custpart.res
      @echo WF::LINK::C Set ++ Link
      icc.exe @<<
$(DEBUG) $(OPT) $(INCLUDES) $(WARN)
 /B" /de /pmtype:pm /noi /noe /nod /map"
 /Fe$(ODDIR)\bin\custpart.dll
 /Fm./custpart.map
 $(NONTOBJ)
 $(ODLIB)\oformp.lib
 $(CRTLIB)
 $(ODLIB)\os2386.lib
 $(ODLIB)\OpenDoc.lib
 $(PUBLIC)\simplprt.lib
 $(UICLBETA)\lib\dde4muii.lib
 $(CCLBETA)\lib\dde4cci.lib
 $(CPPBETA)\lib\som.lib
 .\custpart.def
<<
  rc .\custpart.res $(ODDIR)\bin\custpart.dll

$(ODLIB)\custpart.lib: $(ODDIR)\bin\custpart.dll
   @echo IMPLIB::Import library contruction
   IMPLIB /NOLOGO $(ODLIB)\custpart.lib .\custpart.def
