
#ifndef _CUSTMODL_
#define _CUSTMODL_

/*******************************************************************************
* FILE NAME: custmodl.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class(es):                                              *
*     CustomerModel - This class is a example model class for parts whose data *
*                    consists of several data objects written elsewhere.       *
*                    This class can act as the model object for various view   *
*                    objects, including MyFormView and MyContainerObject  .    *
*                                                                              *
* COPYRIGHT:                                                                   *
*   Licensed Materials - Property of IBM                                       *
*   (C) Copyright IBM Corporation 1994                                         *
*   All Rights Reserved                                                        *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

// ----- UICL Includes -----
#include <oformp.hpp>       //always first (achieve proper definition of "true", "false", etc.)

#include <icust.hpp>
#include <icompany.hpp>
#include <iadd.hpp>
#include <balance.hpp>

#ifndef _MYDEFS_H
  #include <mydefs.h>
#endif

// ----- OpenDoc Includes (if this part deals with OpenDoc directly anywhere) -----


/*----------------------------------------------------------------------------  */
/* Align classes on four byte boundary.                                         */
/*----------------------------------------------------------------------------  */
#pragma pack(4)

// Forward declarations for other classes:
class MyCustomerView;
class MySecondaryCustomerView;
class ODStorageUnit;
class Balance;


class CustomerModel : public ODFModel {
/*******************************************************************************
* This class is an example class which derives from ODFModel.               *
*******************************************************************************/
public:
   typedef ODFModel Inherited;

   CustomerModel();
   virtual  ~CustomerModel();

   virtual ICustomer *customer();         //return the "customer" data content object
   virtual ICompany *company();           //return the "company" data content object
   virtual Balance *balance();                 //return the "balance" data content


   virtual CustomerModel &openViews();
   virtual CustomerModel &openView (IResourceId viewId);
   virtual void Externalize();
   virtual void InitPart (ODStorageUnit*);
   virtual void InitPartFromStorage (ODStorageUnit*);

/*--------------------------------- Private ----------------------------------*/
private:

   ICustomer *fCustomer;
   ICompany *fCompany;
   Balance *fBalance;
   ODStorageUnit    *auxsu;

#pragma SOMClassName (*, "CustomerModel")
}; // CustomerModel


/*----------------------------------------------------------------------------*/
/* Resume compiler default packing.                                           */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif /* _CUSTMODL_ */
