 /*******************************************************************************
* FILE NAME: custmodl.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in custmodl.hpp.                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   Licensed Materials - Property of IBM                                       *
*   (C) Copyright IBM Corporation 1992, 1994                                   *
*   All Rights Reserved                                                        *
*   US Government Users Restricted Rights - Use, duplication, or               *
*   disclosure                                                                 *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
// Priority INT_MIN (-2147483647 - 1) + 1024 + 512
#pragma priority( -2147482112 )

#pragma SOMAsDefault (off)

//=============== Local and UICL includes
#include <custmodl.hpp>
#include <custview.hpp>
#include <iframe.hpp>
#include <iexcept.hpp>
#include <istring.hpp>
#include <ireslib.hpp>
#include <irect.hpp>
#include <icolor.hpp>
#include <itrace.hpp>

//============= OpenDoc toolkit includes needed by code in this part which deals directly with OpenDoc
#define INCL_ODDRAFT
#define INCL_ODSTORAGESYSTEM
#define INCL_ODSTORAGEUNIT
#include <os2.hh>


// Segment definitions 
#ifdef IC_PAGETUNE
  #define _CUSTMODL_CPP_
  #include <ipagetun.h>
#endif

#pragma SOMAsDefault (pop)

#define kKindCustomerPart "CustomerModel::custpart"

const ODType kCustomerPartData = "CustomerModel Data";
const ODType kCustomerPartName = "CustomerModel Customer Name";
const ODType kCustomerPartState = "CustomerModel Customer Address State";
const ODType kCustomerPartBal = "CustomerModel Balance Value";

/*------------------------------------------------------------------------------
| CustomerModel::CustomerModel                                                 |
|                                                                              |
| Constructor to create a form part - protected, default ctor                  |
------------------------------------------------------------------------------*/
CustomerModel :: CustomerModel()
  : fCustomer(0), fCompany(0)
{
   // Obtain your model data. To keep this sample simple, we just hardcode it here;
   //  in real life, your data might come from a database, a file, etc.
   fCustomer = new ICustomer( IString("Rob Petri") );
   IAddress * address = new IAddress();
   address->setStreet( IString("148 Bonnie Meadow Lane") );
   address->setCity( IString("New Rochelle") );
   address->setState( IString("NY") );
   fCustomer->setAddress(address);

   fCompany = new ICompany( IString("Brady Productions, Inc.") );

   fBalance = new Balance(25000);

}


/*------------------------------------------------------------------------------
| CustomerModel::~CustomerModel                                                |
|                                                                              |
------------------------------------------------------------------------------*/
CustomerModel :: ~CustomerModel()
{
   delete fCompany;
   delete ( fCustomer->address() );
   delete fCustomer;
   delete fBalance;
}


//******next three functions are only small examples of how one might interact with
//****** OpenDoc toolkit to do persistance. ODFrk will simplify this in later driver...

/*------------------------------------------------------------------------------
| CustomerModel::InitPart                                                     |
|                                                                             |
| Override of ODPart::InitPart.                                               |
|       For now, you must deal directly with OD toolkit here.                 |
------------------------------------------------------------------------------*/
void CustomerModel :: InitPart (ODStorageUnit *su)
{
   if (IsInitialized())
      return;

   // Call the inherited InitPart (don't call InitPersistentObject).
   Inherited::InitPart (su);

   // Identify part.
   su->Focus (kODPropPart,
              kODPosUndefined,
              kODISOStr,
              0,
              kODPosUndefined);
   su->SetValue (strlen(kKindCustomerPart) + 1, (ODValue) kKindCustomerPart);   

   // Create an auxiliary storage unit for the class' contribution to the part
   // contents.
   auxsu = su->GetDraft()->CreateStorageUnit();

   // All of this class' content will be added to the auxiliary storaage unit  
   auxsu->AddProperty (kODPropContents);
   auxsu->AddValue (kCustomerPartName);
   auxsu->AddValue (kCustomerPartState);
   auxsu->AddValue (kCustomerPartBal);
                                    
   su->Focus (kODPropContents,
              kODPosUndefined,
              kODNULL,
              0,
              kODPosUndefined);
   su->AddValue ((ODValueType) kCustomerPartData);
   ODStorageUnitRef auxsuRef = su->GetStrongStorageUnitRef (auxsu);
   su->SetValue (sizeof (ODStorageUnitRef), &auxsuRef);

}

/*------------------------------------------------------------------------------
| CustomerModel::InitPartFromStorage                                          |
|                                                                             |
| Override of ODPart::InitPartFromStorage.                                    |
|       For now, you must deal directly with OD toolkit here                  |
------------------------------------------------------------------------------*/
void CustomerModel :: InitPartFromStorage (ODStorageUnit* su)
{
   ODStorageUnitRef auxsuRef;
   ODULong          valueSize;

   if (IsInitialized())
      return;

   // Call inherited InitPartFromStorage (not InitPersistentObjectFromStorage).
   Inherited::InitPartFromStorage (su);

   // Get this class' auxiliary storage unit.
   su->Focus (kODPropContents,
              kODPosUndefined,
              kCustomerPartData,
              0,
              kODPosUndefined);

   su->GetValue (su->GetSize(), &auxsuRef);
   auxsu = su->GetDraft()->GetStorageUnit (su->GetIDFromStorageUnitRef (auxsuRef));

   // Initialize from persistent data.
   auxsu->Focus (kODPropContents,
                 kODPosUndefined,
                 kCustomerPartName,
                 0,
                 kODPosUndefined);
   valueSize = auxsu->GetSize();
   char* customerName = (char*) malloc (valueSize);
   auxsu->GetValue (valueSize, customerName);
   customer()->setName( IString (customerName) );
   free (customerName);

   auxsu->Focus (kODNULL,
                 kODPosSame,
                 kCustomerPartState,
                 0,
                 kODPosUndefined);
   valueSize = auxsu->GetSize();
   char* state = (char*) malloc (valueSize);
   auxsu->GetValue (valueSize, state);
   customer()->address()->setState(IString (state));
   free (state);

   auxsu->Focus (kODPropContents,
                 kODPosUndefined,
                 kCustomerPartBal,
                 0,
                 kODPosUndefined);
   int tempBal;
   auxsu->GetValue (auxsu->GetSize(), &tempBal);
   balance()->setValue(tempBal);

}

/*------------------------------------------------------------------------------
| CustomerModel::Externalize                                                  |
|                                                                             |
| Override of ODPart::Externalize.  Write out persistent data to storage.     |
|       For now, you must deal directly with OD toolkit here                  |
------------------------------------------------------------------------------*/
void CustomerModel :: Externalize ()
{
   ODStorageUnit   *su = GetStorageUnit();
   ODStorageUnitRef auxsuRef;
   ODULong          valueSize, dataSize;

   Inherited::Externalize();

   auxsu->Focus (kODPropContents,
                 kODPosUndefined,
                 kCustomerPartName,
                 0,
                 kODPosUndefined);
   valueSize = auxsu->GetSize();
   dataSize = customer()->name().length() + 1;
   if (valueSize <= dataSize)
   {
      auxsu->SetValue ( valueSize, (ODValue)(char*)(customer()->name()) );
      auxsu->InsertValue (dataSize - valueSize,
                          (ODValue)(char*)(customer()->name().subString(valueSize + 1)) );
   }
   else
   {
      auxsu->SetValue ( dataSize, (ODValue)(char*)(customer()->name()) );
      auxsu->DeleteValue (valueSize - dataSize);
   }

   auxsu->Focus (kODNULL,
                 kODPosSame,
                 kCustomerPartState,
                 0,
                 kODPosUndefined);
   valueSize = auxsu->GetSize();
   IString tempState = customer()->address()->state();
   dataSize = tempState.length() + 1;
   if (valueSize <= dataSize)
   {
      auxsu->SetValue (valueSize, (ODValue)(char*)tempState);
      auxsu->InsertValue (dataSize - valueSize,
                          (ODValue)(char*)(tempState.subString(valueSize + 1)));
   }
   else
   {
      auxsu->SetValue (dataSize, (ODValue)(char*)tempState);
      auxsu->DeleteValue (valueSize - dataSize);
   }

   auxsu->Focus (kODNULL,
                 kODPosSame,
                 kCustomerPartBal,
                 0,
                 kODPosUndefined);
   int tempBal = balance()->value();
   auxsu->SetValue (sizeof (int), (ODValue)&tempBal);

   auxsu->Externalize();

   su->Focus (kODPropContents,
              kODPosUndefined,
              kCustomerPartData,
              0,
              kODPosUndefined);
   auxsuRef = su->GetStrongStorageUnitRef (auxsu);
   su->SetValue (sizeof (ODStorageUnitRef), &auxsuRef);
}


/*------------------------------------------------------------------------------
| CustomerModel::openViews                                                    |
|                                                                             |
| Create an initial view for this model                                       |
------------------------------------------------------------------------------*/
CustomerModel& CustomerModel :: openViews ()
{
  // This is one way to create views. It is also possible for some other piece
  // of code outside this class to create the view object(s), add them to this model, etc.
  openView(ID_FIRSTVIEW);
  openView(ID_SECONDVIEW);

  return *this;
}


/*------------------------------------------------------------------------------
| CustomerModel::openView                                                     |
|                                                                             |
| Restore view for this model                                                 |
------------------------------------------------------------------------------*/
CustomerModel& CustomerModel :: openView (IResourceId viewId)
{
  MyCustomerView *firstView;
  MySecondaryCustomerView *secondView;
  switch (viewId) {
   case ID_FIRSTVIEW:
     firstView =
          new MyCustomerView (ID_FIRSTVIEW,
                              this,
                              ISize (200, 100));  // Specified size
                                                     // only used during initial
                                                     // creation.
                                                  // style defaults
     firstView->setModelUpdateMode(ODFFormView::immediate);
     firstView->makeConnections();
     addView (firstView);
     firstView->initializeView();
     firstView->setBackgroundColor(IColor::red);
     firstView->setForegroundColor(IColor::black);
     break;
   case ID_SECONDVIEW:
     secondView =
           new MySecondaryCustomerView (ID_SECONDVIEW,
                                        this,
                                        ISize (200,320) );  // style defaults
     // let ModelUpdateMode default (to onFocusChange)
     secondView->makeConnections();
     addView(secondView);
     secondView->initializeView();
     break;
  }

  return *this;
}


/*------------------------------------------------------------------------------
| CustomerModel::customer                                                     |
|                                                                             |
| Return the "customer" model content object                                  |
------------------------------------------------------------------------------*/
ICustomer* CustomerModel :: customer ()
{
  return fCustomer;
}


/*------------------------------------------------------------------------------
| CustomerModel::company                                                      |
|                                                                             |
| Return the "company" model content object                                   |
------------------------------------------------------------------------------*/
ICompany* CustomerModel :: company ()
{
  return fCompany;
}


/*------------------------------------------------------------------------------
| CustomerModel::balance                                                      |
|                                                                             |
| Return the "balance" model content object                                   |
------------------------------------------------------------------------------*/
Balance* CustomerModel :: balance ()
{
  return fBalance;
}

