#ifndef _BALANCE_
  #define _BALANCE_
/*******************************************************************************
* FILE NAME: iadd.hpp                                                          *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class(es):                                              *
*    Balance - Builder part written by hypothetical customer                   *
*                                                                              *
* COPYRIGHT:                                                                   *
*   Licensed Materials - Property of IBM                                       *
*   (C) Copyright IBM Corporation 1994, 1995                                   *
*   All Rights Reserved                                                        *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
* DISCLAIMER OF WARRANTIES:                                                    *
*   The following [enclosed] code is sample code created by IBM                *
*   Corporation.  This sample code is not part of any standard IBM product     *
*   and is provided to you solely for the purpose of assisting you in the      *
*   development of your applications.  The code is provided "AS IS",           *
*   without warranty of any kind.  IBM shall not be liable for any damages     *
*   arising out of your use of the sample code, even if they have been         *
*   advised of the possibility of such damages.                                *
*******************************************************************************/

#include <ipart.hpp>

#if 0
/*-------------------------- Pragma Library Support --------------------------*/
#ifndef __NO_DEFAULT_LIBS__
  #ifdef IC_PM
    #ifdef __IMPORTLIB__
       #pragma library("CPPOV03I.LIB")
    #else
       #pragma library("CPPOV03O.LIB")
    #endif
  #endif
  #ifdef IC_WIN
    #ifdef __IMPORTLIB__
       #pragma library("CPPWV03I.LIB")
    #else
       #pragma library("CPPWV03O.LIB")
    #endif
  #endif
#endif
#endif  /* #if 0 */

/*----------------------------------------------------------------------------*/
/* Align classes on four byte boundary.                                       */
/*----------------------------------------------------------------------------*/
#pragma pack(4)

class Balance : public IPart {
/*******************************************************************************
* This class is an attempt to see how a user would make a one-value addition   *
* to the canned data content objects available. Is this too much "work"?       *
*******************************************************************************/
public:
   typedef IBase Inherited;

   Balance(int aValue) : fValue(aValue)
    {;}
   virtual  ~Balance() 
    {;}
   int value() {return fValue;}
   Balance &setValue(int aValue) {fValue=aValue;}
   IString asString() {return IString(fValue);}

//??? In stream-oriented persistance support, use TStream??? ostream? new class?
//   IStream
//     &operator <<= (IStream  &aStream) { return aStream + fValue;}

/*----------------------- Notification Event Descriptions ----------------------
| List of attribute and event notification identifiers:                        |
|                                                                              |
|   balanceId         - Notification ID provided to observers when the         |
|                       balance value changes.                                 |
------------------------------------------------------------------------------*/
static INotificationId const
  balanceId;

private:
   int fValue;
}; // Balance



/*----------------------------------------------------------------------------*/
/* Resume compiler default packing.                                           */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif /* BALANCE */
