/* 
 *      File:           simplprt.cpp //+(rlt 3-8-95)
 *
 *   Contains:  IDL description of Container Part
 *
 *   Written by:        Jason Crawford
 *
 *
 *   Change History (most recent first):
 *      
 *       <3>      3-8-95         rlt    Fixed clips based on Content transformation
 *       <2>      3-8-95         rlt    Changed Default color
 *       <1>      3-8-95         rlt    Added History preamble
 *
 *
 */
/*
 *  This file was generated by the SOM Compiler and Emitter Framework.
 *  Generated using:
 *      SOM Emitter emitxtm: 2.38
 */

#ifndef SOM_Module_simplprt_Source
#define SOM_Module_simplprt_Source
#endif
#define SimplePart_Class_Source
#define VARIABLE_MACROS

#define INCL_GPICONTROL
#define INCL_GPIPRIMITIVES
#define INCL_GPIREGIONS
#define INCL_GPITRANSFORMS
#define INCL_WININPUT
#define INCL_WINSTDDRAG

#define INCL_ODARBITRATOR
#define INCL_ODCANVAS
#define INCL_ODDRAGANDDROP
#define INCL_ODDRAFT
#define INCL_ODERRORS
#define INCL_ODFACET
#define INCL_ODFOCUSSET
#define INCL_ODFRAME
#define INCL_ODMENUBAR
#define INCL_ODSHAPE
//#define INCL_ODSEMANTICINTERFACE
#define INCL_ODSESSION
#define INCL_ODSTORAGEUNIT
#define INCL_ODSTORAGEUNITVIEW
#define INCL_ODTRANSFORM
#define INCL_ODUNDO
#define INCL_ODWINDOW
#define INCL_ODWINDOWSTATE
#include <os2.h>



#include "SimplPrt.xih"
#include "PartInfo.hpp"     //mcs aj - we have made PartInfo public

#include "print.h"
#include "common.hpp"
#include <string.h>

#define UNDONEEDSFIXINMAYBE

#define YGRID 32
#define XGRID 32

static const ODPropertyName  kPropFrameInfo = "SimplePart:Property:FrameInfo";
static const ODPropertyName  kPropMouseDownOffset = "SimplePart:Property:MouseDownOffset";

// todo: The following entry almost certainly needs to be placed in a public location
static const ODValueType    kOS2POINTL = "Bento:OS2:IBM:POINTL";

const ODType   kSimplePartPresNormal  = "SimplePart:Presentation:Normal";
const ODType   kSimplePartPresPalette = "SimplePart:Presentation:Palette";
const ODType   kSimplePartValueType   = "SimplePart Color";
#define kKindTestSimple "SimplePart:simplprt"


const ODCommandID cODColor = 2000;
const ODCommandID cODGray = 2001;
const ODCommandID cODRed = 2002;
const ODCommandID cODGreen = 2003;
const ODCommandID cODYellow = 2004;
const ODCommandID cODBlue = 2005;
const ODCommandID cODMagenta = 2006;
const ODCommandID cODCyan = 2007;
const ODCommandID cODWhite = 2008;
const ODCommandID cODOtherColor = 2009;



//#if 1 mcs aj
#if 0
   // we may want to make PartInfoRec public and declare it in its
   // own IDL file.   I'll wait until after the port before attempting
   // that. (jlc 94-8)
   class PartInfoRec
   {
   public:
      PartInfoRec() { fIsActive = kODFalse; fNeedsActivating = kODFalse; }
      virtual ~PartInfoRec() { }
      RGBColor bgColor;
      HRGN   bgClipRegion;
      ODBoolean  fIsActive;  // Does this frame have its focus set?
      ODBoolean  fNeedsActivating; // should this be activated when its window is activated?
   };
#endif

// SetBGColorRec is used for Undo/Redo.
struct SetBGColorRec
{
  SetBGColorRec(RGBColor oldColor, RGBColor newColor, ODFrame* frame)
          {_fOldColor = oldColor; _fNewColor = newColor;
            _fFrame = frame;}
  RGBColor   _fOldColor;
  RGBColor   _fNewColor;
  ODFrame*  _fFrame;
};






SOM_Scope ODSemanticInterface*  SOMLINK SimplePartGetSemanticInterface(SimplePart *somSelf,
                                                                        Environment *ev)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartGetSemanticInterface");

    return (ODSemanticInterface *) 0;
}

SOM_Scope void  SOMLINK SimplePartCommonInitSimplePart(SimplePart *somSelf,
                                                        Environment *ev)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartCommonInitSimplePart");

    static int defcolor = 4; //+ (rlt - 3-8-95)

   _fDefaultColor = (defcolor++) % 8;  // pick semi random color
   _fSession = somSelf->GetStorageUnit(ev)->GetSession(ev);
   _fSelectionFocus = _fSession->Tokenize(ev, kODSelectionFocus);
   _fMenuFocus = _fSession->Tokenize(ev, kODMenuFocus);
   _fKeyFocus = _fSession->Tokenize(ev, kODKeyFocus);

   _fFocusSet = new ODFocusSet();
   _fFocusSet->InitFocusSet(ev);
   _fFocusSet->Add(ev, _fSelectionFocus);
   _fFocusSet->Add(ev, _fMenuFocus);
   _fFocusSet->Add(ev, _fKeyFocus);

}

SOM_Scope ODBoolean  SOMLINK SimplePartHandleMouseDown(SimplePart *somSelf,
                                                        Environment *ev,
                                                       ODFacet* facet,
                                                       ODPoint* where,
                                                       ODEventData* event)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartHandleMouseDown");

    somSelf->Activate(ev, facet);

    return kODTrue;
}

SOM_Scope void  SOMLINK SimplePartMoveResize(SimplePart *somSelf,
                                              Environment *ev,
                                             ODFacet* facet,
                                             Proxy* selection,
                                             ODSLong fs)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartMoveResize");


}

SOM_Scope ODBoolean  SOMLINK SimplePartHandleMouseDownDrag(SimplePart *somSelf,
                                                            Environment *ev,
                                                           ODFacet* facet,
                                                           Proxy* selection,
                                                           ODEventData* event)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartHandleMouseDownDrag");

    return kODFalse;
}

SOM_Scope ODBoolean  SOMLINK SimplePartHandleMouseDownEdgeResize(SimplePart *somSelf,
                                                                  Environment *ev,
                                                                 ODFacet* facet,
                                                                 Proxy* selection,
                                                                 POINTL* mouse)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartHandleMouseDownEdgeResize");

    return kODFalse;
}

SOM_Scope ODBoolean  SOMLINK SimplePartHandleMouseDownCornerResize(SimplePart *somSelf,
                                                                    Environment *ev,
                                                                   ODFacet* facet,
                                                                   Proxy* selection,
                                                                   POINTL* mouse)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartHandleMouseDownCornerResize");

    return kODFalse;
}

SOM_Scope ODBoolean  SOMLINK SimplePartHandleKeyDown(SimplePart *somSelf,
                                                      Environment *ev,
                                                     ODFrame* focusFrame,
                                                     ODEventData* event)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartHandleKeyDown");

    DosBeep(200,30);
    return kODTrue;
}

SOM_Scope ODBoolean  SOMLINK SimplePartHandleMenuEvent(SimplePart *somSelf,
                                                        Environment *ev,
                                                       ODFrame* focusFrame,
                                                       ODEventData* event)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartHandleMenuEvent");

    return kODTrue;
}

SOM_Scope ODBoolean  SOMLINK SimplePartHandleMouseMove(SimplePart *somSelf,
                                                        Environment *ev,
                                                       ODFacet* facet,
                                                       ODPoint* where,
                                                       ODEventData* event)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartHandleMouseMove");

    return kODTrue;
}


SOM_Scope void  SOMLINK SimplePartActivateFrame(SimplePart *somSelf,
                                                 Environment *ev,
                                                ODFrame* frame)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartActivateFrame");

    if (frame != kODNULL) {

    ODBoolean succeeded = false;

    succeeded = _fSession->GetArbitrator(ev)->RequestFocusSet(ev, _fFocusSet,frame);

    if (succeeded)
    {
       somSelf->FocusAcquired(ev, _fSelectionFocus, frame);
       somSelf->FocusAcquired(ev, _fMenuFocus, frame);
       somSelf->FocusAcquired(ev, _fKeyFocus, frame);
    }
  }

}

SOM_Scope void  SOMLINK SimplePartDeActivateFrame(SimplePart *somSelf,
                                                   Environment *ev,
                                                  ODFrame* frame)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartDeActivateFrame");

    if (frame != kODNULL) {
       _fSession->GetArbitrator(ev)->RelinquishFocusSet(ev, _fFocusSet,frame);
       somSelf->FocusLost(ev, _fSelectionFocus, frame);
       somSelf->FocusLost(ev, _fMenuFocus, frame);
       somSelf->FocusLost(ev, _fKeyFocus, frame);
    }
}

SOM_Scope void  SOMLINK SimplePartActivatingWindow(SimplePart *somSelf,
                                                    Environment *ev,
                                                   ODFrame* frame)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartActivatingWindow");
    PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo(ev);
    if (pInfo->fNeedsActivating)
    {
       somSelf->ActivateFrame(ev, frame);
       pInfo->fNeedsActivating = kODFalse;
    }
}

SOM_Scope void  SOMLINK SimplePartDeActivatingWindow(SimplePart *somSelf,
                                                      Environment *ev,
                                                     ODFrame* frame)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartDeActivatingWindow");
    PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo(ev);
    if (frame == _fSession->GetArbitrator(ev)->GetFocusOwner(ev, _fSelectionFocus))
    {
       pInfo->fNeedsActivating = kODTrue;
       //somSelf->DeActivateFrame(ev, frame);
    }
    else
       pInfo->fNeedsActivating = kODFalse;

}


SOM_Scope void  SOMLINK SimplePartUserSetBGColor(SimplePart *somSelf,
                                                  Environment *ev,
                                                 ODFrame* frame,
                                                 RGBColor whichColor)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartUserSetBGColor");
#ifdef NOT_YET
    PartInfoRec* pInfo = (PartInfoRec *) frame->GetPartInfo(ev);
    if (!pInfo)
    {
      pInfo = new PartInfoRec;
      frame->SetPartInfo(ev, (ODInfoType) pInfo);
    }
    if (whichColor != pInfo->bgColor)
    {
      somSelf->SetBGColor(ev, frame, whichColor);
    }
#endif
}

SOM_Scope void  SOMLINK SimplePartSetBGColor(SimplePart *somSelf,
                                              Environment *ev,
                                             ODFrame* aFrame,
                                             ODUShort whichColor)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartSetBGColor");
#ifdef NOT_YET
    PartInfoRec* pInfo = (PartInfoRec *) aFrame->GetPartInfo(ev);
    if (!pInfo)
    {
      pInfo = new PartInfoRec;
      aFrame->SetPartInfo(ev, (ODInfoType) pInfo);
    }

   RGBColor newColor = pInfo->bgColor;

   switch (whichColor)
   {
      break;
      case  cODGray:    newColor = 7 % 8;     break;
      case  cODRed:     newColor = 6 % 8;     break;
      case  cODGreen:   newColor = 5 % 8;     break;
      case  cODYellow:  newColor = 4 % 8;     break;
      case  cODBlue:    newColor = 3 % 8;     break;
      case  cODMagenta: newColor = 2 % 8;     break;
      case  cODCyan:    newColor = 1 % 8;     break;
      case  cODWhite:   newColor = 0 % 8;     break;
      default: break;
   }
   somSelf->UserSetBGColor(ev, aFrame,newColor);
#endif
}

SOM_Scope void  SOMLINK SimplePartSetGrafPortOrigin(SimplePart *somSelf,
                                                     Environment *ev,
                                                    ODFacet* facet)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartSetGrafPortOrigin");

    ODTransform* localToGlobal = facet->GetContentTransform(ev);
    HPS hps = facet->GetCanvas(ev)->GetPlatformCanvas(ev);
    MATRIXLF mtx;
    facet->GetContentTransform(ev)->GetMATRIXLF(ev, &mtx);
    GpiSetModelTransformMatrix(hps, 9, &mtx, TRANSFORM_REPLACE);
    facet->GetCanvas(ev)->ReleasePlatformCanvas(ev);
}

SOM_Scope ODWindow*  SOMLINK SimplePartCreateWindow(SimplePart *somSelf,
                                                     Environment *ev,
                                                    ODFrame* sourceFrame)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartCreateWindow");

    Rect windRect;
    ODPlatformWindow platformWindow = kODNULL;
    ODWindow* window = kODNULL;

    platformWindow = _fSession->CreatePlatformWindow(ev);
    window =  _fSession->GetWindowState(ev)->CreateWindow(ev, platformWindow,
                                         (sourceFrame==kODNULL),  // Keeps draft open
                                         kODTrue,  // Is resizable
                                         kODFalse, // Is floating
                                         kODTrue,  // should save
                                      somSelf, kODNullTypeToken, kODNullTypeToken, sourceFrame);
    return window;
}

SOM_Scope RGBColor  SOMLINK SimplePartGetDefaultColor(SimplePart *somSelf, 
                                                       Environment *ev)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartGetDefaultColor");

    return ( _fDefaultColor );
}

SOM_Scope void  SOMLINK SimplePartSetDefaultColor(SimplePart *somSelf, 
                                                   Environment *ev, 
                                                  RGBColor color)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartSetDefaultColor");

    _fDefaultColor = color;
}

SOM_Scope void  SOMLINK SimplePartsomInit(SimplePart *somSelf)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartsomInit");

    SimplePart_parent_ODPart_somInit(somSelf);

    _fWindowID = 0;

    _fFrameGroupIDCounter = 1;

    _fContents = kODNULL;

    _fFocusSet = kODNULL;

    _fSemtIntf = kODNULL;

    _fSession = kODNULL;

    _fTestDrawSU = kODNULL;
}

SOM_Scope void  SOMLINK SimplePartsomUninit(SimplePart *somSelf)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartsomUninit");


    #define SEMANTIC_INTERFACES_NOT_DONE
    #ifndef SEMANTIC_INTERFACES_NOT_DONE
       if (_fSemtIntf != kODNULL)
           delete _fSemtIntf;
    #endif

    Environment * ev = somGetGlobalEnvironment();
    ODReleaseObject(ev,_fTestDrawSU);
    SimplePart_parent_ODPart_somUninit(somSelf);
}

SOM_Scope void  SOMLINK SimplePartFulfillPromise(SimplePart *somSelf,
                                                  Environment *ev,
                                                 ODStorageUnitView* promiseSUView)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartFulfillPromise");

}

SOM_Scope void  SOMLINK SimplePartDropCompleted(SimplePart *somSelf,
                                                 Environment *ev,
                                                ODPart* destPart,
                                                ODDropResult dropResult)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartDropCompleted");

}

SOM_Scope MRESULT  SOMLINK SimplePartDragEnter(SimplePart *somSelf,
                                                Environment *ev,
                                               ODDragItemIterator* dragInfo,
                                               ODFacet* facet,
                                               ODPoint* where)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartDragEnter");


    return MRFROM2SHORT (DOR_NEVERDROP, DO_UNKNOWN);

}

SOM_Scope MRESULT  SOMLINK SimplePartDragWithin(SimplePart *somSelf,
                                                 Environment *ev,
                                                ODDragItemIterator* dragInfo,
                                                ODFacet* facet,
                                                ODPoint* where)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartDragWithin");

    return MRFROM2SHORT (DOR_NEVERDROP, DO_UNKNOWN);
}

SOM_Scope void  SOMLINK SimplePartDragLeave(SimplePart *somSelf,
                                             Environment *ev,
                                            ODFacet* facet, ODPoint* where)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartDragLeave");

}

SOM_Scope ODDropResult  SOMLINK SimplePartDrop(SimplePart *somSelf,
                                                Environment *ev,
                                               ODDragItemIterator* dropInfo,
                                               ODFacet* facet,
                                               ODPoint* where)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartDrop");

    return kODDropFail;


}

SOM_Scope void  SOMLINK SimplePartContainingPartPropertiesChanged(SimplePart *somSelf,
                                                                   Environment *ev,
                                                                  ODFrame* frame,
                                                                  ODStorageUnit* propertyUnit)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartContainingPartPropertiesChanged");


}

SOM_Scope ODStorageUnit*  SOMLINK SimplePartGetContainingPartProperties(SimplePart *somSelf,
                                                                         Environment *ev,
                                                                        ODFrame* frame)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartGetContainingPartProperties");


    // this part has no properties to return
    return kODNULL;

}

SOM_Scope void  SOMLINK SimplePartRevealFrame(SimplePart *somSelf,
                                               Environment *ev,
                                              ODFrame* embeddedFrame,
                                              ODShape* revealShape)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartRevealFrame");

}

SOM_Scope void  SOMLINK SimplePartEmbeddedFrameSpec(SimplePart *somSelf,
                                                     Environment *ev,
                                                    ODFrame* embeddedFrame,
                                                    ODObjectSpec spec)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartEmbeddedFrameSpec");

}

SOM_Scope ODEmbeddedFramesIterator*  SOMLINK SimplePartCreateEmbeddedFramesIterator(SimplePart *somSelf,
                                                                                     Environment *ev,
                                                                                    ODFrame* frame)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartCreateEmbeddedFramesIterator");

    THROW(kODErrCannotEmbed);
}

SOM_Scope void  SOMLINK SimplePartAddDisplayFrame(SimplePart *somSelf,
                                                   Environment *ev,
                                                  ODFrame* frame)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartAddDisplayFrame");

   PartInfoRec* pInfo = new PartInfoRec;
   if (frame->IsRoot(ev))
     pInfo->fNeedsActivating = kODTrue;

   frame->SetPartInfo(ev, (ODInfoType) pInfo);
   return;

}

SOM_Scope void  SOMLINK SimplePartAttachSourceFrame(SimplePart *somSelf,
                                                     Environment *ev,
                                                    ODFrame* frame,
                                                    ODFrame* sourceFrame)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartAttachSourceFrame");

}

SOM_Scope void  SOMLINK SimplePartRemoveDisplayFrame(SimplePart *somSelf,
                                                      Environment *ev,
                                                     ODFrame* frame)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartRemoveDisplayFrame");

    if (frame  != kODNULL)
    {
          _fSession->GetArbitrator(ev)->RelinquishFocusSet(ev, _fFocusSet,frame );
 
          PartInfoRec* pInfo = (PartInfoRec*) frame ->GetPartInfo(ev);
          frame ->SetPartInfo(ev, (ODInfoType) kODNULL);
//AJ          delete pInfo;
        //  frame ->Release(ev);
 
    }
}

SOM_Scope void  SOMLINK SimplePartCloseDisplayFrame(SimplePart *somSelf,
                                                     Environment *ev,
                                                    ODFrame* frame)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartCloseDisplayFrame");
//AJ    somSelf->RemoveDisplayFrame( ev, frame );
    return;
}

SOM_Scope void  SOMLINK SimplePartFrameShapeChanged(SimplePart *somSelf,
                                                     Environment *ev,
                                                    ODFrame* frame)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartFrameShapeChanged");

}

SOM_Scope void  SOMLINK SimplePartViewTypeChanged(SimplePart *somSelf,
                                                   Environment *ev,
                                                  ODFrame* frame)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartViewTypeChanged");
}

SOM_Scope void  SOMLINK SimplePartPresentationChanged(SimplePart *somSelf,
                                                       Environment *ev,
                                                      ODFrame* frame)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartPresentationChanged");

}

SOM_Scope void  SOMLINK SimplePartSequenceChanged(SimplePart *somSelf,
                                                   Environment *ev,
                                                  ODFrame* frame)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartSequenceChanged");
}

SOM_Scope void  SOMLINK SimplePartWritePartInfo(SimplePart *somSelf,
                                                 Environment *ev,
                                                ODPtr partInfo,
                                                ODStorageUnitView* storageUnitView)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartWritePartInfo");

    if (partInfo)
    {
      ODBoolean needsActivating = ((PartInfoRec*)partInfo)->fNeedsActivating
                    || ((PartInfoRec*)partInfo)->fIsActive;
      storageUnitView->SetValue(ev, sizeof(ODBoolean),
                    (ODValue)&needsActivating);
    }

}

SOM_Scope ODPtr  SOMLINK SimplePartReadPartInfo(SimplePart *somSelf,
                                                 Environment *ev,
                                                ODFrame* frame,
                                                ODStorageUnitView* storageUnitView)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartReadPartInfo");

    if (storageUnitView->GetSize(ev))
    {
//      PartInfoRec* partInfo = new PartInfoRec;
      // Derived class must create PartInfoRec.  Would like to add different interface for
      // initializing partinfo.      mcs 3/21/95  aj6/6/95
      PartInfoRec* partInfo = (PartInfoRec*)frame->GetPartInfo(ev);

      ODBoolean needsActivating;
      storageUnitView->GetValue(ev, sizeof(ODBoolean),
                    (ODValue)&(needsActivating));
      partInfo->fNeedsActivating = needsActivating;

      return partInfo;
    }
    else
      return ((ODPtr)kODNULL);
}

SOM_Scope ODID  SOMLINK SimplePartOpen(SimplePart *somSelf,  Environment *ev,
                                       ODFrame* frame)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartOpen");

    ODWindow* window = kODNULL;

    if (frame) // Doing a View As Window
    {
      window = _fSession->GetWindowState(ev)->GetWindow(ev, _fWindowID);
      if (window)
        window->Select(ev);
      else
      {
        window = somSelf->CreateWindow(ev, frame);
        _fWindowID = window->GetID(ev);
        window->Open(ev);
        window->Show(ev);
        window->Select(ev);
      }
    }
    else
    {
      window = somSelf->CreateWindow(ev, frame);
      _fWindowID = window->GetID(ev);
      window->Open(ev);
      window->Show(ev);
      window->Select(ev);
    }
    return window->GetID(ev);

}

SOM_Scope ODFrame*  SOMLINK SimplePartRequestEmbeddedFrame(SimplePart *somSelf,
                                                            Environment *ev,
                                                           ODFrame* containingFrame,
                                                           ODFrame* baseFrame,
                                                           ODShape* frameShape,
                                                           ODPart* embedPart,
                                                           ODTypeToken viewType,
                                                           ODTypeToken presentation,
                                                           ODBoolean isOverlaid)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartRequestEmbeddedFrame");
    return baseFrame;
}

SOM_Scope void  SOMLINK SimplePartRemoveEmbeddedFrame(SimplePart *somSelf,
                                                       Environment *ev,
                                                      ODFrame* embeddedFrame)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartRemoveEmbeddedFrame");

}

SOM_Scope ODShape*  SOMLINK SimplePartRequestFrameShape(SimplePart *somSelf,
                                                         Environment *ev,
                                                        ODFrame* embeddedFrame,
                                                        ODShape* frameShape)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartRequestFrameShape");

    return frameShape;
}
SOM_Scope void  SOMLINK SimplePartUsedShapeChanged(SimplePart *somSelf,
                                                    Environment *ev,
                                                   ODFrame* embeddedFrame)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartUsedShapeChanged");

}

SOM_Scope ODShape*  SOMLINK SimplePartAdjustBorderShape(SimplePart *somSelf,
                                                         Environment *ev,
                                                        ODFrame* embeddedFrame,
                                                        ODShape* shape)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartAdjustBorderShape");

    return shape;
}

SOM_Scope void  SOMLINK SimplePartFacetAdded(SimplePart *somSelf,
                                              Environment *ev,
                                             ODFacet* facet)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartFacetAdded");

}

SOM_Scope void  SOMLINK SimplePartFacetRemoved(SimplePart *somSelf,
                                                Environment *ev,
                                               ODFacet* facet)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartFacetRemoved");

}

SOM_Scope void  SOMLINK SimplePartCanvasChanged(SimplePart *somSelf,
                                                 Environment *ev,
                                                ODFacet* facet)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartCanvasChanged");

}

SOM_Scope void  SOMLINK SimplePartGeometryChanged(SimplePart *somSelf,
                                                   Environment *ev,
                                                  ODFacet* facet)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartGeometryChanged");

}

SOM_Scope void  SOMLINK SimplePartDraw(SimplePart *somSelf,  Environment *ev,
                                       ODFacet* facet, ODShape* invalidShape)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartDraw");

    ODBoolean drawing = facet->GetCanvas(ev)->IsDynamic(ev);

    ODFrame* displayFrame = facet->GetFrame(ev);
      // transform grafport

         HPS hpsDraw = facet->GetCanvas(ev)->GetPlatformCanvas(ev);
         GpiSavePS(hpsDraw);

         HRGN frameRgn = displayFrame->GetFrameShape(ev)->GetRegion(ev);
         Rect frameRect;
         GpiQueryRegionBox(hpsDraw, frameRgn, &frameRect);

         // set up clipping
         HRGN saveClip;
         ODShape* clipShape = new ODShape;
         clipShape->CopyFrom(ev, facet->GetAggregateClipShape(ev));
         clipShape->Transform(ev, facet->GetFrameTransform(ev));
         HRGN clip = clipShape->GetRegion(ev);
         GpiSetClipRegion(hpsDraw, clip, &saveClip);

               // paint the background

               GpiResetPS(hpsDraw, GRES_ATTRS);

               somSelf->SetGrafPortOrigin(ev, facet);

               RGBColor bgRGB = _fDefaultColor;
               //RGBColor bgRGB = pInfo->bgColor;
               // ULONG ulRGB = (bgRGB.bRed << 16) + (bgRGB.bGreen << 8) + bgRGB.bBlue;
               // ULONG lColorIndex = GpiQueryColorIndex(hpsDraw, 0, ulRGB);
               // GpiSetColor(hpsDraw, pInfo->bgColor);
               GpiSetColor(hpsDraw, _fDefaultColor);
               POINTL ptl = {frameRect.xRight, frameRect.yTop};
               GpiBox(hpsDraw, DRO_FILL, &ptl, 0, 0);

               GpiSetLineType(hpsDraw, LINETYPE_DASHDOUBLEDOT);
               GpiSetColor(hpsDraw, CLR_BLACK);

               for (int y = 0; y < frameRect.yTop; y += YGRID) {
                  ptl.y = y;
                  ptl.x = 0;
                  GpiMove(hpsDraw, &ptl);
                  ptl.x = frameRect.xRight;
                  ptl.y += frameRect.xRight;
                  GpiLine(hpsDraw, &ptl);
               }

               for (int x = XGRID; x < frameRect.xRight; x += XGRID) {
                  ptl.x = x;
                  ptl.y = 0;
                  GpiMove(hpsDraw, &ptl);
                  ptl.x += frameRect.yTop;
                  ptl.y = frameRect.yTop;
                  GpiLine(hpsDraw, &ptl);
               }
         GpiRestorePS(hpsDraw, -1);

         GpiSetClipRegion(hpsDraw, saveClip, (PHRGN)0);
         facet->GetCanvas(ev)->ReleasePlatformCanvas(ev);
         delete clipShape;


}

SOM_Scope void  SOMLINK SimplePartCanvasUpdated(SimplePart *somSelf,
                                                 Environment *ev,
                                                ODCanvas* canvas)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartCanvasUpdated");

}

SOM_Scope void  SOMLINK SimplePartHighlightChanged(SimplePart *somSelf,
                                                    Environment *ev,
                                                   ODFacet* facet)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartHighlightChanged");

}


SOM_Scope ODLink*  SOMLINK SimplePartCreateLink(SimplePart *somSelf,
                                                 Environment *ev,
                                                ODPtr data, ODULong size)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartCreateLink");

    return 0;

}

SOM_Scope void  SOMLINK SimplePartLinkUpdated(SimplePart *somSelf,
                                               Environment *ev,
                                              ODLink* updatedLink,
                                              ODChangeID id)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartLinkUpdated");

}

SOM_Scope void  SOMLINK SimplePartRevealLink(SimplePart *somSelf,
                                              Environment *ev,
                                             ODLinkSource* linkSource)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartRevealLink");

}

SOM_Scope void  SOMLINK SimplePartEmbeddedFrameChanged(SimplePart *somSelf,
                                                        Environment *ev,
                                                       ODFrame* frame,
                                                       ODChangeID change)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartEmbeddedFrameChanged");

}

SOM_Scope void  SOMLINK SimplePartLinkStatusChanged(SimplePart *somSelf,
                                                     Environment *ev,
                                                    ODFrame* frame)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartLinkStatusChanged");

}

SOM_Scope ODBoolean  SOMLINK SimplePartBeginRelinquishFocus(SimplePart *somSelf,
                                                             Environment *ev,
                                                            ODTypeToken focus,
                                                            ODFrame* ownerFrame,
                                                            ODFrame* proposedFrame)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartBeginRelinquishFocus");


    return kODTrue;
}

SOM_Scope void  SOMLINK SimplePartCommitRelinquishFocus(SimplePart *somSelf,
                                                         Environment *ev,
                                                        ODTypeToken focus,
                                                        ODFrame* ownerFrame,
                                                        ODFrame* proposedFrame)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartCommitRelinquishFocus");

    somSelf->FocusLost(ev, focus, ownerFrame);
}

SOM_Scope void  SOMLINK SimplePartAbortRelinquishFocus(SimplePart *somSelf,
                                                        Environment *ev,
                                                       ODTypeToken focus,
                                                       ODFrame* ownerFrame,
                                                       ODFrame* proposedFrame)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartAbortRelinquishFocus");

}

SOM_Scope void  SOMLINK SimplePartFocusAcquired(SimplePart *somSelf,
                                                 Environment *ev,
                                                ODTypeToken focus,
                                                ODFrame* ownerFrame)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartFocusAcquired");
    if (focus == _fSelectionFocus)
    {
      PartInfoRec* pInfo = (PartInfoRec*) ownerFrame->GetPartInfo(ev);
      pInfo->fIsActive = kODTrue;
    } else if (focus == _fMenuFocus) {
      ODWindow * window = ownerFrame->GetWindow( ev);
      #ifdef OLDMENUS
         ODMenuBar * mb = window->CopyBaseMenuBar(ev);
         window->SetMenuBar(ev,  mb );
         mb->Release( ev);
      #else
         ODMenuBar * mb = window->GetBaseMenuBar(ev);
         window->SetMenuBar(ev,  mb );
      #endif
    }

}

SOM_Scope void  SOMLINK SimplePartFocusLost(SimplePart *somSelf,
                                             Environment *ev,
                                            ODTypeToken focus,
                                            ODFrame* ownerFrame)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartFocusLost");
    if (focus == _fSelectionFocus)
    {
      PartInfoRec* pInfo = (PartInfoRec*) ownerFrame->GetPartInfo(ev);
      pInfo->fIsActive = kODFalse;
    } else if (focus == _fMenuFocus) {
      ODWindow * window = ownerFrame->GetWindow( ev);
      window->SetMenuBar(ev,  0 );
    }
}

SOM_Scope void  SOMLINK SimplePartCloneInto(SimplePart *somSelf,
                                             Environment *ev,
                                            ODDraftKey key, ODStorageUnit* storageUnit,
                                            ODStorageUnit* initiatingFrame)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartCloneInto");

    ODStorageUnit*  su = somSelf->GetStorageUnit(ev);

    somSelf->Externalize(ev);

    ODStorageUnit* destTestDrawSU = su
            ->CloneTo(ev, key, storageUnit->GetDraft(ev), initiatingFrame);

    storageUnit->AddProperty(ev, kODPropContents);
    storageUnit->AddValue(ev, kKindTestSimple);
    ODStorageUnitRef aSURef = storageUnit->GetStrongStorageUnitRef(ev, destTestDrawSU);
    storageUnit->SetValue(ev, sizeof(ODStorageUnitRef),&aSURef);

    destTestDrawSU->Release(ev);

    su->CloneInto(ev, key, storageUnit, initiatingFrame);
}

SOM_Scope void  SOMLINK SimplePartExternalizeKinds(SimplePart *somSelf,
                                                    Environment *ev,
                                                   ODTypeList* kindset)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartExternalizeKinds");

    somSelf->Externalize(ev);
}

SOM_Scope void  SOMLINK SimplePartExternalize(SimplePart *somSelf,
                                               Environment *ev)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartExternalize");


    ODStorageUnit* su = somSelf->GetStorageUnit(ev);
// mcs AJ: no need to store these here, since class derived from simplprt will store its own kind, etc.
//    su->AddProperty(ev, kODPropPart);
//    su->AddValue(ev, kODISOStr);
//    su->SetValue(ev, strlen(kKindTestSimple) + 1, (ODValue) kKindTestSimple);
//    su->AddProperty(ev, kODPropContents);
//    su->AddValue(ev, (ODValueType) kSimplePartValueType);
//    su->SetValue(ev, sizeof(RGBColor),  (ODValue) &_fDefaultColor);

}

SOM_Scope void  SOMLINK SimplePartChangeKind(SimplePart *somSelf,
                                              Environment *ev,
                                             ODType kind)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartChangeKind");

}

SOM_Scope ODBoolean  SOMLINK SimplePartHandleEvent(SimplePart *somSelf,
                                                    Environment *ev,
                                                   ODEventData* event,
                                                   ODFrame* frame,
                                                   ODFacet* facet)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartHandleEvent");

    ODBoolean handled = kODFalse;

    switch (event->msg)
    {
       case WM_BUTTON1DOWN:
          {
             ODPoint windowODPoint(ODPOINTL(SHORT1FROMMP(event->mp1), 
                                            SHORT2FROMMP(event->mp1)));
             handled = somSelf->HandleMouseDown(ev, facet, &windowODPoint, event);
          }
          break;


       case WM_CONTEXTMENU       :
          handled = kODTrue;   // We're too lazy to implement a context menu
                                     //   and if we don't return true the message will
                                     //   be propagated to the parent frame.  We could
                                     //   prevent that by clearing PropagateEvents,
                                     //   but this should also work.
          event->result = (MRESULT)1; // handled
          break;
       case WM_CHAR:
          if (!(SHORT1FROMMP(event->mp1) & KC_KEYUP)) {
             handled = somSelf->HandleKeyDown(ev, frame, event);
          } /* endif */
          break;
       
       case WM_ACTIVATE:
          handled = true; // actually ignored by dispatcher
          if (SHORT1FROMMP(event->mp1) != 0)
             somSelf->ActivatingWindow(ev, frame);
          else
             somSelf->DeActivatingWindow(ev, frame);
          break;

       case WM_COMMAND:
          if (SHORT1FROMMP(event->mp2) & CMDSRC_MENU ||
              SHORT1FROMMP(event->mp2) & CMDSRC_ACCELERATOR)
          {
             handled = somSelf->HandleMenuEvent(ev, frame, event);
          }
          break;

       default:
          return kODFalse;
    }
    return handled;
}

SOM_Scope ODBoolean  SOMLINK SimplePartHandleEventInEmbedded(SimplePart *somSelf,
                                                              Environment *ev,
                                                             ODEventData* event,
                                                             ODFrame* frame,
                                                             ODFacet* facet,
                                                             ODFrame* embeddedFrame,
                                                             ODFacet* embeddedFacet)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartHandleEventInEmbedded");

    return kODFalse;
}

SOM_Scope void  SOMLINK SimplePartMouseEnter(SimplePart *somSelf,
                                              Environment *ev,
                                             ODFacet* facet,
                                             ODPoint* where)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartMouseEnter");

                                      //   pointer type we prefer.
}

SOM_Scope void  SOMLINK SimplePartMouseWithin(SimplePart *somSelf,
                                               Environment *ev,
                                              ODFacet* facet,
                                              ODPoint* where)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartMouseWithin");

}

SOM_Scope void  SOMLINK SimplePartMouseLeave(SimplePart *somSelf,
                                              Environment *ev,
                                             ODFacet* facet)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartMouseLeave");

    // we may need to restore the pointer here.  I'll check later. todo (jso 94-9)
}

SOM_Scope void  SOMLINK SimplePartAdjustMenus(SimplePart *somSelf,
                                               Environment *ev,
                                              ODFrame* frame)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartAdjustMenus");

}

SOM_Scope void  SOMLINK SimplePartUndoAction(SimplePart *somSelf,
                                              Environment *ev,
                                             ODActionData actionState)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartUndoAction");

    // not much to undo yet
}

SOM_Scope void  SOMLINK SimplePartRedoAction(SimplePart *somSelf,
                                              Environment *ev,
                                             ODActionData actionState)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartRedoAction");

    // not much to redo yet
}

SOM_Scope void  SOMLINK SimplePartDisposeActionState(SimplePart *somSelf,
                                                      Environment *ev,
                                                     ODActionData actionState,
                                                     ODDoneState doneState)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartDisposeActionState");

    // not much to redo
}

SOM_Scope void  SOMLINK SimplePartWriteActionState(SimplePart *somSelf,
                                                    Environment *ev,
                                                   ODPtr actionState,
                                                   ODStorageUnitView* storageUnitView)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartWriteActionState");

}

SOM_Scope ODPtr  SOMLINK SimplePartReadActionState(SimplePart *somSelf,
                                                    Environment *ev,
                                                   ODStorageUnitView* storageUnitView)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartReadActionState");

    return kODNULL;
}

SOM_Scope void  SOMLINK SimplePartInitPart(SimplePart *somSelf,
                                            Environment *ev,
                                           ODStorageUnit* storageUnit)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartInitPart");

    if (somSelf->IsInitialized(ev))
      return;

    somSelf->InitPersistentObject(ev, storageUnit);


    somSelf->CommonInitSimplePart(ev);

}

SOM_Scope void  SOMLINK SimplePartInitPartFromStorage(SimplePart *somSelf,
                                                       Environment *ev,
                                                      ODStorageUnit* storageUnit)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartInitPartFromStorage");


    if (somSelf->IsInitialized(ev))
      return;

    somSelf->InitPersistentObjectFromStorage(ev, storageUnit);


    somSelf->CommonInitSimplePart(ev);


//AJ    ODStorageUnit* su = somSelf->GetStorageUnit(ev);
//AJ    su->Focus(ev, kODPropContents, kODPosUndefined, kSimplePartValueType, 0, kODPosUndefined);
//AJ    su->GetValue(ev, sizeof(RGBColor), (ODValue) &_fDefaultColor);


}

SOM_Scope void  SOMLINK SimplePartRelease(SimplePart *somSelf,
                                           Environment *ev)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartRelease");

    SimplePart_parent_ODPart_Release(somSelf, ev);
    if (somSelf->GetRefCount(ev) == 0)
       somSelf->GetStorageUnit(ev)->GetDraft(ev)->ReleasePart(ev, somSelf);
}

SOM_Scope void  SOMLINK SimplePartActivate(SimplePart *somSelf,
                                                Environment *ev,
                                                ODFacet* facet)
{
    SimplePartData *somThis = SimplePartGetData(somSelf);
    SimplePartMethodDebug("SimplePart","SimplePartActivate");

    if (!facet->GetWindow(ev)->IsActive(ev))
       facet->GetWindow(ev)->Select(ev);
    else {
       PartInfoRec* pInfo = (PartInfoRec*) facet->GetFrame(ev)->GetPartInfo(ev);
       if (!pInfo->fIsActive) {
          somSelf->ActivateFrame(ev, facet->GetFrame(ev));
       } /* endif */
    } /* endif */
}

#ifdef __IBMC___
  #pragma linkage (SOMInitModule, system)
#endif

SOMEXTERN void SOMLINK SOMInitModule (long majorVersion, long minorVersion,
                                 string className)
{
   SOM_IgnoreWarning (majorVersion);  /* This function makes   */
   SOM_IgnoreWarning (minorVersion);  /* no use of the passed  */
   SOM_IgnoreWarning (className);     /* arguments.            */

   SimplePartNewClass ( SimplePart_MajorVersion, SimplePart_MinorVersion);
}
