/****************************** Module Header ******************************\
*
* Module Name: OD.H
*
* OpenDoc for OS/2 constants, types, functions and class definitions
*
* Copyright (c) International Business Machines Corporation 1994
*    Modified 1995 by ODFrk team (M.Streble & A.Jolin)
*
* ===========================================================================
*
* The folowing symbols are used in this file for conditional sections.
*
*   #define:                      To include:
*
*   INCL_OD                       Include all OpenDoc classes
*   INCL_ODOSA                    Include OpenDoc classes for OSA
*   INCL_ODACTIVEFRAMEMENUBAR     ODActiveFrameMenuBar class definition   mcs 05/04/95
*   INCL_ODARBITRATOR             ODArbitrator class definition
*   INCL_ODCANVAS                 ODCanvas class definition
*   INCL_ODCLIPBOARD              ODClipboard class definition
*   INCL_ODCONTAINER              ODContainer class definition
*   INCL_ODDISPATCHER             ODDispatcher class definition
*   INCL_ODDISPATCHMODULE         ODDispatchModule class definition
*   INCL_ODDOCUMENT               ODDocument class definition
*   INCL_ODDRAFT                  ODDraft class definition
*   INCL_ODDRAGANDDROP            ODDragAndDrop class definition and
                                  ODDragItemIterator class definition
*   INCL_ODEMBEDDEDFRAMESITERATOR ODEmbeddedFramesIterator class definition
*   INCL_ODERRORS                 ODError definitions
*   INCL_ODEXTENSION              ODExtension class definition
*   INCL_ODFACET                  ODFacet class definition and
                                  ODFacetIterator class definition and
                                  ODFrameFacetIterator class definition
*   INCL_ODFOCUSMODULE            ODFocusModule class definition
*   INCL_ODFOCUSOWNERITERATOR     ODFocusOwnerIterator class definition
*   INCL_ODFOCUSSET               ODFocusSet class definition and
*   INCL_ODSELECTEDPARTEXTENSION  ODSelectedPartExtension
                                  ODFocusSetIterator class definition
*   INCL_ODFRAME                  ODFrame class definition
*   INCL_ODLINK                   ODLink class definition
*   INCL_ODLINKMANAGER            ODLinkManager class definition
*   INCL_ODLINKSOURCE             ODLinkSource class definition
*   INCL_ODLINKSPEC               ODLinkSpec class definition
*   INCL_ODMENUBAR                ODMenuBar class definition
*   INCL_ODMESSAGEINTERFACE       ODMessageInterface class definition
*   INCL_ODNAMERESOLVER           ODNameResolver class definition
*   INCL_ODNAMESPACE              ODNameSpace class definition
*   INCL_ODNAMESPACEMANAGER       ODNameSpaceManager class definition
*   INCL_ODNOTEBOOK               ODNotebook class definition
*   INCL_ODOBJECT                 ODObject class definition
*   INCL_ODPART                   ODPart class definition
*   INCL_ODPARTHANDLERINFO        ODPartHandlerInfo class definition
*   INCL_ODPARTHANDLERREGISTRY    ODPartHandlerRegistry class definition
*   INCL_ODPERSISTENTOBJECT       ODPersistentObject class definition
*   INCL_ODPLATFORMTYPELIST       ODPlatformTypeList class definition and
                                  ODPlatformTypeListIterator class definition
*   INCL_ODREGISTRYMANAGER        ODRegistryManager class definition
*   INCL_ODREFCNTOBJECT           ODRefCntObject class definition

*   INCL_ODSEMANTICINTERFACE      ODSemtanticInterface class definition
*   INCL_ODSESSION                ODSession class definition
*   INCL_ODSHAPE                  ODShape class definition
*   INCL_ODSTANDARDDISPATCHMODULE ODStandardDispatchModule class definition
*   INCL_ODSTORAGESYSTEM          ODStorageSystem class definition
*   INCL_ODSTORAGEUNIT            ODStorageUnit class definition and
                                  ODStorageUnitCursor class definition and
                                  ODStorageUnitIterator class definition
*   INCL_ODSTORAGEUNITVIEW        ODStorageUnitView class definition
*   INCL_ODTRANSFORM              ODTransform class definition
*   INCL_ODTRANSLATION            ODTranslation class definition
*   INCL_ODTYPELIST               ODTypeList class definition and
                                  ODTypeListIterator class definition
*   INCL_ODUNDO                   ODUndo class definition
*   INCL_ODVALUENAMESPACE         ODValueNameSpace class definition
*   INCL_ODWINDOW                 ODWindow class definition and
                                  ODWindowIterator class definition
*   INCL_ODWINDOWSTATE            ODWindowState class definition
*
\***************************************************************************/

/* NOINC */
#ifdef __IBMC__
   #pragma checkout( suspend )
   #ifndef __CHKHDR__
      #pragma checkout( suspend )
   #endif
   #pragma checkout( resume )
#endif
/* INC */

#ifndef OD_INCLUDED
#define OD_INCLUDED

#ifdef INCL_OD /* include all OpenDoc classes */
   #define INCL_ODACTIVEFRAMEMENUBAR        // mcs 05/04/95
   #define INCL_ODARBITRATOR
   #define INCL_ODCANVAS
   #define INCL_ODCLIPBOARD
   #define INCL_ODCONTAINER
   #define INCL_ODDISPATCHER
   #define INCL_ODDISPATCHMODULE
   #define INCL_ODDOCUMENT
   #define INCL_ODDRAFT
   #define INCL_ODDRAGANDDROP
   #define INCL_ODEMBEDDEDFRAMESITERATOR
   #define INCL_ODERRORS
   #define INCL_ODEXTENSION
   #define INCL_ODFACET
   #define INCL_ODFOCUSMODULE
   #define INCL_ODFOCUSOWNERITERATOR
   #define INCL_ODFOCUSSET
   #define INCL_ODFRAME
   #define INCL_ODLINK
   #define INCL_ODLINKMANAGER
   #define INCL_ODLINKSOURCE
   #define INCL_ODLINKSPEC
   #define INCL_ODMENUBAR
   #define INCL_ODMESSAGEINTERFACE
   #define INCL_ODNAMERESOLVER
   #define INCL_ODNAMESPACE
   #define INCL_ODNAMESPACEMANAGER
   #define INCL_ODNOTEBOOK
   #define INCL_ODOBJECT
   #define INCL_ODPART
   #define INCL_ODPARTHANDLERINFO
   #define INCL_ODPARTHANDLERREGISTRY
   #define INCL_ODPARTKIND
   #define INCL_ODPERSISTENTOBJECT
   #define INCL_ODPLATFORMTYPELIST
   #define INCL_ODREGISTRYMANAGER
   #define INCL_ODREFCNTOBJECT
   #define INCL_ODSELECTEDPARTEXTENSION
   #define INCL_ODSEMANTICINTERFACE
   #define INCL_ODSESSION
   #define INCL_ODSHAPE
   #define INCL_ODSTANDARDDISPATCHMODULE
   #define INCL_ODSTORAGESYSTEM
   #define INCL_ODSTORAGEUNIT
   #define INCL_ODSTORAGEUNITVIEW
   #define INCL_ODTRANSFORM
   #define INCL_ODTRANSLATION
   #define INCL_ODTYPELIST
   #define INCL_ODUNDO
   #define INCL_ODVALUENAMESPACE
   #define INCL_ODWINDOW
   #define INCL_ODWINDOWSTATE
  
   #define INCL_ODxORDCOLL      //mcs & aj This is to add support for OD Collection Classes.
                                //    Later, test if this is needed anymore (by ODFrk)...

#endif /* INCL_OD */


#ifdef INCL_ODOSA /* include OpenDoc classes for OSA */
   #define INCL_ODMESSAGEINTERFACE
   #define INCL_ODNAMERESOLVER
   #define INCL_ODSEMANTICINTERFACE
#endif /* INCL_OD */


// include global constants and types
#include <ODTYPES.HH>                      //aj: use odtypes.hh (modified odtypes.h)

// aj: These includes #ifdef-check themselves. Omit them to simplify hand-conversion
//     from od.h next time.
//#ifndef SOM_Module_StdDefs_OpenDoc_StdDefs_defined
#include <STDDEFS.HH>
//#endif
//#ifndef SOM_Module_StdProps_OpenDoc_StdProps_defined
#include <STDPROPS.HH>
//#endif
//#ifndef SOM_Module_StdTypes_OpenDoc_StdTypes_defined
#include <STDTYPES.HH>
//#endif

// mcs aj - added this ifdef/ifndef block, to make OD collections work
//  Q: why, in DEVCON7, is ordcoll.h only in "public" samples dir?
// mcs A: because this is not a toolkit class
#ifdef INCL_ODxORDCOLL
#ifndef _ORDCOLL_
#include <ordcoll.h>
#endif
#endif

// mcs - added 05/04/95
#ifdef INCL_ODACTIVEFRAMEMENUBAR
#include <menubact.hh>
#endif

#ifdef INCL_ODARBITRATOR
//#ifndef SOM_ODArbitrator_xh
#include <arbitrat.HH>
//#endif
#endif

#ifdef INCL_ODCANVAS
//#ifndef SOM_ODCanvas_xh
#include <canvas.HH>
//#endif
#endif

#ifdef INCL_ODCLIPBOARD
//#ifndef SOM_ODClipboard_xh
#include <clipbd.HH>
//#endif
#endif

#ifdef INCL_ODCONTAINER
//#ifndef SOM_ODContainer_xh
#include <odctr.HH>
//#endif
#endif

#ifdef INCL_ODDISPATCHER
//#ifndef SOM_ODDispatcher_xh
#include <disptch.HH>
//#endif
#endif

#ifdef INCL_ODDISPATCHMODULE
//#ifndef SOM_ODDispatchModule_xh
#include <dispmod.HH>
//#endif
#endif

#ifdef INCL_ODDOCUMENT
//#ifndef SOM_ODDocument_xh
#include <document.HH>
//#endif
#endif

#ifdef INCL_ODDRAFT
//#ifndef SOM_ODDraft_xh
#include <draft.HH>
//#endif
#endif

#ifdef INCL_ODDRAGANDDROP
//#ifndef SOM_ODDragAndDrop_xh
#include <dragdrp.HH>
//#endif
//#ifndef SOM_ODDragItemIterator_xh
#include <dgitmit.HH>
//#endif
#endif

#ifdef INCL_ODEMBEDDEDFRAMESITERATOR
//#ifndef SOM_ODEmbeddedFramesIterator_xh
#include <embfritr.HH>
//#endif
#endif

#ifdef INCL_ODERRORS
//#ifndef SOM_Module_ErrorDef_OpenDoc_Errors_defined
#include <errordef.HH>
//#endif
#endif

#ifdef INCL_ODEXTENSION
//#ifndef SOM_ODExtension_xh
#include <extensn.HH>
//#endif
#endif

#ifdef INCL_ODFACET
//#ifndef SOM_ODFacet_xh
#include <facet.HH>
//#endif
//#ifndef SOM_ODFacetIterator_xh
#include <facetitr.HH>
//#endif
//#ifndef SOM_ODFrameFacetIterator_xh
#include <frfaitr.HH>
//#endif
#endif

#ifdef INCL_ODFOCUSMODULE
//#ifndef SOM_ODFocusModule_xh
#include <focusmod.HH>
//#endif
#endif

#ifdef INCL_ODFOCUSOWNERITERATOR
//#ifndef SOM_ODFocusOwnerIterator_xh
#include <focusown.HH>
//#endif
#endif

#ifdef INCL_ODFOCUSSET
//#ifndef SOM_Module_Foci_OpenDoc_Foci_defined
#include <foci.HH>
//#endif
//#ifndef SOM_ODFocusSet_xh
#include <focusset.HH>
//#endif
//#ifndef SOM_ODFocusSetIterator_xh
#include <focusitr.HH>
//#endif
#endif

#ifdef INCL_ODFRAME
//#ifndef SOM_ODFrame_xh
#include <frame.HH>
//#endif
#endif

#ifdef INCL_ODLINK
//#ifndef SOM_ODLink_xh
#include <link.HH>
//#endif
#endif

#ifdef INCL_ODLINKMANAGER
//#ifndef SOM_ODLinkManager_xh
#include <linkmgr.HH>
//#endif
#endif

#ifdef INCL_ODLINKSOURCE
//#ifndef SOM_ODLinkSource_xh
#include <linksrc.HH>
//#endif
#endif

#ifdef INCL_ODLINKSPEC
//#ifndef SOM_ODLinkSpec_xh
#include <linkspec.HH>
//#endif
#endif

#ifdef INCL_ODMENUBAR
//#ifndef SOM_ODMenuBar_xh
#include <menubar.HH>
//#endif
#endif

#ifdef NOT_107253
#ifdef INCL_ODMESSAGEINTERFACE
//#ifndef SOM_ODMessageInterface_xh
#include <mssgintf.HH>
//#endif
#endif

#ifdef INCL_ODNAMERESOLVER
//#ifndef SOM_ODNameResolver_xh
#include <namrslvr.HH>
//#endif
#endif
#endif

#ifdef INCL_ODNAMESPACE
#ifndef SOM_ODNameSpace_xh
#include <namspac.HH>
#endif
#endif

#ifdef INCL_ODNAMESPACEMANAGER
//#ifndef SOM_ODNameSpaceManager_xh
#include <nmspcmg.HH>
//#endif
#endif

// mcs 05/09/95:
#ifdef INCL_ODNOTEBOOK
#include <odnotebk.hh>
#endif

#ifdef INCL_ODOBJECT
//#ifndef SOM_ODObject_xh
#include <odobject.HH>
//#endif
#endif

#ifdef INCL_ODPART
//#ifndef SOM_ODPart_xh
#include <part.HH>
//#endif
#endif

#ifdef INCL_ODPARTHANDLERINFO
//#ifndef SOM_ODPartHandlerInfo_xh
#include <partinfo.HH>
//#endif
#endif

#ifdef INCL_ODPARTHANDLERREGISTRY
//#ifndef SOM_ODPartHandlerRegistry_xh
#include <odprtreg.HH>
//#endif
#endif

#ifdef INCL_ODPLATFORMTYPELIST
//#ifndef SOM_ODPlatformTypeList_xh
#include <pftypls.HH>
//#endif
//#ifndef SOM_ODPlatformTypeListIterator_xh
#include <pftlitr.HH>
//#endif
#endif

#ifdef INCL_ODPERSISTENTOBJECT
//#ifndef SOM_ODPersistentObject_xh
#include <pstobj.HH>
//#endif
#endif

#ifdef INCL_ODREGISTRYMANAGER
//#ifndef SOM_RegistryManager_xh
#include <rmanager.HH>
//#endif
#endif

#ifdef INCL_ODREFCNTOBJECT
//#ifndef SOM_ODRefCntObject_xh
#include <refctobj.HH>
//#endif
#endif

// mcs 06/01/95
#ifdef INCL_ODSELECTEDPARTEXTENSION
#include <selprtex.hh>
#endif

#ifdef NOT_107253
#ifdef INCL_ODSEMANTICINTERFACE
//#ifndef SOM_ODSemanticInterface_xh
#include <semtintf.HH>
//#endif
#endif
#endif

#ifdef INCL_ODSESSION
//#ifndef SOM_ODSession_xh
#include <odsessn.HH>
//#endif
#endif

#ifdef INCL_ODSHAPE
//#ifndef SOM_ODShape_xh
#include <shape.HH>
//#endif
#endif

#ifdef INCL_ODSTANDARDDISPATCHMODULE
//#ifndef SOM_ODStandardDispatchModule_xh
#include <stddisp.HH>
//#endif
#endif

#ifdef INCL_ODSTORAGESYSTEM
//#ifndef SOM_ODStorageSystem_xh
#include <storage.HH>
//#endif
#endif

#ifdef INCL_ODSTORAGEUNIT
//#ifndef SOM_ODStorageUnit_xh
#include <storageu.HH>
//#endif
//#ifndef SOM_ODStorageUnitCursor_xh
#include <sucursor.HH>
//#endif
//#ifndef SOM_ODStorageUnitRefIterator_xh
#include <surefitr.HH>
//#endif
#endif

#ifdef INCL_ODSTORAGEUNITVIEW
//#ifndef SOM_ODStorageUnitView_xh
#include <suview.HH>
//#endif
#endif


#ifdef INCL_ODTRANSFORM
//#ifndef SOM_ODTransform_xh
#include <trnsform.HH>
//#endif
#endif

#ifdef INCL_ODTRANSLATION
//#ifndef SOM_ODTranslation_xh
#include <translt.HH>
//#endif
#endif

#ifdef INCL_ODTYPELIST
//#ifndef SOM_ODTypeList_xh
#include <typelist.HH>
//#endif
//#ifndef SOM_ODTypeListIterator_xh
#include <typlsitr.HH>
//#endif
#endif

#ifdef INCL_ODUNDO
//#ifndef SOM_ODUndo_xh
#include <undo.HH>
//#endif
#endif

#ifdef INCL_ODVALUENAMESPACE
//#ifndef SOM_ODValueNameSpace_xh
#include <valuens.HH>
//#endif
//#ifndef SOM_ODValueIterator_xh
#include <valueitr.HH>
//#endif
#endif

#ifdef INCL_ODWINDOW
//#ifndef SOM_ODWindow_xh
#include <window.HH>
//#endif
//#ifndef SOM_ODWindowIterator_xh
#include <winiter.HH>
//#endif
#endif

#ifdef INCL_ODWINDOWSTATE
//#ifndef SOM_ODWindowState_xh
#include <winstat.HH>
//#endif
#endif

#endif // OD_INCLUDED

/* NOINC */
#ifdef __IBMC__
   #pragma checkout( suspend )
   #ifndef __CHKHDR__
      #pragma checkout( resume )
   #endif
   #pragma checkout( resume )
#endif
/* INC */

/**************************** end of file **********************************/
