/* NOSHIP */
#ifndef _OWINLSTS_
#define _OWINLSTS_
/*******************************************************************************
* FILE NAME: owinlsts.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of classes that are used to manage the   *
*   collection of views in a model, and the collection of modeled controls in  *
*   a view.                                                                    *
*                                                                              *
* COPYRIGHT:                                                                   *
*   Licensed Materials - Property of IBM                                       *
*   (C) Copyright IBM Corporation 1992, 1994                                   *
*   All Rights Reserved                                                        *
*   US Government Users Restricted Rights - Use, duplication, or               *
*   disclosure                                                                 *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#ifndef _IKEYSET_H
  #include <ikeyset.h>
#endif
#include <iwindow.hpp>
#include <ireslock.hpp>
#include <icontrol.hpp>
//#include <icconst.h>             // needed for WS_VISIBLE, etc.
//#include <odconst.h>             // OpenDoc Frk-specific exceptions, etc. Merge into icconst later.
#include <iexcept.hpp>

//Forward declares

#pragma info(none)


/*------------------------------------------------------------------------------
| ODFWindowListElement class                                                   |
------------------------------------------------------------------------------*/
class ODFWindowListElement : public IBase
{
public:
  ODFWindowListElement (IWindow* aPwin, unsigned long aULong):
        p_key(aULong), p_pwin(aPwin)  { }
  ~ODFWindowListElement ( ) { }
IWindow
  *window ( )  {return p_pwin;}
unsigned long
  elementKey ( )  {return p_key;}

private:
  unsigned long p_key;
  IWindow* p_pwin;

// friend classes & functions
  friend class ODFWindowList;
  friend unsigned long const& key ( ODFWindowListElement* const& pElement );
};

/*------------------------------------------------------------------------------
| ODFWindowList class - used for both view list and modeled controls list      |
------------------------------------------------------------------------------*/
class ODFWindowList : public IKeySet<ODFWindowListElement*, unsigned long>
{
public:
  ODFWindowList ();
  // Development Trace Support
  ~ODFWindowList();

static IPrivateResource
 &libraryKey();

static IPrivateResource
  libKey;

};


#pragma info(restore)

#endif // _OWINLSTS_
