
#ifndef _OFORMV_
#define _OFORMV_

/*******************************************************************************
* FILE NAME: OFORMV.hpp                                                        *
*                                                                              *
* DESCRIPTION: see online documentation                                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   Licensed Materials - Property of IBM                                       *
*   (C) Copyright IBM Corporation 1994                                         *
*   All Rights Reserved                                                        *
*   US Government Users Restricted Rights - Use, duplication, or               *
*   disclosure                                                                 *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
********************************************************************************/

//To avoid "true, True, etc. already defined" error, put include of IBASE before any OD stuff
#include <ivbase.hpp>      

// ----- OpenDoc Includes -----
#include <odtypes.hh>

// ----- UICL Includes -----
#include <icanvas.hpp>
#include <ihandle.hpp>
#include <ipoint.hpp>
#include <irect.hpp>
#include <iconnect.hpp>

// Forward declarations for other classes:
class ODFacet;
class ODFrame;
class ODFModel;
class ODShape;
class ODFFormViewPrivateData;


/*----------------------------------------------------------------------------  */
/* Align classes on four byte boundary.                                         */
/*----------------------------------------------------------------------------  */
#pragma pack(4)

class ODFFormView : public ICanvas {
public:
   typedef ICanvas Inherited;

// forward declaration for nested class
class Style;


/*------------------------------------Style-------------------------------------*/
   INESTEDBITFLAGCLASSDEF2(Style, ODFFormView, ICanvas, IWindow);
   static const Style classDefaultStyle;
   static Style defaultStyle();
   static void setDefaultStyle(const Style &style);

   ODFFormView(
   unsigned long viewId,
   ODFModel *part,
   const ISize &initialSize = ISize ( ),
   const Style &style = defaultStyle ( ));

   virtual  ~ODFFormView();

/*-----------------------View Connection to Model Object------------------------
------------------------------------------------------------------------------*/
   ODFFormView
     &addConnection(IModelViewSynchConnection *connection);
   ODFFormView 
     &removeConnection(IModelViewSynchConnection *connection);

   virtual ODFFormView &startBeingViewFor(ODFModel *model);
   virtual Boolean beginRelinquishFocus(ODTypeToken focus,
                                        ODFFormView *proposedView);  
   ODFFormView 
     &flushDirtyConnections();

   enum UpdateMode {         
     immediate,
     onFocusChg, 
     noAutoUpdate
     };
   virtual ODFFormView
     &setModelUpdateMode        ( UpdateMode updateMode = onFocusChg );
   virtual UpdateMode
     modelUpdateMode            ( ) const;           


//virtual ODFFormView
// &layout              ( );
//ISize
// layoutSize          ( ) const;
//ODFFormView
// &setLayoutSize       ( const ISize& size );
//virtual IWindowPosBuffer
//  fixupChildren       ( );
//Boolean
//  areChildrenReversed ( ) const;

   virtual ODFFormView &initializeView ();
   virtual ODFFormView &stopBeingViewFor (ODFModel *model);
   virtual ODFFormView &drawView();
   virtual ODFModel *model() const;
   IBase::Boolean isViewEnabled() const;
   ODFrame *frame() const;
   ODFacet *facet() const;
   virtual ODFFormView &setViewClient (IControl *clientControl);
   virtual IControl *viewClient ();
   virtual ODFFormView &sizeTo (const ISize &newSize);


private:
   ODFFormView(const ODFFormView &);
   ODFFormView &operator =(const ODFFormView &);
   void throwReadOnlyChangedException();     //???? still need ????

   ODFModel *p_modelPart;
   IObserverList *fConnectionList;
   ODFacet *p_facet;
   ODFrame *p_frame;
   static Style currentDefaultStyle;
   ODFFormViewPrivateData *p_privateData;
   Boolean p_viewEnabled;
   IWindow *p_wndParent;
   IControl *p_viewClient;
}; // ODFFormView

// ODFFormView
   INESTEDBITFLAGCLASSFUNCS(Style, ODFFormView);

/*----------------------------------------------------------------------------  */
/* Resume compiler default packing.                                             */
/*----------------------------------------------------------------------------  */
#pragma pack()
#endif /* _OFORMV_ */
