#ifndef _OFORMP_
#define _OFORMP_

/*******************************************************************************
* FILE NAME: oformp.hpp                                                        *
*                                                                              *
* DESCRIPTION:  see online documentation                                       *
*                                                                              *
* COPYRIGHT:                                                                   *
*   Licensed Materials - Property of IBM                                       *
*   (C) Copyright IBM Corporation 1994                                         *
*   All Rights Reserved                                                        *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

//To avoid "true, True, etc. already defined" error, put include of IBASE before any OD stuff
#include <ivbase.hpp>    

#ifndef _SIMPLPRT_
//#include <smartprt.hh>  aj back to simplprt for devcon7
#include <simplprt.hh>
#endif

#ifndef _ISET_
  #include <iset.h>
#endif

/*----------------------------------------------------------------------------  */
/* Align classes on four byte boundary.                                         */
/*----------------------------------------------------------------------------  */
#pragma pack(4)

// Forward declarations for other classes:
class IVBase;
class IString;
class IResourceId;
class IRectangle;
class IField;
class ODFFormView;
class ODFWindowList;
class ODFFormPartPrivateData;

typedef ISet <ODFrame*> FrameSet;

class ODFModel : public SimplePart {
#pragma SOMClassName(*, "ODFModel")
public:
   typedef SimplePart Inherited;
   virtual  ~ODFModel();

/*-----------------------OpenDoc overrides -------------------------------------
------------------------------------------------------------------------------*/
   virtual void
      FacetAdded (ODFacet* facet),
      Draw (ODFacet *facet, ODShape *invalidShape),
      FrameShapeChanged (ODFrame *frame),
      GeometryChanged (ODFacet *facet),
      AddDisplayFrame (ODFrame *frame),
      CloseDisplayFrame (ODFrame *frame),
      RemoveDisplayFrame (ODFrame *frame),
      Release(),
      WritePartInfo (ODPtr partInfo, ODStorageUnitView *storageUnitView),
      Externalize (),
      InitPart (ODStorageUnit *su),
      InitPartFromStorage (ODStorageUnit *su);
   virtual ODPtr ReadPartInfo (ODFrame *frame, ODStorageUnitView *storageUnitView);
   virtual ODBoolean BeginRelinquishFocus(ODTypeToken focus,
                                      ODFrame* ownerFrame,
                                      ODFrame* proposedFrame);


/*-------------------------Model Maintenance Functions--------------------------
------------------------------------------------------------------------------*/
protected:
   ODFModel &addView(ODFFormView *view);
   ODFModel &removeView(ODFFormView *view);

/*---------------------------View-construction ---------------------------------
------------------------------------------------------------------------------*/
   virtual ODFModel &openViews();
   virtual ODFModel &openView (IResourceId viewId);

/*---------------------------Protected Constructors-----------------------------
------------------------------------------------------------------------------*/
   ODFModel();

/*--------------------------------- Private ----------------------------------  */
private:
//   ODFModel(const ODFModel &);
//   ODFModel &operator =(const ODFModel &);
   FrameSet   *displayFrames;
   Boolean     viewsOpened;
   ODFFormPartPrivateData *pData;

// ODFFormView needs access to displayFrames ISet.  Make it a friend for now.
friend class ODFFormView;
};
// class ODFModel

/*----------------------------------------------------------------------------  */
/* Resume compiler default packing.                                             */
/*----------------------------------------------------------------------------  */
#pragma pack()

/*----------------------------- Inline Functions -----------------------------  */

#ifndef I_NO_INLINES
#endif
#endif /* _OFORMP_ */
