#ifndef _ICONNECT_
#define _ICONNECT_

/*******************************************************************************
* FILE NAME: iconnect.hpp                                                      *
*                                                                              *
* DESCRIPTION: see online documentation                                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   Licensed Materials - Property of IBM                                       *
*   (C) Copyright IBM Corporation 1994                                         *
*   All Rights Reserved                                                        *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <ivbase.hpp>
#include <inotify.hpp>
#include <iobservr.hpp>
#include <ithread.hpp>

/*----------------------------------------------------------------------------  */
/* Align classes on four byte boundary.                                         */
/*----------------------------------------------------------------------------  */
#pragma pack(4)

// Forward declarations for other classes:
class IVBase;
class IString;
class ODFFormView;

class IConnection : public IObserver {
public:
IConnection( INotifier &firstNotifier,
             const INotificationId firstNotificationId,
             const IReference<IThreadFn>& firstFunction,
             INotifier &secondNotifier,
             const INotificationId secondNotificationId,
             const IReference<IThreadFn>& secondFunction   );

IConnection( INotifier &firstNotifier,
             const INotificationId firstNotificationId,
             const IReference<IThreadFn>& firstFunction );

IConnection( INotifier &firstNotifier,
             const INotificationId firstNotificationId,
             INotifier &secondNotifier,
             const INotificationId secondNotificationId );

IConnection( INotifier &firstNotifier,
             const INotificationId firstNotificationId );

virtual ~IConnection();

inline INotifier 
     &firstNotifier() {return fFirstNotifier;}
inline INotifier 
     &secondNotifier() {return fSecondNotifier;}
inline INotificationId 
     firstId() {return fFirstNotificationId;}
inline INotificationId 
     secondId() {return fSecondNotificationId;}
inline virtual IConnection
     &dispatchFirstFunction();      //??rename "firstNotificationOccured()" ?
inline virtual IConnection
     &dispatchSecondFunction();     //??rename "secondNotificationOccured()" ?
inline Boolean
     isOneWay() {return fOneWay;}

protected:
virtual IConnection &dispatchNotificationEvent(
                                const INotificationEvent &event);
private:
   INotifier &fFirstNotifier,
             &fSecondNotifier;
   INotificationId fFirstNotificationId,
                   fSecondNotificationId;
IThreadFn *fFirstFunction, 
          *fSecondFunction;
Boolean fOneWay;
}; // IConnection


class IModelViewSynchConnection : public IConnection {
public:
   IModelViewSynchConnection( INotifier &modelObject,
                const INotificationId modelChangedId,
                const IReference<IThreadFn>& modelChangedFunction,
                ODFFormView &view,
                INotifier &viewObject,
                const IReference<IThreadFn>& viewChangedFunction   );
   IModelViewSynchConnection( INotifier &modelObject,
                const INotificationId modelChangedId,
                const IReference<IThreadFn>& modelChangedFunction,
                ODFFormView &view   );
   IModelViewSynchConnection( INotifier &modelObject,
                const INotificationId modelChangedId,
                ODFFormView &view,
                INotifier &viewObject   );
   IModelViewSynchConnection( INotifier &modelObject,
                const INotificationId modelChangedId,
                ODFFormView &view   );
   ~IModelViewSynchConnection();

//************* inline all this stuff, so our use of it doesn't incur double call overhead ***
   inline INotifier 
              &modelObject() {return firstNotifier();}
   inline INotifier 
              &viewObject(){return secondNotifier();}
   inline INotificationId 
              modelChangedId(){return firstId();}
   inline IModelViewSynchConnection 
              &dispatchModelChangedFunction() {dispatchFirstFunction();}
   inline IModelViewSynchConnection 
              &dispatchViewChangedFunction() {dispatchSecondFunction();}
   inline ODFFormView 
              &view(){return fView;}
   inline virtual Boolean 
              isViewObjectOutOfSynch() {return fViewObjectDirty;}
   inline virtual IModelViewSynchConnection
              &viewObjectOutOfSynch(Boolean outOfSynch = true);

protected:
   virtual IModelViewSynchConnection &dispatchNotificationEvent(
                                const INotificationEvent &event);
virtual Boolean isValueChangedNotification(const INotificationEvent &event);


private:
   ODFFormView &fView;
   Boolean fViewObjectDirty;
}; // IModelViewSynchConnection




/*----------------------------------------------------------------------------  */
/* Resume compiler default packing.                                             */
/*----------------------------------------------------------------------------  */
#pragma pack()

/*----------------------------- Inline Functions -----------------------------  */

#ifndef I_NO_INLINES
#endif
#endif /* _ICONNECT_ */
