/*
 *      File:           Common.hpp
 *
 *   Contains: In-line helper functions, macros and classes for 
 *             sample parts.
 *
 *   Written by:        Jason Crawford
 *
 *   Copyright: (c) 1994 by IBM Corp., all rights reserved.
 *
 *   Change History (most recent first):
 *
 *       <1>      7/6/94        jlc             first checked in
 *
 *
 *   Copyright: (c) 1993-1994 by IBM Corp., all rights reserved.
 *
 */
#ifndef _COMMON_
#define _COMMON_

#if ODDebug
   #define NOTDONE() beepprintf("not done in %s", __FILE__)
   #define NOTDONE2(a) beepprintf("%s not done in %s", a, __FILE__)
#else
   #define NOTDONE()
   #define NOTDONE2(a)
#endif

   void inline InflateRect( PRECTL prectl, long dx, long dy )
   {
      prectl->xLeft   -= dx;
      prectl->xRight  += dx;
      prectl->yBottom -= dy;
      prectl->yTop    += dy;
   }

   void inline OffsetRect( PRECTL prectl, long dx, long dy)
   {
      prectl->xLeft   += dx;
      prectl->xRight  += dx;
      prectl->yBottom += dy;
      prectl->yTop    += dy;
   }

   #define THROW(a) throw a
   #define  ODDeleteObject(object)  \
     do{              \
       if (object!=kODNULL) {  \
         delete object;    \
         object = kODNULL;  \
       }            \
     }while(0)
// mcs   #define  ODReleaseObject(ev, object) \
// mcs     do{                \
// mcs       if (object!=kODNULL) {    \
// mcs         object->Release(ev);  \
// mcs         object = kODNULL;    \
// mcs       }              \
// mcs     }while(0)

   /*
    * The following classes aid in moving between ODPoint and ODRect 
    * coordinates which are expressed using 16.16 fixed values to POINTL 
    * and RECTL coordinates which are expressed using long ints.
    */

   #define FIXED2LONG(f) (((f) + 0x8000) >> 16)
   class ODPOINTL : public POINTL
   {
      public:
      operator ODPoint() const { ODPoint pt = {MAKEFIXED(x,0),MAKEFIXED(y,0)}; return pt; } ;
      ODPOINTL( ODPoint pt) {x = FIXED2LONG(pt.x); y = FIXED2LONG(pt.y); };
      ODPOINTL( int x1, int y1) { x = x1; y = y1; };
      ODPOINTL( ) { x = y = 0; };
      //ODPOINTL( POINTL & pt) { } ;
   };

   inline ODPOINTL & downcastToODPOINTL( POINTL & pt ) { return  (*(ODPOINTL*)&pt); }
   class ODRECTL : public RECTL
   {
      public:
      operator ODRect() const { ODRect rct = {
                                    MAKEFIXED(xLeft,0),
                                    MAKEFIXED(yTop,0),
                                    MAKEFIXED(xRight,0),
                                    MAKEFIXED(yBottom,0)
                                             }; return rct; } ;
      ODRECTL( ODRect rct) {
              xLeft   = FIXED2LONG(rct.left);
              yBottom = FIXED2LONG(rct.bottom);
              xRight  = FIXED2LONG(rct.right);
              yTop    = FIXED2LONG(rct.top);
                           };
      ODRECTL( ODPoint botLeft, ODPoint topRight) {
              xLeft   = FIXED2LONG(botLeft.x);
              yBottom = FIXED2LONG(botLeft.y);
              xRight  = FIXED2LONG(topRight.x);
              yTop    = FIXED2LONG(topRight.y);
                           };
      ODRECTL( ) { xLeft = yBottom = xRight = yTop = 0; };
      ODRECTL( RECTL & rct)  { *this = *(ODRECTL *)&rct ;}
   };
   inline ODRECTL & downcastToODRECTL( RECTL & rct ) { return  *(ODRECTL*)&rct; }
#endif
