#include <wchar.h>
#include <locale.h>
#include <regex.h>

#define MAX_STR_SIZE   256

main(void) 
{
    regex_t    reg;            /* regular expression status buffer     */
    int status,                /* regexec status                       */
        error = 0;             /* error flag                           */             
    char pattern[MAX_STR_SIZE],  /* pattern to look for            */
         test_string[MAX_STR_SIZE];        /* test string          */        

    printf("%s\n", setlocale(LC_ALL, ""));

    strcpy(pattern,"m");
    strcpy(test_string,"this is my test string");

    if(error = regcomp(&reg, pattern, REG_EXTENDED)) {
        printf("error: %d\n", error);
    }
    else {
        status = regexec(&reg, test_string, 0, NULL, 0);
        if (status == 0)
            printf("MATCH! : %s <- pattern found in -> %s\n", pattern, 
                            test_string);
        else
            printf("NO MATCH! : %s <- pattern not found in -> %s\n", 
                            pattern, test_string);
    }
    regfree(&reg);

    strcpy(pattern,"^match this$");
    strcpy(test_string,"match this");

    if(error = regcomp(&reg, pattern, REG_EXTENDED)) {
        printf("error: %d\n", error);
    }
    else {
        status = regexec(&reg, test_string, 0, NULL, 0);
        if (status == 0)
            printf("MATCH! : %s <- pattern found in -> %s\n", 
                   pattern, test_string);
        else
            printf("NO MATCH! : %s <- pattern not found in -> %s\n", 
                   pattern, test_string);
    }
    regfree(&reg);

    strcpy(pattern,"match this");
    strcpy(test_string,"try to match this");

    if(error = regcomp(&reg, pattern, REG_EXTENDED)) {
        printf("error: %d\n", error);
    }
    else {
        status = regexec(&reg, test_string, 0, NULL, 0);
        if (status == 0)
            printf("MATCH! : %s <- pattern found in -> %s\n", 
                   pattern, test_string);
        else
            printf("NO MATCH! : %s <- pattern not found in -> %s\n", 
                   pattern, test_string);
    }
    regfree(&reg);

    strcpy(pattern,"no match here");
    strcpy(test_string,"bdfgijklpqsuvwxyz");

    if(error = regcomp(&reg, pattern, REG_EXTENDED)) {
        printf("error: %d\n", error);
    }
    else {
        status = regexec(&reg, test_string, 0, NULL, 0);
        if (status == 0)
            printf("MATCH! : %s <- pattern found in -> %s\n", 
                   pattern, test_string);
        else
            printf("NO MATCH! : %s <- pattern not found in -> %s\n", 
                   pattern, test_string);
    }
    regfree(&reg);

    strcpy(pattern,"[[:alpha:]]");
    strcpy(test_string,"123456789012345678901234567890");

    if(error = regcomp(&reg, pattern, REG_EXTENDED)) {
        printf("error: %d\n", error);
    }
    else {
        status = regexec(&reg, test_string, 0, NULL, 0);
        if (status == 0)
            printf("MATCH! : %s <- pattern found in -> %s\n", 
                   pattern, test_string);
        else
            printf("NO MATCH! : %s <- pattern not found in -> %s\n", 
                   pattern, test_string);
    }
    regfree(&reg);

    strcpy(pattern,"[[:digit:]]");
    strcpy(test_string,"123456789012345678901234567890");

    if(error = regcomp(&reg, pattern, REG_EXTENDED)) {
        printf("error: %d\n", error);
    }
    else {
        status = regexec(&reg, test_string, 0, NULL, 0);
        if (status == 0)
            printf("MATCH! : %s <- pattern found in -> %s\n", 
                   pattern, test_string);
        else
            printf("NO MATCH! : %s <- pattern not found in -> %s\n", 
                   pattern, test_string);
    }
    regfree(&reg);

    strcpy(pattern,"[a-d]");
    strcpy(test_string,"this is my test 123 string.");

    if(error = regcomp(&reg, pattern, REG_EXTENDED)) {
        printf("error: %d\n", error);
    }
    else {
        status = regexec(&reg, test_string, 0, NULL, 0);
        if (status == 0)
            printf("MATCH! : %s <- pattern found in -> %s\n", 
                   pattern, test_string);
        else
            printf("NO MATCH! : %s <- pattern not found in -> %s\n", 
                   pattern, test_string);
    }
    regfree(&reg);

    strcpy(pattern,"[a-e]");
    strcpy(test_string,"this is my test 123 string.");

    if(error = regcomp(&reg, pattern, REG_EXTENDED)) {
        printf("error: %d\n", error);
    }
    else {
        status = regexec(&reg, test_string, 0, NULL, 0);
        if (status == 0)
            printf("MATCH! : %s <- pattern found in -> %s\n", 
                   pattern, test_string);
        else
            printf("NO MATCH! : %s <- pattern not found in -> %s\n", 
                   pattern, test_string);
    }
    regfree(&reg);

    strcpy(pattern,"[^x]");
    strcpy(test_string,"you won't find one letter like that here");

    if(error = regcomp(&reg, pattern, REG_EXTENDED)) {
        printf("error: %d\n", error);
    }
    else {
        status = regexec(&reg, test_string, 0, NULL, 0);
        if (status == 0)
            printf("MATCH! : %s <- pattern found in -> %s\n", 
                   pattern, test_string);
        else
            printf("NO MATCH! : %s <- pattern not found in -> %s\n", 
                   pattern, test_string);
    }
    regfree(&reg);

}
