/*****************************************************************************/
/***     Include files                                                     ***/
/*****************************************************************************/

#include <stdio.h>                      /* Standard IO functions.            */

#include <wchar.h>                      /* XPG/4 library.                    */
#include <locale.h>                     /* Locale definitions.               */

/*****************************************************************************/
/***     Global variables                                                  ***/
/*****************************************************************************/

char *locale;                           /* Name of locale string.            */

/*****************************************************************************/
/***     Sample date and time conversion                                   ***/
/*****************************************************************************/

void monetary_functs(void)
{
  char out_str[255];                    /* Output string for conversions.    */
  double num = 0.0;                     /* Input number for conversions.     */

                                        /* Print a header.                   */
  printf("\nLocale for monetary: %s\n", locale);

                                        /* Set number to convert.            */
                                        /* Convert without currency symbol.  */
                                        /* Print output results.             */
  num = 12345.6789;
  strfmon(out_str, sizeof(out_str), "Symbol-less format %!(#5i", num);
  printf("\nValue is %.4f    %s\n", num, out_str);

                                        /* Set number to convert.            */
                                        /* Convert in full international fmt.*/
                                        /* Print output results.             */
  num = -12.6789;
  strfmon(out_str, sizeof(out_str), "International format %^#.4i", num);
  printf("Value is %.4f      %s\n", num, out_str);

                                        /* Set number to convert.            */
                                        /* Convert in national format.       */
                                        /* Print output results.             */
  num = 045.6789;
  strfmon(out_str, sizeof(out_str), "National format %=0#7n", num);
  printf("Value is %.4f       %s\n", num, out_str);
}

/*****************************************************************************/
/***     Main program                                                      ***/
/*****************************************************************************/

void main(void)
{
                                        /* Set the locale based on env var.  */
                                        /* Get the locale for monetary.      */
  setlocale(LC_ALL, "");
  locale = setlocale(LC_MONETARY, NULL);

                                        /* Show monetary functions.          */
  monetary_functs();
}
