/*****************************************************************************/
/***     Include files                                                     ***/
/*****************************************************************************/

#include <stdio.h>                      /* Standard IO functions.            */

#include <wchar.h>                      /* I18N library header file.         */
#include <locale.h>                     /* Locale definitions.               */

/*****************************************************************************/
/***     Global defines                                                    ***/
/*****************************************************************************/

#define E_ACCUTE 130                    /* Character for french e accute.    */
#define O_CIRCUM 147                    /* Character for french o circumflex.*/

typedef char    a_string[200];          /* New type for 200 byte strings.    */
typedef wchar_t w_string[100];          /* New type for 100 char wide strings*/

/*****************************************************************************/
/***     Global variables                                                  ***/
/*****************************************************************************/

a_string str_arr[4];                    /* An array of four strings.         */
int loop1, loop2;                       /* Two general loop variables.       */

/*****************************************************************************/
/***     Do collations on strings                                          ***/
/*****************************************************************************/

void print_str_array(void);             /* Function prototype.               */

                                        /* This routine will sort culturally */
                                        /*  four strings in the str_arr array*/
void do_str_collate(void)
{
  a_string str_xfrm, str_swap;          /* Strings for strxfrm and swaps.    */
  char *p;

                                        /* Create the four strings to sort.  */
  sprintf(str_arr[0], "%c%c%c%c", 'c', O_CIRCUM, 't', 'e');
  sprintf(str_arr[1], "%c%c%c%c", 'c', O_CIRCUM, 't', E_ACCUTE);
  sprintf(str_arr[2], "%c%c%c%c", 'c', 'o', 't', E_ACCUTE);
  sprintf(str_arr[3], "%c%c%c%c", 'c', 'o', 't', 'e');

                                        /* Print a header.                   */
                                        /* Print out the initial array.      */
  printf("\nFunctions with multibyte strings:\n");
  printf("---------------------------------\n");
  printf("Initial array: ");
  print_str_array();

                                        /* Do a simple little bubble sort.   */
                                        /* Loop through all elements...      */
                                        /*  Loop through remaining unsorted  */
                                        /*   elements...                     */
                                        /*   If they are out of order...     */
                                        /*    Swap them.                     */
                                        /* Print out results after sort.     */
  for (loop1 = 0; loop1 < 3; loop1++)
  {
      for (loop2 = 0; loop2 < (3 - loop1); loop2++)
      {
          if (strcoll(str_arr[loop2], str_arr[loop2 + 1]) > 0)
          {
             strcpy(str_swap, str_arr[loop2]);
             strcpy(str_arr[loop2], str_arr[loop2 + 1]);
             strcpy(str_arr[loop2 + 1], str_swap);
          }
      }
  }
  printf("After sorting: ");
  print_str_array();

                                        /* Do a transform on one string.     */
                                        /* Print results (collation weights
                                         * are not printable as characters). */
  strxfrm(str_xfrm, str_arr[3], 200);
  printf("\nstrxfrm on string: '%s' is: 0x", str_arr[3]);
  for (p = str_xfrm; *p; p++) {
     printf("%02x", *p);
  }
}

void print_str_array(void)
{
                                        /* For all four array values...      */
                                        /*  Print out the string.            */
                                        /* Print out a newline when done.    */
  for (loop1 = 0; loop1 < 4; loop1++)
  {
      printf("%s ", str_arr[loop1]);
  }
  printf("\n");
}

/*****************************************************************************/
/***     Do collations on wide strings                                     ***/
/*****************************************************************************/

void do_wcs_collate(void)
{
  w_string w1, w2, wcs_xfrm;            /* Declare wide strings needed.      */
  wchar_t *wp;

                                        /* Print a header.                   */
  printf("\nFunctions with wide strings:\n");
  printf("----------------------------\n");

                                        /* Copy values into two wide strings.*/
                                        /* Print out values in strings.      */
                                        /* Print out collation weight for the*/
                                        /*  two strings.                     */
  wcscpy(w1, L"hello");
  wcscpy(w2, L"Hello");
  printf("Two strings are: '%S' and '%S'\n", w1, w2);
  printf("Collation on those two strings is: %d\n", wcscoll(w1, w2));

                                        /* Do a transform on one wide string.*/
                                        /* Print results (collation weights
                                         * are not printable as characters). */
  wcsxfrm(wcs_xfrm, w1, 100);
  printf("\nwcsxfrm on string: '%S' is: 0x", w1);
  for (wp = wcs_xfrm; *wp; wp++) {
     printf("%04x", *wp);
  }
  printf("\n");
}

/*****************************************************************************/
/***     Main program                                                      ***/
/*****************************************************************************/

void main(void)
{
                                        /* Set the locale based on env var.  */
                                        /* Print the locale value.           */
  setlocale(LC_ALL, "");
  printf("\nLocale setting: %s\n", setlocale(LC_COLLATE, NULL));

                                        /* Do collations.                    */
  do_str_collate();
  do_wcs_collate();
}
