                                        /* Structure of default locale info. */
typedef struct
{
   ULONG   ulCountry ;
   CHAR    szKeyboard[6] ;
   CHAR    szLocalePrefix[5] ;
   ULONG   ulDefaultCp ;
} LOCALEINFO ;

typedef struct
{
   USHORT  usKbdLen ;
   USHORT  usKbdCP ;
   CHAR    szKbdCtry[3] ;
   CHAR    szKbdSCtry[5] ;
} KBDDATA ;


/*-----------------------------------------------------------------------------
 *
 * The following locale table defines the mapping between the country code
 * value from OS/2 and the locale name to be associated with that value.
 *   1.  Find a matching country code entry.
 *   2.  If the table's keyboard value is not NULL, then match this value.
 *
 * NOTE:  These values are not included in the table because the country
 *        number is a duplicate of another entry, and there is no way to
 *        determine which value to use.  The locale table entry is the default.
 *
 *                                         V--Conflict with Flemish in Belgium.
 *   32,   0,        "FRBE",    850,       French in Belgium
 *
 *                                         V--Conflict with Serbian in Serbia.
 *   38,   0,        "HRHR",    852,       Croatian in Croatia
 *   38,   0         "SHSP",    852,       Latin Serbian in Serbia
 *   38,   0,        "SLSI",    852,       Slovenian in Slovenia
 *---------------------------------------------------------------------------*/

#define NUM_COUNTRIES          40

LOCALEINFO LocaleTable[ NUM_COUNTRIES ] =
{
    785,   "",       "ARAA",    864,    /* Arabic in Arabic area             */
    359,   "",       "BGBG",    915,    /* Bulgarian in Bulgaria             */
     45,   "",       "DADK",    850,    /* Danish in Denmark                 */
     49,   "",       "DEDE",    869,    /* German in Germany                 */
     30,   "",       "ELGR",    850,    /* Greek in Greece                   */
     99,   "",       "ENUS",    437,    /* English in Asia                   */
     61,   "",       "ENGB",    437,    /* English in Australia              */
     44,   "",       "ENGB",    850,    /* English in U.K.                   */
      1,   "",       "ENUS",    437,    /* English is U.S.                   */
     34,   "",       "ESES",    850,    /* Spanish in Spain                  */
    358,   "",       "FIFI",    850,    /* Finnish in Finland                */
      2,   "",       "FRCA",    850,    /* French in Canada                  */
     33,   "",       "FRFR",    850,    /* French in France                  */
     36,   "",       "HUHU",    852,    /* Hungarian in Hungary              */
    354,   "",       "ISIS",    850,    /* Icelandic in Iceland              */
     39,   "",       "ITIT",    850,    /* Italian in Italy                  */
    972,   "",       "IWIL",    862,    /* Hebrew in Israel                  */
     81,   "",       "JAJP",    932,    /* Japanese in Japan                 */
     82,   "",       "KOKR",    949,    /* Korean in Korea                   */
    389,   "",       "MKMK",    915,    /* Macedonian in Macedonia           */
     32,   "",       "NLBE",    850,    /* Flemish in Belgium                */
     31,   "",       "NLNL",    850,    /* Dutch in Netherlands              */
     47,   "",       "NONO",    850,    /* Norwegian in Norway               */
     48,   "",       "PLPL",    852,    /* Polish in Poland                  */
     55,   "",       "PTBR",    850,    /* Portuguese in Brazil              */
    351,   "",       "PTPT",    850,    /* Portuguese in Portugal            */
     40,   "",       "RORO",    852,    /* Romanian in Romania               */
      7,   "",       "RURU",    866,    /* Russian in Russia                 */
     38,   "",       "SRSP",    915,    /* Cyrillic Serbian in Serbia        */
     46,   "",       "SVSE",    850,    /* Swedish in Sweden                 */
     66,   "",       "THTH",    874,    /* Thai in Thailand                  */
     90,   "",       "TRTR",    857,    /* Turkish in Turkey                 */
     86,   "",       "ZHCN",   1381,    /* Simplified Chinese in China       */
     88,   "",       "ZHTW",    950,    /* Traditional Chinese in Taiwan     */

     41,   "SF",     "FRCH",    850,    /* French in Switzerland             */
     41,   "SG",     "DECH",    850,    /* German in Switzerland             */
     41,   "",       "DECH",    850,    /* German in Switzerland   (Default) */

     42,   "CS245",  "SKSK",    852,    /* Slovak in Slovakia                */
     42,   "CS243",  "CSCZ",    852,    /* Czech in Czech Republic           */
     42,   "",       "CSCZ",    852,    /* Czech in Czech Republic (Default) */
} ;
