/* Return Codes */
#define RC_NO_ERROR           0         /* Return: No error                  */

/* Input Parameter Errors */
#define RC_BAD_SOURCE         1         /* Source directory invalid          */
#define RC_BAD_CONFIG_FLAG    2         /* Config flag not Y or N            */
#define RC_BAD_LANG           3         /* Lang not alpha                    */
                                        /*  1st chars of lang must be xxxx   */
                                        /*  or xx_xx where x is an alpha     */
#define RC_MISSING_REQ_PARM   4         /* Required parameter is missing     */
#define RC_BAD_PARM           5         /* Parameter not recognized          */
#define RC_BAD_ERASE_FLAG     6         /* Erase flag not Y or N             */
#define RC_BAD_DRIVE          7         /* Invalid drive parm                */

/* Processing Errors */
#define RC_SOURCE_SYS         8         /* Cannot open source syslevel file  */
                                        /*  or not a valid syslevel file     */
#define RC_CURRENT_SYS        9         /* Cannot open current syslevel file */
                                        /*  or not a valid syslevel file     */
#define RC_MEMORY_ERROR      10         /* Error allocating memory           */
#define RC_CONFIG_FAILED     11         /* CONFIG.SYS update failed          */
#define RC_COPY_ERROR        12         /* Error copying files               */
#define RC_DISK_FULL         13         /* Disk full                         */
#define RC_DIR_ERROR         14         /* Error creating directory. Already */
                                        /*  exists error is ignored.         */
#define RC_DELETE_SOURCE     15         /* Error occurred deleting source    */
                                        /*  This is the last thing the       */
                                        /*  install does, so everything else */
                                        /*  worked.  Caller may want to      */
                                        /*  ignore this error.               */

