/** wchar.h National Language Support OS2 Include File
*.
*.      (C) COPYRIGHT International Business Machines Corp. 1985, 1990
*.      All Rights Reserved
*.      Licensed Materials - Property of IBM
*.
*.      US Government Users Restricted Rights - Use, duplication or
*.      disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
*.
** Description:
*
*       The wchar.h file is part of the National Language Support
*       system for OS/2 and AIX operating systems. Programmers
*       interested in writing NLS enabled applications would include
*       this file in their source files.
*
**/
/** Constants NLS DataTypes and Constants
*
** Notes:
*
*) The wchar_t datatype is 16-bits in this implementation, however the
*  the X/OPEN XPG4 standard allows other sizes.
**/

#ifndef __H_WCHAR
#define __H_WCHAR

#include <errno.h>
#include <stdarg.h>
#include <limits.h>
#include <stdio.h>
#include <time.h>
#include <stddef.h>
#include <nl_types.h>

#ifndef     _WCTYPE_T
    #define _WCTYPE_T
      typedef unsigned int wctype_t;
#endif


#ifndef     _WINT_T
    #define _WINT_T
      typedef int wint_t;
#endif


#ifndef     fcvt                       /* floating point conversion */
    #define fcvt _fcvt
#endif

typedef unsigned  char  uchar_t;
typedef unsigned short ushort_t;
typedef unsigned   int   uint_t;
typedef unsigned  long  ulong_t;

typedef   signed   int  ssize_t;

#define _ISALPHA  0x001
#define _ISALNUM  0x002
#define _ISBLANK  0x004
#define _ISCNTRL  0x008
#define _ISDIGIT  0x010
#define _ISGRAPH  0x020
#define _ISLOWER  0x040
#define _ISPRINT  0x080
#define _ISPUNCT  0x100
#define _ISSPACE  0x200
#define _ISUPPER  0x400
#define _ISXDIGIT 0x800


/** Error codes
*
** Notes:
*
*      The ANSI, POSIX, and XOPEN standards require that certain values be
*      in errno.h.  The standards allow additional macro definitions,
*      beginning with an E and an uppercase letter.
*
**/


extern int errno;

#undef EILSEQ
#define EILSEQ         52
#undef E2BIG
#define E2BIG          53
#undef ENAMETOOLONG
#define ENAMETOOLONG    86      /* File name too long           */
#define ECLONEME  ERESTART /* this is the way we clone a stream ... */

#define _IOUNGETWC  0x0008      /* UNGETWC flag mask            */

#define MB_MAX_LEN  4

#undef MB_LEN_MAX
#define  MB_LEN_MAX 4

#undef MB_CUR_MAX
#define MB_CUR_MAX (__getmbcurmax())

#ifndef EOF
        #define EOF             (-1)
#endif

#ifndef WEOF
        #define WEOF             (-1)
#endif

/** Prototypes **/

#ifdef __cplusplus
extern "C" {
#endif

extern int __getmbcurmax(void);

/***************************/
/* Runtime Locale Function */
/***************************/
char * setlocale(int, const char *);


/*************************************/
/* Date, Time and Monetary Functions */
/*************************************/
size_t  strftime(char *s, size_t maxsize, const char *format,
                 const struct tm *timeptr);
ssize_t  strfmon(char *s, size_t maxsize, const char *format, ...);
char *  strptime(const char *buf, const char *fmt, struct tm *tm);
size_t  wcsftime(wchar_t *ws, size_t maxsize,
                 const char *format, const struct tm *timeptr);
double  wcstod ( const wchar_t *nptr, wchar_t **endptr );
long    wcstol (const wchar_t *nptr, wchar_t **endptr, int base);
unsigned long  wcstoul (const wchar_t *nptr, wchar_t **endptr, int base);

#undef    _strtodieee
#define   _strtodieee _strtod

/* CSET++ defines strtod differently in <stdlib.h> than */
/*  does CSET/2.  This requires the conditional define below.                 */
#ifndef strtod
#define strtod( p1, p2 )  _strtodieee( (p1), (p2) )
#endif

/*********************************/
/* String Manipulation Functions */
/*********************************/
size_t   wcscspn (const wchar_t *ws1, const wchar_t *ws2);
size_t   wcslen  (const wchar_t *ws);
wchar_t *wcscat  (wchar_t       *ws1, const wchar_t *ws2);
wchar_t *wcscpy  (wchar_t       *ws1, const wchar_t *ws2);
int      wcscmp  (const wchar_t *ws1, const wchar_t *ws2);
int      wcsncmp (const wchar_t *ws1, const wchar_t *ws2, size_t n);
wchar_t *wcspbrk (const wchar_t *ws1, const wchar_t *ws2);
wchar_t *wcsncpy (wchar_t       *ws1, const wchar_t *ws2, size_t n);
size_t   wcsspn  (const wchar_t *ws1, const wchar_t *ws2);
wchar_t *wcschr  (wchar_t       *ws1, wint_t         wc);
wchar_t *wcsncat (wchar_t       *ws1, const wchar_t *ws2, size_t n);
wchar_t *wcsrchr (wchar_t       *ws1, wint_t         wc);
wchar_t *wcstok  (wchar_t       *ws1, const wchar_t *ws2);
wchar_t *wcswcs  (const wchar_t *ws1, const wchar_t *ws2);

/***************************/
/* Formatted I/O Functions */
/***************************/
#undef printf
#undef sprintf
#undef fprintf
#undef vprintf
#undef vsprintf
#undef vfprintf

#define printf   wprintf
#define sprintf  wsprintf
#define fprintf  wfprintf
#define vprintf   nls_vprintf
#define vsprintf  nls_vsprintf
#define vfprintf  nls_vfprintf

#undef scanf
#undef sscanf
#undef fscanf

#define scanf   wscanf
#define sscanf  wsscanf
#define fscanf  wfscanf

int  _xprint(char print_type, void * ostream, char * oformat,va_list oargs);
int  _xscan(char scan_type, void * ostream, char * oformat, va_list oargs );
double _strtod (const char *nptr, char **endptr);
int  wprintf   (const char * oformat, ...);
int  wsprintf  (char * ostring, const char * oformat, ...);
int  wfprintf  (FILE * ostream, const char * oformat, ...);
int  nls_vprintf (const char *format, va_list args);
int  nls_vsprintf (char *outp, const char * format, va_list args);
int  nls_vfprintf (FILE *outp, const char * format, va_list args);
int  wscanf   (char * oformat, ...);
int  wsscanf  (char * ostring, char * oformat, ...);
int  wfscanf  (FILE * ostream, char * oformat, ...);

/**********************/
/* File I/O Functions */
/**********************/
wint_t   fgetwc(FILE *stream);
wchar_t *fgetws(wchar_t *s, int n, FILE *stream);
wint_t   fputwc(const wint_t c, FILE *stream);
int      fputws(const wchar_t *s,FILE *stream);
int      getw(register FILE *stream);
wint_t   getwc (FILE *stream);
wint_t   getwchar (void);
int      putw(int w, register FILE *stream);
wint_t   putwc(wint_t c, FILE *stream);
wint_t   putwchar(wint_t c);
wint_t   ungetwc(wint_t c, FILE *stream);

/**********************************/
/* Character Conversion Functions */
/**********************************/
size_t mbstowcs(wchar_t *pwcs, const char *s, size_t n);
int    mbtowc(wchar_t *pwc, const char *s, size_t len);
int    mblen(const char *s, size_t n);
int    wcswidth(wchar_t *wcs, size_t n);
int    wctomb(char *s, wchar_t pwc);
int    wcwidth(wchar_t wc);
size_t wcstombs(char *s, const wchar_t *pwcs, size_t n);

/***********************/
/* Collation Functions */
/***********************/
int strcoll(const char *s1, const char *s2);
int wcscoll(const wchar_t *wcs1, const wchar_t *wcs2);
size_t wcsxfrm(wchar_t *ws1, const wchar_t *ws2, size_t n);
size_t strxfrm(char *s1, const char *s2, size_t n);

/*****************************************/
/* Character Attribute Testing Functions */
/*****************************************/
#undef isalnum
#undef isalpha
#undef iscntrl
#undef isdigit
#undef isgraph
#undef islower
#undef isprint
#undef ispunct
#undef isspace
#undef isupper
#undef isxdigit
int isalnum(int c);
int isalpha(int c);
int iscntrl(int c);
int isdigit(int c);
int isgraph(int c);
int islower(int c);
int isprint(int c);
int ispunct(int c);
int isspace(int c);
int isupper(int c);
int isxdigit(int c);

int iswalnum(wint_t pc);
int iswalpha(wint_t pc);
int iswcntrl(wint_t pc);
int iswdigit(wint_t pc);
int iswgraph(wint_t pc);
int iswlower(wint_t pc);
int iswprint(wint_t pc);
int iswpunct(wint_t pc);
int iswspace(wint_t pc);
int iswupper(wint_t pc);
int iswxdigit(wint_t pc);
int iswctype(wint_t wc, wctype_t mask);
wctype_t wctype(char *name);

#undef tolower
#undef toupper
int tolower(int c);
int toupper(int c);

wint_t towlower(wint_t wc);
wint_t towupper(wint_t wc);


/**********************************************
** helper functions which work for 16/32 bit **
**********************************************/

double get_i18n_version(void);


#ifdef __cplusplus
}
#endif


#ifdef   _OS2_CORE
    #include <lc_core.h>
    #include <locale.h>
    #include <langinfo.h>
#endif

#endif
