/*****************************************************************************/
/***     Include files                                                     ***/
/*****************************************************************************/

#include <stdio.h>                      /* Standard IO functions.            */

#include <wchar.h>                      /* I18N definitions.                 */

/*****************************************************************************/
/***     Global defines                                                    ***/
/*****************************************************************************/

#define SAME 0

/*****************************************************************************/
/***     Global variables                                                  ***/
/*****************************************************************************/

wchar_t w_str1[100], w_str2[100];       /* Two wide strings used in function.*/

/*****************************************************************************/
/***     Copy and concatenate functions                                    ***/
/*****************************************************************************/

void copy_concat_functions()
{
                                        /* Print a header.                   */
                                        /* Copy a wide string into a variable*/
                                        /* Print out the string.             */
                                        /* Print out the length of the string*/
                                        /* Concatenate a string on the end.  */
                                        /* Print out the new string.         */
                                        /* Copy the first 6 characters to a  */
                                        /*  different wide string.           */
                                        /* Print out that string.            */
                                        /* Concatenate 13 characters from a  */
                                        /*  literal onto the end of the 6    */
                                        /*  character string.                */
                                        /* Print out the results.            */
  printf("\nCopy and concat functions:\n");
  printf("--------------------------\n");
  wcscpy(w_str1, L"This is a wchar_t string.");
  printf("Original string: %S\n", w_str1);
  printf("Length of the string is: %d\n", wcslen(w_str1));
  wcscat(w_str1, L"  Add this on the end!");
  printf("Add to end of the string: %S\n", w_str1);
  wcsncpy(w_str2, w_str1, 6);
  printf("Copy the first 6 characters of the string: %S\n", w_str2);
  wcsncat(w_str2, L"is an added substring.", 13);
  printf("Concat 13 characters on the end: %S\n", w_str2);
}

/*****************************************************************************/
/***     Comparison functions                                              ***/
/*****************************************************************************/

void compare_functions(void)
{
                                        /* Print a header.                   */
                                        /* Copy literals into 2 wide strings.*/
                                        /* Compare the two strings to see if */
                                        /*  they are the same.               */
                                        /* Compare the first 10 characters to*/
                                        /*  see if they are the same.        */
  printf("\nCompare functions:\n");
  printf("------------------\n");
  wcscpy(w_str1, L"This is string 1.");
  wcscpy(w_str2, L"This is string 2.");
  printf("Are the two strings the same? %s\n",
         (wcscmp(w_str1, w_str2) == SAME) ? "Yes" : "No");
  printf("Are the first 10 characters of the two strings the same? %s\n",
         (wcsncmp(w_str1, w_str2, 10) == SAME) ? "Yes" : "No");
}

/*****************************************************************************/
/***     Scanning functions                                                ***/
/*****************************************************************************/

void scanning_functions(void)
{
                                        /* Print a header.                   */
                                        /* Print out the string we'll be     */
                                        /*  scanning...                      */
                                        /* Scan for first occurance of a char*/
                                        /* Scan for first string found in the*/
                                        /*  larger string.                   */
                                        /* Scan for last occurance of a char.*/
                                        /* Scan for first occurance of any of*/
                                        /*  the characters in the substring. */
                                        /*  NOTE: This function first looks  */
                                        /*  for the first occurance of the   */
                                        /*  first char in the substring.  If */
                                        /*  that fails, it looks at the next */
                                        /*  character in the substring...    */
  printf("\nScanning functions:\n");
  printf("-------------------\n");
  printf("Using the string: %S\n", w_str1);
  printf("First occurance of 's' is: %S\n", wcschr(w_str1, L's'));
  printf("First occurance of ' is' is: %S\n", wcswcs(w_str1, L" is"));
  printf("Last occurance of: 's' is: %S\n", wcsrchr(w_str1, L's'));
  printf("Scan: '%S' for first occurance of: 'stuv': '%S'\n", w_str1,
         wcspbrk(w_str1, L"stuv"));
}

/*****************************************************************************/
/***     Substring functions                                               ***/
/*****************************************************************************/

void substring_functions(void)
{
                                        /* Print a header.                   */
                                        /* Assign two wide strings.          */
                                        /* Find out how many characters in   */
                                        /*  the string are in the substring  */
                                        /*  (starting from the first char)?  */
                                        /* Find out how many characters in   */
                                        /*  the string are NOT in the        */
                                        /*  substring (starting from the     */
                                        /*  first char)?                     */
  printf("\nSubstring length functions:\n");
  printf("---------------------------\n");
  wcscpy(w_str1, L"cabbage");
  wcscpy(w_str2, L"abc");
  printf( "The first %d characters of \"%S\" are found in \"%S\"\n",
       wcsspn(w_str1, w_str2), w_str1, w_str2);
  wcscpy(w_str2, L"bde");
  printf( "The first %d characters of \"%S\" are not found in \"%S\"\n",
       wcscspn(w_str1, w_str2), w_str1, w_str2);
}

/*****************************************************************************/
/***     Tokenizing functions                                              ***/
/*****************************************************************************/

void tokenizing_functions(void)
{
  int count;                            /* Loop counter.                     */

                                        /* Print a header.                   */
                                        /* Assign a wide string.             */
                                        /* Tokenize the string based on space*/
                                        /*  comma and period characters, and */
                                        /*  print out the token found.       */
                                        /* Loop seven more times...          */
                                        /*  Tokenize the string again, and   */
                                        /*   print out the token.            */
  printf("\nTokenizing functions:\n");
  printf("---------------------\n");
  wcscpy(w_str1, L"This line has spaces,commas,and periods.!");
  printf("Tokenizing: '%S' based on: ' ,.'\n", w_str1);
  printf("Token: %S\n", wcstok(w_str1, L" ,."));
  for (count = 0; count < 7; count++)
  {
      printf("Token: %S\n", wcstok(NULL, L" ,."));
  }
}

/*****************************************************************************/
/***     Main program                                                      ***/
/*****************************************************************************/

void main(void)
{
                                        /* Perform each of the following     */
                                        /*  groups of wide string functions. */
  copy_concat_functions();
  compare_functions();
  scanning_functions();
  substring_functions();
  tokenizing_functions();
}
