/*****************************************************************************/
/***     Include files                                                     ***/
/*****************************************************************************/

#define INCL_WIN                        /* Include the "win" OS2 calls.      */
#include <os2.h>                        /* Include the OS2 toolkit defs.     */

#include <stdlib.h>                     /* Include the standard library.     */
#include <stdio.h>                      /* Include standard input/output.    */
#include <string.h>                     /* Include string functions.         */
#include <time.h>                       /* Include basic date/time functions.*/
#include <sys\types.h>                  /* Types for stat call.              */
#include <sys\stat.h>                   /* Include file for stat call.       */

#include <wchar.h>                      /* Base XPG4 include file.           */
#include <locale.h>                     /* Locale definitions.               */

#include "localpth.h"                   /* Definitions for locale path dialog*/
#include "about.h"                      /* Definitions for about dialog box. */

/*****************************************************************************/
/***     Catalog defines                                                   ***/
/*****************************************************************************/

                                        /* This should be the define for the */
                                        /*  message catalog name.            */
/* #define CAT_NAME    "wrld.cat"                                            */
/* #define ICON_NAME   "world.ico"                                           */
#define CAT_NAME    "\\i18n\\messages\\%s\\wrld.cat"
char t_cat_name[100];                   /* Needed for hacked solution.       */
                                        /* Same scheme for icons.            */
#define ICON_NAME   "\\i18n\\messages\\%s\\world.ico"
char t_icon_name[100];

/*****************************************************************************/
/***     Dialog defines                                                    ***/
/*****************************************************************************/

#define COUNTRY_DIALOG           3000   /* Defines for controls in the       */
#define COUNTRY_GROUP            3001   /*  dialog for each locale.          */
#define COUNTRY_DATE             3002
#define COUNTRY_TIME             3003
#define COUNTRY_MONEY            3004
#define COUNTRY_COLLATE          3005
#define COUNTRY_COLL_BUTTON      3006
#define COUNTRY_CANCEL_BUTTON    3007
#define COUNTRY_DATE_LABEL       3008
#define COUNTRY_TIME_LABEL       3009
#define COUNTRY_MONEY_LABEL      3010

#define COUNTRY_TITLE_BASE       3020   /* Base of the titles of the locale  */
                                        /*  names.                           */

#define MESSAGE_DIALOG           3100   /* Defines for the message dialog    */
#define MESSAGE_TEXT             3101   /*  displayed instead of the non     */
#define MESSAGE_OK               3102   /*  cultural "WinMessageBox"         */

/*****************************************************************************/
/***     User defined messages                                             ***/
/*****************************************************************************/

#define WM_REDRAW_NLS_TEXT       (WM_USER + 0)
                                        /* This message is sent to any and   */
                                        /*  modeless dialogs when the current*/
                                        /*  language is dynamically changed. */
                                        /*  The dialog is then responsible   */
                                        /*  for changing all locale-depend   */
                                        /*  strings.  The dialog can assume  */
                                        /*  that the message catalog for the */
                                        /*  new locale is open.  In this     */
                                        /*  program, only the locale dialogs */
                                        /*  are sent this message.           */

/*****************************************************************************/
/***     Others                                                            ***/
/*****************************************************************************/

#define RES_CLIENT               256    /* Client window define.             */

#define MENU_FILE                500    /* Items in the FILE menu.           */
#define MENU_FILE_HELP           501
#define MENU_FILE_ABOUT          502

#define MENU_LOCALE              510    /* Items in the locale menu.         */
#define MENU_LOCALE_SET          511

#define MENU_OPTIONS             520    /* Items in the options menu.        */
#define MENU_OPTIONS_ICON        521

#define MENU_LANGS               530    /* Items in the message language menu*/
#define MENU_LANGS_LANG0         531
#define MENU_LANGS_LANG1         532
#define MENU_LANGS_LANG2         533
#define MENU_LANGS_LANG3         534
#define MENU_LANGS_LANG4         535
#define MENU_LANGS_LANG5         536
#define MENU_LANGS_LANG6         537
#define MENU_LANGS_LANG7         538
#define MENU_LANGS_LANG8         539
#define MENU_LANGS_LANG9         540
#define MENU_LANGS_LANG10        541
#define MENU_LANGS_LANG11        542

#define BITMAP_WORLD             600    /* Define for the world bitmap.      */

#define BITMAP_LANG0             601    /* Bitmaps for the countries.        */
#define BITMAP_LANG1             602
#define BITMAP_LANG2             603
#define BITMAP_LANG3             604
#define BITMAP_LANG4             605
#define BITMAP_LANG5             606
#define BITMAP_LANG6             607
#define BITMAP_LANG7             608
#define BITMAP_LANG8             609
#define BITMAP_LANG9             610
#define BITMAP_LANG10            611
#define BITMAP_LANG11            612

/*****************************************************************************/
/***     Global code macros                                                ***/
/*****************************************************************************/

                                        /* This macro is used to set the text*/
                                        /*  for a menu item (for initializing*/
                                        /*  the menu, and when we change     */
                                        /*  message language.                */
#define set_menu_text(item_id, catalog_id, def) \
  WinSetMenuItemText(hwnd_menu, item_id, \
                     catgets(msg_handle, MEN, catalog_id, def));

/*****************************************************************************/
/***     Global type definitions                                           ***/
/*****************************************************************************/

typedef UCHAR nam[10];                  /* New type of locale names.         */
typedef UCHAR long_nam[100];            /* Long names for default locales.   */

/*****************************************************************************/
/***     Global defines                                                    ***/
/*****************************************************************************/

#define NLS_PATH       "NLSPATH"        /* Name of needed environment var.   */

#define NUM_LOCALES    12                /* How many locales are we showing   */
                                        /*  on the world map?                */

#define LOCALE_EN_US   0                /* Defines for each of the locales.  */
#define LOCALE_ES_ES   1
#define LOCALE_DE_DE   2
#define LOCALE_SV_SE   3
#define LOCALE_FR_FR   4
#define LOCALE_JA_JP   5
#define LOCALE_EN_GB   6
#define LOCALE_IT_IT   7
#define LOCALE_AR_AA   8
#define LOCALE_DA_DK   9
#define LOCALE_PL_PL   10
#define LOCALE_NO_NO   11

#define BELL           7                /* ASCII bell character.             */

#define EXIT_NORMAL    0                /* Exit the program with no errors.  */

#define FILE_NOT_FOUND -1               /* Flag for file open call.          */

#define CLS_CLIENT     "MyClass"        /* Default PM class to register.     */

#define WIN_WIDTH      557              /* Width and height of main window.  */
#define WIN_HEIGHT     395

#define NUM_COLL_STRINGS 10             /* Number of strings in list box to  */
                                        /*  collate.                         */

#define NO_LOCALE -1                    /* None of the locale menu items are */
                                        /*  checked.                         */

#define e_accute 130                    /* Some defines for diacritic chars. */
#define o_circumflex 147

/*****************************************************************************/
/***     Global variables                                                  ***/
/*****************************************************************************/

nl_catd msg_handle;                     /* Handle for message catalog.       */

int which_locale;                       /* Which locale has opened the       */
                                        /*  country dialog?                  */

                                        /* NOTE: The following arrays MUST   */
                                        /*        have the locales in the    */
                                        /*        EXACT same order.          */
                                        /* Array of locale names.            */
                                        /* Array of locations to draw the    */
                                        /*  locale dialog boxes.             */
                                        /* Array of rectangles for hit       */
                                        /*  testing when the mouse is clicked*/
nam locale_names[NUM_LOCALES] = {"ENUS437", "ESES850", "DEDE850", "SVSE850",
                                 "FRFR850", "JAJP932", "ENGB850", "ITIT850",
                                 "ARAA1046", "DADK850", "PLPL852", "NONO850"};
POINTL locale_locs[NUM_LOCALES] = {{5, 5}, {140, 5}, {90, 70}, {215, 70},
                                   {275, 5}, {340, 70}, {0, 70}, {140, 105},
                                   {275, 105}, {275, 105}, {275, 105},
                                   {275, 105}};
RECTL  locale_hit_locs[NUM_LOCALES] = {{109, 229, 116, 236},
                                       {255, 249, 262, 256},
                                       {282, 272, 289, 279},
                                       {289, 285, 296, 292},
                                       {265, 261, 272, 268},
                                       {477, 239, 484, 246},
                                       {262, 268, 269, 275},
                                       {289, 242, 296, 249},
                                       {307, 224, 314, 231},
                                       {0, 0, 0, 0},
                                       {0, 0, 0, 0},
                                       {0, 0, 0, 0}};

HBITMAP locale_bitmaps[NUM_LOCALES];    /* Bitmaps for locales in menus.     */
int locale_active[NUM_LOCALES];         /* Array to determine which locales  */
                                        /*  are currently "active" (open).   */
HWND locale_windows[NUM_LOCALES];       /* Array of window handles for locale*/
                                        /*  dialogs.                         */
HWND hwndFrame;                         /* Frame window handle for main win. */
HWND hwndClient;                        /* Client window handle for main win.*/

                                        /* Two paths used for opening locale */
                                        /*  .dll files.                      */
UCHAR       locale_path[200] = "\\i18n\\locale";
UCHAR       temp_locale_path[200];

struct stat stat_buffer;                /* Buffer to hold file status info.  */

nam coll_arr[NUM_COLL_STRINGS];         /* Array of strings to collate.      */

LONG screen_width, screen_height;       /* Width and height of screen.       */

HWND hwnd_menu;                         /* Handle to menu window for main    */
                                        /*  window of program.               */

char *error_text, *error_title;         /* Pointers used for error routine.  */

int cur_mess_locale;                    /* Which locale is currently used    */
                                        /*  for messages.                    */

int icons_in_menus;                     /* Are we showing icons in menus?    */

HPOINTER icon_pointer;                  /* Minimized icon's handle.          */

                                        /* Arrays of locales and country     */
                                        /*  names for default (C) locale.    */
long_nam def_locs[NUM_LOCALES] = {"English in USA", "Spanish in Spain",
                                  "German in Germany", "Swedish in Sweden",
                                  "French in France", "Japanese in Japan",
                                  "English in Great Britain",
                                  "Italian in Italy", "Arabic in Egypt"};
long_nam def_cntry[NUM_LOCALES] = {"United States", "Spain", "Germany",
                                   "Sweden", "France", "Japan", "Great Britain",
                                   "Italy", "Egypt"};
