/*****************************************************************************/
/***     Include files                                                     ***/
/*****************************************************************************/

#include <stdlib.h>                     /* Standard libarary.                */
#include <stdio.h>                      /* Standard IO functions.            */

#include <wchar.h>                      /* XPG/4 library.                    */
#include <locale.h>                     /* Locale definitions.               */

/*****************************************************************************/
/***     Do some wchar_t conversions                                       ***/
/*****************************************************************************/

void do_w_conversions()
{
  char    a_char, b_char;               /* Characters used in conversion.    */
  wchar_t a_w_char;                     /* Wide character used in conversion.*/
  char    a_string[100], b_string[100]; /* Strings used in conversions.      */
  wchar_t a_w_string[50];               /* String of wchar_t for conversion. */

                                        /* Assign a string into a variable.  */
                                        /* Convert it to a wide string.      */
                                        /* Convert the wide string back to a */
                                        /*  multibyte string.                */
                                        /* Print out all three strings.      */
  strcpy(a_string, "Hello there!");
  mbstowcs(a_w_string, a_string, 50);
  wcstombs(b_string, a_w_string, 100);
  printf("Original string:  %s\nConverted string: %S\nConverted back:   %s\n",
         a_string, a_w_string, b_string);

                                        /* Assign a char into a variable.    */
                                        /* Convert it to a wide char.        */
                                        /* Convert the wide char back to a   */
                                        /*  multibyte char.                  */
                                        /* Print out all three chars.        */
  a_char = 'K';
  mbtowc(&a_w_char, &a_char, 2);
  wctomb(&b_char, a_w_char);
  printf("\nOriginal char:  %c\nConverted char: %C\nConverted back: %c\n",
         a_char, a_w_char, b_char);

                                        /* Print out the length (in bytes)   */
                                        /*  of a multibyte character.        */
                                        /* Print out the width (in chars) of */
                                        /*  a wide character.                */
                                        /* Print out the width (in chars) of */
                                        /*  a wide string.                   */
  printf("\nLength of multibyte character: '%c' is: %d\n", a_char,
         mblen(&a_char, MB_CUR_MAX));
  printf("\nWidth of wchar_t character: '%C' is: %d\n", a_w_char,
         wcwidth(a_w_char));
  printf("\nWidth of wchar_t string: '%S' is: %d\n", a_w_string,
         wcswidth(a_w_string, wcslen(a_w_string)));
}

/*****************************************************************************/
/***     Main program                                                      ***/
/*****************************************************************************/

void main(void)
{
                                        /* Set the locale based on env var.  */
                                        /* Print out the locale.             */
  setlocale(LC_ALL, "");
  printf("\nCurrent locale is: %s\n\n", setlocale(LC_CTYPE, NULL));

                                        /* Do some wchar_t conversions.      */
  do_w_conversions();
}
