#include <stdio.h>
#include <stdarg.h>
#include <locale.h>
#include <wchar.h>

int myprint(const char *format, ...);

#define PRINT_RESULT(PRINT_STATEMNT) { \
  myprint("Output:\n"); \
  myprint("Return Code: %d\n\n", (PRINT_STATEMNT)); \
}

main()
{
  short sn;
  int n;

  setlocale(LC_ALL, "");

  myprint("%s\n",
    "myprint(\"%4d%4i%4o%4u%4x%4X\\n\", 123, 123, 123, 123, 123, 123);");
  PRINT_RESULT(myprint("%4d%4i%4o%4u%4x%4X\n", 123, 123, 123, 123, 123, 123));

  myprint("%s\n",
    "myprint(\"%.1d %.3d %01d %03d %.1x %.3x %01x %03x\\n\", \n"
    "       12, 12, 12, 12, 12, 12, 12, 12);");
  PRINT_RESULT(myprint("%.1d %.3d %01d %03d %.1x %.3x %01x %03x\n", \ 
    12, 12, 12, 12, 12, 12, 12, 12));

  myprint("%s\n",
    "myprint(\"%d %o %x %X %u %i %p\\n\", \n"
    "       -12345, -12345, -12345, -12345, -12345, -12345, -12345);");
  PRINT_RESULT(myprint("%d %o %x %X %u %i %p\n", \
    -12345, -12345, -12345, -12345, -12345, -12345, -12345));

  myprint("%s\n",
    "myprint(\"%\\\'d %\\\'o %\\\'x %\\\'X %\\\'u %\\\'i %\\\'p\\n\", \n"
    "       -12345, -12345, -12345, -12345, -12345, -12345, -12345);");
  PRINT_RESULT(myprint("%\'d %\'o %\'x %\'X %\'u %\'i %\'p\n", \
    -12345, -12345, -12345, -12345, -12345, -12345, -12345));

  myprint("%s\n",
    "myprint(\"%#d %#o %#x %#X %#u %#i %#p\\n\", \n"
    "       -12345, -12345, -12345, -12345, -12345, -12345, -12345);");
  PRINT_RESULT(myprint("%#d %#o %#x %#X %#u %#i %#p\n", \
    -12345, -12345, -12345, -12345, -12345, -12345, -12345));

  myprint("%s\n",
    "myprint(\"abc %s ghi %s mno\\n\", \"def\", \"jkl\");");
  PRINT_RESULT(myprint("abc %s ghi %s mno\n", "def", "jkl"));

  myprint("%s\n",
    "myprint(\"abc %2$s ghi %1$s mno\\n\", \"jkl\", \"def\");");
  PRINT_RESULT(myprint("abc %2$s ghi %1$s mno\n", "jkl", "def"));

  myprint("%s\n",
    "myprint(\"abc %4$*3$.*2$s ghi %1$s mno\\n\", \"jkl\", 5, 5, \"def\");");
  PRINT_RESULT(myprint("abc %4$*3$.*2$s ghi %1$s mno\n", "jkl", 5, 5, "def"));

  myprint("%s\n",
    "myprint(\"abc %4$*3$.*2$S ghi %1$S mno\\n\", L\"jkl\", 5, 5, L\"def\");");
  PRINT_RESULT(myprint("abc %4$*3$.*2$S ghi %1$S mno\n", L"jkl", 5, 5, L"def"));

  myprint("%s\n",
    "myprint(\"%s %5s %5.2s %2.5s\\n\", \n"
    "       \"abc\", \"abc\", \"abc\", \"abc\");");
  PRINT_RESULT(myprint("%s %5s %5.2s %2.5s\n", \
    "abc", "abc", "abc", "abc"));

  myprint("%s\n",
    "myprint(\"%S %5S %5.2S %2.5S\\n\", \n"
    "       L\"abc\", L\"abc\", L\"abc\", L\"abc\");");
  PRINT_RESULT(myprint("%S %5S %5.2S %2.5S\n", \
    L"abc", L"abc", L"abc", L"abc"));

  myprint("%s\n",
    "myprint(\"%*.*f\\n\", 8, 2, 12.345);");
  PRINT_RESULT(myprint("%*.*f\n", 8, 2, 12.345));

  myprint("%s\n",
    "myprint(\"%2$*3$d %1$4s\\n\", \"foo\", 345, 5);");
  PRINT_RESULT(myprint("%2$*3$d %1$4s\n", "foo", 345, 5));

  myprint("%s\n",
    "myprint(\"%2$3.3d abc %1$2.-3d def %3$4.d ghi\\n\", 1, 2, 3);");
  PRINT_RESULT(myprint("%2$3.3d abc %1$2.-3d def %3$4.d ghi\n", 1, 2, 3));

  myprint("%s\n",
    "myprint(\"%1$*3$.*4$d %2$s\\n\", 3, \"foo\", 5, 6);");
  PRINT_RESULT(myprint("%1$*3$.*4$d %2$s\n", 3, "foo", 5, 6));

  myprint("%s\n",
    "myprint(\"%c %C %hn %% %c %C %n\\n\", \n"
    "       \'a\', L\'a\', &sn, \'b\', L\'b\', &n);");
  PRINT_RESULT(myprint("%c %C %hn %% %c %C %n\n", \
    'a', L'a', &sn, 'b', L'b', &n));
  myprint("Value of sn is: %hd \n", sn);
  myprint("Value of n is: %d \n\n", n);

  myprint("%s\n",
    "myprint(\"%e %E %f %g %G\\n\", 2.3, 2.3, 2.3, 2.3, 2.3);");
  PRINT_RESULT(myprint("%e %E %f %g %G\n", 2.3, 2.3, 2.3, 2.3, 2.3));

  myprint("%s\n",
    "myprint(\"%Le %LE %Lf %Lg %LG\\n\", \n"
    "       (long double)2.3, (long double)2.3, (long double)2.3, \n"
    "       (long double)2.3, (long double)2.3);");
  PRINT_RESULT(myprint("%Le %LE %Lf %Lg %LG\n", \
    (long double)2.3, (long double)2.3, (long double)2.3, \
    (long double)2.3, (long double)2.3));

  myprint("%s\n",
    "myprint(\"%.3e %.3E %.3f %.3g %.3G\\n\", \n"
    "       2.34567, 2.34567, 2.34567, 2.34567, 2.34567);");
  PRINT_RESULT(myprint("%.3e %.3E %.3f %.3g %.3G\n", \
    2.34567, 2.34567, 2.34567, 2.34567, 2.34567));

  myprint("%s\n",
    "myprint(\"%.3e %.3E %.3f %.3g %.3G\\n\", \n"
    "       12345.67/3, 12345.67/3, 12345.67/3, 12345.67/3, 12345.67/3);");
  PRINT_RESULT(myprint("%.3e %.3E %.3f %.3g %.3G\n", \
    12345.67/3, 12345.67/3, 12345.67/3, 12345.67/3, 12345.67/3));

  myprint("%s\n",
    "myprint(\"%.3e %.3E %.3f %.3g %.3G\\n\", \n"
    "       -12345.67/3, -12345.67/3, -12345.67/3, -12345.67/3, -12345.67/3);");
  PRINT_RESULT(myprint("%.3e %.3E %.3f %.3g %.3G\n", \
    -12345.67/3, -12345.67/3, -12345.67/3, -12345.67/3, -12345.67/3));

  myprint("%s\n",
    "myprint(\"%\\\'3e %\\\'3E %\\\'3f %\\\'3g %\\\'3G\\n\", \n"
    "       -12345.67/3, -12345.67/3, -12345.67/3, -12345.67/3, -12345.67/3);");
  PRINT_RESULT(myprint("%\'e %\'3E %\'3f %\'3g %\'3G\n", \
    -12345.67/3, -12345.67/3, -12345.67/3, -12345.67/3, -12345.67/3));
}

int myprint(const char *format, ...)
{
  va_list args;
  int rc;

  va_start(args, format);
  rc = vprintf(format, args);
  va_end(args);
  return (rc);
}

