/*****************************************************************************/
/***     Include files                                                     ***/
/*****************************************************************************/

#include <stdio.h>                      /* Standard IO functions.            */

#include <wchar.h>                      /* XPG/4 library.                    */
#include <locale.h>                     /* Locale definitions.               */

/*****************************************************************************/
/***     Global defines                                                    ***/
/*****************************************************************************/

#define UPPER_LIMIT    0xFF             /* Maximum character to check.       */

/*****************************************************************************/
/***     Case conversions for wide characters.                             ***/
/*****************************************************************************/

void do_case_w_functions(void)
{
  wint_t ch;                            /* Wide character to check.          */

                                        /* Print out the current locale name.*/
  printf("The current locale is: %s\n\n", setlocale(LC_CTYPE, NULL));

                                        /* Print a banner.                   */
  printf("Table of case conversions for wide characters:\n");
  printf("----------------------------------------------\n");

                                        /* For each wide character...        */
                                        /*  If the character is alpha...     */
                                        /*   If the character can be         */
                                        /*    converted to lowercase,        */
                                        /*    print it out.                  */
                                        /*   If the character can be         */
                                        /*    converted to uppercase,        */
                                        /*    print it out.                  */
  for (ch = 0; ch <= UPPER_LIMIT; ++ch)
  {
    if (iswalpha(ch))
    {
       if (towlower(ch) != ch)
          printf("'%c' converted to lowercase is: '%c'\n", ch, towlower(ch));
       if (towupper(ch) != ch)
          printf("'%c' converted to uppercase is: '%c'\n", ch, towupper(ch));
    }
  }
}

/*****************************************************************************/
/***     Main program                                                      ***/
/*****************************************************************************/

void main(void)
{
                                        /* Set the locale based on env var.  */
  setlocale(LC_ALL, "");

                                        /* Print out upper/lower wide char   */
                                        /*  case table.                      */
  do_case_w_functions();
}
